/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cool.typedmodel.core;

import com.sap.caf.ui.utils.cool.typedmodel.aop.AspectInstance;
import com.sap.caf.ui.utils.cool.typedmodel.aop.IInvocation;
import com.sap.caf.ui.utils.cool.typedmodel.aop.IMethodInterceptor;
import com.sap.caf.ui.utils.cool.typedmodel.aop.config.AbstractAspect;
import com.sap.caf.ui.utils.cool.typedmodel.aop.config.Pointcut;
import com.sap.caf.ui.utils.cool.typedmodel.aop.pointcut.MethodP;
import com.sap.caf.ui.utils.cool.typedmodel.aop.pointcut.P;
import com.sap.engine.services.jndi.persistent.exceptions.IllegalArgumentException;
import com.sap.tc.cmi.metadata.ICMIRelationRoleInfo;
import com.sap.tc.cmi.model.ICMIGenericModelClass;
import com.sap.tc.cmi.model.ICMIModelClass;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import java.lang.reflect.Proxy;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class AopAspectModelIntroduction
extends AbstractAspect {
    private static String GUID_ATTRIBUTE_NAME = "guid";
    protected static final IMethodInterceptor ATTRIBUTE_GETTER = new IMethodInterceptor(){

        public Object invoke(IInvocation invocation) throws Throwable {
            Class<?> retValType = invocation.getMethod().getReturnType();
            if (invocation.getTargetInterface() != invocation.getMethod().getDeclaringClass()) {
                return invocation.invokeNext();
            }
            String key = AopAspectModelIntroduction.method2attribute(invocation.getMethod().getName(), true);
            ICMIGenericModelClass structure = (ICMIGenericModelClass)invocation.getProxy();
            if (key.equalsIgnoreCase(GUID_ATTRIBUTE_NAME) && structure instanceof IAspectRow) {
                IAspectRow aspectRow = AopAspectModelIntroduction.getTargetAspectRow(structure);
                IKey aspectRowKey = aspectRow.getKey();
                return AopAspectModelIntroduction.getKeyAsString(aspectRowKey);
            }
            Object result = structure.getAttributeValue(key);
            if ("java.sql.Timestamp".equals(retValType.getName()) && !(result instanceof Timestamp) && result instanceof Date) {
                result = new Timestamp(((Date)result).getTime());
            }
            return result;
        }
    };
    protected static final IMethodInterceptor ATTRIBUTE_SETTER = new IMethodInterceptor(){

        public Object invoke(IInvocation invocation) throws Throwable {
            Class<?> retValType = invocation.getMethod().getReturnType();
            if (invocation.getTargetInterface() != invocation.getMethod().getDeclaringClass()) {
                return invocation.invokeNext();
            }
            String key = AopAspectModelIntroduction.method2attribute(invocation.getMethod().getName(), false);
            ICMIGenericModelClass structure = (ICMIGenericModelClass)invocation.getProxy();
            structure.setAttributeValue(key, invocation.getArgument(0));
            return null;
        }
    };
    protected static final IMethodInterceptor RELATION_GETTER = new IMethodInterceptor(){

        public Object invoke(IInvocation invocation) throws Throwable {
            if (invocation.getTargetInterface() != invocation.getMethod().getDeclaringClass()) {
                return invocation.invokeNext();
            }
            ICMIGenericModelClass model = (ICMIGenericModelClass)invocation.getProxy();
            ICMIRelationRoleInfo relation = AopAspectModelIntroduction.getRelationFromSetOrGetMethod(model, invocation.getMethod().getName(), true);
            if (relation.getCardinality().isMultiple()) {
                return model.getRelatedModelObjects(relation.getName());
            }
            return model.getRelatedModelObject(relation.getName());
        }
    };
    protected static final IMethodInterceptor RELATION_SETTER = new IMethodInterceptor(){

        public Object invoke(IInvocation invocation) throws Throwable {
            if (invocation.getTargetInterface() != invocation.getMethod().getDeclaringClass()) {
                return invocation.invokeNext();
            }
            ICMIGenericModelClass model = (ICMIGenericModelClass)invocation.getProxy();
            Object arg0 = invocation.getArgument(0);
            ICMIRelationRoleInfo relation = AopAspectModelIntroduction.getRelationFromSetOrGetMethod(model, invocation.getMethod().getName(), false);
            if (relation.getCardinality().isMultiple()) {
                model.setRelatedModelObjects(relation.getName(), (Collection)AopAspectModelIntroduction.getTargetAspect(arg0));
            } else if (arg0 != null) {
                model.setRelatedModelObject(relation.getName(), (ICMIModelClass)AopAspectModelIntroduction.getTargetAspectRow(arg0));
            } else {
                ICMIModelClass relatedModel = model.getRelatedModelObject(relation.getName());
                if (relatedModel != null) {
                    IAspectRow relatedRow = AopAspectModelIntroduction.getTargetAspectRow(relatedModel);
                    model.removeRelatedModelObject(relation.getName(), (ICMIModelClass)relatedRow);
                }
            }
            return null;
        }
    };
    protected static final IMethodInterceptor RELATION_ADDER = new IMethodInterceptor(){

        public Object invoke(IInvocation invocation) throws Throwable {
            if (invocation.getTargetInterface() != invocation.getMethod().getDeclaringClass()) {
                return invocation.invokeNext();
            }
            ICMIGenericModelClass model = (ICMIGenericModelClass)invocation.getProxy();
            ICMIRelationRoleInfo relation = AopAspectModelIntroduction.getRelationFromAddOrRemoveMethod(model, invocation.getMethod().getName(), true);
            Object arg0 = invocation.getArgument(0);
            boolean result = false;
            if (!relation.getCardinality().isMultiple()) {
                throw new UnsupportedOperationException("Cann't call add relation method for target cardinality 1 for relation : " + relation.getName() + " for aspect : " + model.associatedModelClassInfo().getName());
            }
            result = model.addRelatedModelObject(relation.getName(), (ICMIModelClass)AopAspectModelIntroduction.getTargetAspectRow(arg0));
            return new Boolean(result);
        }
    };
    protected static final IMethodInterceptor RELATION_REMOVER = new IMethodInterceptor(){

        public Object invoke(IInvocation invocation) throws Throwable {
            if (invocation.getTargetInterface() != invocation.getMethod().getDeclaringClass()) {
                return invocation.invokeNext();
            }
            ICMIGenericModelClass model = (ICMIGenericModelClass)invocation.getProxy();
            ICMIRelationRoleInfo relation = AopAspectModelIntroduction.getRelationFromAddOrRemoveMethod(model, invocation.getMethod().getName(), false);
            Object arg0 = invocation.getArgument(0);
            boolean result = false;
            result = model.removeRelatedModelObject(relation.getName(), (ICMIModelClass)AopAspectModelIntroduction.getTargetAspectRow(arg0));
            return new Boolean(result);
        }
    };
    private static final Pointcut ATTRIBUTE_GETTER_METHOD = P.and(MethodP.noArguments(), MethodP.methodName("get.+"), P.not(P.or(MethodP.resultType(Void.TYPE), MethodP.resultSupertype(class$com$sap$tc$cmi$model$ICMIModelClass == null ? (class$com$sap$tc$cmi$model$ICMIModelClass = AopAspectModelIntroduction.class$("com.sap.tc.cmi.model.ICMIModelClass")) : class$com$sap$tc$cmi$model$ICMIModelClass), MethodP.resultSupertype(class$java$util$Collection == null ? (class$java$util$Collection = AopAspectModelIntroduction.class$("java.util.Collection")) : class$java$util$Collection))));
    private static final Pointcut ATTRIBUTE_SETTER_METHOD = P.and(new Pointcut[]{MethodP.oneArgument(), MethodP.resultType(Void.TYPE), MethodP.methodName("set.+"), P.not(P.or(MethodP.firstArgumentSupertype(class$com$sap$tc$cmi$model$ICMIModelClass == null ? (class$com$sap$tc$cmi$model$ICMIModelClass = AopAspectModelIntroduction.class$("com.sap.tc.cmi.model.ICMIModelClass")) : class$com$sap$tc$cmi$model$ICMIModelClass), MethodP.firstArgumentSupertype(class$java$util$Collection == null ? (class$java$util$Collection = AopAspectModelIntroduction.class$("java.util.Collection")) : class$java$util$Collection)))});
    private static final Pointcut RELATION_GETTER_METHOD = P.and(MethodP.noArguments(), MethodP.methodName("get.+"), P.or(MethodP.resultSupertype(class$com$sap$tc$cmi$model$ICMIModelClass == null ? (class$com$sap$tc$cmi$model$ICMIModelClass = AopAspectModelIntroduction.class$("com.sap.tc.cmi.model.ICMIModelClass")) : class$com$sap$tc$cmi$model$ICMIModelClass), MethodP.resultSupertype(class$java$util$Collection == null ? (class$java$util$Collection = AopAspectModelIntroduction.class$("java.util.Collection")) : class$java$util$Collection)));
    private static final Pointcut RELATION_SETTER_METHOD = P.and(new Pointcut[]{MethodP.resultType(Void.TYPE), MethodP.oneArgument(), MethodP.methodName("set.+"), P.or(MethodP.firstArgumentSupertype(class$com$sap$tc$cmi$model$ICMIModelClass == null ? (class$com$sap$tc$cmi$model$ICMIModelClass = AopAspectModelIntroduction.class$("com.sap.tc.cmi.model.ICMIModelClass")) : class$com$sap$tc$cmi$model$ICMIModelClass), MethodP.firstArgumentSupertype(class$java$util$Collection == null ? (class$java$util$Collection = AopAspectModelIntroduction.class$("java.util.Collection")) : class$java$util$Collection))});
    private static final Pointcut RELATION_ADDER_METHOD = P.and(new Pointcut[]{MethodP.resultType(Boolean.TYPE), MethodP.oneArgument(), MethodP.methodName("add.+"), P.or(MethodP.firstArgumentSupertype(class$com$sap$tc$cmi$model$ICMIModelClass == null ? (class$com$sap$tc$cmi$model$ICMIModelClass = AopAspectModelIntroduction.class$("com.sap.tc.cmi.model.ICMIModelClass")) : class$com$sap$tc$cmi$model$ICMIModelClass), MethodP.firstArgumentSupertype(class$com$sap$tc$cmi$model$ICMIModelClass == null ? (class$com$sap$tc$cmi$model$ICMIModelClass = AopAspectModelIntroduction.class$("com.sap.tc.cmi.model.ICMIModelClass")) : class$com$sap$tc$cmi$model$ICMIModelClass))});
    private static final Pointcut RELATION_REMOVER_METHOD = P.and(new Pointcut[]{MethodP.resultType(Boolean.TYPE), MethodP.oneArgument(), MethodP.methodName("remove.+"), P.or(MethodP.firstArgumentSupertype(class$com$sap$tc$cmi$model$ICMIModelClass == null ? (class$com$sap$tc$cmi$model$ICMIModelClass = AopAspectModelIntroduction.class$("com.sap.tc.cmi.model.ICMIModelClass")) : class$com$sap$tc$cmi$model$ICMIModelClass), MethodP.firstArgumentSupertype(class$com$sap$tc$cmi$model$ICMIModelClass == null ? (class$com$sap$tc$cmi$model$ICMIModelClass = AopAspectModelIntroduction.class$("com.sap.tc.cmi.model.ICMIModelClass")) : class$com$sap$tc$cmi$model$ICMIModelClass))});
    private static final Pointcut[] POINTS = new Pointcut[]{ATTRIBUTE_GETTER_METHOD, ATTRIBUTE_SETTER_METHOD, RELATION_GETTER_METHOD, RELATION_SETTER_METHOD, RELATION_ADDER_METHOD, RELATION_REMOVER_METHOD};
    private static final IMethodInterceptor[] INTERCEPTORS = new IMethodInterceptor[]{ATTRIBUTE_GETTER, ATTRIBUTE_SETTER, RELATION_GETTER, RELATION_SETTER, RELATION_ADDER, RELATION_REMOVER};
    private static final Object MODEL_APPLIED = new Object();
    static /* synthetic */ Class class$com$sap$tc$cmi$model$ICMIGenericModelClass;
    static /* synthetic */ Class class$com$sap$tc$col$client$generic$api$IAspectRow;
    static /* synthetic */ Class class$com$sap$tc$col$client$generic$api$IAspect;
    static /* synthetic */ Class class$com$sap$tc$cmi$model$ICMIModelClass;
    static /* synthetic */ Class class$java$util$Collection;

    public void advise(AspectInstance aspectInstance) {
        if (aspectInstance.hasAttribute(MODEL_APPLIED)) {
            return;
        }
        if (!aspectInstance.hasMixinForInterface(class$com$sap$tc$cmi$model$ICMIGenericModelClass == null ? (class$com$sap$tc$cmi$model$ICMIGenericModelClass = AopAspectModelIntroduction.class$("com.sap.tc.cmi.model.ICMIGenericModelClass")) : class$com$sap$tc$cmi$model$ICMIGenericModelClass)) {
            return;
        }
        Class myInterface = aspectInstance.getClassIdentifier();
        if (null == myInterface) {
            return;
        }
        Pointcut myMember = MethodP.declaredIn(myInterface);
        for (int i = 0; i < POINTS.length; ++i) {
            Pointcut myMemberPoint = P.and(myMember, POINTS[i]);
            myMemberPoint.advise(aspectInstance, INTERCEPTORS[i]);
        }
        aspectInstance.setAttribute(MODEL_APPLIED, null);
    }

    protected static IAspectRow getTargetAspectRow(Object proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException("Proxy is null. Can't get target aspect row.");
        }
        AspectInstance aspectInst = (AspectInstance)Proxy.getInvocationHandler(proxy);
        return (IAspectRow)aspectInst.getMixinForInterface(class$com$sap$tc$col$client$generic$api$IAspectRow == null ? (class$com$sap$tc$col$client$generic$api$IAspectRow = AopAspectModelIntroduction.class$("com.sap.tc.col.client.generic.api.IAspectRow")) : class$com$sap$tc$col$client$generic$api$IAspectRow).getTarget();
    }

    protected static IAspect getTargetAspect(Object proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException("Proxy is null. Can't get target aspect.");
        }
        AspectInstance aspectInst = (AspectInstance)Proxy.getInvocationHandler(proxy);
        return (IAspect)aspectInst.getMixinForInterface(class$com$sap$tc$col$client$generic$api$IAspect == null ? (class$com$sap$tc$col$client$generic$api$IAspect = AopAspectModelIntroduction.class$("com.sap.tc.col.client.generic.api.IAspect")) : class$com$sap$tc$col$client$generic$api$IAspect).getTarget();
    }

    protected static String method2attribute(String methodName, boolean isGetter) {
        String afterFirstLetter = methodName.substring(4);
        return Character.toLowerCase(methodName.charAt(3)) + afterFirstLetter;
    }

    protected static String getKeyAsString(IKey key) {
        String strKey = key.toString();
        return strKey.substring(1, strKey.length() - 1);
    }

    protected static ICMIRelationRoleInfo getRelationFromSetOrGetMethod(ICMIGenericModelClass model, String methodName, boolean isGet) {
        String relationFromMethod;
        if (isGet) {
            String afterFirstLetter = methodName.substring("get".length() + 1);
            relationFromMethod = Character.toUpperCase(methodName.charAt("get".length())) + afterFirstLetter;
        } else {
            String afterFirstLetter = methodName.substring("set".length() + 1);
            relationFromMethod = Character.toUpperCase(methodName.charAt("set".length())) + afterFirstLetter;
        }
        return AopAspectModelIntroduction.getRelationIgnoreFirstCharacterCase(model, relationFromMethod);
    }

    protected static ICMIRelationRoleInfo getRelationFromAddOrRemoveMethod(ICMIGenericModelClass model, String methodName, boolean isAdd) {
        String relationFromMethod;
        if (isAdd) {
            String afterFirstLetter = methodName.substring("add".length() + 1);
            relationFromMethod = Character.toUpperCase(methodName.charAt("add".length())) + afterFirstLetter;
        } else {
            String afterFirstLetter = methodName.substring("remove".length() + 1);
            relationFromMethod = Character.toUpperCase(methodName.charAt("remove".length())) + afterFirstLetter;
        }
        return AopAspectModelIntroduction.getRelationIgnoreFirstCharacterCase(model, relationFromMethod);
    }

    protected static ICMIRelationRoleInfo getRelationIgnoreFirstCharacterCase(ICMIGenericModelClass model, String relFromMethodName) {
        Collection relations = model.associatedModelClassInfo().getSourceRoleInfos();
        Iterator i = relations.iterator();
        while (i.hasNext()) {
            ICMIRelationRoleInfo relation = (ICMIRelationRoleInfo)i.next();
            String relationName = relation.getName();
            String relationNameWithFirstUpperCaseCharacter = Character.toUpperCase(relationName.charAt(0)) + relationName.substring(1);
            if (!relationNameWithFirstUpperCaseCharacter.equals(relFromMethodName)) continue;
            return relation;
        }
        throw new IllegalArgumentException("Relation with name : " + relFromMethodName + " not found in model class : " + model.associatedModelClassInfo().getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

