/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cool.typedmodel.core;

import com.sap.caf.ui.utils.cool.typedmodel.aop.AspectInstance;
import com.sap.caf.ui.utils.cool.typedmodel.aop.Aspects;
import com.sap.caf.ui.utils.cool.typedmodel.aop.IAspectFactory;
import com.sap.caf.ui.utils.cool.typedmodel.aop.IInvocation;
import com.sap.caf.ui.utils.cool.typedmodel.aop.IMethodInterceptor;
import com.sap.caf.ui.utils.cool.typedmodel.aop.config.AbstractAspect;
import com.sap.caf.ui.utils.cool.typedmodel.aop.config.Pointcut;
import com.sap.caf.ui.utils.cool.typedmodel.cast.ICastResultRule;
import com.sap.caf.ui.utils.cool.typedmodel.core.AspectAttributes;

public class AopAspectCascade
extends AbstractAspect {
    private final Pointcut _pointcut;
    private final ICastResultRule _castRule;
    protected final IMethodInterceptor INTERCEPTOR = new IMethodInterceptor(){

        public Object invoke(IInvocation invocation) throws Throwable {
            Object result = invocation.invokeNext();
            if (null == result || Aspects.isAspectObject(result)) {
                return result;
            }
            Class type = AopAspectCascade.this._castRule.cast(result, invocation);
            IAspectFactory aop = invocation.getAspectInstance().getAspectFactory();
            Object proxy = aop.newInstance(type, result);
            AspectInstance aspect = Aspects.getAspectInstance(proxy);
            aspect.setAttribute(AspectAttributes.KEY_ORIGINAL_OBJECT, result);
            return proxy;
        }
    };

    public AopAspectCascade(Pointcut pointcut, ICastResultRule castRule) {
        this._pointcut = pointcut;
        this._castRule = castRule;
    }

    public void advise(AspectInstance aspectInstance) {
        this._pointcut.advise(aspectInstance, this.INTERCEPTOR);
    }
}

