/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cool.typedmodel.cast;

import com.sap.caf.ui.utils.cool.typedmodel.aop.IInvocation;
import com.sap.caf.ui.utils.cool.typedmodel.cast.ICastResultInvocation;
import com.sap.caf.ui.utils.cool.typedmodel.cast.ICastResultRule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class CastResultStack
implements ICastResultRule {
    private final List _rules = new ArrayList(5);
    private static ICastResultInvocation CAST_RESULT_INVOCATION_ERROR = new ICastResultInvocation(){

        public Class invokeNext(Object result, IInvocation invocation) {
            throw new IllegalStateException("Unnable to dispatch upcast call");
        }

        public ICastResultRule getRule() {
            return ICastResultRule.UPCAST_ERROR;
        }
    };

    public CastResultStack() {
        this(false);
    }

    public CastResultStack(boolean useDefault) {
        if (useDefault) {
            this._rules.add(ICastResultRule.NO_UPCAST);
        }
    }

    public void pushRule(ICastResultRule rule) {
        this._rules.add(rule);
    }

    public Class cast(Object result, IInvocation invocation) {
        ICastResultInvocation next = CAST_RESULT_INVOCATION_ERROR;
        Iterator i = this._rules.iterator();
        while (i.hasNext()) {
            ICastResultRule rule = (ICastResultRule)i.next();
            next = new CastResultInvocationImpl(rule, next);
        }
        return next.invokeNext(result, invocation);
    }

    public static CastResultStack stackOptional(ICastResultRule rule) {
        CastResultStack stack = new CastResultStack(true);
        stack.pushRule(rule);
        return stack;
    }

    public static CastResultStack stackMandatory(ICastResultRule rule) {
        CastResultStack stack = new CastResultStack(false);
        stack.pushRule(rule);
        return stack;
    }

    protected static class CastResultInvocationImpl
    implements ICastResultInvocation {
        private final ICastResultRule _rule;
        private final ICastResultInvocation _next;

        protected CastResultInvocationImpl(ICastResultRule rule, ICastResultInvocation next) {
            this._rule = rule;
            this._next = next;
        }

        public Class invokeNext(Object result, IInvocation invocation) {
            Class newType = this.getRule().cast(result, invocation);
            if (null == newType) {
                return this._next.invokeNext(result, invocation);
            }
            return newType;
        }

        public ICastResultRule getRule() {
            return this._rule;
        }
    }
}

