/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cool.typedmodel.api;

import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IMessage;
import com.sap.tc.col.client.generic.api.IMessageList;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDComponent;
import com.sap.tc.webdynpro.progmodel.api.IWDMessage;
import com.sap.tc.webdynpro.progmodel.api.IWDMessageManager;
import com.sap.tc.webdynpro.progmodel.api.IWDNode;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeElement;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
import com.sap.tc.webdynpro.progmodel.api.WDMessage;
import com.sap.tc.webdynpro.services.message.WDMessageType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class CAFMessages {
    private static final WDMessageType[] CAF_2_WD_MSG_TYPES = new WDMessageType[3];
    private static final Object[] NO_ARGS;
    private static final int NO_MESSAGES = -1;
    static /* synthetic */ Class class$com$sap$tc$col$client$generic$api$IAspectRow;

    public static int forwardAllMessages(IServiceFacade srvcFacade, IWDComponent component) {
        IWDMessageManager manager = component.getMessageManager();
        IMessageList list = srvcFacade.getAllMessages();
        int maxSeverity = -1;
        int size = list.size();
        for (int idx = 0; idx < size; ++idx) {
            IMessage cafMessage = list.getMessage(0);
            IWDMessage wdMessage = CAFMessages.cast(cafMessage, component);
            manager.reportMessage(wdMessage, NO_ARGS, false);
            maxSeverity = Math.max(maxSeverity, cafMessage.getType());
            list.removeMessage(cafMessage);
        }
        return maxSeverity;
    }

    private static int forwardContextMessages(IWDNode source, IWDComponent component) {
        return CAFMessages.forwardContextMessages(source, component, true);
    }

    private static int forwardContextMessages(IWDNode source, IWDComponent component, boolean recursive) {
        int maxIdx;
        int minIdx;
        IWDNodeInfo niSource = source.getNodeInfo();
        Map attributesMapping = CAFMessages.attributesMapping(niSource);
        int maxSeverity = -1;
        if (niSource.isSingleton()) {
            maxIdx = minIdx = source.getLeadSelection();
        } else {
            minIdx = 0;
            maxIdx = source.size() - 1;
        }
        for (int idx = minIdx; idx <= maxIdx; ++idx) {
            IWDNodeElement el = source.getElementAt(idx);
            maxSeverity = Math.max(maxSeverity, CAFMessages.processElementMessages(el, component, attributesMapping));
            if (!recursive) continue;
            maxSeverity = Math.max(maxSeverity, CAFMessages.processChildrenMessages(el, component));
        }
        return maxSeverity;
    }

    public static int forwardContextMessages(IWDNodeElement source, IWDComponent component) {
        return CAFMessages.forwardContextMessages(source, component, true);
    }

    public static int forwardContextMessages(IWDNodeElement source, IWDComponent component, boolean recursive) {
        if (null == source || null == source.node()) {
            return -1;
        }
        int maxSeverity = CAFMessages.processElementMessages(source, component, CAFMessages.attributesMapping(source.node().getNodeInfo()));
        if (recursive) {
            maxSeverity = Math.max(maxSeverity, CAFMessages.processChildrenMessages(source, component));
        }
        return maxSeverity;
    }

    private static int processElementMessages(IWDNodeElement source, IWDComponent component, Map attributesMapping) {
        int maxSeverity = -1;
        if (!(class$com$sap$tc$col$client$generic$api$IAspectRow == null ? (class$com$sap$tc$col$client$generic$api$IAspectRow = CAFMessages.class$("com.sap.tc.col.client.generic.api.IAspectRow")) : class$com$sap$tc$col$client$generic$api$IAspectRow).isInstance(source.model())) {
            return maxSeverity;
        }
        IAspectRow row = (IAspectRow)source.model();
        IWDMessageManager manager = component.getMessageManager();
        IMessageList list = row.getMessages();
        int idx = 0;
        for (int size = list.size(); size > 0; --size) {
            IWDAttributeInfo attr;
            IMessage cafMessage = list.getMessage(idx);
            IWDMessage wdMessage = CAFMessages.cast(cafMessage, component);
            String fieldName = cafMessage.getAspectFieldName();
            IWDAttributeInfo iWDAttributeInfo = attr = null == fieldName ? null : (IWDAttributeInfo)attributesMapping.get(fieldName);
            if (null == attr) {
                manager.reportMessage(wdMessage, NO_ARGS, false);
            } else {
                manager.reportContextAttributeMessage(source, attr, wdMessage, NO_ARGS, false);
            }
            maxSeverity = Math.max(maxSeverity, cafMessage.getType());
            ++idx;
        }
        list.clear();
        return maxSeverity;
    }

    private static int processChildrenMessages(IWDNodeElement elSource, IWDComponent component) {
        int maxSeverity = -1;
        IWDNode nSource = elSource.node();
        IWDNodeInfo niSource = nSource.getNodeInfo();
        int idx = elSource.index();
        Iterator i = niSource.iterateChildren();
        while (i.hasNext()) {
            IWDNodeInfo niChild = (IWDNodeInfo)i.next();
            maxSeverity = Math.max(maxSeverity, CAFMessages.forwardContextMessages(nSource.getChildNode(niChild.getName(), idx), component, true));
        }
        return maxSeverity;
    }

    private static Map attributesMapping(IWDNodeInfo source) {
        HashMap<String, IWDAttributeInfo> result = new HashMap<String, IWDAttributeInfo>();
        Iterator i = source.iterateAttributes();
        while (i.hasNext()) {
            IWDAttributeInfo attr = (IWDAttributeInfo)i.next();
            if (null == attr.getOriginName()) continue;
            result.put(attr.getOriginName(), attr);
        }
        return Collections.unmodifiableMap(result);
    }

    private static final IWDMessage cast(IMessage cafMessage, IWDComponent component) {
        return new WDMessage(component, cafMessage.getCode(), CAFMessages.typeOf(cafMessage), cafMessage.getText());
    }

    private static final WDMessageType typeOf(IMessage message) {
        return CAF_2_WD_MSG_TYPES[message.getType()];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CAFMessages.CAF_2_WD_MSG_TYPES[0] = WDMessageType.STANDARD;
        CAFMessages.CAF_2_WD_MSG_TYPES[1] = WDMessageType.WARNING;
        CAFMessages.CAF_2_WD_MSG_TYPES[2] = WDMessageType.ERROR;
        NO_ARGS = new Object[0];
    }
}

