/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cool.typedmodel.aop.pointcut;

import com.sap.caf.ui.utils.cool.typedmodel.aop.AspectInstance;
import com.sap.caf.ui.utils.cool.typedmodel.aop.Mixin;
import com.sap.caf.ui.utils.cool.typedmodel.aop.config.Pointcut;
import java.lang.reflect.Method;
import java.util.Iterator;

public final class MixinP {
    private MixinP() {
    }

    public static Pointcut isMixinInterface(Class interfaceClass) {
        return new IsMixinInterface(interfaceClass);
    }

    public static Pointcut isMixinSuperinterface(Class interfaceClass) {
        return new IsMixinSuperinterface(interfaceClass);
    }

    private static class IsMixinSuperinterface
    extends MixinInterfaceCheck {
        protected boolean checkMixin(Mixin mixin, Class etalonInterface) {
            return etalonInterface.isAssignableFrom(mixin.getInterfaceClass());
        }

        public IsMixinSuperinterface(Class interfaceClass) {
            super(interfaceClass);
        }
    }

    private static class IsMixinInterface
    extends MixinInterfaceCheck {
        protected boolean checkMixin(Mixin mixin, Class etalonInterface) {
            return mixin.getInterfaceClass() == etalonInterface;
        }

        public IsMixinInterface(Class interfaceClass) {
            super(interfaceClass);
        }
    }

    private static abstract class MixinInterfaceCheck
    extends Pointcut {
        private final Class _interfaceClass;

        public boolean adviseMethod(AspectInstance instance, Mixin mixin, Method method) {
            return this.checkMixin(mixin, this._interfaceClass);
        }

        public boolean introduceOn(AspectInstance instance) {
            Iterator iterator = instance.getMixins().iterator();
            while (iterator.hasNext()) {
                Mixin mixin = (Mixin)iterator.next();
                if (!this.checkMixin(mixin, this._interfaceClass)) continue;
                return true;
            }
            return false;
        }

        protected abstract boolean checkMixin(Mixin var1, Class var2);

        protected MixinInterfaceCheck(Class interfaceClass) {
            this._interfaceClass = interfaceClass;
        }
    }
}

