/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cool.typedmodel.aop.pointcut;

import com.sap.caf.ui.utils.cool.typedmodel.aop.AspectInstance;
import com.sap.caf.ui.utils.cool.typedmodel.aop.Mixin;
import com.sap.caf.ui.utils.cool.typedmodel.aop.attribute.Attributes;
import com.sap.caf.ui.utils.cool.typedmodel.aop.config.Pointcut;
import java.lang.reflect.Method;
import java.util.regex.Pattern;

public final class MethodP {
    private MethodP() {
    }

    public static Pointcut methodName(String pattern) {
        return new MethodName(pattern);
    }

    public static Pointcut methodAttribute(String attribute) {
        return new MethodAttribute(attribute);
    }

    public static Pointcut resultType(Class allowedType) {
        return new ResultType(allowedType, true);
    }

    public static Pointcut resultSupertype(Class allowedType) {
        return new ResultType(allowedType, false);
    }

    public static Pointcut argumentType(int idx, Class allowedType) {
        return new ArgumentType(idx, allowedType, true);
    }

    public static Pointcut argumentSupertype(int idx, Class allowedType) {
        return new ArgumentType(idx, allowedType, false);
    }

    public static Pointcut firstArgumentType(Class allowedType) {
        return new ArgumentType(0, allowedType, true);
    }

    public static Pointcut firstArgumentSupertype(Class allowedType) {
        return new ArgumentType(0, allowedType, false);
    }

    public static Pointcut lastArgumentType(Class allowedType) {
        return new ArgumentType(-1, allowedType, true);
    }

    public static Pointcut lastArgumentSupertype(Class allowedType) {
        return new ArgumentType(-1, allowedType, false);
    }

    public static Pointcut noArguments() {
        return MethodP.argumentCount(0);
    }

    public static Pointcut oneArgument() {
        return MethodP.argumentCount(1);
    }

    public static Pointcut twoArguments() {
        return MethodP.argumentCount(2);
    }

    public static Pointcut declaredIn(Class interfaceClass) {
        return new MethodOfInterface(interfaceClass, true);
    }

    public static Pointcut methodOf(Class interfaceClass) {
        return new MethodOfInterface(interfaceClass, false);
    }

    public static Pointcut argumentCount(int requiredCount) {
        return new ArgumentCount(requiredCount);
    }

    protected static class MethodOfInterface
    extends MethodLevelPointcut {
        private final Class _interfaceClass;
        private final boolean _exact;

        public boolean adviseMethod(AspectInstance instance, Mixin mixin, Method method) {
            if (this._exact) {
                return method.getDeclaringClass() == this._interfaceClass;
            }
            return this._interfaceClass.isAssignableFrom(method.getDeclaringClass());
        }

        protected MethodOfInterface(Class interfaceClass, boolean exact) {
            this._interfaceClass = interfaceClass;
            this._exact = exact;
        }
    }

    protected static class ArgumentType
    extends MethodLevelPointcut {
        final int _idx;
        final Class _allowedType;
        final boolean _exact;

        private ArgumentType(int idx, Class allowedType, boolean exact) {
            this._idx = idx;
            this._allowedType = allowedType;
            this._exact = exact;
        }

        public boolean adviseMethod(AspectInstance instance, Mixin mixin, Method method) {
            Class<?> thisType;
            Class<?>[] argTypes = method.getParameterTypes();
            if (Math.abs(this._idx) >= argTypes.length) {
                return false;
            }
            Class<?> clazz = thisType = this._idx >= 0 ? argTypes[this._idx] : argTypes[argTypes.length + this._idx];
            if (this._exact) {
                return thisType == this._allowedType;
            }
            return this._allowedType.isAssignableFrom(thisType);
        }
    }

    protected static class ArgumentCount
    extends MethodLevelPointcut {
        private final int _requiredCount;

        private ArgumentCount(int requiredCount) {
            this._requiredCount = requiredCount;
        }

        public boolean adviseMethod(AspectInstance instance, Mixin mixin, Method method) {
            Class<?>[] argTypes = method.getParameterTypes();
            return argTypes.length == this._requiredCount;
        }
    }

    protected static class ResultType
    extends MethodLevelPointcut {
        final Class _allowedType;
        final boolean _exact;

        private ResultType(Class allowedType, boolean exact) {
            this._allowedType = allowedType;
            this._exact = exact;
        }

        public boolean adviseMethod(AspectInstance instance, Mixin mixin, Method method) {
            Class<?> thisType = method.getReturnType();
            if (this._exact) {
                return thisType == this._allowedType;
            }
            return this._allowedType.isAssignableFrom(thisType);
        }

        public boolean introduceOn(AspectInstance instance) {
            return true;
        }
    }

    public static class MethodAttribute
    extends MethodLevelPointcut {
        private final String _attribute;

        public String getAttribute() {
            return this._attribute;
        }

        public boolean adviseMethod(AspectInstance instance, Mixin mixin, Method method) {
            return Attributes.hasAttribute(method, this._attribute);
        }

        public MethodAttribute(String attribute) {
            this._attribute = attribute;
        }
    }

    protected static class MethodName
    extends MethodLevelPointcut {
        private final Pattern _pattern;

        public boolean adviseMethod(AspectInstance instance, Mixin mixin, Method method) {
            return this._pattern.matcher(method.getName()).matches();
        }

        public MethodName(String pattern) {
            this._pattern = Pattern.compile(pattern);
        }
    }

    protected static class MethodLevelPointcut
    extends Pointcut {
        protected MethodLevelPointcut() {
        }

        public boolean introduceOn(AspectInstance instance) {
            return true;
        }
    }
}

