/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cool.typedmodel.aop.config;

import com.sap.caf.ui.utils.cool.typedmodel.aop.AspectException;
import com.sap.caf.ui.utils.cool.typedmodel.aop.AspectInstance;
import com.sap.caf.ui.utils.cool.typedmodel.aop.IMethodInterceptor;
import com.sap.caf.ui.utils.cool.typedmodel.aop.Mixin;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;

public abstract class Pointcut {
    public void advise(AspectInstance instance, IMethodInterceptor interceptor) {
        this.advise(instance, interceptor, null);
    }

    public void advise(AspectInstance instance, Class interceptorClass) {
        this.advise(instance, null, interceptorClass);
    }

    public void advise(AspectInstance instance, IMethodInterceptor interceptor, Class interceptorClass) {
        List mixins = instance.getMixins();
        Iterator iterator = mixins.iterator();
        while (iterator.hasNext()) {
            Mixin mixin = (Mixin)iterator.next();
            Method[] methods = mixin.getAllMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!this.adviseMethod(instance, mixin, method)) continue;
                if (interceptor != null) {
                    mixin.addInterceptor(method, interceptor);
                    continue;
                }
                if (interceptorClass != null) {
                    try {
                        mixin.addInterceptor(method, (IMethodInterceptor)interceptorClass.newInstance());
                        continue;
                    }
                    catch (Exception e) {
                        throw new AspectException(e);
                    }
                }
                throw new AssertionError((Object)"interceptor or class needs to be specified");
            }
        }
    }

    public boolean adviseMethod(AspectInstance instance, Mixin mixin, Method method) {
        return false;
    }

    public boolean introduceOn(AspectInstance instance) {
        return false;
    }

    public void introduce(AspectInstance instance, Mixin mixin) {
        if (this.introduceOn(instance)) {
            instance.addMixin(mixin);
        }
    }
}

