/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cool.typedmodel.aop.config;

import com.sap.caf.ui.utils.cool.typedmodel.aop.AspectException;
import com.sap.caf.ui.utils.cool.typedmodel.aop.AspectInstance;
import com.sap.caf.ui.utils.cool.typedmodel.aop.IMethodInterceptor;
import com.sap.caf.ui.utils.cool.typedmodel.aop.config.IAspect;
import com.sap.caf.ui.utils.cool.typedmodel.aop.config.Pointcut;
import com.sap.caf.ui.utils.cool.typedmodel.aop.pointcut.P;

public class InterceptorAspect
implements IAspect {
    public static final int SINGLETON = 0;
    public static final int PER_METHOD = 1;
    public static final int PER_INSTANCE = 2;
    private Class interceptorClass;
    private int stateManagement;
    private IMethodInterceptor singletonInterceptor;
    private Pointcut pointcut;

    public InterceptorAspect(IMethodInterceptor interceptor) {
        this(P.all(), interceptor);
    }

    public InterceptorAspect(Class interceptorClass, int stateManagement) {
        this(P.all(), interceptorClass, stateManagement);
    }

    public InterceptorAspect(Pointcut pointcut, Class interceptorClass, int stateManagement) {
        this.stateManagement = stateManagement;
        if (stateManagement != 0 && stateManagement != 1 && stateManagement != 2) {
            throw new AssertionError((Object)("SINGLETON, PER_METHOD and PER_INSTANCE is supported only, not " + stateManagement));
        }
        if (stateManagement == 0) {
            this.singletonInterceptor = this.createInterceptor();
        }
        this.setPointcut(pointcut);
        this.interceptorClass = interceptorClass;
    }

    public void setPointcut(Pointcut pointcut) {
        this.pointcut = pointcut;
    }

    public InterceptorAspect(Pointcut pointcut, IMethodInterceptor interceptor) {
        this.pointcut = pointcut;
        this.singletonInterceptor = interceptor;
        this.stateManagement = 0;
    }

    public Class getInterceptorClass() {
        return this.interceptorClass;
    }

    public int getStateManagement() {
        return this.stateManagement;
    }

    private IMethodInterceptor createInterceptor() {
        try {
            return (IMethodInterceptor)this.interceptorClass.newInstance();
        }
        catch (Exception e) {
            throw new AspectException(e);
        }
    }

    public void introduce(AspectInstance aspectinstance) {
    }

    public void advise(AspectInstance instance) {
        if (this.stateManagement == 0) {
            this.pointcut.advise(instance, this.singletonInterceptor);
        } else if (this.stateManagement == 2) {
            this.pointcut.advise(instance, this.createInterceptor());
        } else if (this.stateManagement == 1) {
            this.pointcut.advise(instance, this.interceptorClass);
        }
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }
}

