/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cool.typedmodel.aop.config;

import com.sap.caf.ui.utils.cool.typedmodel.aop.AspectException;
import com.sap.caf.ui.utils.cool.typedmodel.aop.AspectInstance;
import com.sap.caf.ui.utils.cool.typedmodel.aop.Mixin;
import com.sap.caf.ui.utils.cool.typedmodel.aop.config.IAspect;

public class FindTargetMixinAspect
implements IAspect {
    private final String _implementationSuffix;
    private static final String DEFAULT_IMPLEMENTATION_SUFFIX = "Impl";

    public FindTargetMixinAspect() {
        this(DEFAULT_IMPLEMENTATION_SUFFIX);
    }

    public FindTargetMixinAspect(String implementationSuffix) {
        this._implementationSuffix = implementationSuffix;
    }

    public void introduce(AspectInstance aspectInstance) {
        Object target;
        if (aspectInstance.getClassIdentifier() == null) {
            return;
        }
        if (aspectInstance.hasMixinForInterface(aspectInstance.getClassIdentifier())) {
            return;
        }
        Mixin mixin = new Mixin();
        Class interfaceClass = aspectInstance.getClassIdentifier();
        Class targetClass = this.findImpl(interfaceClass);
        try {
            target = targetClass.newInstance();
        }
        catch (Exception e) {
            throw new AspectException("Could not instantiate target " + targetClass, e);
        }
        mixin.setInterfaceClass(interfaceClass);
        mixin.setTarget(target);
        aspectInstance.addMixin(mixin);
    }

    public void advise(AspectInstance aspectInstance) {
    }

    private Class findImpl(Class interfaceClass) {
        Class implementation = FindTargetMixinAspect.findImpl(interfaceClass, this._implementationSuffix);
        if (implementation == null) {
            throw new AssertionError((Object)("could not find target for " + interfaceClass));
        }
        return implementation;
    }

    public static Class findImpl(Class interfaceClass, String implementationSuffix) {
        String name = interfaceClass.getName();
        int packageEnd = name.lastIndexOf(46);
        String className = name.substring(0, packageEnd) + name.substring(packageEnd) + implementationSuffix;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

