/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cool.typedmodel.aop.config;

import com.sap.caf.ui.utils.cool.typedmodel.aop.AspectInstance;
import com.sap.caf.ui.utils.cool.typedmodel.aop.IAspectFactory;
import com.sap.caf.ui.utils.cool.typedmodel.aop.Mixin;
import com.sap.caf.ui.utils.cool.typedmodel.aop.config.IAspect;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class AspectSystem
implements IAspectFactory {
    private List _aspects = new ArrayList();

    public void addAspect(IAspect aspect) {
        this._aspects.add(aspect);
    }

    public Object newInstance(Class classIdentifier) {
        return this.newInstance(classIdentifier, null);
    }

    public Object newInstance(Class classIdentifier, Object primaryDelegate) {
        AspectInstance aspectInstance = this.createAspectInstance(classIdentifier, primaryDelegate);
        return aspectInstance.getProxy();
    }

    private AspectInstance createAspectInstance(Class classIdentifier, Object primaryDelegate) {
        AspectInstance aspectInstance = new AspectInstance(this, classIdentifier);
        Mixin wrapperMixin = null == primaryDelegate ? null : new Mixin(classIdentifier, primaryDelegate);
        this.initialize(aspectInstance, wrapperMixin);
        return aspectInstance;
    }

    protected void initialize(AspectInstance aspectInstance) {
        this.initialize(aspectInstance, null);
    }

    protected void initialize(AspectInstance aspectInstance, Mixin wrapperMixin) {
        if (null != wrapperMixin) {
            aspectInstance.addMixin(wrapperMixin);
        }
        this.introduce(aspectInstance);
        this.advise(aspectInstance);
    }

    protected void advise(AspectInstance aspectInstance) {
        Iterator aspectIterator = this._aspects.iterator();
        while (aspectIterator.hasNext()) {
            IAspect aspect = (IAspect)aspectIterator.next();
            aspect.advise(aspectInstance);
        }
    }

    protected void introduce(AspectInstance aspectInstance) {
        Iterator iterator = this._aspects.iterator();
        while (iterator.hasNext()) {
            IAspect aspect = (IAspect)iterator.next();
            aspect.introduce(aspectInstance);
        }
    }

    public void reinitialize(AspectInstance aspectInstance) {
        this.advise(aspectInstance);
    }

    public List getAspects() {
        return Collections.unmodifiableList(this._aspects);
    }
}

