/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cool.typedmodel.aop.attribute;

import com.sap.caf.ui.utils.cool.typedmodel.aop.attribute.AttributeException;
import com.sap.caf.ui.utils.cool.typedmodel.aop.attribute.Attributes;
import com.sap.caf.ui.utils.cool.typedmodel.aop.attribute.ClassAttributes;
import com.sap.caf.ui.utils.cool.typedmodel.aop.attribute.ClassPropertiesHelper;
import com.sap.caf.ui.utils.cool.typedmodel.aop.attribute.IAttributesLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Properties;

public class PropertyFileAttributeLoader
implements IAttributesLoader {
    public static final String ATTRIBUTE_FILE_SUFFIX = ".attributes";

    public void load(ClassAttributes classAttributes) {
        ClassPropertiesHelper classPropertiesHelper = new ClassPropertiesHelper(classAttributes);
        classPropertiesHelper.loadAttributes(this.getProperties(classAttributes.getAttributeClass()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Properties getProperties(Class klass) {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            try {
                String className = klass.getName();
                inputStream = Attributes.findFile(klass, ClassPropertiesHelper.className(klass) + ATTRIBUTE_FILE_SUFFIX);
                if (inputStream == null) {
                    inputStream = Attributes.findFile(klass, className.replace('.', '/') + ATTRIBUTE_FILE_SUFFIX);
                }
                if (inputStream != null) {
                    properties.load(inputStream);
                }
            }
            catch (MalformedURLException e) {
                throw new AttributeException("Error fetching properties for " + klass, e);
            }
            catch (IOException e) {
                throw new AttributeException("Error fetching properties for " + klass, e);
            }
            catch (AttributeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AttributeException("Error fetching properties for " + klass, e);
            }
            Object var6_9 = null;
            if (inputStream == null) return properties;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {}
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        inputStream.close();
        return properties;
    }
}

