/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cool.typedmodel.aop.attribute;

import com.sap.caf.ui.utils.cool.typedmodel.aop.attribute.AttributeException;
import com.sap.caf.ui.utils.cool.typedmodel.aop.attribute.ClassAttributes;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class ClassPropertiesHelper {
    private static Map methodSignatureCache = new HashMap();
    private static final String CLASS_PREFIX = "class";
    private static final String FIELD_PREFIX = "field";
    private static final String METHOD_PREFIX = "method";
    Properties properties = new Properties();
    private String className;
    private String packageName;
    private ClassAttributes targetClassAttributes;
    private Class attributeClass;

    public ClassPropertiesHelper() {
    }

    public ClassPropertiesHelper(ClassAttributes classAttributes) {
        this();
        this.setTargetClassAttributes(classAttributes);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setTargetClassAttributes(ClassAttributes classAttributes) {
        this.targetClassAttributes = classAttributes;
        this.setAttributeClass(classAttributes.getAttributeClass());
    }

    private void setAttributeClass(Class attributeClass) {
        this.attributeClass = attributeClass;
        if (attributeClass != null) {
            this.className = ClassPropertiesHelper.className(attributeClass);
            this.packageName = ClassPropertiesHelper.packageName(attributeClass);
        }
    }

    void loadAttributes(Properties properties) {
        if (this.targetClassAttributes == null) {
            throw new AssertionError();
        }
        this.properties = properties;
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            String attributeName;
            Map.Entry<Object, Object> entry = iterator.next();
            String propertyName = (String)entry.getKey();
            String attributeValue = (String)entry.getValue();
            String[] parts = propertyName.split("\\.");
            if (CLASS_PREFIX.equals(parts[0])) {
                attributeName = ClassPropertiesHelper.joinTail(parts, 1);
                this.loadClassAttribute(attributeName, attributeValue);
                continue;
            }
            if (FIELD_PREFIX.equals(parts[0])) {
                attributeName = ClassPropertiesHelper.joinTail(parts, 2);
                String fieldName = parts[1];
                this.loadFieldAttribute(fieldName, attributeName, attributeValue);
                continue;
            }
            if (METHOD_PREFIX.equals(parts[0])) {
                attributeName = ClassPropertiesHelper.joinTail(parts, 2);
                String methodSignature = parts[1];
                this.loadMethodAttribute(methodSignature, attributeName, attributeValue);
                continue;
            }
            throw new AttributeException("Invalid property " + propertyName);
        }
    }

    void loadMethodAttribute(String methodSignature, String attributeName, String attributeValue) {
        if (methodSignature.indexOf(40) == -1 || methodSignature.indexOf(41) == -1) {
            throw new AssertionError((Object)("method signature of wrong format: " + methodSignature));
        }
        if (this.targetClassAttributes != null) {
            Method method = this.findMethod(methodSignature);
            if (method == null) {
                throw new AttributeException("Error while loading attributes, could not find method: " + methodSignature + " for " + this.attributeClass);
            }
            this.targetClassAttributes.setMethodAttribute(method, attributeName, attributeValue);
        }
        this.properties.put("method." + methodSignature + "." + attributeName, attributeValue);
    }

    void loadFieldAttribute(String fieldName, String attributeName, String attributeValue) {
        if (this.targetClassAttributes != null) {
            try {
                Field field = this.attributeClass.getDeclaredField(fieldName);
                this.targetClassAttributes.setFieldAttribute(field, attributeName, attributeValue);
            }
            catch (Exception e) {
                throw new AttributeException("Error while loading attributes, could not find field: " + fieldName + " for " + this.attributeClass, e);
            }
        }
        this.properties.put("field." + fieldName + "." + attributeName, attributeValue);
    }

    void loadClassAttribute(String attributeName, String attributeValue) {
        if (this.targetClassAttributes != null && this.attributeClass != null) {
            this.targetClassAttributes.setClassAttribute(attributeName, attributeValue);
        }
        this.properties.put("class." + attributeName, attributeValue);
    }

    private Method findMethod(String methodSignature) {
        Method[] declaredMethods = this.attributeClass.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method method = declaredMethods[i];
            if (!ClassPropertiesHelper.methodSignature(method).equals(methodSignature)) continue;
            return method;
        }
        return null;
    }

    public static String joinTail(String[] parts, int firstIndex) {
        StringBuffer result = new StringBuffer();
        for (int i = firstIndex; i < parts.length; ++i) {
            String part = parts[i];
            result.append(part);
            if (i >= parts.length - 1) continue;
            result.append(".");
        }
        return result.toString();
    }

    static String methodSignature(Method method) {
        String signature = (String)methodSignatureCache.get(method);
        if (signature == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(method.getName());
            stringBuffer.append('(');
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> parameterType = parameterTypes[i];
                if (parameterType.isArray()) {
                    parameterType = parameterType.getComponentType();
                }
                String type = parameterType.getName();
                type = type.substring(type.lastIndexOf(46) + 1);
                stringBuffer.append(type);
                if (i + 1 >= parameterTypes.length) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append(')');
            signature = stringBuffer.toString();
            methodSignatureCache.put(method, signature);
        }
        return signature;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    static String className(Class klass) {
        String className = klass.getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    static String packageName(Class klass) {
        String className = klass.getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return className.substring(0, lastDot);
    }

    public void transferAttributesToTarget() {
        this.loadAttributes(this.properties);
    }

    public File getAttributeFile(File baseDir) {
        return new File(baseDir, this.getPackageName().replace('.', File.separatorChar) + File.separator + this.getClassName() + ".attributes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File dest) throws IOException {
        FileOutputStream output = new FileOutputStream(this.getAttributeFile(dest));
        try {
            this.properties.store(output, this.getPackageName() + "." + this.getClassName());
        }
        finally {
            ((OutputStream)output).close();
        }
    }
}

