/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cool.typedmodel.aop.attribute;

import com.sap.caf.ui.utils.cool.typedmodel.aop.attribute.ClassAttributes;
import com.sap.caf.ui.utils.cool.typedmodel.aop.attribute.PropertyFileAttributeLoader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Attributes {
    private static List searchPaths = new ArrayList();
    private static Map classAttributesCache = new HashMap();

    public static String getAttribute(Class klass, String attribute) {
        return Attributes.getAttributes(klass).getAttribute(attribute);
    }

    public static String getAttribute(Method method, String attribute) {
        return Attributes.getAttributes(method.getDeclaringClass()).getAttribute(method, attribute);
    }

    public static String getAttribute(Field field, String attribute) {
        return Attributes.getAttributes(field.getDeclaringClass()).getAttribute(field, attribute);
    }

    public static void addSearchPath(URL searchPath) {
        searchPaths.add(searchPath);
    }

    public static void removeSearchPath(URL searchPath) {
        searchPaths.add(searchPath);
    }

    public static boolean hasAttribute(Class klass, String attribute) {
        return Attributes.getAttributes(klass).hasAttribute(attribute);
    }

    public static boolean hasAttribute(Method method, String attribute) {
        return Attributes.hasAttribute(method.getDeclaringClass(), method, attribute);
    }

    private static boolean hasAttribute(Class aClass, Method method, String attribute) {
        return Attributes.getAttributes(aClass).hasAttribute(method, attribute);
    }

    public static boolean hasAttribute(Field field, String attribute) {
        return Attributes.hasAttribute(field.getDeclaringClass(), field, attribute);
    }

    private static boolean hasAttribute(Class aClass, Field field, String attribute) {
        return Attributes.getAttributes(aClass).hasAttribute(field, attribute);
    }

    public static boolean hasInheritedAttribute(Field field, String attribute) {
        return Attributes.hasInheritedAttribute(field.getDeclaringClass(), field, attribute);
    }

    public static boolean hasInheritedAttribute(Class aClass, Field field, String attribute) {
        if (aClass == null) {
            return false;
        }
        if (Attributes.hasAttribute(aClass, field, attribute)) {
            return true;
        }
        if (Attributes.hasInheritedAttribute(aClass.getSuperclass(), field, attribute)) {
            return true;
        }
        Class<?>[] interfaces = aClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            if (!Attributes.hasInheritedAttribute(anInterface, field, attribute)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasInheritedAttribute(Method method, String attribute) {
        return Attributes.hasInheritedAttribute(method.getDeclaringClass(), method, attribute);
    }

    public static boolean hasInheritedAttribute(Class aClass, Method method, String attribute) {
        if (aClass == null) {
            return false;
        }
        try {
            method = aClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (Attributes.hasAttribute(aClass, method, attribute)) {
            return true;
        }
        Class<?>[] interfaces = aClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            if (!Attributes.hasInheritedAttribute(anInterface, method, attribute)) continue;
            return true;
        }
        Class superclass = aClass.getSuperclass();
        return Attributes.hasInheritedAttribute(superclass, method, attribute);
    }

    public static String getInheritedAttribute(Class aClass, String attribute) {
        if (aClass == null) {
            return null;
        }
        if (Attributes.hasAttribute(aClass, attribute)) {
            return Attributes.getAttribute(aClass, attribute);
        }
        String attributeValue = Attributes.getInheritedAttribute(aClass.getSuperclass(), attribute);
        if (attributeValue == null) {
            Class<?> anInterface;
            Class<?>[] interfaces = aClass.getInterfaces();
            for (int i = 0; i < interfaces.length && (attributeValue = Attributes.getInheritedAttribute(anInterface = interfaces[i], attribute)) == null; ++i) {
            }
        }
        return attributeValue;
    }

    public static boolean hasInheritedAttribute(Class aClass, String attribute) {
        if (aClass == null) {
            return false;
        }
        if (Attributes.hasAttribute(aClass, attribute)) {
            return true;
        }
        if (Attributes.hasInheritedAttribute(aClass.getSuperclass(), attribute)) {
            return true;
        }
        Class<?>[] interfaces = aClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            if (!Attributes.hasInheritedAttribute(anInterface, attribute)) continue;
            return true;
        }
        return false;
    }

    public static ClassAttributes getAttributes(Class aClass) {
        ClassAttributes classAttributes = (ClassAttributes)classAttributesCache.get(aClass);
        if (classAttributes == null) {
            classAttributes = new ClassAttributes(aClass);
            new PropertyFileAttributeLoader().load(classAttributes);
            classAttributesCache.put(aClass, classAttributes);
        }
        return classAttributes;
    }

    public static URL[] getSearchPath() {
        return searchPaths.toArray(new URL[0]);
    }

    static InputStream findFile(Class klass, String fileName) throws MalformedURLException {
        InputStream inputStream = klass.getResourceAsStream(fileName);
        if (inputStream == null) {
            inputStream = klass.getResourceAsStream('/' + fileName);
        }
        if (inputStream == null) {
            Iterator iterator = searchPaths.iterator();
            while (iterator.hasNext()) {
                URL searchPath = (URL)iterator.next();
                URL url = new URL(searchPath, fileName);
                try {
                    inputStream = url.openStream();
                }
                catch (IOException ignore) {}
            }
        }
        return inputStream;
    }
}

