/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cool.typedmodel.aop;

import com.sap.caf.ui.utils.cool.typedmodel.aop.AspectInstance;
import com.sap.caf.ui.utils.cool.typedmodel.aop.Aspects;
import com.sap.caf.ui.utils.cool.typedmodel.aop.IInterceptor;
import com.sap.caf.ui.utils.cool.typedmodel.aop.IInvocation;
import com.sap.caf.ui.utils.cool.typedmodel.aop.IMethodInterceptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class Mixin
implements Serializable {
    static final long serialVersionUID = 7386027290257587762L;
    private Class _interfaceClass;
    private Object _target;
    private transient Map _methodInterceptors = new HashMap();

    public Mixin() {
    }

    public Mixin(Class interfaceClass, Object target) {
        this.setInterfaceClass(interfaceClass);
        this.setTarget(target);
    }

    public void setInterfaceClass(Class interfaceClass) {
        this._interfaceClass = interfaceClass;
    }

    public void setTarget(Object target) {
        if (target instanceof Mixin) {
            throw new AssertionError();
        }
        this._target = target;
    }

    public Class getInterfaceClass() {
        return this._interfaceClass;
    }

    public Set getAllInterceptors() {
        HashSet<IInterceptor> allInterceptors = new HashSet<IInterceptor>();
        if (this._methodInterceptors != null) {
            Iterator methodIterator = this._methodInterceptors.values().iterator();
            while (methodIterator.hasNext()) {
                List interceptors = (List)methodIterator.next();
                Iterator interceptorIterator = interceptors.iterator();
                while (interceptorIterator.hasNext()) {
                    IInterceptor interceptor = (IInterceptor)interceptorIterator.next();
                    allInterceptors.add(interceptor);
                }
            }
        }
        return allInterceptors;
    }

    public Object getTarget() {
        return this._target;
    }

    public List getInterceptorsForMethod(Method method) {
        ArrayList interceptors;
        if (this._methodInterceptors == null) {
            this._methodInterceptors = new HashMap();
        }
        if ((interceptors = (ArrayList)this._methodInterceptors.get(method)) == null) {
            interceptors = new ArrayList();
            this._methodInterceptors.put(method, interceptors);
        }
        return interceptors;
    }

    public Class getMainClass() {
        return this.getInterfaceClass();
    }

    public Object invokeMethod(Object proxy, Method method, Object[] args) throws Throwable {
        InvocationImpl invocation = new InvocationImpl(proxy, method, args);
        Object returnValue = invocation.invokeNext();
        return returnValue;
    }

    public boolean isMainMixin() {
        return !this.getInterfaceClass().isInterface();
    }

    public void addInterceptor(IMethodInterceptor interceptor) {
        Method[] methods = this.getAllMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            this.addInterceptor(method, interceptor);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Mixin)) {
            return false;
        }
        Mixin mixinInstance = (Mixin)o;
        if (this._interfaceClass == null ? mixinInstance._interfaceClass != null : !this._interfaceClass.equals(mixinInstance._interfaceClass)) {
            return false;
        }
        return this._target == null ? mixinInstance._target == null : this._target.equals(mixinInstance._target);
    }

    public int hashCode() {
        int result = this._interfaceClass == null ? 0 : this._interfaceClass.hashCode();
        result = 29 * result + (this._target == null ? 0 : this._target.hashCode());
        return result;
    }

    public void addInterceptor(Method method, IMethodInterceptor interceptor) {
        this.getInterceptorsForMethod(method).add(interceptor);
    }

    public Method[] getAllMethods() {
        return this._interfaceClass.getMethods();
    }

    public String toString() {
        return "mixin{" + this.getTarget() + "}";
    }

    protected class InvocationImpl
    implements IInvocation {
        protected Object _proxy;
        protected final Method _method;
        protected final Object[] _args;
        protected ListIterator _interceptors;

        public Object invokeNext() throws Throwable {
            try {
                if (this._interceptors.hasNext()) {
                    return ((IMethodInterceptor)this._interceptors.next()).invoke(this);
                }
                return this._method.invoke(this.getTarget(), this._args);
            }
            catch (InvocationTargetException e) {
                this.throwRealException(e);
                return null;
            }
            catch (Throwable e) {
                throw e;
            }
        }

        private void throwRealException(InvocationTargetException e) throws Exception {
            Throwable realException = e.getTargetException();
            if (realException instanceof Error) {
                throw (Error)realException;
            }
            if (realException instanceof RuntimeException) {
                throw (RuntimeException)realException;
            }
            throw (Exception)realException;
        }

        public IInterceptor getInterceptor(int index) {
            return (IInterceptor)Mixin.this.getInterceptorsForMethod(this._method).get(index);
        }

        public Class getTargetInterface() {
            return Mixin.this.getInterfaceClass();
        }

        public AspectInstance getAspectInstance() {
            return Aspects.getAspectInstance(this.getProxy());
        }

        public int getArgumentCount() {
            return null == this._args ? 0 : this._args.length;
        }

        public Object getArgument(int arg) {
            return this._args[arg];
        }

        public Object getTarget() {
            return Mixin.this._target;
        }

        public void setTarget(Object target) {
            Mixin.this.setTarget(target);
        }

        public Object getProxy() {
            return this._proxy;
        }

        public int getCurrentIndex() {
            return this._interceptors.previousIndex();
        }

        public int getInterceptorCount() {
            return Mixin.this.getInterceptorsForMethod(this._method).size();
        }

        public Method getMethod() {
            return this._method;
        }

        public Object[] getArgs() {
            return this._args;
        }

        public InvocationImpl(Object proxy, Method method, Object[] args) {
            this._proxy = proxy;
            this._method = method;
            this._args = args;
            this._interceptors = Mixin.this.getInterceptorsForMethod(method).listIterator();
        }
    }
}

