/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cool.typedmodel.aop;

import com.sap.caf.ui.utils.cool.typedmodel.aop.AspectInstance;
import com.sap.caf.ui.utils.cool.typedmodel.aop.IAspectFactory;
import java.lang.reflect.Proxy;
import java.util.Collection;

public class Aspects {
    private static ThreadLocal contextAspectFactory = new InheritableThreadLocal();
    private static ThreadLocal currentThis = new InheritableThreadLocal();

    public static Collection getInterceptors(Object proxy) {
        return Aspects.getAspectInstance(proxy).getAllInterceptors();
    }

    public static Object getTarget(Object proxy, Class interfaceClass) {
        return Aspects.getAspectInstance(proxy).getTarget(interfaceClass);
    }

    public static AspectInstance getAspectInstance(Object proxy) {
        return (AspectInstance)Proxy.getInvocationHandler(proxy);
    }

    public static void setTarget(Object proxy, Class interfaceClass, Object target) {
        Aspects.getAspectInstance(proxy).setTarget(interfaceClass, target);
    }

    public static boolean isAspectObject(Object o) {
        return o != null ? Proxy.isProxyClass(o.getClass()) : false;
    }

    public static Object[] getTargets(Object object) {
        return object != null ? Aspects.getAspectInstance(object).getTargets() : null;
    }

    public static IAspectFactory getCurrentAspectFactory() {
        if (Aspects.getThis() != null) {
            return Aspects.getAspectInstance(Aspects.getThis()).getAspectFactory();
        }
        return (IAspectFactory)contextAspectFactory.get();
    }

    public static void setContextAspectFactory(IAspectFactory factory) {
        contextAspectFactory.set(factory);
    }

    public static Class getRealClass(Class proxyClass) {
        if (!Proxy.isProxyClass(proxyClass)) {
            return proxyClass;
        }
        Class<?>[] interfaces = proxyClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            Class realClass = Aspects.getRealClass(anInterface);
            if (realClass == null) continue;
            return realClass;
        }
        return null;
    }

    public static Object getThis() {
        return currentThis.get();
    }

    static void setThis(Object proxy) {
        currentThis.set(proxy);
    }
}

