/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cool.typedmodel.aop;

import com.sap.caf.ui.utils.cool.typedmodel.aop.Aspects;
import com.sap.caf.ui.utils.cool.typedmodel.aop.IAspectFactory;
import com.sap.caf.ui.utils.cool.typedmodel.aop.IConstructionInterceptor;
import com.sap.caf.ui.utils.cool.typedmodel.aop.IConstructionInvocation;
import com.sap.caf.ui.utils.cool.typedmodel.aop.IInterceptor;
import com.sap.caf.ui.utils.cool.typedmodel.aop.IMethodInterceptor;
import com.sap.caf.ui.utils.cool.typedmodel.aop.Mixin;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class AspectInstance
implements InvocationHandler,
Serializable {
    static final long serialVersionUID = 5462785783512485056L;
    private Class _classIdentifier;
    private Object _proxy;
    private ClassLoader _classLoader;
    private final Map _attributes = new HashMap();
    private final Map _mixinsMap = new HashMap();
    private final List _mixinsList = new ArrayList();
    private transient List _constructionInterceptors = new ArrayList();
    private transient IAspectFactory _aspectFactory;
    static /* synthetic */ Class class$java$lang$Object;

    public AspectInstance() {
        this(null);
    }

    public AspectInstance(Class classIdentifier) {
        this(null, classIdentifier);
    }

    public AspectInstance(IAspectFactory aspectFactory, Class classIdentifier) {
        this._aspectFactory = aspectFactory;
        this._classIdentifier = classIdentifier;
        this._classLoader = classIdentifier.getClassLoader();
    }

    private Set getInterfaceClasses() {
        HashSet<Class> interfaces = new HashSet<Class>();
        Iterator iterator = this._mixinsMap.keySet().iterator();
        while (iterator.hasNext()) {
            Class interfaceClass = (Class)iterator.next();
            interfaces.add(interfaceClass);
        }
        if (this._classIdentifier != null) {
            interfaces.add(this._classIdentifier);
        }
        return interfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> interfaceClass = method.getDeclaringClass();
        if (interfaceClass != (class$java$lang$Object == null ? (class$java$lang$Object = AspectInstance.class$("java.lang.Object")) : class$java$lang$Object)) {
            Object result;
            Object prevThis = Aspects.getThis();
            try {
                Aspects.setThis(proxy);
                Mixin mixin = this.getMixinForInterface(interfaceClass);
                result = mixin.invokeMethod(proxy, method, args);
            }
            finally {
                Aspects.setThis(prevThis);
            }
            return result;
        }
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (!Aspects.isAspectObject(arg)) continue;
                args[i] = Aspects.getAspectInstance(arg);
            }
        }
        return method.invoke((Object)this, args);
    }

    public Mixin getMixinForInterface(Class interfaceClass) {
        Mixin mixinInstance = (Mixin)this._mixinsMap.get(interfaceClass);
        if (mixinInstance == null) {
            throw new AssertionError((Object)("there is no mixin for interface " + interfaceClass + " mixins were " + this._mixinsMap));
        }
        return mixinInstance;
    }

    public boolean hasMixinForInterface(Class interfaceClass) {
        return this._mixinsMap.containsKey(interfaceClass);
    }

    public void setTarget(Class interfaceClass, Object target) {
        Mixin mixinInstance = this.getMixinForInterface(interfaceClass);
        mixinInstance.setTarget(target);
    }

    public Object[] getTargets() {
        Object[] targets = new Object[this._mixinsList.size()];
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = ((Mixin)this._mixinsList.get(i)).getTarget();
        }
        return targets;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        IAspectFactory currentAspectFactory = Aspects.getCurrentAspectFactory();
        if (currentAspectFactory == null) {
            throw new AssertionError((Object)("context AspectFactory not specified, it is not possible to deserialize " + this));
        }
        this._aspectFactory = currentAspectFactory;
        this._aspectFactory.reinitialize(this);
    }

    public Class getClassIdentifier() {
        return this._classIdentifier;
    }

    public void addMixin(Mixin mixin) {
        if (this._proxy != null) {
            throw new AssertionError((Object)"Can't add mixins when proxy has been created.");
        }
        Class interfaceClass = mixin.getInterfaceClass();
        this.bindMixinToInterface(interfaceClass, mixin);
        this._mixinsList.add(mixin);
    }

    public void setMixins(List mixinsList) {
        this._mixinsList.clear();
        this._mixinsList.addAll(mixinsList);
        this._mixinsMap.clear();
        Iterator i = mixinsList.iterator();
        while (i.hasNext()) {
            Mixin mixinInstance = (Mixin)i.next();
            this.bindMixinToInterface(mixinInstance.getInterfaceClass(), mixinInstance);
        }
    }

    private void bindMixinToInterface(Class interfaceClass, Mixin mixinInstance) {
        Class<?>[] interfaces;
        Class superclass;
        if (interfaceClass.isInterface()) {
            this._mixinsMap.put(interfaceClass, mixinInstance);
        }
        if ((superclass = interfaceClass.getSuperclass()) != null) {
            this.bindMixinToInterface(superclass, mixinInstance);
        }
        if ((interfaces = interfaceClass.getInterfaces()) != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> anInterface = interfaces[i];
                this.bindMixinToInterface(anInterface, mixinInstance);
            }
        }
    }

    public Set getAllInterceptors() {
        LinkedHashSet<IInterceptor> result = new LinkedHashSet<IInterceptor>();
        if (this._constructionInterceptors != null) {
            result.addAll(this._constructionInterceptors);
        }
        Iterator mixinIterator = this._mixinsList.iterator();
        while (mixinIterator.hasNext()) {
            Mixin mixinInstance = (Mixin)mixinIterator.next();
            Set allInterceptors = mixinInstance.getAllInterceptors();
            Iterator interceptorIterator = allInterceptors.iterator();
            while (interceptorIterator.hasNext()) {
                IInterceptor interceptor = (IInterceptor)interceptorIterator.next();
                result.add(interceptor);
            }
        }
        return result;
    }

    public List getInterceptorsForMethod(Method method) {
        return this.getMixinForInterface(method.getDeclaringClass()).getInterceptorsForMethod(method);
    }

    public final IAspectFactory getAspectFactory() {
        return this._aspectFactory;
    }

    public Object getProxy() {
        if (this._proxy == null) {
            Set interfaces = this.getInterfaceClasses();
            ClassLoader classLoader = this._classLoader != null ? this._classLoader : Thread.currentThread().getContextClassLoader();
            this._proxy = Proxy.newProxyInstance(classLoader, interfaces.toArray(new Class[0]), (InvocationHandler)this);
        }
        this._proxy = this.executeConstructionInterceptors(this._proxy);
        return this._proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeConstructionInterceptors(Object proxy) {
        Object prevThis = Aspects.getThis();
        try {
            Aspects.setThis(proxy);
            if (this._constructionInterceptors != null) {
                Iterator iterator = this._constructionInterceptors.iterator();
                while (iterator.hasNext()) {
                    IConstructionInterceptor constructionInterceptor = (IConstructionInterceptor)iterator.next();
                    proxy = constructionInterceptor.construct(new ConstructionInvocationImpl(proxy, this.getClassIdentifier()));
                }
            }
            Object var6_5 = null;
            if (null != this._constructionInterceptors) {
                this._constructionInterceptors.clear();
                this._constructionInterceptors = null;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (null != this._constructionInterceptors) {
                this._constructionInterceptors.clear();
                this._constructionInterceptors = null;
            }
            Aspects.setThis(prevThis);
            throw throwable;
        }
        Aspects.setThis(prevThis);
        return proxy;
    }

    public String toString() {
        if (this._mixinsList.size() == 1) {
            return "aspect{" + this._mixinsList.get(0).toString() + "}";
        }
        return "aspect{class=" + this._classIdentifier + "," + "mixins=" + this._mixinsList + "}";
    }

    public List getMixins() {
        return Collections.unmodifiableList(this._mixinsList);
    }

    public void addConstructionInterceptor(IConstructionInterceptor constructionInterceptor) {
        if (this._constructionInterceptors == null) {
            this._constructionInterceptors = new ArrayList();
        }
        this._constructionInterceptors.add(constructionInterceptor);
    }

    public void addInterceptor(IMethodInterceptor interceptor) {
        Iterator iterator = this._mixinsList.iterator();
        while (iterator.hasNext()) {
            Mixin mixin = (Mixin)iterator.next();
            mixin.addInterceptor(interceptor);
        }
    }

    public void setAttribute(Object key, Object value) {
        this._attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        return this._attributes.get(key);
    }

    public void clearAttributes() {
        this._attributes.clear();
    }

    public boolean hasAttribute(Object key) {
        return this._attributes.containsKey(key);
    }

    Object getTarget(Class interfaceClass) {
        Mixin interfaceInstance = this.getMixinForInterface(interfaceClass);
        return interfaceInstance.getTarget();
    }

    Set getInterceptors(Class interfaceClass) {
        Mixin interfaceInstance = this.getMixinForInterface(interfaceClass);
        return interfaceInstance.getAllInterceptors();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public final class ConstructionInvocationImpl
    implements IConstructionInvocation {
        private final Object _proxy;
        private Class _interfaceClass;

        public Object getProxy() {
            return this._proxy;
        }

        public Object getTarget() {
            return Aspects.getTarget(this._proxy, this._interfaceClass);
        }

        public void setTarget(Object target) {
            Aspects.setTarget(this._proxy, this._interfaceClass, target);
        }

        public ConstructionInvocationImpl(Object proxy, Class interfaceClass) {
            this._proxy = proxy;
            this._interfaceClass = interfaceClass;
        }
    }
}

