/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cool;

import com.sap.caf.rt.ui.cool.generic.Aspect;
import com.sap.caf.rt.ui.cool.generic.MessageFactory;
import com.sap.caf.rt.ui.cool.generic.ServiceFacadeFactory;
import com.sap.caf.rt.ui.cool.generic.ServiceModule;
import com.sap.caf.rt.ui.cool.metadata.MultiUserType;
import com.sap.caf.rt.ui.cool.metadata.SingleUserType;
import com.sap.caf.ui.utils.cool.CoolConnectionProperties;
import com.sap.caf.ui.utils.cool.CoolConnectionPropertiesException;
import com.sap.caf.ui.utils.cool.CoolUtilsException;
import com.sap.caf.ui.utils.std.CAFUIPublicLogger;
import com.sap.dictionary.runtime.IDataType;
import com.sap.tc.col.cds.ConnectionData;
import com.sap.tc.col.cds.ConnectionDataCommon;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IMessage;
import com.sap.tc.col.client.generic.api.IMessageList;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.core.GCPRuntimeException;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.progmodel.api.IWDMessageManager;
import com.sap.tc.webdynpro.progmodel.api.IWDNode;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeElement;
import com.sap.tc.webdynpro.progmodel.api.IWDViewController;
import com.sap.tc.webdynpro.services.sal.localization.api.WDResourceHandler;
import com.sap.tc.webdynpro.services.session.IScope;
import com.sap.tc.webdynpro.services.session.ScopeType;
import com.sap.tc.webdynpro.services.session.Utils;
import java.text.MessageFormat;
import java.util.Locale;

public class CoolUtils {
    private static final String objectName = "sap.com/caf/ui/ptn/common";
    private static final String jARMRequest = "CAF:UI:sap.com/caf/ui/ptn/common";
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$ui$utils$cool$CoolUtils == null ? (class$com$sap$caf$ui$utils$cool$CoolUtils = CoolUtils.class$("com.sap.caf.ui.utils.cool.CoolUtils")) : class$com$sap$caf$ui$utils$cool$CoolUtils));
    public static final String SERVICE_FACADE_KEY = "SERVICE_FACADE";
    public static final int NOT_USER_TYPE = 0;
    public static final int SINGLE_USER_TYPE = 1;
    public static final int MULTI_USER_TYPE = 2;
    public static final String COL_CLASS_ASPECT = "Aspect.";
    public static final String COL_CLASS_QUERY = "Query.";
    static /* synthetic */ Class class$com$sap$caf$ui$utils$cool$CoolUtils;

    public static IServiceFacade getServiceFacade(String deployableObjectName) throws CoolUtilsException {
        String method = "IServiceFacade getServiceFacade(String)";
        CAFUIPublicLogger.entering(null, jARMRequest, "IServiceFacade getServiceFacade(String)", logger);
        try {
            CoolConnectionProperties cp = CoolConnectionProperties.getCoolConnectionProperties(deployableObjectName);
            IServiceFacade iServiceFacade = CoolUtils.getServiceFacade(cp);
            return iServiceFacade;
        }
        catch (CoolConnectionPropertiesException e) {
            String errorMess = MessageFormat.format("Failed to read Cool connection parameters: \n{0}", e.getMessage());
            CAFUIPublicLogger.categoryCAF.logThrowableT(500, logger, "IServiceFacade getServiceFacade(String)", errorMess, (Throwable)e);
            CoolUtilsException CoolUtilsExcep = new CoolUtilsException(errorMess);
            logger.throwing("IServiceFacade getServiceFacade(String)", (Throwable)CoolUtilsExcep);
            throw CoolUtilsExcep;
        }
        catch (GCPRuntimeException e) {
            String errorMess = MessageFormat.format("Failed to connect to Cool server: \n{0}", e.getMessage());
            CAFUIPublicLogger.categoryCAF.logThrowableT(500, logger, "IServiceFacade getServiceFacade(String)", errorMess, (Throwable)e);
            CoolUtilsException CoolUtilsExcep = new CoolUtilsException(errorMess);
            logger.throwing("IServiceFacade getServiceFacade(String)", (Throwable)CoolUtilsExcep);
            throw CoolUtilsExcep;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "IServiceFacade getServiceFacade(String)", logger);
        }
    }

    public static IServiceFacade getServiceFacade(CoolConnectionProperties cp) throws CoolUtilsException {
        String method = "IServiceFacade getServiceFacade(CoolConnectionProperties)";
        CAFUIPublicLogger.entering(null, jARMRequest, "IServiceFacade getServiceFacade(CoolConnectionProperties)", logger);
        try {
            IServiceFacade cd;
            IServiceFacade sf = null;
            if (cp.getCoolHost().equalsIgnoreCase("caf")) {
                sf = ServiceFacadeFactory.getFacadeInstance((Locale)WDResourceHandler.getCurrentSessionLocale());
            } else {
                sf = (IServiceFacade)Utils.getScope((ScopeType)IScope.APPLICATION_SCOPE).get((Object)SERVICE_FACADE_KEY);
                if (sf == null) {
                    cd = new ConnectionDataCommon();
                    cd.setProperty("client", cp.coolClient);
                    cd.setProperty("user", cp.coolUserName);
                    cd.setProperty("passwd", cp.coolUserPassword);
                    cd.setProperty("lang", cp.coolLocaleStr);
                    cd.setProperty("sysnr", cp.coolSysNumber);
                    cd.setProperty("r3name", cp.coolHost);
                    sf = com.sap.tc.col.client.generic.api.ServiceFacadeFactory.createServiceFacade((ConnectionData)cd);
                    Utils.getScope((ScopeType)IScope.APPLICATION_SCOPE).put((Object)SERVICE_FACADE_KEY, (Object)sf);
                }
            }
            cd = sf;
            return cd;
        }
        catch (GCPRuntimeException e) {
            String errorMess = MessageFormat.format("Failed to connect to Cool server: \n{0}", e.getMessage());
            CAFUIPublicLogger.categoryCAF.logThrowableT(500, logger, "IServiceFacade getServiceFacade(CoolConnectionProperties)", errorMess, (Throwable)e);
            CoolUtilsException CoolUtilsExcep = new CoolUtilsException(errorMess);
            logger.throwing("IServiceFacade getServiceFacade(CoolConnectionProperties)", (Throwable)CoolUtilsExcep);
            throw CoolUtilsExcep;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "IServiceFacade getServiceFacade(CoolConnectionProperties)", logger);
        }
    }

    public static IServiceModule getServiceModule(IServiceFacade serviceFacade, String serviceModuleName) throws CoolUtilsException {
        String method = "IServiceModule getServiceModule(IServiceFacade, String)";
        CAFUIPublicLogger.entering(null, jARMRequest, "IServiceModule getServiceModule(IServiceFacade, String)", logger);
        if (serviceFacade == null) {
            return null;
        }
        serviceModuleName = serviceModuleName != null ? serviceModuleName : "";
        try {
            IServiceModule serviceModule = serviceFacade.getServiceModule(serviceModuleName);
            serviceModule.associatedModelInfo();
            IServiceModule iServiceModule = serviceModule;
            return iServiceModule;
        }
        catch (Exception e) {
            String errorMess = MessageFormat.format("Invalid or wrong backend Service Module specified: \n{0}", e.getMessage());
            CAFUIPublicLogger.categoryCAF.logThrowableT(500, logger, "IServiceModule getServiceModule(IServiceFacade, String)", errorMess, (Throwable)e);
            CoolUtilsException CoolUtilsExcep = new CoolUtilsException(errorMess);
            logger.throwing("IServiceModule getServiceModule(IServiceFacade, String)", (Throwable)CoolUtilsExcep);
            throw CoolUtilsExcep;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "IServiceModule getServiceModule(IServiceFacade, String)", logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IAspectDescriptor readAspectMetaData(IServiceModule serviceModule, String aspectName, String[] fieldAttrs, IWDNode nodeTo, String typePrefix) throws CoolUtilsException {
        int i;
        String method = "IAspectDescriptor  readAspectMetaData(IServiceModule, String, String[], IWDNode, String)";
        CAFUIPublicLogger.entering(null, jARMRequest, "IAspectDescriptor  readAspectMetaData(IServiceModule, String, String[], IWDNode, String)", logger);
        if (serviceModule == null) {
            return null;
        }
        IServiceModuleDescriptor serviceModuleDesc = serviceModule.getDescriptor();
        IAspectDescriptor aspectDesc = serviceModuleDesc.getAspectDescriptor(aspectName = aspectName != null ? aspectName : "");
        if (aspectDesc == null) {
            String errorMess = MessageFormat.format("Invalid or wrong backend Aspect specified: \"{0}\"", aspectName);
            CoolUtilsException CoolUtilsExcep = new CoolUtilsException(errorMess);
            logger.throwing("IAspectDescriptor  readAspectMetaData(IServiceModule, String, String[], IWDNode, String)", (Throwable)CoolUtilsExcep);
            CAFUIPublicLogger.exiting(null, jARMRequest, "IAspectDescriptor  readAspectMetaData(IServiceModule, String, String[], IWDNode, String)", logger);
            throw CoolUtilsExcep;
        }
        IStructureDescriptor strDesc = aspectDesc.getStructure();
        int structSize = strDesc.size();
        for (i = 0; i < nodeTo.size(); ++i) {
            nodeTo.removeElement(nodeTo.getElementAt(i));
        }
        try {
            for (i = 0; i < structSize; ++i) {
                IFieldDescriptor fieldDesc = strDesc.getFieldDescriptor(i);
                IWDNodeElement newEl = nodeTo.createElement();
                try {
                    newEl.setAttributeValue(fieldAttrs[0], (Object)fieldDesc.getName());
                }
                catch (Exception e) {
                    CAFUIPublicLogger.traceThrowableT(100, logger, "IAspectDescriptor  readAspectMetaData(IServiceModule, String, String[], IWDNode, String)", e.getMessage(), e);
                }
                try {
                    newEl.setAttributeValue(fieldAttrs[1], (Object)fieldDesc.getText());
                }
                catch (Exception e) {
                    CAFUIPublicLogger.traceThrowableT(100, logger, "IAspectDescriptor  readAspectMetaData(IServiceModule, String, String[], IWDNode, String)", e.getMessage(), e);
                }
                try {
                    String type = typePrefix + fieldDesc.getType();
                    newEl.setAttributeValue(fieldAttrs[2], (Object)type);
                }
                catch (Exception e) {
                    CAFUIPublicLogger.traceThrowableT(100, logger, "IAspectDescriptor  readAspectMetaData(IServiceModule, String, String[], IWDNode, String)", e.getMessage(), e);
                }
                nodeTo.addElement(newEl);
            }
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "IAspectDescriptor  readAspectMetaData(IServiceModule, String, String[], IWDNode, String)", logger);
        }
        return aspectDesc;
    }

    public static void removeCurrentAspectRow(IAspect aspect, IWDNode node) throws CoolUtilsException {
        String method = "removeCurrentAspectRow(IAspect, IWDNode)";
        CAFUIPublicLogger.entering(null, jARMRequest, "removeCurrentAspectRow(IAspect, IWDNode)", logger);
        try {
            IWDNodeElement el = node.getCurrentElement();
            aspect.remove(node.getLeadSelection());
            aspect.sendChanges();
            node.removeElement(el);
        }
        catch (Exception e) {
            String errorMess = MessageFormat.format("Could not remove the aspect row and corresponding current element of the context node : \n{0}", e.getMessage());
            CAFUIPublicLogger.traceThrowableT(100, logger, "removeCurrentAspectRow(IAspect, IWDNode)", errorMess, e);
            CoolUtilsException CoolUtilsExcep = new CoolUtilsException(errorMess);
            logger.throwing("removeCurrentAspectRow(IAspect, IWDNode)", (Throwable)CoolUtilsExcep);
            throw CoolUtilsExcep;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "removeCurrentAspectRow(IAspect, IWDNode)", logger);
        }
    }

    public static String getKeyAsString(IKey key) throws CoolUtilsException {
        String method = "String getKeyAsString(IKey)";
        CAFUIPublicLogger.entering(null, jARMRequest, "String getKeyAsString(IKey)", logger);
        try {
            String strKey = key.toString();
            String string = strKey.substring(1, strKey.length() - 1);
            return string;
        }
        catch (Exception e) {
            String errorMess = MessageFormat.format("Could not convert Key to string : \n{0}", e.getMessage());
            CAFUIPublicLogger.traceThrowableT(100, logger, "String getKeyAsString(IKey)", errorMess, e);
            CoolUtilsException CoolUtilsExcep = new CoolUtilsException(errorMess);
            logger.throwing("String getKeyAsString(IKey)", (Throwable)CoolUtilsExcep);
            throw CoolUtilsExcep;
        }
        finally {
            CAFUIPublicLogger.exiting(null, jARMRequest, "String getKeyAsString(IKey)", logger);
        }
    }

    public static boolean reportCoolMessages(IServiceFacade sf, IWDViewController viewController, boolean stopOnFirstFail, boolean cancelNavigation) {
        return MessageFactory.reportOrRaiseCoolMessages((IMessageList)sf.getAllMessages(), (IWDMessageManager)viewController.getComponent().getMessageManager(), (boolean)stopOnFirstFail, (boolean)cancelNavigation, (boolean)false);
    }

    public static boolean reportCoolMessages(IAspect aspect, IWDMessageManager manager, boolean stopOnFirstFail, boolean cancelNavigation) {
        return MessageFactory.reportOrRaiseCoolMessages((IMessageList)aspect.getMessages(), (IWDMessageManager)manager, (boolean)stopOnFirstFail, (boolean)cancelNavigation, (boolean)false);
    }

    public static boolean reportCoolMessages(IQuery query, IWDMessageManager manager, boolean stopOnFirstFail, boolean cancelNavigation) {
        return MessageFactory.reportOrRaiseCoolMessages((IMessageList)CoolUtils.getQueryResultAspect(query).getMessages(), (IWDMessageManager)manager, (boolean)stopOnFirstFail, (boolean)cancelNavigation, (boolean)false);
    }

    private static IAspect getQueryResultAspect(IQuery query) {
        IAspect aspect = query.getResultAspect();
        if (aspect == null) {
            throw new RuntimeException("Cannot get list of messages from query, because result aspect is null. Query: " + query);
        }
        return aspect;
    }

    public static boolean reportCoolMessages(IServiceFacade sf, IWDMessageManager manager, boolean stopOnFirstFail, boolean cancelNavigation) {
        return MessageFactory.reportOrRaiseCoolMessages((IMessageList)sf.getAllMessages(), (IWDMessageManager)manager, (boolean)stopOnFirstFail, (boolean)cancelNavigation, (boolean)false);
    }

    public static boolean reportCoolMessages(IMessageList list, IWDMessageManager manager, boolean stopOnFirstFail, boolean cancelNavigation) {
        return MessageFactory.reportOrRaiseCoolMessages((IMessageList)list, (IWDMessageManager)manager, (boolean)stopOnFirstFail, (boolean)cancelNavigation, (boolean)false);
    }

    public static boolean raiseCoolMessages(IServiceFacade sf, IWDViewController viewController, boolean stopOnFirstFail, boolean cancelNavigation) {
        return MessageFactory.reportOrRaiseCoolMessages((IMessageList)sf.getAllMessages(), (IWDMessageManager)viewController.getComponent().getMessageManager(), (boolean)stopOnFirstFail, (boolean)cancelNavigation, (boolean)true);
    }

    public static boolean reportCoolMessages(IAspect aspect, IWDViewController viewController, boolean stopOnFirstFail, boolean cancelNavigation) {
        return MessageFactory.reportOrRaiseCoolMessages((IMessageList)aspect.getMessages(), (IWDMessageManager)viewController.getComponent().getMessageManager(), (boolean)stopOnFirstFail, (boolean)cancelNavigation, (boolean)false);
    }

    public static boolean reportCoolMessages(IQuery query, IWDViewController viewController, boolean stopOnFirstFail, boolean cancelNavigation) {
        return MessageFactory.reportOrRaiseCoolMessages((IMessageList)CoolUtils.getQueryResultAspect(query).getMessages(), (IWDMessageManager)viewController.getComponent().getMessageManager(), (boolean)stopOnFirstFail, (boolean)cancelNavigation, (boolean)false);
    }

    public static boolean raiseCoolMessages(IAspect aspect, IWDMessageManager manager, boolean stopOnFirstFail, boolean cancelNavigation) {
        return MessageFactory.reportOrRaiseCoolMessages((IMessageList)aspect.getMessages(), (IWDMessageManager)manager, (boolean)stopOnFirstFail, (boolean)cancelNavigation, (boolean)true);
    }

    public static boolean raiseCoolMessages(IQuery query, IWDMessageManager manager, boolean stopOnFirstFail, boolean cancelNavigation) {
        return MessageFactory.reportOrRaiseCoolMessages((IMessageList)CoolUtils.getQueryResultAspect(query).getMessages(), (IWDMessageManager)manager, (boolean)stopOnFirstFail, (boolean)cancelNavigation, (boolean)true);
    }

    public static boolean raiseCoolMessages(IServiceFacade sf, IWDMessageManager manager, boolean stopOnFirstFail, boolean cancelNavigation) {
        return MessageFactory.reportOrRaiseCoolMessages((IMessageList)sf.getAllMessages(), (IWDMessageManager)manager, (boolean)stopOnFirstFail, (boolean)cancelNavigation, (boolean)true);
    }

    public static boolean raiseCoolMessages(IMessageList list, IWDMessageManager manager, boolean stopOnFirstFail, boolean cancelNavigation) {
        return MessageFactory.reportOrRaiseCoolMessages((IMessageList)list, (IWDMessageManager)manager, (boolean)stopOnFirstFail, (boolean)cancelNavigation, (boolean)true);
    }

    public static boolean reportOrRaiseCoolMessages(IMessageList list, IWDMessageManager manager, boolean stopOnFirstFail, boolean cancelNavigation, boolean raise) {
        return MessageFactory.reportOrRaiseCoolMessages((IMessageList)list, (IWDMessageManager)manager, (boolean)stopOnFirstFail, (boolean)cancelNavigation, (boolean)raise);
    }

    public static boolean isAspectDirty(IAspect aspect) {
        return ((Aspect)aspect).isDirty();
    }

    public static boolean isServiceModuleDirty(IServiceModule sm) {
        return ((ServiceModule)sm).isDirty();
    }

    public static boolean isFatal(IAspect aspect) {
        return CoolUtils.isFatal(aspect.getMessages());
    }

    public static boolean isFatal(IQuery query) {
        return CoolUtils.isFatal(CoolUtils.getQueryResultAspect(query).getMessages());
    }

    public static boolean isFatal(IServiceFacade sf) {
        return CoolUtils.isFatal(sf.getAllMessages());
    }

    public static boolean isFatal(IMessageList list) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            IMessage msg = list.getMessage(i);
            if (!msg.isFailed()) continue;
            return true;
        }
        return false;
    }

    public static int isUserTypeField(IDataType dataType) {
        if (dataType instanceof MultiUserType) {
            return 2;
        }
        if (dataType instanceof SingleUserType) {
            return 1;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

