/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cool;

import com.sap.dictionary.runtime.ISimpleTypeModifiable;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.metadata.api.IAspectActionDescriptor;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IQueryDescriptor;
import com.sap.tc.col.client.metadata.api.IRelationDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNode;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeElement;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
import com.sap.typeservices.IModifiableSimpleValueSet;
import com.sap.typeservices.ISimpleValueSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CoolDescriptorsSelector {
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$ui$utils$cool$CoolDescriptorsSelector == null ? (class$com$sap$caf$ui$utils$cool$CoolDescriptorsSelector = CoolDescriptorsSelector.class$("com.sap.caf.ui.utils.cool.CoolDescriptorsSelector")) : class$com$sap$caf$ui$utils$cool$CoolDescriptorsSelector));
    private IServiceFacade m_ServiceFacade;
    private IWDNode m_CtxNode;
    private IWDNodeInfo m_NodeInfo;
    private List m_ServiceModules = new LinkedList();
    private Map m_CtxAttr2CoolItem = new HashMap();
    static /* synthetic */ Class class$com$sap$caf$ui$utils$cool$CoolDescriptorsSelector;

    public CoolDescriptorsSelector(IServiceFacade facade, IWDNode ctxNode) {
        this.m_ServiceFacade = facade;
        this.m_CtxNode = ctxNode;
        if (ctxNode != null) {
            this.m_NodeInfo = ctxNode.getNodeInfo();
        }
    }

    public void addServiceFacade(String[] moduleCtxAttrs) {
        this.m_ServiceModules.addAll(Arrays.asList(moduleCtxAttrs));
    }

    public void addServiceModule(String ctxAttr, String[] aspectCtxAttrs, String[] queryCtxAttrs) {
        ModuleInfo coolItemInfo = (ModuleInfo)this.m_CtxAttr2CoolItem.get(ctxAttr);
        if (coolItemInfo == null) {
            coolItemInfo = new ModuleInfo(aspectCtxAttrs, queryCtxAttrs);
        } else {
            if (coolItemInfo.aspectCtxAttrs == null) {
                coolItemInfo.aspectCtxAttrs = aspectCtxAttrs;
            }
            if (coolItemInfo.queryCtxAttrs == null) {
                coolItemInfo.queryCtxAttrs = queryCtxAttrs;
            }
        }
        this.m_CtxAttr2CoolItem.put(ctxAttr, coolItemInfo);
        this.addServiceFacade(new String[]{ctxAttr});
    }

    public void addServiceModuleWithAspect(String ctxAttr, String aspectCtxAttr, String[] aspectAttrCtxAttrs) {
        this.addServiceModuleWithAspect(ctxAttr, aspectCtxAttr, aspectAttrCtxAttrs, null, null);
    }

    public void addServiceModuleWithAspect(String ctxAttr, String aspectCtxAttr, String[] aspectAttrCtxAttrs, String[] aspectActionCtxAttrs, String[] aspectRelationCtxAttrs) {
        this.addServiceModule(ctxAttr, new String[]{aspectCtxAttr}, null);
        this.addAspect(aspectCtxAttr, aspectAttrCtxAttrs, aspectActionCtxAttrs, aspectRelationCtxAttrs);
    }

    public void addServiceModuleWithQuery(String ctxAttr, String queryCtxAttr, String[] inParamCtxAttrs) {
        this.addServiceModuleWithQuery(ctxAttr, queryCtxAttr, inParamCtxAttrs, null, null, null, null);
    }

    public void addServiceModuleWithQuery(String ctxAttr, String queryCtxAttr, String[] inParamCtxAttrs, String resultAspectCtxAttr, String[] outParamCtxAttrs) {
        this.addServiceModuleWithQuery(ctxAttr, queryCtxAttr, inParamCtxAttrs, resultAspectCtxAttr, outParamCtxAttrs, null, null);
    }

    public void addServiceModuleWithQuery(String ctxAttr, String queryCtxAttr, String[] inParamCtxAttrs, String resultAspectCtxAttr, String[] outParamCtxAttrs, String[] actionCtxAttrs, String[] relationCtxAttrs) {
        this.addServiceModule(ctxAttr, null, new String[]{queryCtxAttr});
        this.addQuery(queryCtxAttr, inParamCtxAttrs, resultAspectCtxAttr, outParamCtxAttrs, actionCtxAttrs, relationCtxAttrs);
    }

    public void addAspect(String ctxAttr, String[] attrCtxAttrs) {
        this.addAspect(ctxAttr, attrCtxAttrs, null, null);
    }

    public void addAspect(String ctxAttr, String[] attrCtxAttrs, String[] actionCtxAttrs, String[] relationCtxAttrs) {
        AspectInfo coolItemInfo = (AspectInfo)this.m_CtxAttr2CoolItem.get(ctxAttr);
        if (coolItemInfo == null) {
            coolItemInfo = new AspectInfo(attrCtxAttrs, actionCtxAttrs, relationCtxAttrs);
        } else {
            if (coolItemInfo.attrCtxAttrs == null) {
                coolItemInfo.attrCtxAttrs = attrCtxAttrs;
            }
            if (coolItemInfo.actionCtxAttrs == null) {
                coolItemInfo.actionCtxAttrs = actionCtxAttrs;
            }
            if (coolItemInfo.relationCtxAttrs == null) {
                coolItemInfo.relationCtxAttrs = relationCtxAttrs;
            }
        }
        this.m_CtxAttr2CoolItem.put(ctxAttr, coolItemInfo);
    }

    public void addAspectWithAction(String ctxAttr, String[] attrCtxAttrs, String actionCtxAttr, String[] actionParamCtxAttrs) {
        this.addAspect(ctxAttr, attrCtxAttrs, new String[]{actionCtxAttr}, null);
        this.addAction(actionCtxAttr, actionParamCtxAttrs);
    }

    public void addQuery(String ctxAttr, String[] inParamCtxAttrs) {
        this.m_CtxAttr2CoolItem.put(ctxAttr, new QueryInfo(inParamCtxAttrs));
    }

    public void addQuery(String ctxAttr, String[] inParamCtxAttrs, String resultAspectCtxAttr, String[] outParamCtxAttrs) {
        this.addQuery(ctxAttr, inParamCtxAttrs, resultAspectCtxAttr, outParamCtxAttrs, null, null);
    }

    public void addQuery(String ctxAttr, String[] inParamCtxAttrs, String resultAspectCtxAttr, String[] outParamCtxAttrs, String[] actionCtxAttrs, String[] relationCtxAttrs) {
        this.addQuery(ctxAttr, inParamCtxAttrs);
        if (outParamCtxAttrs != null) {
            QueryInfo queryInfo = (QueryInfo)this.m_CtxAttr2CoolItem.get(ctxAttr);
            if (resultAspectCtxAttr == null) {
                resultAspectCtxAttr = CoolDescriptorsSelector.getQueryResultAspectCtxAttr(ctxAttr);
                queryInfo.hasResultAspectAttr = false;
            } else {
                queryInfo.hasResultAspectAttr = true;
            }
            queryInfo.aspectCtxAttr = resultAspectCtxAttr;
            this.addAspect(resultAspectCtxAttr, outParamCtxAttrs, actionCtxAttrs, relationCtxAttrs);
        }
    }

    public void addAction(String ctxAttr, String[] attrCtxAttrs) {
        this.m_CtxAttr2CoolItem.put(ctxAttr, new ActionInfo(attrCtxAttrs));
    }

    public void initServiceFacade() {
        try {
            if (!this.m_ServiceModules.isEmpty()) {
                List valueSets = this.getValueSets(this.m_ServiceModules.toArray(new String[this.m_ServiceModules.size()]));
                String[] moduleNames = this.getServiceFacade().getServiceModuleNames();
                for (int i = 0; i < moduleNames.length; ++i) {
                    this.putValue(valueSets, moduleNames[i]);
                }
                IWDNodeElement el = this.getCtxNode().getCurrentElement();
                String firstModule = moduleNames.length > 0 ? moduleNames[0] : null;
                Iterator iVS = valueSets.iterator();
                Iterator iM = this.m_ServiceModules.iterator();
                while (iM.hasNext()) {
                    String moduleCtxAttr = (String)iM.next();
                    this.setContextAttribute(moduleCtxAttr, (ISimpleValueSet)iVS.next());
                    this.selectServiceModule(moduleCtxAttr);
                }
            }
        }
        catch (Exception e) {
            logger.catching((Throwable)e);
        }
    }

    public void selectServiceModule(String ctxAttr) {
        try {
            List valueSets;
            IWDNodeElement el = this.getCtxNode().getCurrentElement();
            IServiceModuleDescriptor moduleDescr = this.getServiceFacade().getServiceModule(el.getAttributeAsText(ctxAttr)).getDescriptor();
            ModuleInfo moduleInfo = (ModuleInfo)this.getCoolItemInfo(ctxAttr);
            if (moduleInfo.aspectCtxAttrs != null) {
                valueSets = this.getValueSets(moduleInfo.aspectCtxAttrs);
                IAspectDescriptor[] aspectDecrs = moduleDescr.getAspectDescriptors();
                for (int i = 0; i < aspectDecrs.length; ++i) {
                    this.putValue(valueSets, aspectDecrs[i].getName());
                }
                Iterator iVS = valueSets.iterator();
                for (int iA = 0; iA < moduleInfo.aspectCtxAttrs.length; ++iA) {
                    String aspectCtxAttr = moduleInfo.aspectCtxAttrs[iA];
                    this.setModuleItem(aspectCtxAttr, (ISimpleValueSet)iVS.next(), moduleDescr);
                    this.selectAspect(aspectCtxAttr);
                }
            }
            if (moduleInfo.queryCtxAttrs != null) {
                valueSets = this.getValueSets(moduleInfo.queryCtxAttrs);
                IQueryDescriptor[] queryDecrs = moduleDescr.getQueryDescriptors();
                for (int i = 0; i < queryDecrs.length; ++i) {
                    this.putValue(valueSets, queryDecrs[i].getName());
                }
                Iterator iVS = valueSets.iterator();
                for (int i = 0; i < moduleInfo.queryCtxAttrs.length; ++i) {
                    String queryCtxAttr = moduleInfo.queryCtxAttrs[i];
                    this.setModuleItem(queryCtxAttr, (ISimpleValueSet)iVS.next(), moduleDescr);
                    this.selectQuery(queryCtxAttr);
                }
            }
        }
        catch (Exception e) {
            logger.catching((Throwable)e);
        }
    }

    public void selectAspect(String ctxAttr) {
        this.selectAspect(ctxAttr, null);
    }

    public void selectAspect(String ctxAttr, IServiceModuleDescriptor moduleDescr) {
        try {
            String aspectName = this.getCtxNode().getCurrentElement().getAttributeAsText(ctxAttr);
            this.selectAspect(ctxAttr, aspectName, moduleDescr);
        }
        catch (Exception e) {
            logger.catching((Throwable)e);
        }
    }

    private void selectAspect(String ctxAttr, String aspectName, IServiceModuleDescriptor moduleDescr) throws Exception {
        List valueSets;
        AspectInfo aspectInfo = (AspectInfo)this.getCoolItemInfo(ctxAttr);
        if (moduleDescr == null) {
            moduleDescr = aspectInfo.getModuleDescriptor();
        }
        IAspectDescriptor aspectDescr = moduleDescr.getAspectDescriptor(aspectName);
        if (aspectInfo.attrCtxAttrs != null) {
            this.selectStructure(aspectDescr.getStructure(), aspectInfo.attrCtxAttrs);
        }
        if (aspectInfo.actionCtxAttrs != null) {
            valueSets = this.getValueSets(aspectInfo.actionCtxAttrs);
            IAspectActionDescriptor[] actionDecrs = aspectDescr.getAspectActionDescriptors();
            for (int i = 0; i < actionDecrs.length; ++i) {
                this.putValue(valueSets, actionDecrs[i].getName());
            }
            Iterator iVS = valueSets.iterator();
            for (int i = 0; i < aspectInfo.actionCtxAttrs.length; ++i) {
                String actionCtxAttr = aspectInfo.actionCtxAttrs[i];
                ActionInfo actionInfo = (ActionInfo)this.getCoolItemInfo(actionCtxAttr);
                actionInfo.aspectDescr = aspectDescr;
                this.setContextAttribute(actionCtxAttr, (ISimpleValueSet)iVS.next());
                this.selectAction(actionCtxAttr);
            }
        }
        if (aspectInfo.relationCtxAttrs != null) {
            valueSets = this.getValueSets(aspectInfo.relationCtxAttrs);
            IRelationDescriptor[] relationDecrs = aspectDescr.getKeyDescriptor().getRelationDescriptors();
            for (int i = 0; i < relationDecrs.length; ++i) {
                this.putValue(valueSets, relationDecrs[i].getName());
            }
            this.setContextAttributes(aspectInfo.relationCtxAttrs, valueSets);
        }
    }

    public void selectQuery(String ctxAttr) {
        this.selectQuery(ctxAttr, null);
    }

    public void selectQuery(String ctxAttr, IServiceModuleDescriptor moduleDescr) {
        try {
            QueryInfo queryInfo = (QueryInfo)this.getCoolItemInfo(ctxAttr);
            if (moduleDescr == null) {
                moduleDescr = queryInfo.getModuleDescriptor();
            }
            String queryName = this.getCtxNode().getCurrentElement().getAttributeAsText(ctxAttr);
            IQueryDescriptor queryDescr = moduleDescr.getQueryDescriptor(queryName);
            if (queryInfo.attrCtxAttrs != null) {
                this.selectStructure(queryDescr.getInputParameters(), queryInfo.attrCtxAttrs);
            }
            if (queryInfo.aspectCtxAttr != null) {
                IAspectDescriptor resultAspectDescr = queryDescr.getResultAspectDescriptor();
                ModuleItemInfo moduleItemInfo = (ModuleItemInfo)this.getCoolItemInfo(queryInfo.aspectCtxAttr);
                moduleItemInfo.moduleDescr = resultAspectDescr.getServiceModuleDescriptor();
                String resultAspectName = resultAspectDescr.getName();
                if (queryInfo.hasResultAspectAttr) {
                    this.getCtxNode().getCurrentElement().setAttributeValue(queryInfo.aspectCtxAttr, (Object)resultAspectName);
                }
                this.selectAspect(queryInfo.aspectCtxAttr, resultAspectName, null);
            }
        }
        catch (Exception e) {
            logger.catching((Throwable)e);
        }
    }

    public void selectAction(String ctxAttr) {
        this.selectAction(ctxAttr, null);
    }

    public void selectAction(String ctxAttr, IAspectDescriptor aspectDescr) {
        try {
            ActionInfo actionInfo = (ActionInfo)this.getCoolItemInfo(ctxAttr);
            if (actionInfo.attrCtxAttrs != null) {
                String actionName = this.getCtxNode().getCurrentElement().getAttributeAsText(ctxAttr);
                if (aspectDescr == null) {
                    aspectDescr = actionInfo.getAspectDescriptor();
                }
                IAspectActionDescriptor actionDescr = aspectDescr.getAspectActionDescriptor(actionName);
                this.selectStructure(actionDescr.getInputParameters(), actionInfo.attrCtxAttrs);
            }
        }
        catch (Exception e) {
            logger.catching((Throwable)e);
        }
    }

    private void selectStructure(IStructureDescriptor structDescr, String[] attrCtxAttrs) throws Exception {
        List valueSets = this.getValueSets(attrCtxAttrs);
        int size = structDescr.size();
        for (int i = 0; i < size; ++i) {
            this.putValue(valueSets, structDescr.getFieldDescriptor(i).getName());
        }
        this.setContextAttributes(attrCtxAttrs, valueSets);
    }

    private void setModuleItem(String ctxAttr, ISimpleValueSet valueSet, IServiceModuleDescriptor moduleDescr) throws Exception {
        ModuleItemInfo moduleItemInfo = (ModuleItemInfo)this.getCoolItemInfo(ctxAttr);
        moduleItemInfo.moduleDescr = moduleDescr;
        this.setContextAttribute(ctxAttr, valueSet);
    }

    private void setContextAttributes(String[] ctxAttrs, List valueSets) throws Exception {
        Iterator iVS = valueSets.iterator();
        for (int i = 0; i < ctxAttrs.length; ++i) {
            this.setContextAttribute(ctxAttrs[i], (ISimpleValueSet)iVS.next());
        }
    }

    private void setContextAttribute(String ctxAttr, ISimpleValueSet valueSet) throws Exception {
        IWDNodeElement el = this.getCtxNode().getCurrentElement();
        if (!valueSet.containsKey((Object)el.getAttributeAsText(ctxAttr))) {
            String firstItem = valueSet.isEmpty() ? null : (String)valueSet.getKey(0);
            el.setAttributeValue(ctxAttr, (Object)firstItem);
        }
    }

    private List getValueSets(String[] ctxAttrs) throws Exception {
        if (ctxAttrs != null) {
            ArrayList<IModifiableSimpleValueSet> valueSets = new ArrayList<IModifiableSimpleValueSet>(ctxAttrs.length);
            for (int i = 0; i < ctxAttrs.length; ++i) {
                valueSets.add(this.getValueSet(ctxAttrs[i]));
            }
            return valueSets;
        }
        return Collections.EMPTY_LIST;
    }

    private IModifiableSimpleValueSet getValueSet(String ctxAttr) throws Exception {
        ISimpleTypeModifiable type;
        IModifiableSimpleValueSet valueSet = null;
        IWDAttributeInfo attrInfo = this.getCtxNodeInfo().getAttribute(ctxAttr);
        if (attrInfo != null && (type = attrInfo.getModifiableSimpleType()) != null && type.hasSVService() && (valueSet = type.getSVServices().getModifiableSimpleValueSet()) != null) {
            valueSet.clear();
        }
        return valueSet;
    }

    private void putValue(List valueSets, String value) {
        Iterator i = valueSets.iterator();
        while (i.hasNext()) {
            IModifiableSimpleValueSet valueSet = (IModifiableSimpleValueSet)i.next();
            valueSet.put((Object)value, value);
        }
    }

    private CoolItemInfo getCoolItemInfo(String ctxAttr) throws Exception {
        CoolItemInfo info = (CoolItemInfo)this.m_CtxAttr2CoolItem.get(ctxAttr);
        if (info != null) {
            return info;
        }
        throw new RuntimeException("The context attribute is not added to Cool items hierarchy: " + ctxAttr);
    }

    private static String getQueryResultAspectCtxAttr(String queryCtxAttr) {
        return queryCtxAttr + "$query";
    }

    private IWDNode getCtxNode() throws Exception {
        if (this.m_CtxNode != null) {
            return this.m_CtxNode;
        }
        throw new NullPointerException("Context node is not specified ot <null>");
    }

    private IWDNodeInfo getCtxNodeInfo() throws Exception {
        this.getCtxNode();
        return this.m_NodeInfo;
    }

    private IServiceFacade getServiceFacade() throws Exception {
        if (this.m_ServiceFacade != null) {
            return this.m_ServiceFacade;
        }
        throw new NullPointerException("Service facade is not specified or <null>");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AspectInfo
    extends ModuleItemInfo {
        String[] actionCtxAttrs;
        String[] relationCtxAttrs;

        AspectInfo(String[] attrCtxAttrs, String[] actionCtxAttrs, String[] relationCtxAttrs) {
            super(attrCtxAttrs);
            this.actionCtxAttrs = actionCtxAttrs;
            this.relationCtxAttrs = relationCtxAttrs;
        }
    }

    private class ActionInfo
    extends StructureInfo {
        private IAspectDescriptor aspectDescr;

        ActionInfo(String[] attrCtxAttrs) {
            super(attrCtxAttrs);
        }

        public IAspectDescriptor getAspectDescriptor() throws Exception {
            if (this.aspectDescr != null) {
                return this.aspectDescr;
            }
            throw new NullPointerException("Aspect descriptor is null");
        }
    }

    private class QueryInfo
    extends ModuleItemInfo {
        String aspectCtxAttr;
        boolean hasResultAspectAttr = false;

        QueryInfo(String[] inParamCtxAttrs) {
            super(inParamCtxAttrs);
        }
    }

    private class ModuleItemInfo
    extends StructureInfo {
        private IServiceModuleDescriptor moduleDescr;

        ModuleItemInfo(String[] attrCtxAttrs) {
            super(attrCtxAttrs);
        }

        public IServiceModuleDescriptor getModuleDescriptor() throws Exception {
            if (this.moduleDescr != null) {
                return this.moduleDescr;
            }
            throw new NullPointerException("Service Module descriptor is null");
        }
    }

    private class StructureInfo
    extends CoolItemInfo {
        String[] attrCtxAttrs;

        StructureInfo(String[] attrCtxAttrs) {
            this.attrCtxAttrs = attrCtxAttrs;
        }
    }

    private class ModuleInfo
    extends CoolItemInfo {
        String[] aspectCtxAttrs;
        String[] queryCtxAttrs;

        ModuleInfo(String[] aspectCtxAttrs, String[] queryCtxAttrs) {
            this.aspectCtxAttrs = aspectCtxAttrs;
            this.queryCtxAttrs = queryCtxAttrs;
        }
    }

    private abstract class CoolItemInfo {
        private CoolItemInfo() {
        }
    }
}

