/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.utils.cafproperties;

import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.bol.context.CAFProperties;
import com.sap.caf.ui.utils.std.CAFUIPublicLogger;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;

public abstract class CAFPropertyReader {
    private static final String VAR_HOST = "km_host";
    private static final String VAR_PORT = "km_port";
    private static final String objectName = "sap.com/caf/ui/ptn/common";
    private static final String jARMRequest = "CAF:UI:sap.com/caf/ui/ptn/common";
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$ui$utils$cafproperties$CAFPropertyReader == null ? (class$com$sap$caf$ui$utils$cafproperties$CAFPropertyReader = CAFPropertyReader.class$("com.sap.caf.ui.utils.cafproperties.CAFPropertyReader")) : class$com$sap$caf$ui$utils$cafproperties$CAFPropertyReader));
    static /* synthetic */ Class class$com$sap$caf$ui$utils$cafproperties$CAFPropertyReader;

    public static String getCAFPropery(String propertyName) {
        String method = "String getCAFPropery(String)";
        CAFUIPublicLogger.entering(null, jARMRequest, "String getCAFPropery(String)", logger);
        CAFProperties props = new CAFProperties();
        try {
            props.loadApplicationProperties();
        }
        catch (Exception e) {
            String message = MessageFormat.format("Could not read properties(property name: {0}) cause: {1}", propertyName, e.getMessage());
            CAFUIPublicLogger.categoryCAF.logThrowableT(400, logger, "String getCAFPropery(String)", message, (Throwable)e);
            CAFUIPublicLogger.exiting(null, jARMRequest, "String getCAFPropery(String)", logger);
            throw new RuntimeException(message);
        }
        CAFUIPublicLogger.exiting(null, jARMRequest, "String getCAFPropery(String)", logger);
        return CAFPropertyReader.getActualUrl(props.getProperty(propertyName));
    }

    public static String getCAFProperty(String propertyName) throws Exception {
        String method = "String getCAFProperty(String)";
        CAFUIPublicLogger.entering(null, jARMRequest, "String getCAFProperty(String)", logger);
        CAFProperties props = new CAFProperties();
        props.loadApplicationProperties();
        CAFUIPublicLogger.exiting(null, jARMRequest, "String getCAFProperty(String)", logger);
        return props.getProperty(propertyName);
    }

    public static String substituteKMUrlParams(String url) {
        return CAFPropertyReader.getActualUrl(url);
    }

    public static String getActualUrl(String url) {
        String method = "String getActualUrl(String)";
        CAFUIPublicLogger.entering(null, jARMRequest, "String getActualUrl(String)", logger);
        StringBuffer tmp = null;
        Object host = null;
        int i = -1;
        i = url.indexOf(VAR_HOST);
        if (i != -1) {
            tmp = new StringBuffer();
            tmp.append(url.substring(0, i));
            tmp.append(CAFContext.KM_MACHINE_ADDRESS);
            tmp.append(url.substring(i + VAR_HOST.length()));
            url = tmp.toString();
        }
        if ((i = url.indexOf(VAR_PORT)) != -1) {
            tmp = new StringBuffer();
            tmp.append(url.substring(0, i));
            tmp.append(CAFContext.KM_MACHINE_PORT);
            tmp.append(url.substring(i + VAR_PORT.length()));
            url = tmp.toString();
        }
        CAFUIPublicLogger.exiting(null, jARMRequest, "String getActualUrl(String)", logger);
        return url;
    }

    public static String makeKMUrlByRId(String url, String rId) {
        String result;
        int iEndCh;
        String method = "String makeKMUrlByRId(String, String)";
        CAFUIPublicLogger.entering(null, jARMRequest, "String makeKMUrlByRId(String, String)", logger);
        String kmAddress = url;
        if (kmAddress == null) {
            kmAddress = "";
        }
        if (rId != null && rId.length() > 0 && rId.charAt(0) == '/') {
            for (iEndCh = kmAddress.length(); iEndCh > 0 && kmAddress.charAt(iEndCh - 1) == '/'; --iEndCh) {
            }
        }
        if ((result = kmAddress.substring(0, iEndCh) + rId).indexOf(63) == -1) {
            result = result + "?dummy";
        }
        CAFUIPublicLogger.exiting(null, jARMRequest, "String makeKMUrlByRId(String, String)", logger);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

