/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

class TextUtilities {
    public static final String[] fgDelimiters = new String[]{"\n", "\r", "\r\n"};

    TextUtilities() {
    }

    public static String determineLineDelimiter(String text, String hint) {
        try {
            int[] info = TextUtilities.indexOf(fgDelimiters, text, 0);
            return fgDelimiters[info[1]];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return hint;
        }
    }

    public static int[] indexOf(String[] searchStrings, String text, int offset) {
        int[] result = new int[]{-1, -1};
        int i = 0;
        while (i < searchStrings.length) {
            int index = text.indexOf(searchStrings[i], offset);
            if (index >= 0) {
                if (result[0] == -1) {
                    result[0] = index;
                    result[1] = i;
                } else if (index < result[0]) {
                    result[0] = index;
                    result[1] = i;
                } else if (index == result[0] && searchStrings[i].length() > searchStrings[result[1]].length()) {
                    result[0] = index;
                    result[1] = i;
                }
            }
            ++i;
        }
        return result;
    }

    public static int endsWith(String[] searchStrings, String text) {
        int index = -1;
        int i = 0;
        while (i < searchStrings.length) {
            if (text.endsWith(searchStrings[i]) && (index == -1 || searchStrings[i].length() > searchStrings[index].length())) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static int startsWith(String[] searchStrings, String text) {
        int index = -1;
        int i = 0;
        while (i < searchStrings.length) {
            if (text.startsWith(searchStrings[i]) && (index == -1 || searchStrings[i].length() > searchStrings[index].length())) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static int equals(String[] compareStrings, String text) {
        int i = 0;
        while (i < compareStrings.length) {
            if (text.equals(compareStrings[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

