/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.IStatusField;

public class StatusLineContributionItem
extends ContributionItem
implements IStatusField {
    private static final int INDENT = 3;
    private static final int LENGTH = 14;
    private int fFixedWidth = -1;
    private String fText;
    private Image fImage;
    private CLabel fLabel;

    public StatusLineContributionItem(String id) {
        super(id);
    }

    public void setText(String text) {
        this.fText = text;
        if (this.fLabel != null && !this.fLabel.isDisposed()) {
            this.fLabel.setText(this.fText);
        }
    }

    public void setImage(Image image) {
        this.fImage = image;
        if (this.fLabel != null && !this.fLabel.isDisposed()) {
            this.fLabel.setImage(this.fImage);
        }
    }

    public void fill(Composite parent) {
        this.fLabel = new CLabel(parent, 4);
        StatusLineLayoutData data = new StatusLineLayoutData();
        data.widthHint = this.getWidthHint(parent);
        this.fLabel.setLayoutData((Object)data);
        if (this.fText != null) {
            this.fLabel.setText(this.fText);
        }
    }

    private int getWidthHint(Composite control) {
        if (this.fFixedWidth < 0) {
            GC gc = new GC((Drawable)control);
            gc.setFont(control.getFont());
            this.fFixedWidth = gc.getFontMetrics().getAverageCharWidth() * 14;
            this.fFixedWidth += 6;
            gc.dispose();
        }
        return this.fFixedWidth;
    }
}

