/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.EditorMessages;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class DocumentProviderRegistry {
    private static DocumentProviderRegistry fgRegistry;
    private Map fExtensionMapping = new HashMap();
    private Map fInputTypeMapping = new HashMap();
    private Map fInstances = new HashMap();
    static /* synthetic */ Class class$0;

    public static DocumentProviderRegistry getDefault() {
        if (fgRegistry == null) {
            fgRegistry = new DocumentProviderRegistry();
        }
        return fgRegistry;
    }

    private DocumentProviderRegistry() {
        this.initialize();
    }

    private void read(Map map, IConfigurationElement element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                HashSet<IConfigurationElement> s = (HashSet<IConfigurationElement>)map.get(token);
                if (s == null) {
                    s = new HashSet<IConfigurationElement>();
                    map.put(token, s);
                }
                s.add(element);
            }
        }
    }

    private void initialize() {
        IExtensionPoint extensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.ui", "documentProviders");
        if (extensionPoint == null) {
            String msg = MessageFormat.format(EditorMessages.getString("DocumentProviderRegistry.error.extension_point_not_found"), "org.eclipse.ui");
            ILog log = Platform.getPlugin((String)"org.eclipse.ui").getLog();
            log.log((IStatus)new Status(4, "org.eclipse.ui", 0, msg, null));
            return;
        }
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            this.read(this.fExtensionMapping, elements[i], "extensions");
            this.read(this.fInputTypeMapping, elements[i], "inputTypes");
            ++i;
        }
    }

    private IDocumentProvider getDocumentProvider(IConfigurationElement entry) {
        IDocumentProvider provider = (IDocumentProvider)this.fInstances.get(entry);
        if (provider == null) {
            try {
                provider = (IDocumentProvider)entry.createExecutableExtension("class");
                this.fInstances.put(entry, provider);
            }
            catch (CoreException coreException) {}
        }
        return provider;
    }

    private IConfigurationElement selectConfigurationElement(Set set) {
        if (set != null && !set.isEmpty()) {
            Iterator e = set.iterator();
            return (IConfigurationElement)e.next();
        }
        return null;
    }

    public IDocumentProvider getDocumentProvider(String extension) {
        Set set = (Set)this.fExtensionMapping.get(extension);
        if (set != null) {
            IConfigurationElement entry = this.selectConfigurationElement(set);
            return this.getDocumentProvider(entry);
        }
        return null;
    }

    private List computeClassList(Class type) {
        ArrayList result = new ArrayList();
        Class c = type;
        while (c != null) {
            result.add(c);
            c = c.getSuperclass();
        }
        return result;
    }

    private List computeInterfaceList(List classes) {
        ArrayList result = new ArrayList(4);
        Hashtable visited = new Hashtable(4);
        Iterator e = classes.iterator();
        while (e.hasNext()) {
            Class c = (Class)e.next();
            this.computeInterfaceList(c.getInterfaces(), result, visited);
        }
        return result;
    }

    private void computeInterfaceList(Class[] interfaces, List result, Hashtable visited) {
        Class iface;
        ArrayList<Class> toBeVisited = new ArrayList<Class>(interfaces.length);
        int i = 0;
        while (i < interfaces.length) {
            iface = interfaces[i];
            if (visited.get(iface) == null) {
                visited.put(iface, iface);
                result.add(iface);
                toBeVisited.add(iface);
            }
            ++i;
        }
        Iterator e = toBeVisited.iterator();
        while (e.hasNext()) {
            iface = (Class)e.next();
            this.computeInterfaceList(iface.getInterfaces(), result, visited);
        }
    }

    private Object getFirstInputTypeMapping(List classes) {
        Iterator e = classes.iterator();
        while (e.hasNext()) {
            Class c = (Class)e.next();
            Object mapping = this.fInputTypeMapping.get(c.getName());
            if (mapping == null) continue;
            return mapping;
        }
        return null;
    }

    private Object findInputTypeMapping(Class type) {
        if (type == null) {
            return null;
        }
        Object mapping = this.fInputTypeMapping.get(type.getName());
        if (mapping != null) {
            return mapping;
        }
        List classList = this.computeClassList(type);
        mapping = this.getFirstInputTypeMapping(classList);
        if (mapping != null) {
            return mapping;
        }
        return this.getFirstInputTypeMapping(this.computeInterfaceList(classList));
    }

    public IDocumentProvider getDocumentProvider(IEditorInput editorInput) {
        Set set;
        IFile file;
        IDocumentProvider provider = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((file = (IFile)editorInput.getAdapter((Class)clazz)) != null) {
            provider = this.getDocumentProvider(file.getFileExtension());
        }
        if (provider == null && (set = (Set)this.findInputTypeMapping(editorInput.getClass())) != null) {
            IConfigurationElement entry = this.selectConfigurationElement(set);
            provider = this.getDocumentProvider(entry);
        }
        return provider;
    }
}

