/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j.transport;

import com.hp.soap.client.ClientMessage;
import com.hp.soap.client.SoapBody;
import com.hp.soap.client.SoapClient;
import com.hp.soap.client.SoapException;
import com.hp.soap.xml.XMLUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.uddi4j.UDDIElement;
import org.uddi4j.transport.Transport;
import org.uddi4j.transport.TransportException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HPSOAPTransport
implements Transport {
    boolean debug = true;
    boolean useProxy = false;
    URL httpProxy = null;
    URL httpsProxy = null;
    PrintStream print = System.out;
    public SimpleDateFormat LOG_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public HPSOAPTransport() {
        Object var1_1 = null;
        String string = System.getProperty("http.proxyHost");
        String string2 = System.getProperty("http.proxyPort");
        String string3 = System.getProperty("https.proxyHost");
        String string4 = System.getProperty("https.proxyPort");
        try {
            if (string2 != null && string != null) {
                this.httpProxy = new URL("http", string, Integer.parseInt(string2), "");
                this.useProxy = true;
            } else if (string4 != null && string3 != null) {
                this.httpsProxy = new URL("https", string3, Integer.parseInt(string4), "");
                this.useProxy = true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Invalid URL for proxy");
            malformedURLException.printStackTrace();
            this.useProxy = false;
        }
        try {
            String string5 = System.getProperty("org.uddi4j.logEnabled");
            this.debug = string5 != null && string5.equalsIgnoreCase("true");
            String string6 = System.getProperty("hpsoap.logFileName");
            String string7 = System.getProperty("hpsoap.logDirectory");
            if (string6 != null && !string6.trim().equals("")) {
                File file;
                if (string7 != null && !string7.trim().equals("") && (file = new File(string7)).exists()) {
                    string6 = String.valueOf(string7) + File.separator + string6;
                }
                this.print = new PrintStream(new FileOutputStream(string6, true), true);
                System.out.println("Log file set to " + string6 + "\n");
            } else {
                System.out.println("Logging set to command window\n");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.print = System.out;
        }
    }

    public Element send(UDDIElement uDDIElement, URL uRL) throws TransportException {
        Element element = null;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            element = documentBuilder.newDocument().createElement("SOAP:Body");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.print.println("FATAL error : bailing out");
            System.exit(-1);
        }
        uDDIElement.saveToXML(element);
        return this.send(element, uRL);
    }

    public Element send(Element element, URL uRL) throws TransportException {
        Element element2 = null;
        Node node = null;
        SoapClient soapClient = null;
        ClientMessage clientMessage = null;
        String string = System.getProperty("org.uddi4j.logEnabled");
        try {
            soapClient = this.useProxy ? (uRL.getProtocol().equalsIgnoreCase("HTTP") ? new SoapClient(uRL, this.httpProxy) : new SoapClient(uRL, this.httpsProxy)) : new SoapClient(uRL);
            if (string != null && string.equalsIgnoreCase("true")) {
                this.print.println("[" + this.LOG_DATE_FORMAT.format(new Date()) + "]\n");
                soapClient.setLogStream(this.print);
            } else {
                soapClient.setLogStream(null);
            }
            ClientMessage clientMessage2 = new ClientMessage();
            clientMessage2.getEnvelope().removeAttribute("SOAP:encodingStyle");
            SoapBody soapBody = new SoapBody(element);
            clientMessage2.setBody(soapBody);
            clientMessage = soapClient.sendRequest(clientMessage2);
            if (clientMessage != null) {
                if (clientMessage.getBody() != null) {
                    node = clientMessage.getBody().getElement().getFirstChild();
                } else {
                    this.print.println("INFO:The SOAP Body of the response obtained from Server is null");
                }
                element2 = (Element)node;
            } else {
                this.print.println("INFO:The SOAP Response from Server is null");
            }
        }
        catch (SoapException soapException) {
            String string2 = soapException.getMessage();
            Element element3 = null;
            try {
                element3 = XMLUtil.stringToElement((String)string2);
            }
            catch (Exception exception) {
                throw new TransportException(exception);
            }
            return element3;
        }
        catch (IOException iOException) {
            throw new TransportException(iOException);
        }
        return element2;
    }
}

