/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.jdbc.impl;

import com.sap.ip.bi.sdk.dac.connector.IBIRelational;
import com.sap.ip.bi.sdk.dac.connector.impl.BIConnectionConstants;
import com.sap.ip.bi.sdk.dac.connector.impl.BIRelational;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcConnectionConstants;
import com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcConnectionProperties;
import com.sap.ip.bi.sdk.dac.connector.jdbc.impl.JdbcMDRConnection;
import com.sap.ip.bi.sdk.dac.connector.relational.CommonConnection;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQuery;
import com.sap.ip.bi.sdk.dac.relational.query.impl.BIQueryExpression;
import com.sap.ip.bi.sdk.dac.relational.query.sql.impl.BIDefaultParseNodeFactory;
import com.sap.ip.bi.sdk.dac.relational.query.sql.impl.BIParseQueryExpression;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.ip.bi.sdk.util.impl.ServerRTCounter;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.resource.ResourceException;
import org.omg.cwm.foundation.expressions.FeatureNode;

public class Connection
extends CommonConnection {
    ServerRTCounter serverRTCounter = ServerRTCounter.getInstance();
    private static final boolean tracePrivateMethods = false;
    private static final Location loggingLoc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$relational$CommonConnection == null ? (class$com$sap$ip$bi$sdk$dac$connector$relational$CommonConnection = Connection.class$("com.sap.ip.bi.sdk.dac.connector.relational.CommonConnection")) : class$com$sap$ip$bi$sdk$dac$connector$relational$CommonConnection).getName());
    private static final Category loggingCat = BILoggingSetup.CONNECTION.getCategory();
    private java.sql.Connection jdbcConn = null;
    private DatabaseMetaData jdbcMeta = null;
    private static final String[][] keys = new String[][]{{"user", BIConnectionConstants.USERNAME.toString()}, {"password", BIConnectionConstants.PASSWORD.toString()}};
    private static final HashMap keyMap = new HashMap();
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$relational$CommonConnection;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection;

    private Connection() {
        this.properties = new Properties();
    }

    private Connection(Properties props) {
        super(props);
    }

    public static Connection connect(Properties props) throws ResourceException {
        Connection connection;
        String method = "connect()";
        loggingLoc.entering("connect()");
        try {
            Properties p = new Properties();
            if (props != null) {
                Enumeration<?> names = props.propertyNames();
                while (names.hasMoreElements()) {
                    String key = (String)names.nextElement();
                    p.setProperty(key, props.getProperty(key));
                }
            }
            Connection c = new Connection(p);
            c.connectDB();
            connection = c;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet execute(IBIQuery query) throws BIResourceException {
        Class clazz;
        ResultSet resultSet;
        boolean isInRequest;
        block9: {
            block7: {
                String method = "execute(IBIQuery)";
                loggingLoc.entering("execute(IBIQuery)");
                isInRequest = this.monitorQuery.getCurrentRequest() != null;
                try {
                    if (!isInRequest) {
                        this.monitorQuery.startRequest(IBIMonitor.Request.QUERY);
                    }
                    this.monitorQuery.startComponent(class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection == null ? (class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection = Connection.class$("com.sap.ip.bi.sdk.dac.connector.jdbc.impl.Connection")) : class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection, "execute(IBIQuery)");
                    String sql = this.getSQLStatement(query);
                    try {
                        this.serverRTCounter.setTimer();
                        Statement stmt = this.jdbcConn.createStatement();
                        stmt.execute(sql);
                        this.serverRTCounter.addToTimer(2);
                        this.serverRTCounter.incrementCounter();
                        this.serverRTCounter.setTimer();
                        ResultSet r = stmt.getResultSet();
                        this.serverRTCounter.addToTimer(2);
                        this.serverRTCounter.incrementCounter();
                        resultSet = r;
                        Object var9_9 = null;
                        if (class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection != null) break block7;
                    }
                    catch (SQLException ex) {
                        throw new BIResourceException(((BIRelational)this).connectionInfo.getLocale(), "sdk.dac.connector_1200", (Throwable)ex);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    this.monitorQuery.endComponent(class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection == null ? (class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection = Connection.class$("com.sap.ip.bi.sdk.dac.connector.jdbc.impl.Connection")) : class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection, "execute(IBIQuery)");
                    if (!isInRequest) {
                        this.monitorQuery.endRequest(IBIMonitor.Request.QUERY);
                    }
                    loggingLoc.exiting();
                    throw throwable;
                }
                clazz = class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection = Connection.class$("com.sap.ip.bi.sdk.dac.connector.jdbc.impl.Connection");
                break block9;
            }
            clazz = class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection;
        }
        this.monitorQuery.endComponent(clazz, "execute(IBIQuery)");
        if (!isInRequest) {
            this.monitorQuery.endRequest(IBIMonitor.Request.QUERY);
        }
        loggingLoc.exiting();
        return resultSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet execute(Object nativeQuery) throws BIResourceException {
        Class clazz;
        ResultSet resultSet;
        boolean isInRequest;
        block9: {
            block7: {
                String method = "execute(Object)";
                loggingLoc.entering("execute(Object)");
                isInRequest = this.monitorQuery.getCurrentRequest() != null;
                try {
                    if (!isInRequest) {
                        this.monitorQuery.startRequest(IBIMonitor.Request.QUERY);
                    }
                    this.monitorQuery.startComponent(class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection == null ? (class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection = Connection.class$("com.sap.ip.bi.sdk.dac.connector.jdbc.impl.Connection")) : class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection, "execute(Object)");
                    String sql = nativeQuery.toString();
                    try {
                        this.serverRTCounter.setTimer();
                        Statement stmt = this.jdbcConn.createStatement();
                        stmt.execute(sql);
                        this.serverRTCounter.addToTimer(2);
                        this.serverRTCounter.incrementCounter();
                        this.serverRTCounter.setTimer();
                        ResultSet r = stmt.getResultSet();
                        this.serverRTCounter.addToTimer(2);
                        this.serverRTCounter.incrementCounter();
                        resultSet = r;
                        Object var9_9 = null;
                        if (class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection != null) break block7;
                    }
                    catch (SQLException ex) {
                        throw new BIResourceException(((BIRelational)this).connectionInfo.getLocale(), "sdk.dac.connector_1200", (Throwable)ex);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    this.monitorQuery.endComponent(class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection == null ? (class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection = Connection.class$("com.sap.ip.bi.sdk.dac.connector.jdbc.impl.Connection")) : class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection, "execute(Object)");
                    if (!isInRequest) {
                        this.monitorQuery.endRequest(IBIMonitor.Request.QUERY);
                    }
                    loggingLoc.exiting();
                    throw throwable;
                }
                clazz = class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection = Connection.class$("com.sap.ip.bi.sdk.dac.connector.jdbc.impl.Connection");
                break block9;
            }
            clazz = class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection;
        }
        this.monitorQuery.endComponent(clazz, "execute(Object)");
        if (!isInRequest) {
            this.monitorQuery.endRequest(IBIMonitor.Request.QUERY);
        }
        loggingLoc.exiting();
        return resultSet;
    }

    public Object getNativeRepresentation(IBIQuery query) throws BIResourceException {
        String string;
        String method = "getNativeRepresentation(IBIQuery)";
        loggingLoc.entering("getNativeRepresentation(IBIQuery)");
        boolean isInRequest = this.monitorQuery.getCurrentRequest() != null;
        try {
            if (!isInRequest) {
                this.monitorQuery.startRequest(IBIMonitor.Request.QUERY);
            }
            this.monitorQuery.startComponent(class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection == null ? (class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection = Connection.class$("com.sap.ip.bi.sdk.dac.connector.jdbc.impl.Connection")) : class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection, "getNativeRepresentation(IBIQuery)");
            string = this.getSQLStatement(query);
            Object var6_5 = null;
            this.monitorQuery.endComponent(class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection == null ? (class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection = Connection.class$("com.sap.ip.bi.sdk.dac.connector.jdbc.impl.Connection")) : class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection, "getNativeRepresentation(IBIQuery)");
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.monitorQuery.endComponent(class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection == null ? (class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection = Connection.class$("com.sap.ip.bi.sdk.dac.connector.jdbc.impl.Connection")) : class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$Connection, "getNativeRepresentation(IBIQuery)");
            if (!isInRequest) {
                this.monitorQuery.endRequest(IBIMonitor.Request.QUERY);
            }
            loggingLoc.exiting();
            throw throwable;
        }
        if (!isInRequest) {
            this.monitorQuery.endRequest(IBIMonitor.Request.QUERY);
        }
        loggingLoc.exiting();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean supports(IBIRelational.Supports feature) {
        Boolean bl;
        block6: {
            Boolean bl2;
            block5: {
                Boolean bl3;
                block4: {
                    String method = "supports(IBIRelational.Supports)";
                    loggingLoc.entering("supports(IBIRelational.Supports)");
                    try {
                        if (IBIRelational.Supports.JOIN.equals(feature)) {
                            bl3 = Boolean.TRUE;
                            Object var5_6 = null;
                            break block4;
                        }
                        if (IBIRelational.Supports.SUBSELECT.equals(feature)) {
                            bl2 = Boolean.TRUE;
                            break block5;
                        }
                        bl = Boolean.FALSE;
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        loggingLoc.exiting();
                        throw throwable;
                    }
                }
                loggingLoc.exiting();
                return bl3;
            }
            Object var5_7 = null;
            loggingLoc.exiting();
            return bl2;
        }
        Object var5_8 = null;
        loggingLoc.exiting();
        return bl;
    }

    public boolean isAlive() throws BIResourceException {
        return this.isAliveDB();
    }

    protected synchronized void connectMDR() throws BIResourceException {
        String method = "connectMDR()";
        try {
            try {
                this.mdr = new JdbcMDRConnection(((BIRelational)this).connectionInfo, this.jdbcMeta);
                this.outerMost = this.mdr.connect();
                this.trans = this.mdr.getLocalTransaction();
                this.trans.begin();
            }
            catch (ResourceException ex) {
                throw new BIResourceException(((BIRelational)this).connectionInfo.getLocale(), "sdk.dac.connector.mmr_1000", (Throwable)ex);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }

    protected synchronized void connectDB() throws BIResourceException {
        String method = "connectJDBC()";
        try {
            Properties p = new Properties();
            if (this.properties != null) {
                Enumeration<?> names = this.properties.propertyNames();
                while (names.hasMoreElements()) {
                    String key = (String)names.nextElement();
                    p.setProperty(key, this.properties.getProperty(key));
                    if (!keyMap.containsKey(key)) continue;
                    p.setProperty((String)keyMap.get(key), this.properties.getProperty(key));
                }
            }
            if (p.getProperty(JdbcConnectionConstants.DRIVERNAME.toString()) != null) {
                try {
                    Class.forName(p.getProperty(JdbcConnectionConstants.DRIVERNAME.toString()));
                }
                catch (ClassNotFoundException ex) {
                    throw new BIResourceException(((BIRelational)this).connectionInfo.getLocale(), "sdk_1004", new Object[]{JdbcConnectionConstants.DRIVERNAME.toString()});
                }
            }
            try {
                this.jdbcConn = DriverManager.getConnection(p.getProperty(JdbcConnectionConstants.URL.toString()), p);
                this.serverRTCounter.setTimer();
                this.jdbcMeta = this.jdbcConn.getMetaData();
                this.serverRTCounter.addToTimer(2);
                this.serverRTCounter.incrementCounter();
            }
            catch (SQLException ex) {
                throw new BIResourceException(((BIRelational)this).connectionInfo.getLocale(), "sdk.dac.connector.jdbc_1000", (Throwable)ex);
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void closeDB() throws BIResourceException {
        ((BIRelational)this).connectionInfo = IBIConnectionInfo.DEFAULT;
        try {
            try {
                this.jdbcConn.close();
                this.jdbcConn = null;
            }
            catch (SQLException ex) {
                throw new BIRuntimeException(((BIRelational)this).connectionInfo.getLocale(), "sdk.dac.connector_2003", (Throwable)ex);
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            try {
                if (this.mdr == null) throw throwable;
                if (this.trans != null) {
                    this.trans.rollback();
                    this.trans = null;
                }
                this.mdr.close();
                this.mdr = null;
                throw throwable;
            }
            catch (ResourceException ex) {
                throw new BIRuntimeException(((BIRelational)this).connectionInfo.getLocale(), "sdk.dac.connector_2003", (Throwable)ex);
            }
        }
        try {}
        catch (ResourceException ex) {
            throw new BIRuntimeException(((BIRelational)this).connectionInfo.getLocale(), "sdk.dac.connector_2003", (Throwable)ex);
        }
        if (this.mdr == null) return;
        if (this.trans != null) {
            this.trans.rollback();
            this.trans = null;
        }
        this.mdr.close();
        this.mdr = null;
    }

    protected boolean isAliveDB() {
        return this.jdbcConn != null;
    }

    protected String getAttributeEISProductName() {
        if (this.isAliveDB()) {
            try {
                return this.jdbcMeta.getDatabaseProductName();
            }
            catch (SQLException ex) {
                return "unknown";
            }
        }
        return "unknown";
    }

    protected String getAttributeEISProductVersion() {
        if (this.isAliveDB()) {
            try {
                return this.jdbcMeta.getDatabaseProductVersion();
            }
            catch (SQLException ex) {
                return "unknown";
            }
        }
        return "unknown";
    }

    protected String getAttributeUserName() {
        if (this.isAliveDB()) {
            return this.properties.getProperty(JdbcConnectionProperties.Parameter.USER.toString());
        }
        return "unknown";
    }

    private String getSQLStatement(IBIQuery query) throws BIResourceException {
        this.assertConnectedToMDR();
        if (query != null && this.jdbcConn != null) {
            query.synchronize();
            if (query.getExpression() instanceof FeatureNode) {
                BIDefaultParseNodeFactory f = new BIDefaultParseNodeFactory(((BIRelational)this).connectionInfo, this.jdbcMeta);
                String sql = f.createParseFeatureNode().evaluate((FeatureNode)query.getExpression());
                return sql;
            }
            if (query.getExpression() instanceof BIQueryExpression) {
                String sql = new BIParseQueryExpression(((BIRelational)this).connectionInfo, query, this.jdbcMeta).getCommandText();
                return sql;
            }
            throw new BIResourceException(((BIRelational)this).connectionInfo.getLocale(), "sdk.dac.rel.query_1014");
        }
        if (this.jdbcConn == null) {
            throw new BIRuntimeException(((BIRelational)this).connectionInfo.getLocale(), "sdk.dac.connector.jdbc_1000");
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int i = 0;
        while (i < keys.length) {
            keyMap.put(keys[i][1], keys[i][0]);
            ++i;
        }
    }
}

