/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.jdbc;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionDetails;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcConnection;
import com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcConnectionProperties;
import com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcManagedConnectionFactory;
import com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcManagedConnectionMetaData;
import com.sap.ip.bi.sdk.dac.connector.jdbc.impl.Connection;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class JdbcManagedConnection
implements ManagedConnection,
IBIConnectionDetails {
    private static final boolean tracePrivateMethods = true;
    private static final Location loggingLoc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$jdbc$JdbcManagedConnection == null ? (class$com$sap$ip$bi$sdk$dac$connector$jdbc$JdbcManagedConnection = JdbcManagedConnection.class$("com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcManagedConnection")) : class$com$sap$ip$bi$sdk$dac$connector$jdbc$JdbcManagedConnection).getName());
    private static final Category loggingCat = BILoggingSetup.CONNECTION.getCategory();
    private IBIMonitor monitor = null;
    private PrintWriter m_logWriter;
    protected JdbcManagedConnectionFactory m_managedConnectionFactory;
    private Subject m_subject;
    private JdbcConnectionProperties m_request_info;
    private Connection connection;
    private IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;
    private String user;
    private String passwd;
    protected Vector m_associated_connections = new Vector();
    protected Vector m_connection_listeners = null;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$jdbc$JdbcManagedConnection;

    protected JdbcManagedConnection(JdbcManagedConnectionFactory managed_connection_factory, Subject subject, JdbcConnectionProperties request_info) throws ResourceException {
        String method = "JdbcManagedConnection(JdbcManagedConnectionFactory, Subject, JdbcConnectionProperties)";
        loggingLoc.entering("JdbcManagedConnection(JdbcManagedConnectionFactory, Subject, JdbcConnectionProperties)");
        try {
            this.m_managedConnectionFactory = managed_connection_factory;
            this.m_logWriter = managed_connection_factory.m_logWriter;
            this.m_subject = subject;
            this.m_request_info = request_info;
            try {
                Properties connProps = new Properties(managed_connection_factory.m_properties);
                if (subject != null) {
                    connProps.setProperty(JdbcConnectionProperties.Parameter.USER.name, "");
                    connProps.setProperty(JdbcConnectionProperties.Parameter.PASSWD.name, "");
                } else if (request_info != null && request_info.m_properties != null) {
                    Enumeration e = ((Hashtable)request_info.m_properties).keys();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        connProps.setProperty(key, request_info.getProperty(key));
                    }
                }
                this.connection = Connection.connect(connProps);
                this.connectionInfo = this.connection.getConnectionInfo();
            }
            catch (Exception ex) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_1100", (Throwable)ex);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean equals(JdbcManagedConnectionFactory managed_connection_factory, Subject subject, JdbcConnectionProperties request_info) throws ResourceException {
        boolean bl;
        block10: {
            boolean bl2;
            block9: {
                boolean bl3;
                block8: {
                    boolean bl4;
                    block7: {
                        boolean bl5;
                        block6: {
                            String method = "equals(JdbcManagedConnectionFactory, Subject, JdbcConnectionProperties)";
                            loggingLoc.entering("equals(JdbcManagedConnectionFactory, Subject, JdbcConnectionProperties)");
                            try {
                                if (this.m_subject != null && subject == null || this.m_subject == null && subject != null) {
                                    bl5 = false;
                                    Object var9_6 = null;
                                    break block6;
                                }
                                if (this.m_subject != null && !this.m_subject.equals(subject)) {
                                    bl4 = false;
                                    break block7;
                                }
                                if (managed_connection_factory != null && !this.m_managedConnectionFactory.equals(managed_connection_factory)) {
                                    bl3 = false;
                                    break block8;
                                }
                                if (subject == null && !this.compareProperties(request_info)) {
                                    bl2 = false;
                                    break block9;
                                }
                                bl = true;
                                break block10;
                            }
                            catch (Throwable throwable) {
                                Object var9_11 = null;
                                loggingLoc.exiting();
                                throw throwable;
                            }
                        }
                        loggingLoc.exiting();
                        return bl5;
                    }
                    Object var9_7 = null;
                    loggingLoc.exiting();
                    return bl4;
                }
                Object var9_8 = null;
                loggingLoc.exiting();
                return bl3;
            }
            Object var9_9 = null;
            loggingLoc.exiting();
            return bl2;
        }
        Object var9_10 = null;
        loggingLoc.exiting();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean compareProperties(JdbcConnectionProperties other) throws ResourceException {
        boolean bl;
        block10: {
            boolean bl2;
            block9: {
                String method = "compareProperties(JdbcConnectionProperties)";
                loggingLoc.entering("compareProperties(JdbcConnectionProperties)");
                try {
                    JdbcConnectionProperties request_info = null;
                    request_info = other == null ? new JdbcConnectionProperties(this.m_managedConnectionFactory.m_properties) : other;
                    if (request_info.m_properties == null) {
                        request_info.m_properties = this.m_managedConnectionFactory.m_properties;
                    }
                    if (request_info.m_properties == null) {
                        request_info.m_properties = this.m_managedConnectionFactory.m_properties;
                    }
                    if (((Hashtable)this.connection.getProperties()).size() < ((Hashtable)request_info.m_properties).size()) {
                        loggingLoc.debugT(loggingCat, "connection.getProperties().size() < request_info.m_properties.size()" + ((Hashtable)this.connection.getProperties()).size() + "  " + ((Hashtable)request_info.m_properties).size());
                        loggingLoc.exiting((Object)new Boolean(false));
                        bl2 = false;
                        Object var11_6 = null;
                        break block9;
                    }
                    boolean is_equal = true;
                    Enumeration keys = ((Hashtable)this.connection.getProperties()).keys();
                    while (true) {
                        if (!keys.hasMoreElements() || !is_equal) {
                            loggingLoc.debugT(loggingCat, "compareProperties  is_equal " + is_equal);
                            loggingLoc.exiting((Object)new Boolean(is_equal));
                            bl = is_equal;
                            break block10;
                        }
                        String key = (String)keys.nextElement();
                        String valueMC = this.connection.getProperty(key);
                        String valueNew = request_info.m_properties.getProperty(key);
                        loggingLoc.debugT(loggingCat, "key:" + key + "valueMC:" + valueMC + "valueNew:" + valueNew);
                        if (valueMC != null && valueMC.length() > 0 && (valueNew == null || valueNew.length() == 0)) {
                            is_equal = false;
                            continue;
                        }
                        if ((valueMC == null || valueMC.length() == 0) && valueNew != null && valueNew.length() > 0) {
                            is_equal = false;
                            continue;
                        }
                        if (valueMC == null || valueNew == null || valueMC.equals(valueNew)) continue;
                        is_equal = false;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_8 = null;
                    loggingLoc.exiting();
                    throw throwable;
                }
            }
            loggingLoc.exiting();
            return bl2;
        }
        Object var11_7 = null;
        loggingLoc.exiting();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy() throws ResourceException {
        String method = "destroy()";
        loggingLoc.entering("destroy()");
        try {
            if (this.connection == null) {
                Object var9_2 = null;
                loggingLoc.exiting();
                return;
            }
            try {
                try {
                    this.cleanup();
                }
                catch (ResourceException ex) {
                    loggingLoc.throwing("destroy()", (Throwable)ex);
                    throw ex;
                }
                Object var4_5 = null;
                this.connectionInfo = IBIConnectionInfo.DEFAULT;
                try {
                    try {
                        this.connection.close();
                    }
                    catch (Exception ex) {
                        throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_2003", (Throwable)ex);
                    }
                    Object var7_7 = null;
                    this.connection = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    this.connection = null;
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.connectionInfo = IBIConnectionInfo.DEFAULT;
                try {}
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    this.connection = null;
                    throw throwable2;
                }
                try {}
                catch (Exception ex) {
                    throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_2003", (Throwable)ex);
                }
                this.connection.close();
                Object var7_9 = null;
                this.connection = null;
                throw throwable;
            }
            Object var9_3 = null;
            loggingLoc.exiting();
            return;
        }
        catch (Throwable throwable) {
            Object var9_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        JdbcConnection jdbcConnection;
        String method = "getConnection(Subject, ConnectionRequestInfo)";
        loggingLoc.entering("getConnection(Subject, ConnectionRequestInfo)");
        try {
            this.assertConnection();
            jdbcConnection = new JdbcConnection(this);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return jdbcConnection;
    }

    public void cleanup() throws ResourceException {
        String method = "cleanup()";
        loggingLoc.entering("cleanup()");
        try {
            Vector vector = this.m_associated_connections;
            synchronized (vector) {
                Vector list = (Vector)this.m_associated_connections.clone();
                int num_connections = list.size();
                int i = 0;
                while (i < num_connections) {
                    ((JdbcConnection)((Object)list.elementAt(i))).dissociateManagedConnection();
                    ++i;
                }
                this.m_associated_connections.removeAllElements();
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void associateConnection(Object connection) throws ResourceException {
        String method = "associateConnection(Object)";
        loggingLoc.entering("associateConnection(Object)");
        try {
            if (connection == null) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_1101");
            }
            if (!(connection instanceof JdbcConnection)) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_1007", new Object[]{connection.getClass().toString()});
            }
            this.assertConnection();
            ((JdbcConnection)((Object)connection)).associateConnection(this);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        String method = "addConnectionEventListener(ConnectionEventListener)";
        loggingLoc.entering("addConnectionEventListener(ConnectionEventListener)");
        try {
            if (this.m_connection_listeners == null) {
                this.m_connection_listeners = new Vector();
            }
            this.m_connection_listeners.addElement(listener);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        String method = "removeConnectionEventListener(ConnectionEventListener)";
        loggingLoc.entering("removeConnectionEventListener(ConnectionEventListener)");
        try {
            if (this.m_connection_listeners != null) {
                this.m_connection_listeners.removeElement(listener);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public XAResource getXAResource() throws ResourceException {
        String method = "getXAResource()";
        loggingLoc.entering("getXAResource()");
        try {
            throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk_1000");
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            loggingLoc.exiting();
            throw throwable;
        }
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        String method = "getLocalTransaction()";
        loggingLoc.entering("getLocalTransaction()");
        try {
            throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk_1000");
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            loggingLoc.exiting();
            throw throwable;
        }
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        JdbcManagedConnectionMetaData jdbcManagedConnectionMetaData;
        String method = "getMetaData()";
        loggingLoc.entering("getMetaData()");
        try {
            this.assertConnection();
            jdbcManagedConnectionMetaData = new JdbcManagedConnectionMetaData(this);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return jdbcManagedConnectionMetaData;
    }

    public void setLogWriter(PrintWriter logWriter) throws ResourceException {
        String method = "setLogWriter(PrintWriter)";
        loggingLoc.entering("setLogWriter(PrintWriter)");
        try {
            this.m_logWriter = logWriter;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public PrintWriter getLogWriter() throws ResourceException {
        PrintWriter printWriter;
        String method = "getLogWriter()";
        loggingLoc.entering("getLogWriter()");
        try {
            printWriter = this.m_logWriter;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return printWriter;
    }

    public JdbcManagedConnectionFactory getManagedConnectionFactory() {
        JdbcManagedConnectionFactory jdbcManagedConnectionFactory;
        String method = "getManagedConnectionFactory()";
        loggingLoc.entering("getManagedConnectionFactory()");
        try {
            jdbcManagedConnectionFactory = this.m_managedConnectionFactory;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return jdbcManagedConnectionFactory;
    }

    protected void unregisterConnection(JdbcConnection connection) {
        String method = "unregisterConnection(JdbcConnection)";
        loggingLoc.entering("unregisterConnection(JdbcConnection)");
        try {
            this.m_associated_connections.removeElement((Object)connection);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    protected void assertConnection() throws BIResourceException {
        String method = "assertConnection()";
        loggingLoc.entering("assertConnection()");
        try {
            if (this.connection == null || !this.connection.isAlive()) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_1101");
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    protected Connection getConnection() throws BIResourceException {
        Connection connection;
        String method = "getConnection()";
        loggingLoc.entering("getConnection()");
        try {
            this.assertConnection();
            connection = this.connection;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fireConnectionClosedEvent(javax.resource.cci.Connection connection) throws ResourceException {
        block6: {
            block5: {
                String method = "fireConnectionClosedEvent(javax.resource.cci.Connection)";
                loggingLoc.entering("fireConnectionClosedEvent(javax.resource.cci.Connection)");
                try {
                    if (this.m_connection_listeners == null) {
                        Object var7_3 = null;
                        break block5;
                    }
                    ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
                    event.setConnectionHandle((Object)connection);
                    Vector list = (Vector)this.m_connection_listeners.clone();
                    int i = 0;
                    while (true) {
                        if (i >= list.size()) {
                            break block6;
                        }
                        ((ConnectionEventListener)list.elementAt(i)).connectionClosed(event);
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_5 = null;
                    loggingLoc.exiting();
                    throw throwable;
                }
            }
            loggingLoc.exiting();
            return;
        }
        Object var7_4 = null;
        loggingLoc.exiting();
    }

    public IBIConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

