/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.jdbc;

import com.sap.ip.bi.sdk.dac.connector.impl.BIConnectionConstants;
import com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcConnectionConstants;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.resource.cci.ConnectionSpec;
import javax.resource.spi.ConnectionRequestInfo;

public class JdbcConnectionProperties
implements ConnectionSpec,
ConnectionRequestInfo,
Serializable,
Cloneable {
    protected Properties m_properties = new Properties();

    public JdbcConnectionProperties() {
    }

    public JdbcConnectionProperties(Properties properties) {
        Enumeration keys = ((Hashtable)properties).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.setProperty(key, properties.getProperty(key));
        }
    }

    public JdbcConnectionProperties(String username, String password, String url, String driverName) {
        this.setProperty(Parameter.USER.name, username);
        this.setProperty(Parameter.PASSWD.name, password);
        this.setProperty(Parameter.URL.name, url);
        this.setProperty(Parameter.DRIVERNAME.name, driverName);
    }

    public JdbcConnectionProperties(String username, String password, String url, String driverName, String fixedCatalog, String fixedSchema) {
        this.setProperty(Parameter.USER.name, username);
        this.setProperty(Parameter.PASSWD.name, password);
        this.setProperty(Parameter.URL.name, url);
        this.setProperty(Parameter.DRIVERNAME.name, driverName);
        this.setProperty(Parameter.FIXED_CATALOG.name, fixedCatalog);
        this.setProperty(Parameter.FIXED_SCHEMA.name, fixedSchema);
    }

    protected final void setProperty(String key, String value) {
        if (((Hashtable)this.m_properties).get(key) != null) {
            ((Hashtable)this.m_properties).remove(key);
        }
        if (value != null) {
            this.m_properties.setProperty(key, value);
        }
    }

    protected final String getProperty(String key) {
        return this.m_properties.getProperty(key);
    }

    public Object clone() {
        return new JdbcConnectionProperties(this.m_properties);
    }

    public String getUserName() {
        return this.getProperty(Parameter.USER.name);
    }

    public void setUserName(String user) {
        this.setProperty(Parameter.USER.name, user);
    }

    public String getPassword() {
        return this.getProperty(Parameter.PASSWD.name);
    }

    public void setPassword(String password) {
        this.setProperty(Parameter.PASSWD.name, password);
    }

    public final String getURL() {
        return this.getProperty(Parameter.URL.name);
    }

    public final void setURL(String url) {
        this.setProperty(Parameter.URL.name, url);
    }

    public final String getDriverName() {
        return this.getProperty(Parameter.DRIVERNAME.name);
    }

    public final void setDriverName(String driverName) {
        this.setProperty(Parameter.DRIVERNAME.name, driverName);
    }

    public final String getFixedCatalog() {
        return this.getProperty(Parameter.FIXED_CATALOG.name);
    }

    public final void setFixedCatalog(String fixedCatalog) {
        this.setProperty(Parameter.FIXED_CATALOG.name, fixedCatalog);
    }

    public final String getFixedSchema() {
        return this.getProperty(Parameter.FIXED_SCHEMA.name);
    }

    public final void setFixedSchema(String fixedSchema) {
        this.setProperty(Parameter.FIXED_SCHEMA.name, fixedSchema);
    }

    public int hashCode() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < Parameter.m_num_parameters) {
            String value;
            Parameter p = Parameter.m_parameters[i];
            if (p != null && (value = this.m_properties.getProperty(p.name)) != null) {
                sb.append(value);
            }
            ++i;
        }
        return sb.toString().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof JdbcConnectionProperties)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        JdbcConnectionProperties obj = (JdbcConnectionProperties)other;
        if (((Hashtable)this.m_properties).size() != ((Hashtable)obj.m_properties).size()) {
            return false;
        }
        boolean is_equal = true;
        Enumeration keys = ((Hashtable)this.m_properties).keys();
        while (keys.hasMoreElements() && is_equal) {
            String key = (String)keys.nextElement();
            String value1 = this.m_properties.getProperty(key);
            String value2 = obj.m_properties.getProperty(key);
            if (value1 == null && value2 != null) {
                is_equal = false;
                continue;
            }
            if (value1 != null && value2 == null) {
                is_equal = false;
                continue;
            }
            if (value1.equals(value2)) continue;
            is_equal = false;
        }
        return is_equal;
    }

    public static class Parameter
    implements Serializable {
        protected static Parameter[] m_parameters = new Parameter[5];
        public static final Parameter USER = new Parameter(BIConnectionConstants.USERNAME);
        public static final Parameter PASSWD = new Parameter(BIConnectionConstants.PASSWORD);
        public static final Parameter LANG = new Parameter(BIConnectionConstants.LANGUAGE);
        public static final Parameter URL = new Parameter(JdbcConnectionConstants.URL);
        public static final Parameter DRIVERNAME = new Parameter(JdbcConnectionConstants.DRIVERNAME);
        public static final Parameter FIXED_CATALOG = new Parameter(JdbcConnectionConstants.FIXED_CATALOG);
        public static final Parameter FIXED_SCHEMA = new Parameter(JdbcConnectionConstants.FIXED_SCHEMA);
        private static int m_num_parameters = 0;
        public final String name;

        protected Parameter(BIConnectionConstants name) {
            this(name.toString());
        }

        protected Parameter(String name) {
            Parameter parameter = this;
            synchronized (parameter) {
                this.name = name;
                if (m_parameters.length < ++m_num_parameters) {
                    Parameter[] old = m_parameters;
                    m_parameters = new Parameter[m_num_parameters];
                    System.arraycopy(old, 0, m_parameters, 0, old.length);
                }
                Parameter.m_parameters[Parameter.m_num_parameters - 1] = this;
            }
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

