/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodelsupplement.webdynpro.listener;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.event.MDOReloadedEvent;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.event.ObjectCreatedEvent;
import com.sap.ide.metamodel.general.event.ObjectDeletedEvent;
import com.sap.ide.metamodel.general.event.PropertyChangedEvent;
import com.sap.ide.metamodel.general.event.ReferencedObjectAddedEvent;
import com.sap.ide.metamodel.general.event.ReferencedObjectChangedEvent;
import com.sap.ide.metamodel.general.event.ReferencedObjectRemovedEvent;
import com.sap.ide.metamodel.general.event.SubObjectCreatedEvent;
import com.sap.ide.metamodel.general.event.SubObjectDeletedEvent;
import com.sap.ide.metamodel.general.event.SubObjectMovedEvent;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodelsupplement.webdynpro.MetamodelSupplementPlugin;
import com.sap.ide.metamodelsupplement.webdynpro.links.DataLinkContainer;

public class MetamodelChangeListener
implements DevelopmentObjectObserver {
    private DataLinkContainer mLinkContainer;

    public MetamodelChangeListener(DataLinkContainer linkContainer) {
        this.mLinkContainer = linkContainer;
    }

    public void update(MetamodelEvent event) {
        if (event.getEventId() == 8) {
            SubObjectCreatedEvent subObjectCreatedEvent = (SubObjectCreatedEvent)event;
            this.subObjectCreated(subObjectCreatedEvent);
        } else if (event.getEventId() == 16) {
            SubObjectDeletedEvent subObjectDeletedEvent = (SubObjectDeletedEvent)event;
            this.subObjectDeleted(subObjectDeletedEvent);
        } else if (event.getEventId() == 32) {
            SubObjectMovedEvent subObjectMovedEvent = (SubObjectMovedEvent)event;
            this.subObjectMoved(subObjectMovedEvent);
        } else if (event.getEventId() == 128) {
            ReferencedObjectChangedEvent refObjChanged = (ReferencedObjectChangedEvent)event;
            this.refObjectChanged(refObjChanged);
        } else if (event.getEventId() == 256) {
            ReferencedObjectAddedEvent refObjAdded = (ReferencedObjectAddedEvent)event;
            this.refObjectAdded(refObjAdded);
        } else if (event.getEventId() == 512) {
            ReferencedObjectRemovedEvent refObjRemoved = (ReferencedObjectRemovedEvent)event;
            this.refObjectRemoved(refObjRemoved);
        } else if (event.getEventId() == 1) {
            ObjectCreatedEvent objectCreatedEvent = (ObjectCreatedEvent)event;
            this.objectCreated(objectCreatedEvent);
        } else if (event.getEventId() == 2) {
            ObjectDeletedEvent objectdeletedEvent = (ObjectDeletedEvent)event;
            this.objectDeleted(objectdeletedEvent);
        } else if (event.getEventId() == 4) {
            PropertyChangedEvent propertyChangedEvent = (PropertyChangedEvent)event;
            this.propertyChanged(propertyChangedEvent);
        } else if (event.getEventId() == 8192) {
            MDOReloadedEvent mdoReloadEvent = (MDOReloadedEvent)event;
            this.mdoReloaded(mdoReloadEvent);
        }
    }

    private void mdoReloaded(MDOReloadedEvent mdoReloadEvent) {
        DevelopmentObject devObj = mdoReloadEvent.getModifiedObject();
        this.mLinkContainer.reloadDataLinks(devObj);
    }

    private void propertyChanged(PropertyChangedEvent propertyChangedEvent) {
        DevelopmentObject devObj = propertyChangedEvent.getModifiedObject();
        MainDevelopmentObject mdo = devObj.getMDO();
        if (mdo instanceof Controller) {
            Controller controller;
            Controller source = controller = (Controller)mdo;
            if (controller.hasView()) {
                source = controller.getView();
            }
            this.mLinkContainer.modelReferenceChanged((DevelopmentObject)source, null);
        }
    }

    private void objectDeleted(ObjectDeletedEvent objectdeletedEvent) {
        DevelopmentObject devObj = objectdeletedEvent.getModifiedObject();
        if (devObj.isDeleted()) {
            return;
        }
        if (devObj instanceof ContextModelNode) {
            Controller controller;
            ContextModelNode modelNode = (ContextModelNode)devObj;
            if (!modelNode.hasModelClass()) {
                return;
            }
            ModelClass modelClass = modelNode.getModelClass();
            Controller source = controller = (Controller)devObj.getMDO();
            if (controller.hasView()) {
                source = controller.getView();
            }
            this.mLinkContainer.modelReferenceDeleted((DevelopmentObject)source, modelNode);
        }
    }

    private void objectCreated(ObjectCreatedEvent objectCreatedEvent) {
        DevelopmentObject modifiedObj = objectCreatedEvent.getModifiedObject();
        this.mLinkContainer.refreshDataLinks(modifiedObj);
    }

    private void refObjectRemoved(ReferencedObjectRemovedEvent refObjRemoved) {
    }

    private void refObjectAdded(ReferencedObjectAddedEvent refObjAdded) {
    }

    private void refObjectChanged(ReferencedObjectChangedEvent refObjChanged) {
        try {
            Controller controller;
            DevelopmentObject modifiedObj = refObjChanged.getModifiedObject();
            DevelopmentObject newObject = refObjChanged.getNewReferencedObject();
            DevelopmentObjectKey oldRefObject = refObjChanged.getOldReferencedObject();
            if (!(modifiedObj.getMDO() instanceof Controller)) {
                return;
            }
            Controller devObj = controller = (Controller)modifiedObj.getMDO();
            if (controller.hasView()) {
                devObj = controller.getView();
            }
            if (newObject == null) {
                DevelopmentObject object;
                if (modifiedObj instanceof ContextModelNode && (object = modifiedObj.getMetamodel().getObjectFromKey(oldRefObject)) instanceof ModelClass) {
                    this.mLinkContainer.modelReferenceDeleted((DevelopmentObject)devObj, ((ModelClass)object).getModel());
                }
            } else {
                this.mLinkContainer.modelReferenceChanged((DevelopmentObject)devObj, newObject);
            }
        }
        catch (Exception e) {
            MetamodelSupplementPlugin.internalError(this.getClass(), "refObjectChanged(ReferencedObjectChangedEvent)", e.getMessage(), e, true);
        }
    }

    private void subObjectMoved(SubObjectMovedEvent subObjectMovedEvent) {
    }

    private void subObjectDeleted(SubObjectDeletedEvent subObjectDeletedEvent) {
        ControllerUsage controllerUsage;
        ControllerUsage target;
        DevelopmentObject modifiedObject = subObjectDeletedEvent.getModifiedObject();
        DevelopmentObject subObject = subObjectDeletedEvent.getSubObject();
        if (modifiedObject instanceof ComponentControllerUsage && subObject instanceof ControllerUsage) {
            ComponentControllerUsage usage;
            ComponentControllerUsage source = usage = (ComponentControllerUsage)modifiedObject;
            target = null;
            controllerUsage = (ControllerUsage)subObject;
            if (controllerUsage.hasComponentUsage()) {
                target = controllerUsage;
            } else if (controllerUsage.hasUsedController()) {
                target = controllerUsage.getUsedController();
            }
            if (null != source && null != target) {
                this.mLinkContainer.deleteLink((DevelopmentObject)source, (DevelopmentObject)target);
            }
        }
        if (modifiedObject instanceof Controller) {
            DevelopmentObject source = modifiedObject;
            Controller controller = (Controller)source;
            if (controller.hasView()) {
                source = controller.getView();
            }
            target = null;
            if (subObject instanceof ControllerUsage) {
                controllerUsage = (ControllerUsage)subObject;
                if (controllerUsage.hasComponentUsage()) {
                    if (controllerUsage.hasUsedController()) {
                        target = controllerUsage;
                    }
                } else if (controllerUsage.hasUsedController()) {
                    target = controllerUsage.getUsedController();
                }
            } else if (subObject instanceof ComponentUsage) {
                target = ((ComponentUsage)subObject).getUsedComponent();
            }
            if (null != target && null != source) {
                this.mLinkContainer.deleteLink(source, (DevelopmentObject)target);
            }
        } else if (modifiedObject instanceof Model && subObject instanceof ModelClass) {
            this.mLinkContainer.modelClassDeleted((Model)modifiedObject, (ModelClass)subObject);
        }
    }

    private void subObjectCreated(SubObjectCreatedEvent subObjectCreatedEvent) {
        DevelopmentObject changedObject = subObjectCreatedEvent.getModifiedObject();
        DevelopmentObject subObject = subObjectCreatedEvent.getSubObject();
        Controller source = null;
        ControllerUsage target = null;
        if (changedObject instanceof Controller) {
            Controller controller;
            source = controller = (Controller)changedObject;
            if (controller.hasView()) {
                source = controller.getView();
            }
        } else if (changedObject instanceof ComponentControllerUsage) {
            ComponentControllerUsage usage = (ComponentControllerUsage)changedObject;
            source = usage;
        }
        Object parent = null;
        if (subObject instanceof ControllerUsage) {
            ControllerUsage usage = (ControllerUsage)subObject;
            if (usage.hasComponentUsage()) {
                if (usage.hasUsedController()) {
                    target = usage;
                }
            } else if (usage.hasUsedController()) {
                target = usage.getUsedController();
            }
        }
        if (null != source && null != target) {
            this.mLinkContainer.addLink((DevelopmentObject)source, (DevelopmentObject)target);
        }
    }

    public void update(MetamodelEvent[] events) {
        int i = 0;
        while (i < events.length) {
            this.update(events[i]);
            ++i;
        }
    }

    private ComponentControllerUsage getComponentControllerUsage(ControllerUsage usage) {
        if (usage.hasComponentUsage()) {
            ComponentUsage compUsage = usage.getComponentUsage();
            ComponentControllerUsage[] compControllerUsages = compUsage.getComponentControllerUsages();
            int i = 0;
            while (i < compControllerUsages.length) {
                if (compControllerUsages[i].getUsedComponentController() == usage.getUsedController()) {
                    return compControllerUsages[i];
                }
                ++i;
            }
        }
        return null;
    }
}

