/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodelsupplement.webdynpro.links;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.metamodel.webdynpro.component.controller.AbstractContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElementMapping;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodelsupplement.webdynpro.MetamodelSupplementPlugin;
import com.sap.ide.metamodelsupplement.webdynpro.events.DataLinkObserver;
import com.sap.ide.metamodelsupplement.webdynpro.links.DataLink;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.tssap.selena.model.elements.UniqueName;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class DataLinkContainer {
    private static final DataLink[] EMPTY_DATA_LINK_ARRAY = new DataLink[0];
    private Hashtable mDataLinks = new Hashtable();
    private WebDynproRoot mWebDynproRoot;
    private Vector mModelUsages = new Vector();
    private Hashtable mUniqueNames = new Hashtable();
    private List mDataLinkObservers = new Vector();

    public void clearDataLinks() {
        this.mWebDynproRoot = null;
        this.mDataLinks.clear();
        this.mModelUsages.clear();
        this.mUniqueNames.clear();
    }

    public void addLink(DevelopmentObject source, DevelopmentObject target) {
        Set keys = this.mDataLinks.keySet();
        Iterator iter = keys.iterator();
        try {
            while (iter.hasNext()) {
                DevelopmentObject objSource = (DevelopmentObject)iter.next();
                if (!objSource.getKey().equals(source.getKey())) continue;
                List targets = (List)this.mDataLinks.get(source);
                int i = 0;
                while (i < targets.size()) {
                    DataLink dataLink = (DataLink)targets.get(i);
                    if (dataLink.getTarget().equals(target)) {
                        return;
                    }
                    ++i;
                }
                DataLink link = this.createDataLink(source, target);
                targets.add(link);
                this.mUniqueNames.put(link.getUniqueName().toString(), link);
                this.fireLinkCreatedEvent(link);
                return;
            }
        }
        catch (Exception e) {
            MetamodelSupplementPlugin.internalError(this.getClass(), "addLink(DevelopmentObject, DevelopmentObject)", "Error while creating data link", e, true);
        }
        DataLink link = this.createDataLink(source, target);
        Vector<DataLink> targets = new Vector<DataLink>();
        targets.add(link);
        this.mDataLinks.put(source, targets);
        this.mUniqueNames.put(link.getUniqueName().toString(), link);
        this.fireLinkCreatedEvent(link);
    }

    private DataLink createDataLink(DevelopmentObject source, DevelopmentObject target) {
        DataLink link = new DataLink(source, target);
        return link;
    }

    public boolean deleteLink(DevelopmentObject source, DevelopmentObject target) {
        try {
            if (this.mDataLinks.containsKey(source)) {
                DataLink link;
                Vector targets = (Vector)this.mDataLinks.get(source);
                int index = -1;
                int i = 0;
                while (i < targets.size()) {
                    link = (DataLink)targets.get(i);
                    if (link.getTarget().equals(target)) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                if (index == -1) {
                    return false;
                }
                link = (DataLink)targets.get(index);
                this.fireLinkDeletedEvent(link);
                this.mUniqueNames.remove(link.getUniqueName().toString());
                targets.removeElementAt(index);
                if (targets.isEmpty()) {
                    this.removeDataLink(source);
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            MetamodelSupplementPlugin.internalError(this.getClass(), "deleteLink(DevelopmentObject, DevelopmentObject)", "Error while deleting data link", e, true);
            return false;
        }
    }

    private void removeDataLink(DevelopmentObject source) {
        this.mDataLinks.remove(source);
    }

    public boolean deleteLink(DataLink link) {
        return this.deleteLink(link.getSource(), link.getTarget());
    }

    public DataLink[] getOutgoingDataLinks(DevelopmentObject source) {
        if (this.mDataLinks.containsKey(source)) {
            Vector targets = (Vector)this.mDataLinks.get(source);
            DataLink[] targetLinks = new DataLink[targets.size()];
            int i = 0;
            while (i < targets.size()) {
                targetLinks[i] = (DataLink)targets.get(i);
                ++i;
            }
            return targetLinks;
        }
        this.addOutGoingDataLinks(source);
        if (this.mDataLinks.containsKey(source)) {
            Vector targets = (Vector)this.mDataLinks.get(source);
            DataLink[] targetLinks = new DataLink[targets.size()];
            int i = 0;
            while (i < targets.size()) {
                targetLinks[i] = (DataLink)targets.get(i);
                ++i;
            }
            return targetLinks;
        }
        return EMPTY_DATA_LINK_ARRAY;
    }

    private void addOutGoingDataLinks(DevelopmentObject source) {
        if (source instanceof View) {
            this.addControllerDataLinks((DevelopmentObject)((View)source), ((View)source).getViewController());
        } else if (source instanceof Controller) {
            this.addControllerDataLinks(source, (Controller)source);
        } else if (source instanceof ComponentControllerUsage) {
            this.addComponentControllerUsageDataLink((ComponentControllerUsage)source);
        }
    }

    private void addComponentControllerUsageDataLink(ComponentControllerUsage compControllerUsage) {
        ControllerUsage[] controllerUsages = compControllerUsage.getOutgoingControllerUsages();
        int k = 0;
        while (k < controllerUsages.length) {
            ControllerUsage controllerUsage = controllerUsages[k];
            if (controllerUsage.hasComponentUsage()) {
                this.addLink((DevelopmentObject)compControllerUsage, (DevelopmentObject)controllerUsage);
            } else {
                this.addLink((DevelopmentObject)compControllerUsage, (DevelopmentObject)controllerUsage.getUsedController());
            }
            ++k;
        }
    }

    public void deleteAllLinks() {
    }

    public void initialize(WebDynproRoot webDynproRoot) {
        this.mWebDynproRoot = webDynproRoot;
    }

    private void addExistingDataLinks(Component component) {
        View[] views = component.getViews();
        int j = 0;
        while (j < views.length) {
            View view = views[j];
            Controller controller = view.getViewController();
            this.addControllerDataLinks((DevelopmentObject)view, controller);
            ++j;
        }
        Controller controller = component.getComponentController();
        this.addControllerDataLinks((DevelopmentObject)controller, controller);
        controller = component.getComponentInterface().getConfigurationController();
        this.addControllerDataLinks((DevelopmentObject)controller, controller);
        controller = component.getComponentInterface().getInterfaceController();
        this.addControllerDataLinks((DevelopmentObject)controller, controller);
        Controller[] controllers = component.getControllers();
        int j2 = 0;
        while (j2 < controllers.length) {
            if (!controllers[j2].hasView()) {
                this.addControllerDataLinks((DevelopmentObject)controllers[j2], controllers[j2]);
            }
            ++j2;
        }
        ComponentUsage[] compUsages = component.getComponentUsages();
        int i = 0;
        while (i < compUsages.length) {
            ComponentUsage compUsage = compUsages[i];
            ComponentControllerUsage[] compControllerUsages = compUsage.getComponentControllerUsages();
            int j3 = 0;
            while (j3 < compControllerUsages.length) {
                ComponentControllerUsage compControllerUsage = compControllerUsages[j3];
                ControllerUsage[] controllerUsages = compControllerUsage.getOutgoingControllerUsages();
                int k = 0;
                while (k < controllerUsages.length) {
                    ControllerUsage controllerUsage = controllerUsages[k];
                    this.addLink((DevelopmentObject)compControllerUsage, (DevelopmentObject)controllerUsage.getUsedController());
                    ++k;
                }
                ++j3;
            }
            ++i;
        }
    }

    private void addControllerDataLinks(DevelopmentObject source, Controller controller) {
        if (source == null || controller == null) {
            return;
        }
        ControllerUsage[] usages = controller.getOutgoingControllerUsages();
        int k = 0;
        while (k < usages.length) {
            ControllerUsage usage = usages[k];
            if (usage.hasComponentUsage()) {
                if (usage.hasUsedController()) {
                    this.addLink(source, (DevelopmentObject)usage);
                }
            } else if (usage.hasUsedController()) {
                this.addLink(source, (DevelopmentObject)usage.getUsedController());
            }
            ++k;
        }
        if (controller.getContext() == null) {
            return;
        }
        AbstractContextNode[] childNodes = controller.getContext().getChildNodes();
        this.mModelUsages.clear();
        this.addModelUsages(childNodes, controller.getOutgoingControllerUsages());
        int k2 = 0;
        while (k2 < this.mModelUsages.size()) {
            Model model = (Model)this.mModelUsages.get(k2);
            if (null != model) {
                this.addLink(source, (DevelopmentObject)model);
            }
            ++k2;
        }
    }

    private void addModelUsages(AbstractContextNode[] childNodes, ControllerUsage[] controllerUsages) {
        int i = 0;
        while (i < childNodes.length) {
            AbstractContextNode node = childNodes[i];
            if (node instanceof ContextModelNode) {
                ModelClass modelClass;
                Model model;
                ContextModelNode modelNode = (ContextModelNode)node;
                ContextElementMapping mapping = CheckLayerHelper.getMapping((ContextElement)modelNode, (ControllerUsage[])controllerUsages);
                if (modelNode.hasModelClass() && !this.mModelUsages.contains(model = (Model)(modelClass = modelNode.getModelClass()).getParent())) {
                    this.mModelUsages.add(model);
                }
            }
            if (node instanceof ContextNode && ((ContextNode)node).getChildNodeCount() > 0) {
                this.addModelUsages(((ContextNode)node).getChildNodes(), controllerUsages);
            }
            ++i;
        }
    }

    public void modelReferenceAdded(DevelopmentObject devObj, ModelClass modelClass) {
        Model model = modelClass.getModel();
        Vector dataLinks = (Vector)this.mDataLinks.get(devObj);
        int i = 0;
        while (i < dataLinks.size()) {
            DataLink link = (DataLink)dataLinks.get(i);
            if (link.getTarget().equals(model)) {
                return;
            }
            ++i;
        }
        this.addLink(devObj, (DevelopmentObject)model);
    }

    public void modelReferenceDeleted(DevelopmentObject devObj, ContextModelNode modelNode) {
        if (modelNode != null && modelNode.hasModelClass()) {
            Model model = modelNode.getModelClass().getModel();
            this.modelReferenceDeleted(devObj, model);
        }
    }

    public void modelReferenceDeleted(DevelopmentObject devObj, Model model) {
        this.mModelUsages.clear();
        Controller controller = null;
        if (devObj instanceof View) {
            controller = ((View)devObj).getViewController();
        } else if (devObj instanceof Controller) {
            controller = (Controller)devObj;
        } else {
            return;
        }
        this.addModelUsages(controller.getContext().getChildNodes(), controller.getOutgoingControllerUsages());
        boolean found = false;
        int i = 0;
        while (i < this.mModelUsages.size()) {
            if (model.equals(this.mModelUsages.get(i))) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            this.deleteLink(devObj, (DevelopmentObject)model);
        }
    }

    public void modelReferenceChanged(DevelopmentObject devObj, DevelopmentObject newObject) {
        try {
            if (newObject instanceof ModelClass) {
                ModelClass modelClass = (ModelClass)newObject;
                Model targetModel = modelClass.getModel();
                this.addLink(devObj, (DevelopmentObject)targetModel);
            } else if (newObject instanceof ModelClassProperty) {
                ModelClassProperty modelClassProperty = (ModelClassProperty)newObject;
            }
            this.refreshModelBinding(devObj);
        }
        catch (Exception ex) {
            MetamodelSupplementPlugin.internalError(this.getClass(), "modelReferenceChanged(DevelopmentObject,DevelopmentObject)", "Error while updating model references", ex, true);
        }
    }

    private void refreshModelBinding(DevelopmentObject source) {
        Vector links = (Vector)this.mDataLinks.get(source);
        if (null == links) {
            return;
        }
        if (source instanceof View) {
            View view = (View)source;
            Controller controller = view.getViewController();
            this.mModelUsages.clear();
            this.addModelUsages(controller.getContext().getChildNodes(), controller.getOutgoingControllerUsages());
            int i = 0;
            while (i < this.mModelUsages.size()) {
                Model model = (Model)this.mModelUsages.get(i);
                String str = model.getName();
                ++i;
            }
        }
    }

    public DataLink findDataLink(UniqueName uniqueName) {
        Object link = this.mUniqueNames.get(uniqueName.toString());
        if (null == link) {
            // empty if block
        }
        return (DataLink)link;
    }

    private void refreshModelBindings(Model model, ModelClass modelClass) {
        Enumeration keyEnum = this.mDataLinks.keys();
        while (keyEnum.hasMoreElements()) {
            DevelopmentObject source = (DevelopmentObject)keyEnum.nextElement();
            Vector targets = (Vector)this.mDataLinks.get(source);
            Vector<DataLink> deleteTargets = new Vector<DataLink>();
            int i = 0;
            while (i < targets.size()) {
                DataLink link = (DataLink)targets.get(i);
                DevelopmentObject target = link.getTarget();
                if (target instanceof Model) {
                    boolean found = false;
                    Controller controller = null;
                    if (source instanceof View) {
                        controller = ((View)source).getViewController();
                    } else if (source instanceof Controller) {
                        controller = (Controller)source;
                    } else {
                        return;
                    }
                    if (model.equals(target) && !(found = this.modelReferenceExists(controller.getContext().getChildNodes(), model, modelClass))) {
                        deleteTargets.add(link);
                    }
                }
                ++i;
            }
            int deleteIndex = 0;
            while (deleteIndex < deleteTargets.size()) {
                this.deleteLink((DataLink)deleteTargets.get(deleteIndex));
                ++deleteIndex;
            }
            deleteTargets.clear();
        }
    }

    private boolean modelReferenceExists(AbstractContextNode[] childNodes, Model model, ModelClass targetClass) {
        int i = 0;
        while (i < childNodes.length) {
            ModelClass modelClass;
            AbstractContextNode contextNode = childNodes[i];
            if (contextNode instanceof ContextModelNode && null != (modelClass = CheckLayerHelper.getModelClass((ContextModelNode)((ContextModelNode)contextNode)))) {
                boolean found;
                Model mod = modelClass.getModel();
                if (null != mod && mod.equals(model) && !modelClass.equals(targetClass)) {
                    return true;
                }
                ContextModelNode modelNode = (ContextModelNode)contextNode;
                if (modelNode.getChildNodeCount() > 0 && (found = this.modelReferenceExists(modelNode.getChildNodes(), model, targetClass))) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public void modelClassDeleted(Model model, ModelClass modelClass) {
        this.refreshModelBindings(model, modelClass);
    }

    public void addDataLinkObserver(DataLinkObserver observer) {
        try {
            this.mDataLinkObservers.add(observer);
        }
        catch (Exception ex) {
            MetamodelSupplementPlugin.internalError(this.getClass(), "addDataLinkObserver(DataLinkObserver)", ex.getMessage(), ex, true);
        }
    }

    public void removeDataLinkObserver(DataLinkObserver observer) {
        this.mDataLinkObservers.remove(observer);
    }

    private void fireLinkCreatedEvent(DataLink link) {
        int i = 0;
        while (i < this.mDataLinkObservers.size()) {
            DataLinkObserver observer = (DataLinkObserver)this.mDataLinkObservers.get(i);
            observer.dataLinkCreated(link);
            ++i;
        }
    }

    private void fireLinkDeletedEvent(DataLink link) {
        int i = 0;
        while (i < this.mDataLinkObservers.size()) {
            DataLinkObserver observer = (DataLinkObserver)this.mDataLinkObservers.get(i);
            observer.dataLinkDeleted(link);
            ++i;
        }
    }

    public void refreshDataLinks(DevelopmentObject devObj) {
        Controller controller = null;
        if (devObj instanceof Controller) {
            controller = (Controller)devObj;
        } else {
            if (devObj instanceof Component) {
                this.addExistingDataLinks((Component)devObj);
                return;
            }
            if (devObj instanceof ContextElement) {
                controller = (Controller)((ContextElement)devObj).getMDO();
                devObj = controller;
            } else {
                return;
            }
        }
        if (controller.hasView()) {
            devObj = controller.getView();
        }
        this.addControllerDataLinks(devObj, controller);
    }

    public void reloadDataLinks(DevelopmentObject devObj) {
        Controller controller = null;
        if (!(devObj instanceof Controller)) {
            if (devObj instanceof Component) {
                this.reloadComponentDataLinks((Component)devObj);
                return;
            }
            return;
        }
        controller = (Controller)devObj;
        this.reloadControllerDataLinks(controller);
    }

    private void reloadComponentDataLinks(Component component) {
        Controller controller = component.getComponentController();
        this.reloadControllerDataLinks(controller);
        if (component.hasComponentInterface()) {
            if (component.getComponentInterface().hasConfigurationController()) {
                controller = component.getComponentInterface().getConfigurationController();
                this.reloadControllerDataLinks(controller);
            }
            if (component.getComponentInterface().hasInterfaceController()) {
                controller = component.getComponentInterface().getInterfaceController();
                this.reloadControllerDataLinks(controller);
            }
        }
        Controller[] controllers = component.getControllers();
        int i = 0;
        while (i < controllers.length) {
            this.reloadControllerDataLinks(controllers[i]);
            ++i;
        }
        this.reloadComponentUsageDataLinks(component);
    }

    private void reloadComponentUsageDataLinks(Component component) {
        ComponentUsage[] compUsages = component.getComponentUsages();
        int i = 0;
        while (i < compUsages.length) {
            int k;
            ComponentUsage compUsage = compUsages[i];
            ComponentControllerUsage[] compControllerUsages = compUsage.getComponentControllerUsages();
            int j = 0;
            while (j < compControllerUsages.length) {
                ComponentControllerUsage compControllerUsage = compControllerUsages[j];
                ControllerUsage[] controllerUsages = compControllerUsage.getOutgoingControllerUsages();
                DataLink[] existingDataLinks = this.getOutgoingDataLinks((DevelopmentObject)compControllerUsage);
                k = 0;
                while (k < existingDataLinks.length) {
                    boolean found = false;
                    DataLink link = existingDataLinks[k];
                    int l = 0;
                    while (l < controllerUsages.length) {
                        if (link.getTarget().getKey().equals(controllerUsages[l].getUsedController().getKey())) {
                            found = true;
                            break;
                        }
                        ++l;
                    }
                    if (!found) {
                        this.deleteLink(link);
                    }
                    ++k;
                }
                ++j;
            }
            int j2 = 0;
            while (j2 < compControllerUsages.length) {
                ComponentControllerUsage compControllerUsage = compControllerUsages[j2];
                ControllerUsage[] controllerUsages = compControllerUsage.getOutgoingControllerUsages();
                k = 0;
                while (k < controllerUsages.length) {
                    ControllerUsage controllerUsage = controllerUsages[k];
                    this.addLink((DevelopmentObject)compControllerUsage, (DevelopmentObject)controllerUsage.getUsedController());
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
    }

    private void reloadControllerDataLinks(Controller controller) {
        if (null == controller) {
            return;
        }
        try {
            ControllerUsage[] newControllerUsages;
            Controller source;
            block22: {
                source = controller;
                if (controller.hasView()) {
                    source = controller.getView();
                }
                newControllerUsages = controller.getOutgoingControllerUsages();
                if (controller.getContext() != null) {
                    this.mModelUsages.clear();
                    this.addModelUsages(controller.getContext().getChildNodes(), newControllerUsages);
                }
                if (!this.mDataLinks.containsKey(source)) break block22;
                DataLink[] existingDataLinks = this.getOutgoingDataLinks((DevelopmentObject)source);
                int i = 0;
                while (i < existingDataLinks.length) {
                    DataLink link;
                    boolean found;
                    block21: {
                        DevelopmentObject target;
                        block23: {
                            found = false;
                            target = null;
                            link = existingDataLinks[i];
                            if (!(link.getTarget() instanceof Model)) break block23;
                            int k = 0;
                            while (k < this.mModelUsages.size()) {
                                target = (DevelopmentObject)this.mModelUsages.get(k);
                                if (link.getTarget().getKey().equals(target.getKey())) {
                                    found = true;
                                    break block21;
                                }
                                ++k;
                            }
                            break block21;
                        }
                        int j = 0;
                        while (j < newControllerUsages.length) {
                            block26: {
                                block25: {
                                    ControllerUsage usage;
                                    block24: {
                                        usage = newControllerUsages[j];
                                        if (!usage.hasComponentUsage()) break block24;
                                        target = usage;
                                        break block25;
                                    }
                                    if (!usage.hasUsedController()) break block26;
                                    target = usage.getUsedController();
                                }
                                if (link.getTarget().getKey().equals(target.getKey())) {
                                    found = true;
                                    break;
                                }
                            }
                            ++j;
                        }
                    }
                    if (!found) {
                        this.deleteLink(link);
                    }
                    ++i;
                }
            }
            int i = 0;
            while (i < newControllerUsages.length) {
                block29: {
                    ControllerUsage target;
                    block28: {
                        ControllerUsage usage;
                        block27: {
                            usage = newControllerUsages[i];
                            target = null;
                            if (!usage.hasComponentUsage()) break block27;
                            target = usage;
                            break block28;
                        }
                        if (!usage.hasUsedController()) break block29;
                        target = usage.getUsedController();
                    }
                    if (null != source && null != target) {
                        this.addLink((DevelopmentObject)source, (DevelopmentObject)target);
                    }
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.mModelUsages.size()) {
                DevelopmentObject target = (DevelopmentObject)this.mModelUsages.get(i2);
                if (null != source && null != target) {
                    this.addLink((DevelopmentObject)source, target);
                }
                ++i2;
            }
        }
        catch (Exception e) {
            MetamodelSupplementPlugin.internalError(this.getClass(), "reloadControllerDataLinks(Controller)", "Error while reloading controller data links", e, true);
        }
    }
}

