/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodelsupplement.webdynpro;

import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodelsupplement.webdynpro.events.DataLinkObserver;
import com.sap.ide.metamodelsupplement.webdynpro.links.DataLink;
import com.sap.ide.metamodelsupplement.webdynpro.links.DataLinkContainer;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import java.util.Hashtable;

public class DataLinkManager {
    private static Hashtable mDataLinkManagers = new Hashtable();
    private DataLinkContainer mDataLinkContainer;

    public static DataLinkManager getDataLinkManager(String projectName) {
        if (projectName == null) {
            throw new IllegalArgumentException("ProjectName must not be null");
        }
        MetamodelManager.getMetamodelManager((String)projectName);
        return (DataLinkManager)mDataLinkManagers.get(projectName);
    }

    static void addDataLinkManager(String projectName, DataLinkManager dataLinkManager) {
        if (projectName != null && !mDataLinkManagers.containsKey(projectName)) {
            mDataLinkManagers.put(projectName, dataLinkManager);
        }
    }

    static void removeDataLinkManager(String projectName) {
        if (projectName != null) {
            mDataLinkManagers.remove(projectName);
        }
    }

    DataLinkManager(DataLinkContainer dataLinkContainer) {
        this.mDataLinkContainer = dataLinkContainer;
    }

    public DataLink[] getOutgoingDataLinks(DevelopmentObject source) {
        return this.mDataLinkContainer.getOutgoingDataLinks(source);
    }

    public DataLink findDataLink(UniqueName uniqueName) {
        return this.mDataLinkContainer.findDataLink(uniqueName);
    }

    public void addDataLinkObserver(DataLinkObserver observer) {
        this.mDataLinkContainer.addDataLinkObserver(observer);
    }

    public void removeDataLinkObserver(DataLinkObserver observer) {
        this.mDataLinkContainer.removeDataLinkObserver(observer);
    }

    public static UniqueName createUniqueName(DevelopmentObject source, DevelopmentObject target) {
        if (source != null && target != null) {
            return ModelAccess.createUniqueName((String)"WebDynpro", (String)"DataLink", null, (String)DataLinkManager.createName(source, target), null);
        }
        return null;
    }

    private static String createName(DevelopmentObject source, DevelopmentObject target) {
        if (source != null && target != null) {
            return DataLinkManager.adaptKey(source.getKey().toString() + "#" + target.getKey().toString());
        }
        return null;
    }

    private static String adaptKey(String key) {
        return key.replace(':', '#');
    }
}

