/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.htmlb;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Document;
import com.sapportals.htmlb.Form;
import com.sapportals.htmlb.Includes;
import com.sapportals.htmlb.Resource;
import com.sapportals.htmlb.enum.ResourceType;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.rendering.IFileParam;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.PageContext;
import com.sapportals.htmlb.rendering.RendererManager;
import com.sapportals.htmlb.util.SingleItemEnumeration;
import com.sapportals.portal.htmlb.HtmlbResource;
import com.sapportals.portal.prt.component.IPortalComponentRequest;
import com.sapportals.portal.prt.component.IPortalComponentResponse;
import com.sapportals.portal.prt.component.IPortalComponentSession;
import com.sapportals.portal.prt.component.PortalComponentContentType;
import com.sapportals.portal.prt.event.IPortalRequestEvent;
import com.sapportals.portal.prt.pom.INode;
import com.sapportals.portal.prt.resource.IResource;
import com.sapportals.portal.prt.service.laf.ILAFService;
import com.sapportals.portal.prt.session.IUserContext;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class PrtContext
extends PageContext {
    final String THEMEPART_NAME = "ur";
    IPortalComponentRequest portalRequest;
    IPortalComponentResponse portalResponse;
    String styleSheetURL;
    boolean oldFormChecked;
    boolean eventChecked;
    boolean notMyRequest;
    private Locale locale;

    public PrtContext(Object request, Object response) {
        super(request, response);
    }

    protected void init(Object request, Object response) {
        String sid;
        IUserContext user;
        INode eventNode;
        String stylePath;
        if (request instanceof IPortalComponentRequest) {
            this.portalRequest = (IPortalComponentRequest)request;
            super.setHttpServletRequest(this.portalRequest.getServletRequest());
        } else if (request instanceof HttpServletRequest) {
            this.portalRequest = null;
            this.setHttpServletRequest((HttpServletRequest)request);
            Object x = ((HttpServletRequest)request).getAttribute("com.sapportals.portal.prt.component.IPortalComponentRequest");
            if (x instanceof IPortalComponentRequest) {
                this.portalRequest = (IPortalComponentRequest)x;
            }
        }
        this.detectUserAgent(this.getHttpServletRequest());
        this.setResponse(response);
        this.setUTF8Encoding(true);
        String contentType = this.getHttpServletRequest().getContentType();
        this.setMultiPartMime(contentType != null && contentType.startsWith("multipart/form-data"));
        String mimePath = this.getMimePath();
        if (mimePath == null || mimePath.length() == 0) {
            this.setMimePath(RendererManager.getDefaultMimePath());
        }
        if ((stylePath = this.getStylePath()) == null || stylePath.length() == 0) {
            this.setStylePath(RendererManager.getDefaultStylePath());
        }
        INode thisNode = this.portalRequest.getNode();
        IPortalRequestEvent myEvent = this.portalRequest.getRequestEvent();
        INode iNode = eventNode = myEvent != null ? myEvent.getTarget() : null;
        if (!thisNode.equals(eventNode)) {
            this.eventChecked = true;
            this.oldFormChecked = true;
            this.notMyRequest = true;
        }
        if (this.isMultiPartMime()) {
            Object op = this.portalRequest.getValue("_HTMLB_PC");
            if (op instanceof PrtContext) {
                PrtContext opx = (PrtContext)((Object)op);
                this.parametersMultiPart = opx.getParametersMultiPart();
            } else {
                this.portalRequest.putValue("_HTMLB_PC", (Object)this);
            }
        }
        if ((user = this.portalRequest.getUser()) != null) {
            try {
                ((Object)((Object)this)).getClass();
                Class<?> c = Class.forName("com.sap.security.api.IUser");
                Method getAccessibilityLevel = null;
                getAccessibilityLevel = c != null ? c.getMethod("getAccessibilityLevel", null) : user.getClass().getMethod("getAccessibilityLevel", null);
                if (getAccessibilityLevel != null) {
                    Integer level = (Integer)getAccessibilityLevel.invoke((Object)user, null);
                    int accessibility = level;
                    Field defaultLevel = null;
                    defaultLevel = c != null ? c.getField("DEFAULT_ACCESSIBILITY_LEVEL") : user.getClass().getField("DEFAULT_ACCESSIBILITY_LEVEL");
                    if (defaultLevel != null) {
                        int dLevel = defaultLevel.getInt(user);
                        if (accessibility != dLevel) {
                            this.setSection508Rendering(true);
                        } else {
                            this.setSection508Rendering(false);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.setSection508Rendering(false);
            }
        }
        this.setLocale(this.portalRequest.getLocale());
        this.setActionUrl(this.portalRequest.createPageURL(this.portalRequest.getComponentContext(this.portalRequest.getNode().getNodeMode()).getContextName()));
        if (!this.notMyRequest && (sid = this.getParameter("htmlb_sid")) != null && sid.length() > 0) {
            this.readOldParamList(sid);
        }
        if (this.isMultiPartMime()) {
            this.getParameter("abc");
        }
        this.setRTL(this.queryRTL(this.portalRequest));
    }

    protected void checkForCurrentEvent() {
        if (!this.eventChecked) {
            super.checkForCurrentEvent();
            this.eventChecked = true;
        }
    }

    protected void checkFormElements() {
        if (!this.oldFormChecked) {
            super.checkFormElements();
            this.oldFormChecked = true;
        }
    }

    public Enumeration getParameterNames() {
        if (this.isMultiPartMime()) {
            this.initMultiPartMime();
            return this.parametersMultiPart.keys();
        }
        return this.getHttpServletRequest().getParameterNames();
    }

    public String getParameter(String name) {
        String value = null;
        if (this.isMultiPartMime()) {
            this.initMultiPartMime();
            Object param = this.parametersMultiPart.get(name);
            value = param instanceof String[] ? ((String[])param)[0] : null;
        } else {
            String s;
            value = s = this.getHttpServletRequest().getParameter(name);
        }
        if (value == null && this.oldParamList != null) {
            value = (String)this.oldParamList.get(name);
        }
        return this.attemptUTF8Encoding(value);
    }

    public String[] getParameterValues(String name) {
        String[] values = null;
        if (this.isMultiPartMime()) {
            this.initMultiPartMime();
            Object param = this.parametersMultiPart.get(name);
            values = param instanceof String[] ? (String[])param : null;
        } else {
            values = this.getHttpServletRequest().getParameterValues(name);
        }
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                values[i] = this.attemptUTF8Encoding(values[i]);
                ++i;
            }
        }
        return values;
    }

    public boolean isFileParam(String name) {
        if (!this.notMyRequest) {
            return super.isFileParam(name);
        }
        return false;
    }

    public IFileParam getFileParam(String name) {
        if (!this.notMyRequest) {
            return super.getFileParam(name);
        }
        return null;
    }

    public Object getRequest() {
        return this.portalRequest;
    }

    public void setRequest(Object request) {
        this.portalRequest = (IPortalComponentRequest)request;
    }

    public Object getResponse() {
        return this.portalResponse;
    }

    public void setResponse(Object response) {
        this.portalResponse = (IPortalComponentResponse)response;
        if (this.portalResponse != null) {
            this.setWriter((Writer)new PageContext.UnbufferedWriter((PageContext)this, this.portalResponse.getWriter()));
            if (this.portalRequest != null) {
                this.setJavascriptPath(this.portalRequest.getWebServicePath("com.sap.portal.htmlb") + "/jslib/");
                try {
                    ILAFService myLAFService = (ILAFService)this.portalRequest.getService("com.sap.portal.themes.lafservice.laf");
                    this.styleSheetURL = myLAFService.getThemePartURL(this.portalRequest, "ur");
                }
                catch (Exception e) {
                    this.styleSheetURL = "./";
                }
                String stylePath = this.styleSheetURL.substring(0, this.styleSheetURL.lastIndexOf(47) + 1);
                if (stylePath.startsWith("http")) {
                    int pos = -1;
                    int i = 0;
                    while (i < 3) {
                        pos = stylePath.indexOf(47, pos + 1);
                        ++i;
                    }
                    stylePath = stylePath.substring(pos);
                }
                this.setStylePath(stylePath);
                if (stylePath.endsWith("ur/")) {
                    stylePath = stylePath.substring(0, stylePath.length() - "ur/".length());
                }
                String mimePath = stylePath + "common/";
                this.setMimePath(mimePath);
            }
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.setRTL(this.queryRTL());
    }

    public Locale getLocale() {
        if (this.locale == null) {
            if (this.portalRequest != null) {
                this.setLocale(this.portalRequest.getLocale());
            }
            this.setLocale(Locale.getDefault());
        }
        return this.locale;
    }

    public Enumeration getLocales() {
        if (this.portalRequest != null) {
            return new SingleItemEnumeration((Object)this.portalRequest.getLocale());
        }
        return new SingleItemEnumeration((Object)Locale.getDefault());
    }

    public Document createDocument(String title) {
        this.document = new Document(title);
        Includes documentIncludes = new Includes();
        documentIncludes.addHeadResource(ResourceType.JAVASCRIPT, "DEFAULT_JS", (Object)this.getJavascriptUrl());
        if (!this.getUrMapiJavascriptUrl().equals(this.getJavascriptPath())) {
            documentIncludes.addHeadResource(ResourceType.JAVASCRIPT, "SAP_UR_MAPI_JS", (Object)this.getUrMapiJavascriptUrl());
        }
        if (!this.getUrPopupJavascriptUrl().equals(this.getJavascriptPath())) {
            documentIncludes.addHeadResource(ResourceType.JAVASCRIPT, "SAP_UR_POPUP_JS", (Object)this.getUrPopupJavascriptUrl());
        }
        this.document.setIncludes(documentIncludes);
        return this.document;
    }

    public void setFormDefaults(Form form) {
        IPortalComponentRequest request = (IPortalComponentRequest)this.getRequest();
        if (request != null) {
            String actionUrl = request.createComponentURL(request.getNode(), request.createRequestEvent("HtmlbEvent"));
            form.setAction(actionUrl);
        }
    }

    public void render() {
        if (this.document != null) {
            this.portalResponse.setContentType(PortalComponentContentType.HTML);
            this.document.preRender((IPageContext)this);
            this.render((Component)this.document);
        }
    }

    public void startDocument() {
    }

    public void startDocumentHead(String title) {
    }

    public void writeHeadIncludes() {
        this.write("<script defer language=\"JavaScript\">ur_system.is508");
        this.write("=" + this.getIs508());
        if (this.getIsRTL()) {
            this.write(";ur_system.direction=\"rtl\"");
        }
        this.write(";ur_language=\"" + this.getLocale().toString() + "\";");
        this.write(";</script>");
        Includes headIncludes = this.document.getIncludes();
        Iterator heads = headIncludes.getHeadList().iterator();
        while (heads.hasNext()) {
            Resource myResource = (Resource)heads.next();
            if (ResourceType.CSS.equals(myResource.getType())) {
                this.portalResponse.addResource((IResource)new HtmlbResource("css", (String)myResource.getData()));
                continue;
            }
            if (!ResourceType.JAVASCRIPT.equals(myResource.getType())) continue;
            this.portalResponse.addResource((IResource)new HtmlbResource("script", (String)myResource.getData()));
        }
    }

    public void endDocumentHead() {
    }

    public void startDocumentBody() {
        this.document.render(3, (IPageContext)this);
    }

    public void endDocumentBody() {
        HashSet menus = this.document.getHoverMenus();
        int maxDepth = 0;
        HashSet hoverMenus = this.document.getHoverMenus();
        if (menus != null && !menus.isEmpty()) {
            Iterator hoverIt = hoverMenus.iterator();
            while (hoverIt.hasNext()) {
                HoverMenu menu = (HoverMenu)hoverIt.next();
                int tempDepth = menu.getMenuDepth();
                if (maxDepth < tempDepth) {
                    maxDepth = tempDepth;
                }
                this.render((Component)menu);
            }
        }
        this.document.render(4, (IPageContext)this);
    }

    public void endDocument() {
    }

    public String getStylesheetUrl() {
        if (this.styleSheetURL != null) {
            return this.styleSheetURL;
        }
        return super.getStylesheetUrl();
    }

    public Object getAttribute(String key) {
        IPortalComponentSession mySession;
        if (this.portalRequest != null && (mySession = this.portalRequest.getComponentSession()) != null) {
            return mySession.getValue(key);
        }
        return null;
    }

    public void setAttribute(String key, Object value) {
        IPortalComponentSession mySession = this.portalRequest.getComponentSession();
        mySession.putValue(key, value);
    }

    protected void readOldParamList(String formId) {
        IPortalComponentRequest rq;
        IPortalComponentSession session;
        Object request = this.getRequest();
        if (request instanceof IPortalComponentRequest && (session = (rq = (IPortalComponentRequest)request).getComponentSession()) != null) {
            this.oldParamList = (HashMap)session.getValue(formId);
        }
    }

    public void storeParametersInSession(String formId) {
        IPortalComponentRequest rq;
        IPortalComponentSession session;
        Object request = this.getRequest();
        if (request instanceof IPortalComponentRequest && (session = (rq = (IPortalComponentRequest)request).getComponentSession()) != null) {
            this.newParamList = new HashMap();
            session.putValue(formId, (Object)this.newParamList);
        }
    }

    public void registerStylesheet(String key) {
        ILAFService myLAFService = null;
        try {
            myLAFService = (ILAFService)this.portalRequest.getService("com.sap.portal.themes.lafservice.laf");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (myLAFService != null) {
            myLAFService.includeThemePartInResponse(key, this.portalRequest, this.portalResponse);
        }
    }

    private boolean queryRTL(IPortalComponentRequest r) {
        try {
            ILAFService myLAFService = (ILAFService)this.portalRequest.getService("com.sap.portal.themes.lafservice.laf");
            return myLAFService.isRtl(r);
        }
        catch (Exception e) {
            return this.queryRTL();
        }
    }
}

