/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.htmlb;

import com.sapportals.htmlb.VersionInfo;
import com.sapportals.htmlb.rendering.IContextCondition;
import com.sapportals.htmlb.rendering.PageContextFactory;
import com.sapportals.portal.htmlb.PrtContextCondition;
import com.sapportals.portal.prt.component.IPortalComponentRequest;
import com.sapportals.portal.prt.component.IPortalComponentResponse;
import com.sapportals.portal.prt.service.IService;
import com.sapportals.portal.prt.service.IServiceConfiguration;
import com.sapportals.portal.prt.service.IServiceContext;
import com.sapportals.portal.prt.service.document.IDocumentHookListener;
import com.sapportals.portal.prt.service.document.IDocumentHookService;
import com.sapportals.portal.prt.service.laf.ILAFService;
import java.io.File;

public class HTMLBService
implements IService,
IDocumentHookListener {
    final String THEMEPART_NAME = "ur";
    public static final String KEY = "com.sap.portal.htmlb.htmlb";
    IServiceContext context;
    static /* synthetic */ Class class$com$sapportals$portal$htmlb$PrtContext;

    public void init(IServiceContext context) {
        String url = context.getPublicServicePath();
        if (url != null) {
            url = "file:/" + url.replace('\\', '/') + "/mimes/mimesinfo.xml";
            System.setProperty("statusicons.mimes.name", url);
        }
        this.context = context;
        String config = context.getPrivateServicePath();
        if (config != null) {
            config = config + File.separator + "lib" + File.separator + "htmlb.properties";
            System.setProperty("htmlb.property.name", config);
        }
    }

    public void afterInit() {
        IDocumentHookService hookSrvc = (IDocumentHookService)this.context.getService("com.sap.portal.runtime.application.document.document");
        hookSrvc.addDocumentHook((IDocumentHookListener)this);
    }

    public void configure(IServiceConfiguration configuration) {
    }

    public void destroy() {
        try {
            IDocumentHookService hookSrvc = (IDocumentHookService)this.context.getService("com.sap.portal.runtime.application.document.document");
            if (hookSrvc != null) {
                hookSrvc.removeDocumentHook((IDocumentHookListener)this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void release() {
    }

    public IServiceContext getContext() {
        return this.context;
    }

    public String getKey() {
        return KEY;
    }

    public void doDocumentHook(int documentPosition, IPortalComponentRequest request, IPortalComponentResponse response) {
        response.write(this.doDocumentHook(documentPosition, request));
    }

    public String doDocumentHook(int documentPosition, IPortalComponentRequest request) {
        switch (documentPosition) {
            case 4: {
                return this.onHeadTagBegin(request);
            }
        }
        return "";
    }

    private String onHeadTagBegin(IPortalComponentRequest request) {
        String styleSheetURL = null;
        try {
            ILAFService myLAFService = (ILAFService)request.getService("com.sap.portal.themes.lafservice.laf");
            styleSheetURL = myLAFService.getThemePartURL(request, "ur");
        }
        catch (Exception e) {
            styleSheetURL = "./";
        }
        String stylePath = styleSheetURL.substring(0, styleSheetURL.lastIndexOf(47) + 1);
        if (stylePath.startsWith("http")) {
            int pos = -1;
            int i = 0;
            while (i < 3) {
                pos = stylePath.indexOf(47, pos + 1);
                ++i;
            }
            stylePath = stylePath.substring(pos);
        }
        String mimePath = stylePath.substring(0, stylePath.length() - 2);
        mimePath = mimePath.substring(0, mimePath.lastIndexOf("/")) + "/common/";
        String javaScriptPath = request.getWebServicePath("com.sap.portal.htmlb") + "/jslib/";
        StringBuffer htmlHook = new StringBuffer(512);
        htmlHook.append("\n<!-- ");
        htmlHook.append(VersionInfo.getVersion());
        htmlHook.append(" -->\n<!-- HTMLB: begin VARS -->\n<script language=\"JavaScript\">\n");
        htmlHook.append("ur_system = {doc : window.document , mimepath :\"");
        htmlHook.append(mimePath);
        htmlHook.append("\", stylepath : \"");
        htmlHook.append(stylePath);
        htmlHook.append("\", emptyhoverurl : \"");
        htmlHook.append(javaScriptPath);
        htmlHook.append("emptyhover.html");
        htmlHook.append("\", is508 : false, domainrelaxing : \"MINIMAL\"};\n");
        htmlHook.append("</script>\n<!-- HTMLB: end   VARS -->\n");
        return htmlHook.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PageContextFactory.registerRendererContext((IContextCondition)new PrtContextCondition(), (Class)(class$com$sapportals$portal$htmlb$PrtContext == null ? (class$com$sapportals$portal$htmlb$PrtContext = HTMLBService.class$("com.sapportals.portal.htmlb.PrtContext")) : class$com$sapportals$portal$htmlb$PrtContext));
        System.setProperty("statusicons.mimes.url", "/irj/portalapps/com.sap.portal.htmlb/mimes/common/");
    }
}

