/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.xmi;

import com.sap.ip.mmr.foundation.JmiException;
import com.sap.ip.mmr.xmi.HRefResolver;
import com.sap.ip.mmr.xmi.XmiContext;
import java.net.URL;
import javax.jmi.reflect.RefObject;
import javax.jmi.xmi.MalformedXMIException;

public class HRefResolverImpl
implements HRefResolver {
    private String theBaseDocumentURL;
    private XmiContext context;

    public HRefResolverImpl(String baseDocumentURL) {
        if (baseDocumentURL == null) {
            this.theBaseDocumentURL = baseDocumentURL;
        } else {
            this.theBaseDocumentURL = baseDocumentURL.replace('\\', '/');
            if (this.theBaseDocumentURL != null) {
                int index = this.theBaseDocumentURL.lastIndexOf(47);
                this.theBaseDocumentURL = index > 0 ? this.theBaseDocumentURL.substring(0, index) : "./";
            }
        }
    }

    public RefObject resolve(URL baseDocumentURL, String href) throws MalformedXMIException {
        RefObject obj = null;
        int index = href.indexOf(124);
        if (index == -1) {
            index = href.indexOf(35);
        }
        if (index == -1 && (obj = this.context.getReference(href)) == null) {
            throw new JmiException("2105", new Object[]{href});
        }
        String docName = href.substring(0, index).trim();
        String xmiId = href.substring(index + 1, href.length()).trim();
        if (xmiId.length() == 0 || docName.length() == 0) {
            throw new JmiException("2105", new Object[]{href});
        }
        if (this.theBaseDocumentURL != null && this.theBaseDocumentURL.indexOf("http:") != 0) {
            int index2 = docName.lastIndexOf(47);
            String name = docName.substring(index2 + 1);
            docName = this.theBaseDocumentURL + '/' + name;
            if (docName.indexOf("jar:") != 0 && docName.indexOf("file:") != 0) {
                docName = "file:" + docName;
            }
        }
        int docId = this.context.getDocumentId(docName);
        obj = this.context.getReference(docId, xmiId);
        return obj;
    }

    public XmiContext getContext() {
        return this.context;
    }

    public void setContext(XmiContext context) {
        this.context = context;
    }

    public String resolveURL(URL baseDocumentURL, String href) throws MalformedXMIException {
        String url = "";
        if (this.theBaseDocumentURL != null) {
            url = this.theBaseDocumentURL.replace('\\', '/');
        }
        if (url.indexOf("file:") != 0) {
            url = "file:" + url;
        }
        return url + '/' + href;
    }
}

