/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.persistence;

import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.foundation.AssociationsOfObject;
import com.sap.ip.mmr.foundation.FileContent;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.ObjectInputStreamWithClassLoader;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.fs.IRepositoryFS;
import com.sap.ip.mmr.fs.RepositoryFS;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.search.AttributesValues;
import com.sap.tc.logging.Location;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jmi.model.ModelElement;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;

public class PersistenceFSCache {
    public static final String DIR_CACHE = "MMRCache";
    private static final String FILE_TYPE_SER = ".ser";
    private static final String FILE_TYPE_XML = ".xml";
    public static final String INDEX_TIMESTAMPS = "timestamps.properties";
    private static PersistenceFSCache persistenceFSCache;
    private static IRepositoryFS repositoryFS;
    private static final Location location;
    private Map timestampsLoaded = new HashMap();
    private boolean used = true;
    static /* synthetic */ Class class$com$sap$ip$mmr$persistence$PersistenceFSCache;

    private PersistenceFSCache() {
        repositoryFS = RepositoryServer.getRepositoryFS();
    }

    public static final PersistenceFSCache getPersistenceFSCache() {
        if (persistenceFSCache == null) {
            persistenceFSCache = new PersistenceFSCache();
        }
        return persistenceFSCache;
    }

    private String getTempDir(IConnection connection) {
        if (connection == null) {
            return null;
        }
        String tempDir = connection.getConnectionSpec().getProperties().getProperty("tempDir").replace('\\', '/');
        if (tempDir.charAt(tempDir.length() - 1) != '/') {
            tempDir = tempDir + '/';
        }
        return tempDir + DIR_CACHE;
    }

    private String getTempDir(IConnection connection, Workspace workspace) {
        String hashCode = PersistenceFSCache.getHashCodeFromWorkspace(workspace);
        return this.getTempDir(connection) + '/' + hashCode;
    }

    public final void clear(IConnection connection) {
        String tempDir = this.getTempDir(connection);
        RepositoryServer.getRepositoryFS().deleteDirectory(tempDir);
        File f = new File(tempDir);
        if (!f.exists()) {
            f.mkdir();
        }
    }

    protected String createFileNameInstanceSer(String dir, String mofId) {
        return dir + '/' + mofId + "_I" + FILE_TYPE_SER;
    }

    public boolean deleteInstance(IConnection connection, Workspace workspace, String path) {
        this.setUsed(connection);
        if (!this.isUsed()) {
            return true;
        }
        boolean res = true;
        String p = this.completePath(connection, workspace, path);
        if (p == null) {
            return false;
        }
        File f = new File(p);
        if (f.exists()) {
            res = f.delete();
        }
        return res;
    }

    public boolean writeInstance(IConnection connection, Workspace workspace, RefBaseObject rbo) {
        String path;
        boolean res = true;
        this.setUsed(connection);
        if (!this.isUsed()) {
            return true;
        }
        String nameStorageDir = this.getStorageDir(connection, workspace, rbo);
        File f = new File(nameStorageDir);
        if (!f.exists()) {
            RepositoryServer.getRepositoryFS().createDirectory(nameStorageDir);
        }
        if (!((f = new File(path = this.createFileNameInstanceSer(nameStorageDir, rbo.refMofId()))).exists() && !f.canWrite() || RepositoryServer.getRepositoryFS().writeBinary(path, this.encodeObjectSer(connection, rbo)))) {
            res = false;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected byte[] encodeObjectSer(IConnection connection, Object o) {
        byte[] res;
        block19: {
            block18: {
                ByteArrayOutputStream baos;
                block16: {
                    String method = "encodeObjectSer(IConnection connection, Object o)";
                    location.entering("encodeObjectSer(IConnection connection, Object o)");
                    res = null;
                    if (!(o instanceof Serializable)) break block18;
                    Serializable oser = (Serializable)o;
                    baos = new ByteArrayOutputStream();
                    ObjectOutputStream os = null;
                    os = new ObjectOutputStream(baos);
                    os.writeObject(oser);
                    Object var10_8 = null;
                    try {
                        baos.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                    try {
                        if (os != null) {
                            os.close();
                        }
                        break block16;
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                    break block16;
                    {
                        catch (IOException e) {
                            RepositoryServer.getCategory().errorT(location, "encodeObjectSer(IConnection connection, Object o)", MMRResourceAccessor.getInstance().getMessageText("0003"), new Object[]{e.toString()});
                            Object var10_9 = null;
                            try {
                                baos.close();
                            }
                            catch (IOException e1) {
                                RepositoryServer.category.errorT(location, e1.toString());
                            }
                            try {
                                if (os != null) {
                                    os.close();
                                }
                                break block16;
                            }
                            catch (IOException e1) {
                                RepositoryServer.category.errorT(location, e1.toString());
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_10 = null;
                        try {
                            baos.close();
                        }
                        catch (IOException e1) {
                            RepositoryServer.category.errorT(location, e1.toString());
                        }
                        try {
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (IOException e1) {
                            RepositoryServer.category.errorT(location, e1.toString());
                        }
                        throw throwable;
                    }
                }
                res = baos.toByteArray();
                break block19;
            }
            res = null;
        }
        location.exiting();
        return res;
    }

    protected Object decodeObjectSer(IConnection connection, byte[] data) {
        String version;
        String method = "decodeObjectSer(IConnection connection, byte data[])";
        location.entering("decodeObjectSer(IConnection connection, byte data[])");
        Object o = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader(bais, RepositoryServer.getRepositoryServer(), connection);
            o = ois.readObject();
            ois.close();
            bais.close();
        }
        catch (IOException e) {
            o = null;
        }
        catch (ClassNotFoundException e) {
            o = null;
        }
        if (o instanceof IMMRObject && (version = ((IMMRObject)o).get___GeneratorVersion()).compareTo("1.1.1") < 0) {
            o = null;
        }
        location.exiting();
        return o;
    }

    public ModelElement readModelElement(IConnection connection, Workspace workspace, String mofId, String path, long lastModified) {
        ModelElement me = null;
        this.setUsed(connection);
        if (!this.isUsed()) {
            return me;
        }
        long lchg = this.getTimeStamp(connection, workspace, path);
        if (lchg < lastModified) {
            return null;
        }
        byte[] data = this.getFileContent(connection, this.completePath(connection, workspace, path));
        if (data == null) {
            return me;
        }
        me = (ModelElement)this.decodeObjectSer(connection, data);
        if (me != null && me instanceof ModelElementImpl) {
            ModelElementImpl mei = (ModelElementImpl)me;
            if (mofId != null) {
                mei.setMofId(mofId);
            }
            mei.setRepository(connection.getRepository());
            mei.setMofLayer(2);
            mei.setState(StateEnum.STATE_UNCHANGED);
        }
        return me;
    }

    public RefObject readRefObject(IConnection connection, Workspace workspace, String mofId, String path, long lastModified) {
        RefObject ro = null;
        this.setUsed(connection);
        if (!this.isUsed()) {
            return ro;
        }
        long lchg = this.getTimeStamp(connection, workspace, path);
        if (lchg < lastModified) {
            return null;
        }
        byte[] data = this.getFileContent(connection, this.completePath(connection, workspace, path));
        if (data == null) {
            return ro;
        }
        ro = (RefObject)this.decodeObjectSer(connection, data);
        if (ro != null && ro instanceof IMMRObject) {
            IMMRObject mdro = (IMMRObject)ro;
            if (mofId != null) {
                mdro.set___MofId(mofId);
            }
            mdro.set___State(StateEnum.STATE_UNCHANGED);
        }
        return ro;
    }

    public AssociationsOfObject readAoo(IConnection connection, Workspace workspace, String path, long lastModified) {
        AssociationsOfObject aoo = null;
        this.setUsed(connection);
        if (!this.isUsed()) {
            return aoo;
        }
        long lchg = this.getTimeStamp(connection, workspace, path);
        if (lchg < lastModified) {
            return null;
        }
        byte[] data = this.getFileContent(connection, this.completePath(connection, workspace, path));
        if (data == null) {
            return aoo;
        }
        Object o = this.decodeObjectSer(connection, data);
        if (o instanceof AssociationsOfObject) {
            aoo = (AssociationsOfObject)o;
        }
        return aoo;
    }

    public boolean deleteAssoc(IConnection connection, Workspace workspace, String path) {
        this.setUsed(connection);
        if (!this.isUsed()) {
            return true;
        }
        boolean res = true;
        String p = this.completePath(connection, workspace, path);
        if (p == null) {
            return false;
        }
        File f = new File(p);
        if (f.exists()) {
            res = f.delete();
        }
        return res;
    }

    public boolean writeAoo(IConnection connection, Workspace workspace, String dir, AssociationsOfObject aoo) {
        if (aoo == null) {
            return false;
        }
        this.setUsed(connection);
        if (!this.isUsed()) {
            return true;
        }
        boolean res = true;
        String path = this.completePath(connection, workspace, dir);
        File f = new File(path);
        if (!(f.exists() && !f.canWrite() || RepositoryServer.getRepositoryFS().writeBinary(path, this.encodeObjectSer(connection, aoo)))) {
            res = false;
        }
        return res;
    }

    protected byte[] getFileContent(IConnection connection, String path) {
        File f = new File(path);
        if (!f.exists()) {
            return null;
        }
        return RepositoryServer.getRepositoryFS().readFileContent(path);
    }

    protected String getStorageDir(IConnection connection, Workspace workspace, RefBaseObject ro) {
        String name = "default";
        RefObject rom = ro.refMetaObject();
        if (rom != null && rom instanceof ModelElement) {
            name = Utilities.getUtilities().encodeQualifiedName(((ModelElement)rom).getQualifiedName()).replace('.', '/');
        }
        String hashCode = PersistenceFSCache.getHashCodeFromWorkspace(workspace);
        return this.getTempDir(connection) + '/' + hashCode + '/' + name;
    }

    public static String getHashCodeFromWorkspace(Workspace workspace) {
        return "h" + workspace.getName().hashCode();
    }

    private String completePath(IConnection connection, Workspace workspace, String path) {
        if (path == null) {
            return null;
        }
        String p = path;
        int n = p.indexOf("MMR_M2");
        if (n >= 0) {
            p = p.substring(n + "MMR_M2".length());
        }
        if ((n = p.indexOf("MMR_M1")) >= 0) {
            p = p.substring(n + "MMR_M1".length());
        }
        if ((n = p.lastIndexOf(FILE_TYPE_XML)) >= 0) {
            p = p.substring(0, n) + FILE_TYPE_SER;
        }
        if (p.length() > 0 && p.charAt(0) == '/') {
            p = p.substring(1);
        }
        StringBuffer sb = new StringBuffer(120).append(this.getTempDir(connection)).append("/h").append(String.valueOf(workspace.getName().hashCode())).append('/').append(p);
        return sb.toString();
    }

    public boolean deleteWorkspace(IConnection connection, Workspace workspace) {
        this.setUsed(connection);
        if (!this.isUsed()) {
            return true;
        }
        String hashCode = PersistenceFSCache.getHashCodeFromWorkspace(workspace);
        String dir = this.getTempDir(connection) + '/' + hashCode;
        return RepositoryServer.getRepositoryFS().deleteDirectory(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Properties getTypeInformationM1(IConnection connection, Workspace workspace, Properties typeInformationM1) {
        block9: {
            this.copy(this.getFilenameTypeInformationOrigin(connection, workspace, 1), this.getFilenameTypeInformation(connection, workspace, 1));
            File f = new File(this.getFilenameTypeInformation(connection, workspace, 1));
            this.setUsed(connection);
            if (f.exists()) {
                FileInputStream fis = null;
                BufferedInputStream bis = null;
                fis = new FileInputStream(f);
                bis = new BufferedInputStream(fis);
                typeInformationM1.load(bis);
                Object var9_7 = null;
                try {
                    bis.close();
                    fis.close();
                }
                catch (IOException e1) {
                    RepositoryServer.category.errorT(location, e1.toString());
                }
                break block9;
                {
                    catch (Exception e) {
                        RepositoryServer.category.errorT(location, e.toString());
                        Object var9_8 = null;
                        try {
                            bis.close();
                            fis.close();
                        }
                        catch (IOException e1) {
                            RepositoryServer.category.errorT(location, e1.toString());
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    try {
                        bis.close();
                        fis.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                    throw throwable;
                }
            }
        }
        return this.getTimeStamps(connection, workspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Properties getTypeInformationM2(IConnection connection, Workspace workspace, Properties typeInformationM2) {
        block9: {
            this.copy(this.getFilenameTypeInformationOrigin(connection, workspace, 2), this.getFilenameTypeInformation(connection, workspace, 2));
            File f = new File(this.getFilenameTypeInformation(connection, workspace, 2));
            this.setUsed(connection);
            if (f.exists()) {
                FileInputStream fis = null;
                BufferedInputStream bis = null;
                fis = new FileInputStream(f);
                bis = new BufferedInputStream(fis);
                typeInformationM2.load(bis);
                Object var9_7 = null;
                try {
                    bis.close();
                    fis.close();
                }
                catch (IOException e1) {
                    RepositoryServer.category.errorT(location, e1.toString());
                }
                break block9;
                {
                    catch (Exception e) {
                        RepositoryServer.category.errorT(location, e.toString());
                        Object var9_8 = null;
                        try {
                            bis.close();
                            fis.close();
                        }
                        catch (IOException e1) {
                            RepositoryServer.category.errorT(location, e1.toString());
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    try {
                        bis.close();
                        fis.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                    throw throwable;
                }
            }
        }
        return this.getTimeStamps(connection, workspace);
    }

    protected String getFilenameTypeInformation(IConnection connection, Workspace workspace, int layer) {
        String fname = this.getDirectoryMMR(connection, workspace, layer);
        if (fname == null) {
            return null;
        }
        return fname + '/' + "IndexTypeInformation.properties";
    }

    protected String getFilenameTypeInformationOrigin(IConnection connection, Workspace workspace, int layer) {
        String fname = this.getDirectoryMMROrigin(connection, workspace, layer);
        if (fname == null) {
            return null;
        }
        return fname + '/' + "IndexTypeInformation.properties";
    }

    protected String getDirectoryMMR(IConnection connection, Workspace workspace, int layer) {
        String dir = this.getTempDir(connection, workspace).replace('\\', '/');
        if (!dir.endsWith("/")) {
            dir = dir + '/';
        }
        switch (layer) {
            case 1: {
                dir = dir + "MMR_M1";
                break;
            }
            case 2: {
                dir = dir + "MMR_M2";
                break;
            }
            default: {
                return null;
            }
        }
        return dir;
    }

    protected String getDirectoryMMROrigin(IConnection connection, Workspace workspace, int layer) {
        String dir = workspace.getPath().replace('\\', '/');
        if (!dir.endsWith("/")) {
            dir = dir + '/';
        }
        switch (layer) {
            case 1: {
                dir = dir + "MMR_M1";
                break;
            }
            case 2: {
                dir = dir + "MMR_M2";
                break;
            }
            default: {
                return null;
            }
        }
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void updateTypeInformation(IConnection connection, Workspace workspace, Properties typeInformationM1, Properties typeInformationM2) {
        block29: {
            FileOutputStream out;
            File f;
            String dn;
            String fn;
            block28: {
                this.setUsed(connection);
                String method = "updateTypeInformation(IConnection connection, String sourceDir, String destDir)";
                fn = null;
                dn = null;
                fn = this.getFilenameTypeInformation(connection, workspace, 1);
                dn = this.getDirectoryMMR(connection, workspace, 1);
                if (fn != null && typeInformationM1 != null && typeInformationM1.size() > 0) {
                    f = new File(dn);
                    if (f.exists() && !f.isDirectory()) {
                        return;
                    }
                    f = new File(fn);
                    if (!f.exists() || f.canWrite()) {
                        RepositoryServer.getRepositoryFS().createDirectory(dn);
                        out = null;
                        out = new FileOutputStream(fn, false);
                        typeInformationM1.store(out, "TypeInformation");
                        Object var12_10 = null;
                        try {
                            if (out != null) {
                                ((OutputStream)out).close();
                            }
                            break block28;
                        }
                        catch (IOException e1) {
                            RepositoryServer.category.errorT(location, e1.toString());
                        }
                        break block28;
                        {
                            catch (Exception e) {
                                RepositoryServer.getCategory().errorT(location, "updateTypeInformation(IConnection connection, String sourceDir, String destDir)", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{e.toString()});
                                Object var12_11 = null;
                                try {
                                    if (out != null) {
                                        ((OutputStream)out).close();
                                    }
                                    break block28;
                                }
                                catch (IOException e1) {
                                    RepositoryServer.category.errorT(location, e1.toString());
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var12_12 = null;
                            try {
                                if (out != null) {
                                    ((OutputStream)out).close();
                                }
                            }
                            catch (IOException e1) {
                                RepositoryServer.category.errorT(location, e1.toString());
                            }
                            throw throwable;
                        }
                    }
                }
            }
            fn = this.getFilenameTypeInformation(connection, workspace, 2);
            dn = this.getDirectoryMMR(connection, workspace, 2);
            if (fn != null && typeInformationM2 != null && typeInformationM2.size() > 0) {
                f = new File(dn);
                if (f.exists() && !f.isDirectory()) {
                    return;
                }
                f = new File(fn);
                if (!f.exists() || f.canWrite()) {
                    RepositoryServer.getRepositoryFS().createDirectory(dn);
                    out = null;
                    out = new FileOutputStream(fn, false);
                    typeInformationM2.store(out, "TypeInformation");
                    Object var15_19 = null;
                    try {
                        if (out != null) {
                            ((OutputStream)out).close();
                        }
                        break block29;
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                    break block29;
                    {
                        catch (Exception e) {
                            RepositoryServer.getCategory().errorT(location, "updateTypeInformation(IConnection connection, String sourceDir, String destDir)", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{e.toString()});
                            Object var15_20 = null;
                            try {
                                if (out != null) {
                                    ((OutputStream)out).close();
                                }
                                break block29;
                            }
                            catch (IOException e1) {
                                RepositoryServer.category.errorT(location, e1.toString());
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var15_21 = null;
                        try {
                            if (out != null) {
                                ((OutputStream)out).close();
                            }
                        }
                        catch (IOException e1) {
                            RepositoryServer.category.errorT(location, e1.toString());
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Properties getQualifiedNamesM2(IConnection connection, Workspace workspace, Properties qualifiedNamesM2) {
        block9: {
            this.copy(this.getFilenameQualifiedNamesOrigin(connection, workspace, 2), this.getFilenameQualifiedNames(connection, workspace, 2));
            File f = new File(this.getFilenameQualifiedNames(connection, workspace, 2));
            this.setUsed(connection);
            if (f.exists()) {
                FileInputStream fis = null;
                BufferedInputStream bis = null;
                fis = new FileInputStream(f);
                bis = new BufferedInputStream(fis);
                qualifiedNamesM2.load(bis);
                Object var9_7 = null;
                try {
                    bis.close();
                    fis.close();
                }
                catch (IOException e1) {
                    RepositoryServer.category.errorT(location, e1.toString());
                }
                break block9;
                {
                    catch (Exception e) {
                        RepositoryServer.category.errorT(location, e.toString());
                        Object var9_8 = null;
                        try {
                            bis.close();
                            fis.close();
                        }
                        catch (IOException e1) {
                            RepositoryServer.category.errorT(location, e1.toString());
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    try {
                        bis.close();
                        fis.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                    throw throwable;
                }
            }
        }
        return this.getTimeStamps(connection, workspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Properties getQualifiedNamesM1(IConnection connection, Workspace workspace, Properties qualifiedNamesM1) {
        block9: {
            this.copy(this.getFilenameQualifiedNamesOrigin(connection, workspace, 1), this.getFilenameQualifiedNames(connection, workspace, 1));
            File f = new File(this.getFilenameQualifiedNames(connection, workspace, 1));
            this.setUsed(connection);
            if (f.exists()) {
                FileInputStream fis = null;
                BufferedInputStream bis = null;
                fis = new FileInputStream(f);
                bis = new BufferedInputStream(fis);
                qualifiedNamesM1.load(bis);
                Object var9_7 = null;
                try {
                    bis.close();
                    fis.close();
                }
                catch (IOException e1) {
                    RepositoryServer.category.errorT(location, e1.toString());
                }
                break block9;
                {
                    catch (Exception e) {
                        RepositoryServer.category.errorT(location, e.toString());
                        Object var9_8 = null;
                        try {
                            bis.close();
                            fis.close();
                        }
                        catch (IOException e1) {
                            RepositoryServer.category.errorT(location, e1.toString());
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    try {
                        bis.close();
                        fis.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                    throw throwable;
                }
            }
        }
        return this.getTimeStamps(connection, workspace);
    }

    protected String getFilenameQualifiedNames(IConnection connection, Workspace workspace, int layer) {
        String fname = this.getDirectoryMMR(connection, workspace, layer);
        if (fname == null) {
            return null;
        }
        return fname + '/' + "IndexQualifiedName.properties";
    }

    protected String getFilenameQualifiedNamesOrigin(IConnection connection, Workspace workspace, int layer) {
        String fname = this.getDirectoryMMROrigin(connection, workspace, layer);
        if (fname == null) {
            return null;
        }
        return fname + '/' + "IndexQualifiedName.properties";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void updateQualifiedNames(IConnection connection, Workspace workspace, Properties qualifiedNamesM2) {
        block13: {
            String method = "updateQualifiedNamesM2(IConnection connection)";
            this.setUsed(connection);
            String fn = null;
            String dn = null;
            fn = this.getFilenameQualifiedNames(connection, workspace, 2);
            dn = this.getDirectoryMMR(connection, workspace, 2);
            if (fn != null && qualifiedNamesM2 != null && qualifiedNamesM2.size() > 0) {
                File f = new File(dn);
                if (f.exists() && !f.isDirectory()) {
                    return;
                }
                f = new File(fn);
                RepositoryServer.getRepositoryFS().createDirectory(dn);
                FileOutputStream out = null;
                out = new FileOutputStream(fn, false);
                qualifiedNamesM2.store(out, "QualifiedNames");
                Object var11_9 = null;
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                    break block13;
                }
                catch (IOException e1) {
                    RepositoryServer.category.errorT(location, e1.toString());
                }
                break block13;
                {
                    catch (Exception e) {
                        RepositoryServer.getCategory().errorT(location, "updateQualifiedNamesM2(IConnection connection)", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{e.toString()});
                        Object var11_10 = null;
                        try {
                            if (out != null) {
                                ((OutputStream)out).close();
                            }
                            break block13;
                        }
                        catch (IOException e1) {
                            RepositoryServer.category.errorT(location, e1.toString());
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    try {
                        if (out != null) {
                            ((OutputStream)out).close();
                        }
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                    throw throwable;
                }
            }
        }
    }

    protected String getFilenameSearch(IConnection connection, Workspace workspace, int layer) {
        String fname = this.getDirectoryMMR(connection, workspace, layer);
        if (fname == null) {
            return null;
        }
        return fname + '/' + "IndexSearch.xml";
    }

    protected String getFilenameSearchOrigin(IConnection connection, Workspace workspace, int layer) {
        String fname = this.getDirectoryMMROrigin(connection, workspace, layer);
        if (fname == null) {
            return null;
        }
        return fname + '/' + "IndexSearch.xml";
    }

    public void updateSearchData(IConnection connection, Workspace workspace, AttributesValues attributesValuesM1, AttributesValues attributesValuesM2) {
        FileContent fc;
        File f;
        this.setUsed(connection);
        String fns = null;
        String dns = null;
        fns = this.getFilenameSearch(connection, workspace, 1);
        dns = this.getDirectoryMMR(connection, workspace, 1);
        if (fns != null && attributesValuesM1 != null && attributesValuesM1.size() > 0) {
            f = new File(dns);
            if (f.exists() && !f.isDirectory()) {
                return;
            }
            f = new File(fns);
            if (attributesValuesM1 != null && attributesValuesM1.size() > 0) {
                RepositoryServer.getRepositoryFS().createDirectory(dns);
                fc = new FileContent(fns, attributesValuesM1.xmlExport());
                RepositoryServer.getRepositoryFS().writeFileContent(fc, false);
            }
        }
        fns = this.getFilenameSearch(connection, workspace, 2);
        dns = this.getDirectoryMMR(connection, workspace, 2);
        if (fns != null && attributesValuesM2 != null && attributesValuesM2.size() > 0) {
            f = new File(dns);
            if (f.exists() && !f.isDirectory()) {
                return;
            }
            f = new File(fns);
            if (attributesValuesM2 != null && attributesValuesM2.size() > 0) {
                RepositoryServer.getRepositoryFS().createDirectory(dns);
                fc = new FileContent(fns, attributesValuesM2.xmlExport());
                RepositoryServer.getRepositoryFS().writeFileContent(fc, false);
            }
        }
    }

    public Properties getAttributesValuesM1(IConnection connection, Workspace workspace, AttributesValues attributesValuesM1) {
        this.setUsed(connection);
        if (attributesValuesM1 == null) {
            attributesValuesM1 = new AttributesValues();
        }
        if (attributesValuesM1.size() < 1) {
            byte[] data;
            this.copy(this.getFilenameSearchOrigin(connection, workspace, 1), this.getFilenameSearch(connection, workspace, 1));
            String fns = this.getFilenameSearch(connection, workspace, 1);
            File f = new File(fns);
            if (f != null && f.exists() && (data = RepositoryServer.getRepositoryFS().readFileContent(this.getFilenameSearch(connection, workspace, 1))) != null) {
                attributesValuesM1.xmlImport(data);
            }
        }
        return this.getTimeStamps(connection, workspace);
    }

    public Properties getAttributesValuesM2(IConnection connection, Workspace workspace, AttributesValues attributesValuesM2) {
        this.setUsed(connection);
        if (attributesValuesM2 == null) {
            attributesValuesM2 = new AttributesValues();
        }
        if (attributesValuesM2.size() < 1) {
            byte[] data;
            this.copy(this.getFilenameSearchOrigin(connection, workspace, 2), this.getFilenameSearch(connection, workspace, 2));
            String fns = this.getFilenameSearch(connection, workspace, 2);
            File f = new File(fns);
            if (f != null && f.exists() && (data = RepositoryServer.getRepositoryFS().readFileContent(this.getFilenameSearch(connection, workspace, 2))) != null) {
                attributesValuesM2.xmlImport(data);
            }
        }
        return this.getTimeStamps(connection, workspace);
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed(boolean b) {
        this.used = b;
    }

    private void setUsed(IConnection connection) {
        if (connection != null) {
            Boolean b = (Boolean)connection.getConnectionSpec().getProperties().get("MMR_USE_CACHE");
            if (b == null || b.equals(Boolean.TRUE)) {
                this.setUsed(true);
            } else {
                this.setUsed(false);
            }
        }
    }

    protected void copy(String pathS, String pathT) {
        File fS = new File(pathS);
        if (!fS.exists()) {
            return;
        }
        long tS = fS.lastModified();
        File fT = new File(pathT);
        long tT = 0L;
        if (fT.exists()) {
            tT = fT.lastModified();
        }
        if (tS > tT) {
            byte[] bytes = repositoryFS.readFileContent(fS.getAbsolutePath());
            repositoryFS.writeBinary(fT.getAbsolutePath(), bytes);
            fT.setLastModified(tS);
        }
    }

    public long getTimeStamp(IConnection connection, Workspace workspace, String path) {
        long lchg = 0L;
        if (!this.isUsed()) {
            return lchg;
        }
        Properties p = this.getTimeStamps(connection, workspace);
        String s = p.getProperty(path.replace('\\', '/'));
        if (s != null) {
            lchg = Long.parseLong(s);
        }
        return lchg;
    }

    public void setTimeStamp(IConnection connection, Workspace workspace, String path, long timestamp) {
        Properties p = this.getTimeStamps(connection, workspace);
        p.put(path.replace('\\', '/'), String.valueOf(timestamp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Properties getTimeStamps(IConnection connection, Workspace workspace) {
        Properties timestamps;
        block16: {
            block15: {
                BufferedInputStream bis;
                FileInputStream fis;
                block14: {
                    timestamps = (Properties)this.timestampsLoaded.get(workspace);
                    if (timestamps != null) break block16;
                    timestamps = new Properties();
                    String path = this.getPathTimestamps(connection, workspace);
                    fis = null;
                    bis = null;
                    File f = new File(path);
                    if (!f.exists()) break block14;
                    fis = new FileInputStream(f);
                    bis = new BufferedInputStream(fis);
                    timestamps.load(bis);
                }
                Object var9_9 = null;
                try {
                    if (bis != null) {
                        bis.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                    break block15;
                }
                catch (IOException e1) {
                    RepositoryServer.category.errorT(location, e1.toString());
                }
                break block15;
                {
                    catch (Exception e) {
                        RepositoryServer.category.errorT(location, e.toString());
                        Object var9_10 = null;
                        try {
                            if (bis != null) {
                                bis.close();
                            }
                            if (fis != null) {
                                fis.close();
                            }
                            break block15;
                        }
                        catch (IOException e1) {
                            RepositoryServer.category.errorT(location, e1.toString());
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    try {
                        if (bis != null) {
                            bis.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                    throw throwable;
                }
            }
            this.timestampsLoaded.put(workspace, timestamps);
        }
        return timestamps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void updateTimestamps(IConnection connection, Workspace workspace, Properties timestampsNew) {
        block21: {
            this.setUsed(connection);
            if (!this.isUsed()) {
                return;
            }
            Properties timestamps = (Properties)this.timestampsLoaded.get(workspace);
            if (timestamps != null) {
                timestamps.putAll((Map<?, ?>)timestampsNew);
                String path = this.getPathTimestamps(connection, workspace);
                FileInputStream fis = null;
                BufferedInputStream bis = null;
                File f = new File(path);
                if (!f.exists()) {
                    RepositoryFS.createDirsOfPath(path);
                    f.createNewFile();
                }
                FileOutputStream out = new FileOutputStream(f, false);
                timestamps.store(out, "timestamps");
                Object var11_12 = null;
                try {
                    if (bis != null) {
                        bis.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                    break block21;
                }
                catch (IOException e1) {
                    RepositoryServer.category.errorT(location, e1.toString());
                }
                break block21;
                {
                    catch (Exception e) {
                        RepositoryServer.category.errorT(location, e.toString());
                        Object var11_13 = null;
                        try {
                            if (bis != null) {
                                bis.close();
                            }
                            if (fis != null) {
                                fis.close();
                            }
                            break block21;
                        }
                        catch (IOException e1) {
                            RepositoryServer.category.errorT(location, e1.toString());
                        }
                        break block21;
                    }
                    catch (Error e) {
                        RepositoryServer.category.errorT(location, e.toString());
                        Object var11_14 = null;
                        try {
                            if (bis != null) {
                                bis.close();
                            }
                            if (fis != null) {
                                fis.close();
                            }
                            break block21;
                        }
                        catch (IOException e1) {
                            RepositoryServer.category.errorT(location, e1.toString());
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    try {
                        if (bis != null) {
                            bis.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                    throw throwable;
                }
            }
        }
    }

    protected String getPathTimestamps(IConnection connection, Workspace workspace) {
        if (workspace == null) {
            return null;
        }
        String path = this.getTempDir(connection, workspace).replace('\\', '/');
        if (path == null) {
            return null;
        }
        if (!path.endsWith("/")) {
            path = path + '/';
        }
        path = path + INDEX_TIMESTAMPS;
        return path;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$persistence$PersistenceFSCache == null ? (class$com$sap$ip$mmr$persistence$PersistenceFSCache = PersistenceFSCache.class$("com.sap.ip.mmr.persistence.PersistenceFSCache")) : class$com$sap$ip$mmr$persistence$PersistenceFSCache);
    }
}

