/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.m2layer.model;

import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.foundation.JmiVerifyException;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import com.sap.ip.mmr.m2layer.model.StructuralFeatureImpl;
import java.util.Collection;
import java.util.List;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MultiplicityType;
import javax.jmi.model.Reference;
import javax.jmi.model.ScopeKind;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.VisibilityKind;

public class ReferenceImpl
extends StructuralFeatureImpl
implements Reference {
    static final long serialVersionUID = -8350335521058266034L;
    public static final String REFERENCEDEND = "referencedEnd";
    public static final String EXPOSEDEND = "exposedEnd";

    public ReferenceImpl(IRepository repository) {
        super(repository);
    }

    public ReferenceImpl(IRepository repository, String name) {
        super(repository, name);
    }

    public ReferenceImpl(IRepository repository, String name, String annotation, ScopeKind scope, VisibilityKind visibility, MultiplicityType multiplicity, boolean isChangeable) {
        super(repository, name);
        this.setAnnotation(annotation);
        this.setScope(scope);
        this.setVisibility(visibility);
        this.setMultiplicity(multiplicity);
        this.setChangeable(isChangeable);
    }

    public void copy(ModelElementImpl modelElement) {
        super.copy(modelElement);
    }

    public AssociationEnd getExposedEnd() {
        return this.getModelPackage().getExposes().getExposedEnd((Reference)this);
    }

    public void setExposedEnd(AssociationEnd newValue) {
        if (newValue == null) {
            return;
        }
        this.getModelPackage().getExposes().add((Reference)this, newValue);
    }

    public AssociationEnd getReferencedEnd() {
        return this.getModelPackage().getRefersTo().getReferencedEnd((Reference)this);
    }

    public void setReferencedEnd(AssociationEnd newValue) {
        if (newValue == null) {
            return;
        }
        this.getModelPackage().getRefersTo().add((Reference)this, newValue);
    }

    public void refSetValue(String featureName, Object value) {
        super.refSetValue(featureName, value);
        if (featureName.compareTo(REFERENCEDEND) == 0 && value instanceof AssociationEnd) {
            this.setReferencedEnd((AssociationEnd)value);
        }
        if (featureName.compareTo(EXPOSEDEND) == 0 && value instanceof AssociationEnd) {
            this.setExposedEnd((AssociationEnd)value);
        }
    }

    public Object refGetValue(String featureName) {
        Object o = super.refGetValue(featureName);
        if (o == null) {
            if (featureName.compareTo(REFERENCEDEND) == 0) {
                o = this.getReferencedEnd();
            }
            if (featureName.compareTo(EXPOSEDEND) == 0) {
                o = this.getExposedEnd();
            }
        }
        return o;
    }

    public Collection refVerifyConstraints(boolean deepVerify) {
        Collection col = super.refVerifyConstraints(deepVerify);
        AssociationEnd re = this.getReferencedEnd();
        if (re == null) {
            col = this.addException(col, new JmiVerifyException("2607", new Object[]{this}));
        } else {
            col = this.checkMultipliticy(col, re.getMultiplicity());
            if (!re.getMultiplicity().equals(this.getMultiplicity())) {
                col = this.addException(col, new JmiVerifyException("MOF_CONSTR_21", new Object[]{this}));
            }
            if (this.isChangeable() && !re.isChangeable()) {
                col = this.addException(col, new JmiVerifyException("MOF_CONSTR_23", new Object[]{this}));
            }
            if (!this.getType().equals(re.getType())) {
                col = this.addException(col, new JmiVerifyException("MOF_CONSTR_24", new Object[]{this}));
            }
            if (!re.isNavigable()) {
                col = this.addException(col, new JmiVerifyException("MOF_CONSTR_25", new Object[]{this}));
            }
            MofClass mc = (MofClass)this.getContainer();
            List ast = mc.allSupertypes();
            AssociationEnd ee = this.getExposedEnd();
            if (!ee.getType().equals(mc) && !ast.contains(ee.getType())) {
                col = this.addException(col, new JmiVerifyException("MOF_CONSTR_26", new Object[]{this}));
            }
            if (!this.isVisible((ModelElement)re)) {
                col = this.addException(col, new JmiVerifyException("MOF_CONSTR_27", new Object[]{this}));
            }
        }
        if (!this.getScope().equals(ScopeKindEnum.INSTANCE_LEVEL)) {
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_22", new Object[]{this}));
        }
        col = this.checkMultipliticy(col, this.getMultiplicity());
        return col;
    }
}

