/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.m2layer.model;

import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import com.sap.ip.mmr.m2layer.model.StructuralFeatureImpl;
import javax.jmi.model.Attribute;
import javax.jmi.model.MultiplicityType;
import javax.jmi.model.ScopeKind;
import javax.jmi.model.VisibilityKind;

public class AttributeImpl
extends StructuralFeatureImpl
implements Attribute {
    static final long serialVersionUID = 8326983280613337645L;
    public static final String ISDERIVED = "isDerived";
    private boolean derived = false;

    public AttributeImpl(IRepository repository) {
        super(repository);
    }

    public AttributeImpl(IRepository repository, String name) {
        super(repository, name);
    }

    public AttributeImpl(IRepository repository, String name, String annotation, ScopeKind scope, VisibilityKind visibility, MultiplicityType multiplicity, boolean isChangeable, boolean isDerived) {
        super(repository, name);
        this.setAnnotation(annotation);
        this.setScope(scope);
        this.setVisibility(visibility);
        this.setMultiplicity(multiplicity);
        this.setChangeable(isChangeable);
        this.setDerived(isDerived);
    }

    public void copy(ModelElementImpl modelElement) {
        super.copy(modelElement);
        if (modelElement instanceof AttributeImpl) {
            AttributeImpl a = (AttributeImpl)modelElement;
            this.setDerived(a.derived);
        }
    }

    public boolean isDerived() {
        return this.derived;
    }

    public final void setDerived(boolean newValue) {
        if (this.derived != newValue) {
            this.derived = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public void refSetValue(String featureName, Object value) {
        super.refSetValue(featureName, value);
        if (featureName.compareTo(ISDERIVED) == 0) {
            if (value instanceof String) {
                this.setDerived(Boolean.getBoolean((String)value));
            } else if (value instanceof Boolean) {
                this.setDerived((Boolean)value);
            }
        }
    }

    public Object refGetValue(String featureName) {
        Object o = super.refGetValue(featureName);
        if (o == null && featureName.compareTo(ISDERIVED) == 0) {
            o = new Boolean(this.isDerived());
        }
        return o;
    }
}

