/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.generate.jmi;

import com.sap.ip.mmr.foundation.JavaSource;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.generate.jmi.AttributeWithType;
import com.sap.ip.mmr.generate.jmi.CodeContainer;
import com.sap.ip.mmr.generate.jmi.Generator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.Constant;
import javax.jmi.model.GeneralizableElement;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.Namespace;
import javax.jmi.model.Operation;
import javax.jmi.model.Reference;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.Tag;
import javax.jmi.model.VisibilityKindEnum;

public class GeneratorInstance {
    public static String getJavaInterfaceName(MofClass mofClass) {
        return Generator.getJMIIdentifier((ModelElement)mofClass);
    }

    public static String getJavaInterfaceNameQualified(MofClass mofClass) {
        return Generator.getJMIIdentifierQualified((Namespace)mofClass);
    }

    public static String getJavaClassName(MofClass mofClass) {
        String str = Generator.getJMIIdentifier((ModelElement)mofClass) + "Impl";
        return str;
    }

    public static String getJavaClassNameQualified(MofClass mofClass) {
        String str = Generator.getJMIIdentifierQualified((Namespace)mofClass) + "Impl";
        return str;
    }

    public static String getJavaClassNameQualified(String qualifiedName) {
        String str = qualifiedName + "Impl";
        return str;
    }

    public JavaSource generateTemplate(MofClass mofClass, boolean noJavaDocs, boolean generateInterfaces) {
        ModelElement me;
        StringBuffer code = new StringBuffer(1000);
        JavaSource source = null;
        if (!generateInterfaces && mofClass.isAbstract()) {
            return null;
        }
        List contents = mofClass.getContents();
        List superTypesAll = Generator.getAllSupertypes((GeneralizableElement)mofClass);
        ArrayList contentsAll = new ArrayList();
        if (!generateInterfaces) {
            Iterator i = superTypesAll.iterator();
            while (i.hasNext()) {
                ModelElement me2 = (ModelElement)i.next();
                if (!(me2 instanceof Namespace)) continue;
                contentsAll.addAll(((Namespace)me2).getContents());
            }
        }
        contentsAll.addAll(contents);
        String javaInterfaceName = GeneratorInstance.getJavaInterfaceName(mofClass);
        String javaInterfaceNameQualified = GeneratorInstance.getJavaInterfaceNameQualified(mofClass);
        String javaClassName = GeneratorInstance.getJavaClassName(mofClass);
        String javaClassNameQualified = GeneratorInstance.getJavaClassNameQualified(mofClass);
        Generator.generatePackageStatement(code, (Namespace)mofClass);
        Generator.generateDefaultIncludes(code);
        HashSet<String> imports = new HashSet<String>();
        Iterator iter = contentsAll.iterator();
        while (iter.hasNext()) {
            Tag tag;
            Object o = iter.next();
            if (!(o instanceof Tag) || (tag = (Tag)o).getTagId().compareTo("com.sap.ip.mmr.ImportStatementsJava") != 0) continue;
            code.append("// These new import statements are included by the tag tagId=");
            code.append(tag.getTagId());
            code.append(", name=");
            code.append(Generator.getJMIIdentifier((ModelElement)tag));
            code.append(Utilities.SystemLineSeparator);
            Iterator iter1 = tag.getValues().iterator();
            while (iter1.hasNext()) {
                String importString = (String)iter1.next();
                if (importString.compareTo(GeneratorInstance.getJavaInterfaceNameQualified(mofClass)) == 0 || importString.compareTo(GeneratorInstance.getJavaClassNameQualified(mofClass)) == 0 || imports.contains(importString)) continue;
                code.append("import ");
                code.append(importString);
                code.append(";");
                code.append(Utilities.SystemLineSeparator);
                imports.add(importString);
            }
            code.append(Utilities.SystemLineSeparator);
        }
        if (!noJavaDocs) {
            Generator.generateAnnotationTemplate(code, (ModelElement)mofClass);
        }
        if (generateInterfaces) {
            code.append("public interface ");
            code.append(javaInterfaceName);
        } else {
            code.append("public class ");
            code.append(javaClassName);
        }
        if (generateInterfaces) {
            code.append(" extends ");
            List superTypes = mofClass.getSupertypes();
            iter = superTypes.iterator();
            if (!iter.hasNext()) {
                code.append("javax.jmi.reflect.RefObject");
            } else {
                while (iter.hasNext()) {
                    Classifier type = (Classifier)iter.next();
                    code.append(Generator.getJMIIdentifierQualified((Namespace)type));
                    if (!iter.hasNext()) continue;
                    code.append(", ");
                }
            }
        } else {
            code.append(" implements com.sap.ip.mmr.m1layer.IMMRObject, ");
            code.append(javaInterfaceNameQualified);
        }
        code.append(" {");
        code.append(Utilities.SystemLineSeparator);
        if (!generateInterfaces) {
            Generator.generateTemplateRefObjectDecl(code, (ModelElement)mofClass, javaClassName, false);
        }
        code.append(Utilities.SystemLineSeparator);
        code.append("// constants");
        code.append(Utilities.SystemLineSeparator);
        iter = contents.iterator();
        while (iter.hasNext()) {
            me = (ModelElement)iter.next();
            if (!(me instanceof Constant)) continue;
            Generator.getGeneratorConstantTemplate().generateTemplate(code, (Constant)me, noJavaDocs, generateInterfaces);
        }
        code.append(Utilities.SystemLineSeparator);
        code.append("// instance level attributes");
        code.append(Utilities.SystemLineSeparator);
        iter = generateInterfaces ? contents.iterator() : contentsAll.iterator();
        while (iter.hasNext()) {
            me = (ModelElement)iter.next();
            if (!(me instanceof Attribute) || !ScopeKindEnum.INSTANCE_LEVEL.equals((Object)((Attribute)me).getScope())) continue;
            Generator.getGeneratorAttributeTemplate().generateTemplate(code, (Attribute)me, noJavaDocs, generateInterfaces);
        }
        code.append(Utilities.SystemLineSeparator);
        code.append("// instance level references");
        code.append(Utilities.SystemLineSeparator);
        iter = generateInterfaces ? contents.iterator() : contentsAll.iterator();
        while (iter.hasNext()) {
            me = (ModelElement)iter.next();
            if (!(me instanceof Reference) || !ScopeKindEnum.INSTANCE_LEVEL.equals((Object)((Reference)me).getScope())) continue;
            Generator.getGeneratorReferenceTemplate().generateTemplate(code, (Reference)me, noJavaDocs, generateInterfaces);
        }
        code.append(Utilities.SystemLineSeparator);
        code.append("// instance level operations");
        code.append(Utilities.SystemLineSeparator);
        iter = generateInterfaces ? contents.iterator() : contentsAll.iterator();
        while (iter.hasNext()) {
            me = (ModelElement)iter.next();
            if (!(me instanceof Operation) || !ScopeKindEnum.INSTANCE_LEVEL.equals((Object)((Operation)me).getScope())) continue;
            Generator.getGeneratorOperationTemplate().generateTemplate(code, (Operation)me, noJavaDocs, generateInterfaces);
        }
        code.append(Utilities.SystemLineSeparator);
        this.generateConstructorTemplate(code, mofClass, generateInterfaces);
        if (!generateInterfaces) {
            CodeContainer cc = new CodeContainer();
            Generator.generateTemplateRefObject(cc, (ModelElement)mofClass, javaClassName, false);
            this.overwriteMethods(cc, contentsAll);
            code.append(cc.toString());
        }
        HashSet<String> operations = new HashSet<String>();
        iter = contentsAll.iterator();
        while (iter.hasNext()) {
            Tag tag;
            Object o = iter.next();
            if (!(o instanceof Tag) || (tag = (Tag)o).getTagId().compareTo("com.sap.ip.mmr.OperationJava") != 0 || operations.contains(tag.getName())) continue;
            operations.add(tag.getName());
            code.append("// These operations (methods) are included by the tag tagId=");
            code.append(tag.getTagId());
            code.append(", name=");
            code.append(Generator.getJMIIdentifier((ModelElement)tag));
            code.append(Utilities.SystemLineSeparator);
            Iterator iter1 = tag.getValues().iterator();
            while (iter1.hasNext()) {
                String opcode = (String)iter1.next();
                code.append(opcode);
                code.append(Utilities.SystemLineSeparator);
            }
            code.append(Utilities.SystemLineSeparator);
        }
        code.append("}");
        code.append(Utilities.SystemLineSeparator);
        source = generateInterfaces ? new JavaSource(javaInterfaceNameQualified) : new JavaSource(javaClassNameQualified);
        source.setSourceCode(code.toString());
        return source;
    }

    private void overwriteMethods(CodeContainer cc, Collection contentsAll) {
        CodeContainer.CodeMethod method = cc.getMethod("refClass");
        if (method != null) {
            method.getBody().clear();
            method.addBody("RefPackage p = refImmediatePackage();");
            method.addBody("int n = ___qualifiedName.lastIndexOf('.');");
            method.addBody("String name = ___qualifiedName.substring(n+1);");
            method.addBody("return p.refClass(name);");
        }
        if ((method = cc.getMethod("toString")) != null) {
            int maxAtr = 10;
            method.getBody().clear();
            method.addBody("final int maxValueLen = 20;");
            method.addBody("String str = ___qualifiedName + \"::\" + ___mofId + \"(\";");
            method.addBody("String atrValue;");
            method.addBody("java.lang.Object atrV;");
            int n = 0;
            Iterator iter = contentsAll.iterator();
            while (iter.hasNext()) {
                Attribute a;
                Object o = iter.next();
                if (!(o instanceof Attribute) || !ScopeKindEnum.INSTANCE_LEVEL.equals((Object)(a = (Attribute)o).getScope())) continue;
                method.addBody("atrV = (java.lang.Object)  refGetValue(\"" + a.getName() + "\");");
                method.addBody("if (atrV == null) {");
                method.addBody("  atrValue = null;");
                method.addBody("} else {");
                method.addBody("  atrValue = atrV.toString();");
                method.addBody("}");
                method.addBody("if (atrValue != null && atrValue.length() > maxValueLen) {");
                method.addBody("  atrValue = atrValue.substring(0,maxValueLen) + \"...\";");
                method.addBody("}");
                method.addBody("str += \"" + Generator.getJMIIdentifier((ModelElement)a) + "='\" + atrValue + \"'\";");
                if (iter.hasNext()) {
                    method.addBody("str += ',';");
                }
                if (++n < 10) continue;
                break;
            }
            method.addBody("str += \")\";");
            method.addBody("return str;");
        }
    }

    private void generateConstructorTemplate(StringBuffer code, MofClass mofClass, boolean generateInterfaces) {
        if (generateInterfaces) {
            return;
        }
        if (!(mofClass.isAbstract() || mofClass.getVisibility().toString().compareTo(VisibilityKindEnum.PUBLIC_VIS.toString()) != 0 && generateInterfaces)) {
            HashSet<AttributeWithType> set = new HashSet<AttributeWithType>();
            ArrayList<AttributeWithType> list = new ArrayList<AttributeWithType>();
            Iterator iter = Generator.getAllContent((ModelElement)mofClass).iterator();
            while (iter.hasNext()) {
                Attribute atr;
                ModelElement me = (ModelElement)iter.next();
                if (!(me instanceof Attribute) || (atr = (Attribute)me).getType() == null || !atr.getScope().equals(ScopeKindEnum.INSTANCE_LEVEL)) continue;
                AttributeWithType awt = new AttributeWithType(Generator.getJMIIdentifier((ModelElement)atr), Generator.getAttributeType(atr, true));
                awt.setMultiplicity(atr.getMultiplicity());
                if (set.contains(awt)) continue;
                set.add(awt);
                list.add(awt);
            }
            if (list.size() > 0) {
                AttributeWithType awt;
                code.append("// specific constructor");
                code.append(Utilities.SystemLineSeparator);
                code.append("public ");
                code.append(GeneratorInstance.getJavaClassName(mofClass));
                code.append("(IRepository repository, ");
                iter = list.iterator();
                while (iter.hasNext()) {
                    awt = (AttributeWithType)iter.next();
                    code.append(awt.getType());
                    code.append(' ');
                    code.append(awt.getName());
                    if (!iter.hasNext()) continue;
                    code.append(", ");
                }
                code.append(") {");
                code.append(Utilities.SystemLineSeparator);
                code.append("    ___repository = repository;");
                code.append(Utilities.SystemLineSeparator);
                code.append("    " + Generator.composeVariableName("MofId", true) + " = com.sap.ip.mmr.Repository.createMofId();");
                code.append(Utilities.SystemLineSeparator);
                iter = list.iterator();
                while (iter.hasNext()) {
                    awt = (AttributeWithType)iter.next();
                    String varInt = Generator.composeVariableName(awt.getName(), false);
                    if (awt.getMultiplicity().getUpper() != 1) {
                        code.append("    " + varInt + ".addAll(" + awt.getName() + ");");
                    } else {
                        code.append("    " + varInt + " = " + awt.getName() + ";");
                    }
                    code.append(Utilities.SystemLineSeparator);
                }
                code.append("}");
                code.append(Utilities.SystemLineSeparator);
            }
            code.append(Utilities.SystemLineSeparator);
        }
    }
}

