/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.generate.jmi;

import com.sap.ip.mmr.foundation.JavaSource;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.generate.jmi.AttributeWithType;
import com.sap.ip.mmr.generate.jmi.CodeContainer;
import com.sap.ip.mmr.generate.jmi.Generator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jmi.model.Attribute;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.GeneralizableElement;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.Namespace;
import javax.jmi.model.Operation;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.StructureType;
import javax.jmi.model.VisibilityKindEnum;

public class GeneratorClass {
    public static String getJavaInterfaceName(MofClass mofClass) {
        return Generator.getJMIIdentifier((ModelElement)mofClass) + "Class";
    }

    public static String getJavaInterfaceNameQualified(MofClass mofClass) {
        return Generator.getJMIIdentifierQualified((Namespace)mofClass) + "Class";
    }

    public static String getJavaClassName(MofClass mofClass) {
        String str = Generator.getJMIIdentifier((ModelElement)mofClass) + "Class" + "Impl";
        return str;
    }

    public static String getJavaClassNameQualified(MofClass mofClass) {
        String str = Generator.getJMIIdentifierQualified((Namespace)mofClass) + "Class" + "Impl";
        return str;
    }

    public static String getJavaClassNameQualified(String qualifiedName) {
        String str = qualifiedName + "Class" + "Impl";
        return str;
    }

    public JavaSource generateTemplate(MofClass mofClass, boolean noJavaDocs, boolean generateInterfaces) {
        ModelElement me;
        StringBuffer code = new StringBuffer(1000);
        JavaSource source = null;
        String javaInterfaceName = GeneratorClass.getJavaInterfaceName(mofClass);
        String javaInterfaceNameQualified = GeneratorClass.getJavaInterfaceNameQualified(mofClass);
        String javaClassName = GeneratorClass.getJavaClassName(mofClass);
        String javaClassNameQualified = GeneratorClass.getJavaClassNameQualified(mofClass);
        Generator.generatePackageStatement(code, (Namespace)mofClass);
        Generator.generateDefaultIncludes(code);
        if (!noJavaDocs) {
            Generator.generateAnnotationTemplate(code, (ModelElement)mofClass);
        }
        if (generateInterfaces) {
            code.append("public interface ");
            code.append(javaInterfaceName);
        } else {
            code.append("public class ");
            code.append(javaClassName);
        }
        if (generateInterfaces) {
            code.append(" extends javax.jmi.reflect.RefClass ");
        } else {
            code.append(" implements com.sap.ip.mmr.m1layer.IMMRObject, com.sap.ip.mmr.m1layer.IRefClass, ");
            code.append(javaInterfaceNameQualified);
        }
        code.append(" {");
        code.append(Utilities.SystemLineSeparator);
        List contents = mofClass.getContents();
        List superTypesAll = Generator.getAllSupertypes((GeneralizableElement)mofClass);
        LinkedList contentsAll = new LinkedList();
        if (contents.size() > 0) {
            contentsAll.addAll(contents);
        }
        Iterator i = superTypesAll.iterator();
        while (i.hasNext()) {
            ModelElement me2 = (ModelElement)i.next();
            if (!(me2 instanceof Namespace)) continue;
            contentsAll.addAll(((Namespace)me2).getContents());
        }
        if (!generateInterfaces) {
            Generator.generateTemplateRefClassDecl(code, (ModelElement)mofClass, javaClassName, true);
        }
        if (!mofClass.isAbstract()) {
            this.generateCreateTemplate(code, mofClass, generateInterfaces);
        }
        code.append("// each directly contained StructType with visibility = public_vis");
        code.append(Utilities.SystemLineSeparator);
        Iterator iter = contents.iterator();
        while (iter.hasNext()) {
            me = (ModelElement)iter.next();
            if (!(me instanceof StructureType)) continue;
            Generator.generateStructureTypeTemplate(code, (StructureType)me, generateInterfaces);
        }
        code.append(Utilities.SystemLineSeparator);
        code.append("// each directly contained EnumType with visibility = public_vis");
        code.append(Utilities.SystemLineSeparator);
        iter = contents.iterator();
        while (iter.hasNext()) {
            me = (ModelElement)iter.next();
            if (!(me instanceof EnumerationType)) continue;
            Generator.generateEnumerationTypeTemplate(code, (EnumerationType)me, generateInterfaces);
        }
        code.append(Utilities.SystemLineSeparator);
        code.append("// classifier-level scope attributes");
        code.append(Utilities.SystemLineSeparator);
        iter = contentsAll.iterator();
        while (iter.hasNext()) {
            Attribute atr;
            me = (ModelElement)iter.next();
            if (!(me instanceof Attribute) || !ScopeKindEnum.CLASSIFIER_LEVEL.equals((Object)(atr = (Attribute)me).getScope())) continue;
            Generator.getGeneratorAttributeTemplate().generateTemplate(code, atr, noJavaDocs, generateInterfaces);
        }
        code.append(Utilities.SystemLineSeparator);
        code.append("// classifier-level scope operations");
        code.append(Utilities.SystemLineSeparator);
        iter = contentsAll.iterator();
        while (iter.hasNext()) {
            Operation oper;
            me = (ModelElement)iter.next();
            if (!(me instanceof Operation) || !ScopeKindEnum.CLASSIFIER_LEVEL.equals((Object)(oper = (Operation)me).getScope())) continue;
            Generator.getGeneratorOperationTemplate().generateTemplate(code, oper, noJavaDocs, generateInterfaces);
        }
        code.append(Utilities.SystemLineSeparator);
        if (!generateInterfaces) {
            this.generateIsSingletonMethod(code, mofClass, generateInterfaces);
            this.generateIsAbstractMethod(code, mofClass, generateInterfaces);
        }
        if (!generateInterfaces) {
            CodeContainer cc = new CodeContainer();
            Generator.generateTemplateRefClass(cc, (ModelElement)mofClass, javaClassName, true);
            code.append(cc.toString());
        }
        code.append("}");
        code.append(Utilities.SystemLineSeparator);
        source = generateInterfaces ? new JavaSource(javaInterfaceNameQualified) : new JavaSource(javaClassNameQualified);
        source.setSourceCode(code.toString());
        return source;
    }

    private void generateIsSingletonMethod(StringBuffer code, MofClass mofClass, boolean generateInterfaces) {
        if (!generateInterfaces) {
            code.append("// meta object is singleton");
            code.append(Utilities.SystemLineSeparator);
            code.append("private boolean isSingleton() {");
            code.append(Utilities.SystemLineSeparator);
            if (mofClass.isSingleton()) {
                code.append("  return true;");
                code.append(Utilities.SystemLineSeparator);
            } else {
                code.append("  return false;");
                code.append(Utilities.SystemLineSeparator);
            }
            code.append("}");
            code.append(Utilities.SystemLineSeparator);
        }
    }

    private void generateIsAbstractMethod(StringBuffer code, MofClass mofClass, boolean generateInterfaces) {
        if (!generateInterfaces) {
            code.append("// meta object is abstract");
            code.append(Utilities.SystemLineSeparator);
            code.append("private boolean isAbstract() {");
            code.append(Utilities.SystemLineSeparator);
            if (mofClass.isAbstract()) {
                code.append("  return true;");
                code.append(Utilities.SystemLineSeparator);
            } else {
                code.append("  return false;");
                code.append(Utilities.SystemLineSeparator);
            }
            code.append("}");
            code.append(Utilities.SystemLineSeparator);
        }
    }

    private void generateCreateTemplate(StringBuffer code, MofClass mofClass, boolean generateInterfaces) {
        if (!(mofClass.isAbstract() || !mofClass.getVisibility().equals(VisibilityKindEnum.PUBLIC_VIS) && generateInterfaces)) {
            HashSet<AttributeWithType> set = new HashSet<AttributeWithType>();
            ArrayList<AttributeWithType> list = new ArrayList<AttributeWithType>();
            mofClass.allSupertypes();
            Iterator iter = Generator.getAllContent((ModelElement)mofClass).iterator();
            while (iter.hasNext()) {
                AttributeWithType awt;
                Attribute atr;
                ModelElement me = (ModelElement)iter.next();
                if (!(me instanceof Attribute) || (atr = (Attribute)me).isDerived() || !atr.getScope().equals(ScopeKindEnum.INSTANCE_LEVEL) || atr.getType() == null || set.contains(awt = new AttributeWithType(Generator.getJMIIdentifier((ModelElement)atr), GeneratorClass.getAttributeType(atr)))) continue;
                set.add(awt);
                list.add(awt);
            }
            code.append("public ");
            code.append(Generator.getJMIIdentifierQualified((Namespace)mofClass));
            code.append(" create");
            code.append(Generator.convertFirstCharToUpper(Generator.getJMIIdentifier((ModelElement)mofClass)));
            code.append("(");
            code.append(") ");
            if (generateInterfaces) {
                code.append(";");
            } else {
                code.append("{ return (");
                code.append(Generator.getJMIIdentifierQualified((Namespace)mofClass));
                code.append(") refCreateInstance(null); }");
            }
            code.append(Utilities.SystemLineSeparator);
            if (list.size() > 0) {
                AttributeWithType awt;
                code.append("public ");
                code.append(Generator.getJMIIdentifierQualified((Namespace)mofClass));
                code.append(" create");
                code.append(Generator.convertFirstCharToUpper(Generator.getJMIIdentifier((ModelElement)mofClass)));
                code.append("(");
                iter = list.iterator();
                while (iter.hasNext()) {
                    awt = (AttributeWithType)iter.next();
                    code.append(awt.getType());
                    code.append(' ');
                    code.append(awt.getName());
                    if (!iter.hasNext()) continue;
                    code.append(", ");
                }
                if (generateInterfaces) {
                    code.append(") throws javax.jmi.reflect.JmiException;");
                } else {
                    code.append(") {");
                    code.append(Utilities.SystemLineSeparator);
                    code.append("   java.util.ArrayList ___list = new java.util.ArrayList(" + set.size() + ");");
                    code.append(Utilities.SystemLineSeparator);
                    iter = list.iterator();
                    while (iter.hasNext()) {
                        awt = (AttributeWithType)iter.next();
                        code.append("   ___list.add(" + Generator.getJavaTypeAsObject(awt.getType(), awt.getName()) + ");");
                        code.append(Utilities.SystemLineSeparator);
                    }
                    code.append("   return (");
                    code.append(Generator.getJMIIdentifierQualified((Namespace)mofClass));
                    code.append(") refCreateInstance(___list);");
                    code.append(Utilities.SystemLineSeparator);
                    code.append("}");
                }
                code.append(Utilities.SystemLineSeparator);
            }
        }
    }

    public static String getAttributeType(Attribute a) {
        String type = null;
        type = Generator.isJavaType(a.getType().getName()) ? (a.getMultiplicity().getLower() == 0 && a.getMultiplicity().getUpper() == 1 ? Generator.getJavaTypeClass(Generator.getType(a.getType(), true)) : (a.getMultiplicity().getLower() == 1 && a.getMultiplicity().getUpper() == 1 ? Generator.getType(a.getType(), true) : (a.getMultiplicity().isOrdered() ? "java.util.List" : "java.util.Collection"))) : (a.getMultiplicity().getLower() == 0 && a.getMultiplicity().getUpper() == 1 ? Generator.getType(a.getType(), true) : (a.getMultiplicity().getLower() == 1 && a.getMultiplicity().getUpper() == 1 ? Generator.getType(a.getType(), true) : (a.getMultiplicity().isOrdered() ? "java.util.List" : "java.util.Collection")));
        return type;
    }
}

