/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.generate.jmi;

import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.generate.jmi.Generator;
import com.sap.tc.logging.Location;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.Feature;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.VisibilityKindEnum;

public class GeneratorAttributeTemplate {
    protected static final transient Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$generate$jmi$GeneratorAttributeTemplate == null ? (class$com$sap$ip$mmr$generate$jmi$GeneratorAttributeTemplate = GeneratorAttributeTemplate.class$("com.sap.ip.mmr.generate.jmi.GeneratorAttributeTemplate")) : class$com$sap$ip$mmr$generate$jmi$GeneratorAttributeTemplate);
    static /* synthetic */ Class class$com$sap$ip$mmr$generate$jmi$GeneratorAttributeTemplate;

    public static String getAccessorName(Attribute attribute) {
        return GeneratorAttributeTemplate.getAccessorName(Generator.getJMIIdentifier((ModelElement)attribute), attribute.getMultiplicity().getUpper(), attribute.getType());
    }

    public static String getAccessorName(String name, int multiplicityUpper, Classifier classifier) {
        String method = "getAccessorName(String name,int multiplicityUpper,Classifier classifier)";
        if (classifier == null) {
            RepositoryServer.getCategory().errorT(location, "getAccessorName(String name,int multiplicityUpper,Classifier classifier)", MMRResourceAccessor.getInstance().getMessageText("2505"), new Object[]{name});
            return "";
        }
        String accessorName = null;
        String attributeName = Generator.convertFirstCharToUpper(name);
        if (multiplicityUpper == 1) {
            if (classifier.getName().compareToIgnoreCase("BOOLEAN") == 0) {
                accessorName = Generator.convertFirstCharToLower(attributeName);
                if (accessorName.substring(0, 2).compareToIgnoreCase("is") != 0) {
                    accessorName = "is" + Generator.convertFirstCharToUpper(accessorName);
                }
            } else {
                accessorName = "get" + attributeName;
            }
        } else {
            accessorName = "get" + attributeName;
        }
        return accessorName;
    }

    public void generateTemplate(StringBuffer code, Attribute attribute, boolean noJavaDocs, boolean generateInterfaces) {
        if (attribute == null || attribute.getType() == null || attribute.getType().getName() == null) {
            return;
        }
        if (generateInterfaces && !attribute.getVisibility().equals(VisibilityKindEnum.PUBLIC_VIS)) {
            return;
        }
        String attributeName = Generator.convertFirstCharToUpper(Generator.getJMIIdentifier((ModelElement)attribute));
        String variableName = Generator.composeVariableName(attributeName, false);
        String accessorName = null;
        if (attribute.getMultiplicity().getUpper() == 1) {
            if (attribute.getType().getName().compareToIgnoreCase("BOOLEAN") == 0) {
                accessorName = Generator.convertFirstCharToLower(attributeName);
                if (accessorName.substring(0, 2).compareToIgnoreCase("is") != 0) {
                    accessorName = "is" + Generator.convertFirstCharToUpper(accessorName);
                }
            } else {
                accessorName = "get" + attributeName;
            }
        } else {
            accessorName = "get" + attributeName;
        }
        String mutatorName = null;
        if (attribute.getMultiplicity().getUpper() == 1) {
            mutatorName = attribute.getType().getName().compareToIgnoreCase("BOOLEAN") == 0 ? (attributeName.substring(0, 2).compareToIgnoreCase("is") == 0 ? "set" + Generator.convertFirstCharToUpper(attributeName.substring(2)) : "set" + attributeName) : "set" + attributeName;
        }
        String typeOfAttribute = Generator.getAttributeType(attribute, true);
        if (!generateInterfaces) {
            code.append("private ");
            code.append(typeOfAttribute);
            code.append(' ');
            code.append(variableName);
            if (attribute.getMultiplicity().getUpper() > 1 || attribute.getMultiplicity().getUpper() < 0) {
                code.append(" = new com.sap.ip.mmr.m1layer.AttributeMultipleValues(new com.sap.ip.mmr.m2layer.model.MultiplicityTypeImpl(" + attribute.getMultiplicity().getLower() + "," + attribute.getMultiplicity().getUpper() + "," + attribute.getMultiplicity().isOrdered() + "," + attribute.getMultiplicity().isUnique() + ")," + !attribute.isChangeable() + ",this)");
            } else if (attribute.getMultiplicity().getLower() == 0 && attribute.getMultiplicity().getUpper() == 1) {
                code.append(" = null");
            } else if (attribute.getMultiplicity().getLower() == 1 && attribute.getMultiplicity().getUpper() == 1 && Generator.isJavaType(typeOfAttribute)) {
                code.append(" = " + Generator.getJavaReturnInitialValueByType(typeOfAttribute));
            }
            code.append(";");
            code.append(Utilities.SystemLineSeparator);
        }
        if (attribute.getMultiplicity().getUpper() == 1) {
            if (attribute.getMultiplicity().getLower() == 0) {
                this.addAccessorTemplate(code, attribute, variableName, typeOfAttribute, accessorName, generateInterfaces);
            } else {
                this.addAccessorTemplate(code, attribute, variableName, typeOfAttribute, accessorName, generateInterfaces);
            }
        } else if (!attribute.getMultiplicity().isOrdered()) {
            this.addAccessorTemplate(code, attribute, variableName, typeOfAttribute, accessorName, generateInterfaces);
        } else {
            this.addAccessorTemplate(code, attribute, variableName, typeOfAttribute, accessorName, generateInterfaces);
        }
        if (attribute.isChangeable() && attribute.getMultiplicity().getUpper() == 1) {
            this.addMutatorSingleTemplate(code, attribute, variableName, typeOfAttribute, mutatorName, generateInterfaces);
        }
    }

    private void addAccessorTemplate(StringBuffer code, Attribute attribute, String variableName, String attributeType, String accessorName, boolean generateInterfaces) {
        if (!generateInterfaces || attribute.getVisibility().equals(VisibilityKindEnum.PUBLIC_VIS)) {
            Generator.generateAnnotationTemplate(code, (ModelElement)attribute);
            code.append(Generator.mapVisibilityToJava((Feature)attribute));
            code.append(' ');
            code.append(attributeType);
            code.append(' ');
            code.append(accessorName);
            code.append(' ');
            if (generateInterfaces) {
                code.append("() throws javax.jmi.reflect.JmiException;");
            } else {
                code.append("() { return ");
                code.append(variableName);
                code.append("; }");
            }
            code.append(Utilities.SystemLineSeparator);
        }
    }

    private void addMutatorSingleTemplate(StringBuffer code, Attribute attribute, String variableName, String attributeType, String mutatorName, boolean generateInterfaces) {
        if (!generateInterfaces || attribute.getVisibility().equals(VisibilityKindEnum.PUBLIC_VIS)) {
            Generator.generateAnnotationTemplate(code, (ModelElement)attribute);
            code.append(Generator.mapVisibilityToJava((Feature)attribute));
            code.append(" void ");
            code.append(mutatorName);
            code.append(" (");
            code.append(attributeType);
            code.append(" newValue) ");
            if (generateInterfaces) {
                code.append("throws javax.jmi.reflect.JmiException;");
            } else {
                String type;
                code.append("{");
                code.append(Utilities.SystemLineSeparator);
                if (attribute.getType() instanceof MofClass && !Generator.isJavaType(type = Generator.getType(attribute.getType(), true)) && type.compareTo("java.lang.String") != 0) {
                    code.append("  if (newValue != null) {");
                    code.append(Utilities.SystemLineSeparator);
                    code.append("    if (((javax.jmi.reflect.RefObject)newValue).refImmediateComposite() != null && ((javax.jmi.reflect.RefObject)newValue).refImmediateComposite() != this) {");
                    code.append(Utilities.SystemLineSeparator);
                    code.append("      throw new javax.jmi.reflect.CompositionViolationException(newValue,null);");
                    code.append(Utilities.SystemLineSeparator);
                    code.append("    } else {");
                    code.append(Utilities.SystemLineSeparator);
                    code.append("       ((com.sap.ip.mmr.m1layer.IMMRObject)newValue).set___ImmediateComposite(this);");
                    code.append(Utilities.SystemLineSeparator);
                    code.append("    }");
                    code.append(Utilities.SystemLineSeparator);
                    code.append("  }");
                    code.append(Utilities.SystemLineSeparator);
                }
                code.append(variableName);
                code.append(" = newValue; set___State(com.sap.ip.mmr.StateEnum.STATE_CHANGED);");
                code.append(Utilities.SystemLineSeparator);
                code.append("}");
            }
            code.append(Utilities.SystemLineSeparator);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

