/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.foundation;

import com.sap.ip.mmr.ITask;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.TaskProxy;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TasksManager {
    private Set tasks = new HashSet();
    protected static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$foundation$TasksManager == null ? (class$com$sap$ip$mmr$foundation$TasksManager = TasksManager.class$("com.sap.ip.mmr.foundation.TasksManager")) : class$com$sap$ip$mmr$foundation$TasksManager);
    static /* synthetic */ Class class$com$sap$ip$mmr$foundation$TasksManager;

    public boolean register(ITask persistenceTask) {
        this.tasks.add(persistenceTask);
        return true;
    }

    public boolean deregister(ITask persistenceTask) {
        this.tasks.remove(persistenceTask);
        return true;
    }

    public Iterator iterator() {
        return new TaskToRunIterator(this);
    }

    protected Set getTasks() {
        return this.tasks;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class TaskToRunIterator
    implements Iterator {
        List taskProxies = new ArrayList();
        List tasksToRun = new ArrayList();

        public TaskToRunIterator(TasksManager tm) {
            Iterator iter = tm.getTasks().iterator();
            while (iter.hasNext()) {
                ITask task = (ITask)iter.next();
                TaskProxy tp = new TaskProxy(task);
                tp.setFinished(false);
                this.taskProxies.add(tp);
            }
            this.tasksToRun.addAll(this.taskProxies);
            Collections.sort(this.taskProxies);
        }

        public boolean hasNext() {
            return this.tasksToRun.size() > 0;
        }

        public Object next() {
            if (this.tasksToRun.size() <= 0) {
                return null;
            }
            TaskProxy tpFound = null;
            Iterator iter = this.tasksToRun.iterator();
            while (iter.hasNext() && tpFound == null) {
                TaskProxy tp = (TaskProxy)iter.next();
                if (!this.isReady(tp)) continue;
                tpFound = tp;
                iter.remove();
            }
            if (tpFound != null) {
                tpFound.setFinished(true);
                return tpFound.getTask();
            }
            return null;
        }

        public boolean isReady(TaskProxy taskProxy) {
            String method = "isReady(TaskProxy taskProxy)";
            boolean ready = true;
            Collection col = taskProxy.getTask().getTasksDependsOn();
            if (col != null) {
                Iterator iter = col.iterator();
                while (iter.hasNext() && ready) {
                    ITask pt = (ITask)iter.next();
                    TaskProxy tp = this.findTaskProxy(pt);
                    if (tp == null) {
                        RepositoryServer.getCategory().errorT(location, "isReady(TaskProxy taskProxy)", MMRResourceAccessor.getInstance().getMessageText("1030"), new Object[]{pt});
                        continue;
                    }
                    if (tp.isFinished()) continue;
                    ready = false;
                }
            }
            return ready;
        }

        public TaskProxy findTaskProxy(ITask task) {
            int index = Collections.binarySearch(this.taskProxies, task);
            if (index >= 0) {
                return (TaskProxy)this.taskProxies.get(index);
            }
            return null;
        }

        public void remove() {
            String method = "remove()";
            RepositoryServer.getCategory().errorT(location, "remove()", MMRResourceAccessor.getInstance().getMessageText("0000"));
        }
    }
}

