/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.foundation;

import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.foundation.ClassLoaderFactory;
import com.sap.ip.mmr.foundation.HierarchyNode;
import com.sap.ip.mmr.foundation.HierarchyNodeObject;
import com.sap.ip.mmr.foundation.HierarchyNodeRoot;
import com.sap.ip.mmr.foundation.HierarchyNodeText;
import com.sap.ip.mmr.foundation.IHierarchyNode;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.jmi.model.ModelElement;
import javax.jmi.reflect.RefBaseObject;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Hierarchy
implements Serializable {
    static final long serialVersionUID = 476288566182468264L;
    protected static final transient Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$foundation$Hierarchy == null ? (class$com$sap$ip$mmr$foundation$Hierarchy = Hierarchy.class$("com.sap.ip.mmr.foundation.Hierarchy")) : class$com$sap$ip$mmr$foundation$Hierarchy);
    public static final String HIERARCHY = "hierarchy";
    public static final String MOFID = "mofId";
    public static final String NAME = "name";
    public static final String LASTCHANGED = "lastChanged";
    public static final String MOFLAYER = "MOFLayer";
    public static final String NODE = "node";
    public static final String NODE_ROOT = "nodeRoot";
    public static final String NODE_TEXT = "nodeText";
    public static final String NODE_OBJECT = "nodeObject";
    public static final String DESCRIPTION = "description";
    public static final String TEXT = "text";
    public static final String LOCALE_LANGUAGE = "localeLanguage";
    public static final String LOCALE_COUNTRY = "localeCountry";
    public static final String LOCALE_VARIANT = "localeVariant";
    private String mofId;
    private String name;
    private int mofLayer;
    private String lastChanged;
    private HierarchyNodeRoot root;
    private transient IRepository repository;
    private transient boolean changed = true;
    static /* synthetic */ Class class$com$sap$ip$mmr$foundation$Hierarchy;

    public Hierarchy(IRepository repository, int mofLayer, String name) {
        this.repository = repository;
        this.mofLayer = mofLayer;
        this.name = name;
        this.mofId = Repository.createMofId();
        this.lastChanged = Utilities.getUtilities().getTimeSAPInternalFormat();
    }

    public HierarchyNodeText createNodeText(String name, String text) {
        HierarchyNodeText node = new HierarchyNodeText(name);
        node.addDescription(Locale.getDefault(), text);
        return node;
    }

    public HierarchyNodeText createNodeText(String name, Locale locale, String text) {
        HierarchyNodeText node = new HierarchyNodeText(name);
        node.addDescription(locale, text);
        return node;
    }

    public HierarchyNodeObject createNodeObject(String name, RefBaseObject refBaseObject) {
        HierarchyNodeObject node = new HierarchyNodeObject(name, refBaseObject);
        return node;
    }

    public List findNodes(String mofId) {
        LinkedList<IHierarchyNode> list = new LinkedList<IHierarchyNode>();
        Iterator iter = this.getNodes().iterator();
        while (iter.hasNext()) {
            IHierarchyNode node = (IHierarchyNode)iter.next();
            if (!Utilities.getUtilities().containsPattern(node.getMofId(), mofId)) continue;
            list.add(node);
        }
        return list;
    }

    public List findNodesByName(String name) {
        LinkedList<IHierarchyNode> list = new LinkedList<IHierarchyNode>();
        Iterator iter = this.getNodes().iterator();
        while (iter.hasNext()) {
            IHierarchyNode node = (IHierarchyNode)iter.next();
            if (!Utilities.getUtilities().containsPattern(node.getName(), name)) continue;
            list.add(node);
        }
        return list;
    }

    public List findNodesByDescription(Locale locale, String description) {
        LinkedList<HierarchyNode> list = new LinkedList<HierarchyNode>();
        Iterator iter = this.getNodes().iterator();
        while (iter.hasNext()) {
            HierarchyNodeObject no;
            IHierarchyNode node = (IHierarchyNode)iter.next();
            if (node instanceof HierarchyNodeText) {
                HierarchyNodeText nt = (HierarchyNodeText)node;
                if (!Utilities.getUtilities().containsPattern(nt.getDescription(), description)) continue;
                list.add(nt);
                continue;
            }
            if (!(node instanceof HierarchyNodeObject) || (no = (HierarchyNodeObject)node).getRefBaseObject() == null || !(no.getRefBaseObject() instanceof ModelElement) || !Utilities.getUtilities().containsPattern(((ModelElement)no.getRefBaseObject()).getAnnotation(), description)) continue;
            list.add(no);
        }
        return list;
    }

    protected List getNodes() {
        LinkedList list = new LinkedList();
        this.getNodesRecursive(this.getRoot(), list);
        return list;
    }

    protected void getNodesRecursive(IHierarchyNode parent, List list) {
        IHierarchyNode node;
        Iterator iter = parent.iterator();
        while (iter.hasNext()) {
            node = (IHierarchyNode)iter.next();
            list.add(node);
        }
        iter = parent.iterator();
        while (iter.hasNext()) {
            node = (IHierarchyNode)iter.next();
            this.getNodesRecursive(node, list);
        }
    }

    public String getName() {
        return this.name;
    }

    public void clear() {
        this.getRoot().removeAllChildren();
    }

    public IHierarchyNode getRoot() {
        if (this.root == null) {
            this.root = new HierarchyNodeRoot(this, "root");
        }
        return this.root;
    }

    public void setRoot(HierarchyNodeRoot root) {
        this.setChanged(true, false);
        this.root = root;
    }

    public RefBaseObject getRefBaseObject(String mofId) {
        return this.repository.select(this.mofLayer, mofId, false);
    }

    public String writeXML() {
        StringBuffer b = new StringBuffer(2048);
        b.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        b.append('<');
        b.append(HIERARCHY);
        b.append(' ');
        b.append(MOFID);
        b.append("=\"");
        b.append(this.getMofId());
        b.append("\" ");
        b.append(MOFLAYER);
        b.append("=\"");
        b.append(this.mofLayer);
        b.append("\" ");
        b.append(NAME);
        b.append("=\"");
        b.append(this.name);
        b.append("\" ");
        b.append(LASTCHANGED);
        b.append("=\"");
        b.append(this.lastChanged);
        b.append("\"");
        b.append('>');
        this.getRoot().writeXMLTagStart(b);
        this.getRoot().writeXMLTagContent(b);
        this.getRoot().writeXMLTagEnd(b);
        b.append("</");
        b.append(HIERARCHY);
        b.append('>');
        return b.toString();
    }

    public static Hierarchy readXML(IRepository repository, byte[] xml) {
        Hierarchy h = null;
        if (xml == null) {
            return h;
        }
        if (xml.length < 1) {
            return h;
        }
        try {
            MySAXHandler mySAXHandler = new MySAXHandler(repository);
            SAXParser saxParser = ClassLoaderFactory.getClassLoaderFactory().getSAXParser(repository, repository.getConnection());
            saxParser.parse((InputStream)new ByteArrayInputStream(xml), (DefaultHandler)mySAXHandler);
            h = mySAXHandler.getHierarchy();
        }
        catch (Exception e) {
            Repository.category.errorT(location, e.toString());
        }
        return h;
    }

    public int getMofLayer() {
        return this.mofLayer;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Hierarchy: " + this.getName() + " (MOF layer: " + this.getMofLayer() + ")");
        b.append('\n');
        b.append(this.getRoot().toString(1));
        return b.toString();
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public void setRepository(IRepository repository) {
        this.repository = repository;
    }

    public String getMofId() {
        return this.mofId;
    }

    public void setMofId(String mofId) {
        this.mofId = mofId;
    }

    public String getLastChanged() {
        return this.lastChanged;
    }

    public void setLastChanged(String lastChanged) {
        this.lastChanged = lastChanged;
    }

    public boolean isChanged() {
        if (this.changed) {
            return true;
        }
        return this.getRoot().isChanged();
    }

    public void setChanged(boolean changed, boolean deep) {
        this.changed = changed;
        if (deep) {
            this.getRoot().setChanged(changed, deep);
        }
    }

    public void setName(String name) {
        this.setChanged(true, false);
        this.name = name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class MySAXHandler
    extends DefaultHandler {
        IRepository repository;
        Hierarchy hierarchy;
        IHierarchyNode nodeParent;
        HierarchyNodeText nodeText;
        Locale locale;

        public MySAXHandler(IRepository repository) {
            this.repository = repository;
        }

        public Hierarchy getHierarchy() {
            return this.hierarchy;
        }

        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
            if (sName.compareTo(Hierarchy.NODE_OBJECT) == 0) {
                String mofId = attrs.getValue(Hierarchy.MOFID);
                String name = attrs.getValue(Hierarchy.NAME);
                HierarchyNodeObject n = new HierarchyNodeObject(name);
                n.setMofId(mofId);
                n.setParent(this.nodeParent);
                this.nodeParent = n;
            } else if (sName.compareTo(Hierarchy.NODE_TEXT) == 0) {
                String mofId = attrs.getValue(Hierarchy.MOFID);
                String name = attrs.getValue(Hierarchy.NAME);
                this.nodeText = new HierarchyNodeText(name);
                this.nodeText.setMofId(mofId);
                this.nodeText.setParent(this.nodeParent);
                this.nodeParent = this.nodeText;
            } else if (sName.compareTo(Hierarchy.DESCRIPTION) == 0) {
                String language = attrs.getValue(Hierarchy.LOCALE_LANGUAGE);
                String country = attrs.getValue(Hierarchy.LOCALE_COUNTRY);
                String variant = attrs.getValue(Hierarchy.LOCALE_VARIANT);
                this.locale = variant != null ? new Locale(language, country, variant) : (country != null ? new Locale(language, country) : (language != null ? new Locale(language, "") : Locale.getDefault()));
                String text = attrs.getValue(Hierarchy.TEXT);
                if (this.nodeText != null) {
                    this.nodeText.addDescription(this.locale, text);
                }
            } else if (sName.compareTo(Hierarchy.NODE_ROOT) == 0) {
                String mofId = attrs.getValue(Hierarchy.MOFID);
                String name = attrs.getValue(Hierarchy.NAME);
                HierarchyNodeRoot n = new HierarchyNodeRoot(this.hierarchy, name);
                n.setMofId(mofId);
                this.hierarchy.setRoot(n);
                this.nodeParent = n;
            } else if (sName.compareTo(Hierarchy.NODE) == 0) {
                String mofId = attrs.getValue(Hierarchy.MOFID);
                String name = attrs.getValue(Hierarchy.NAME);
                HierarchyNode n = new HierarchyNode(name);
                n.setMofId(mofId);
                n.setParent(this.nodeParent);
                this.nodeParent = n;
            } else if (sName.compareTo(Hierarchy.HIERARCHY) == 0) {
                String mofId = attrs.getValue(Hierarchy.MOFID);
                String mofLayerStr = attrs.getValue(Hierarchy.MOFLAYER);
                String lastChanged = attrs.getValue(Hierarchy.LASTCHANGED);
                int mofLayer = 1;
                if (mofLayerStr != null && mofLayerStr.length() > 0) {
                    mofLayer = Integer.parseInt(mofLayerStr);
                }
                String name = attrs.getValue(Hierarchy.NAME);
                this.hierarchy = new Hierarchy(this.repository, mofLayer, name);
                this.hierarchy.setMofId(mofId);
                this.hierarchy.setLastChanged(lastChanged);
            }
        }

        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            if (sName.compareTo(Hierarchy.NODE_OBJECT) == 0 || sName.compareTo(Hierarchy.NODE_TEXT) == 0 || sName.compareTo(Hierarchy.NODE_ROOT) == 0) {
                this.nodeParent = this.nodeParent.getParent();
            }
        }

        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            if (this.nodeText != null) {
                this.nodeText.addDescription(this.locale, new String(arg0, arg1, arg2).trim());
            }
        }
    }
}

