/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr;

import com.sap.exception.BaseException;
import com.sap.exception.BaseRuntimeException;
import com.sap.ip.mmr.Configuration;
import com.sap.ip.mmr.ConnectionFactory;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.IPersistence;
import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.IRepositoryDB;
import com.sap.ip.mmr.IRepositoryServer;
import com.sap.ip.mmr.ITask;
import com.sap.ip.mmr.PersistenceDescription;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.dbmemory.Cache;
import com.sap.ip.mmr.dbmodel.Table;
import com.sap.ip.mmr.foundation.Association;
import com.sap.ip.mmr.foundation.AssociationsOfObject;
import com.sap.ip.mmr.foundation.ClassLoaderFactory;
import com.sap.ip.mmr.foundation.FileContent;
import com.sap.ip.mmr.foundation.HashMapBidirectional;
import com.sap.ip.mmr.foundation.Hierarchy;
import com.sap.ip.mmr.foundation.JavaSource;
import com.sap.ip.mmr.foundation.ListInstanceInfo;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.ThreadInformation;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.fs.IRepositoryFS;
import com.sap.ip.mmr.fs.RepositoryFS;
import com.sap.ip.mmr.generate.javamodel.IJavaElement;
import com.sap.ip.mmr.jdo.JDODescriptor;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m1layer.Instantiator;
import com.sap.ip.mmr.m1layer.MMRObject;
import com.sap.ip.mmr.m2layer.IModelElement;
import com.sap.ip.mmr.m2layer.model.GeneralizableElementImpl;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import com.sap.ip.mmr.m2layer.model.MofClassImpl;
import com.sap.ip.mmr.m2layer.model.MofPackageImpl;
import com.sap.ip.mmr.persistence.PersistenceFSMultiWS;
import com.sap.ip.mmr.persistence.PersistenceJarMulti;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.search.QueryFilters;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.jmi.model.ModelElement;
import javax.jmi.model.VisibilityKind;
import javax.jmi.model.VisibilityKindEnum;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class RepositoryServer
implements IRepositoryServer {
    public static final Category category = Category.getCategory((Category)Category.APPLICATIONS, (String)"/MMR");
    protected static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$RepositoryServer == null ? (class$com$sap$ip$mmr$RepositoryServer = RepositoryServer.class$("com.sap.ip.mmr.RepositoryServer")) : class$com$sap$ip$mmr$RepositoryServer);
    private static final int USE_PC_FS = 1;
    private static final int USE_PC_DB = 2;
    private static final int USE_PC_JAR = 4;
    private static final int USE_OPTIONAL = 8;
    private static final int USE_PC = 15;
    private static IRepositoryServer repositoryServer;
    private static IRepositoryFS repositoryFS;
    private static Configuration configuration;
    private int dbType = -1;
    private IPersistence repositoryDB;
    private Map cacheM2 = new HashMap();
    private Map cacheM2Assoc = new HashMap();
    private Map cacheM1 = new HashMap();
    private Map cacheM1Assoc = new HashMap();
    private Map qualifiedNamesMap = new HashMap();
    private List pcsM2 = new ArrayList();
    private List pcsM1 = new ArrayList();
    private MofPackageImpl topLevelMofPackageM2;
    private Collection commitedModelElements = new LinkedList();
    private Collection commitedObjects = new LinkedList();
    private Collection deletedModelElements = new LinkedList();
    private Collection deletedObjects = new LinkedList();
    private long timeToLive = 3153600000000L;
    private static final long timeToLiveServer = 300L;
    private long timeLastDeployment;
    private Context jndiInitialContext;
    private Properties properties;
    private Map transactionControllers = new HashMap();
    private String timeOfCreation = Utilities.getUtilities().getTimeSAPInternalFormat();
    private static Map threads;
    private Instantiator instantiatorM1;
    private boolean initialized = false;
    private boolean finalized = false;
    private ThreadGC threadGC;
    static /* synthetic */ Class class$com$sap$ip$mmr$RepositoryServer;
    static /* synthetic */ Class class$com$sap$ip$mmr$IRepositoryServer;
    static /* synthetic */ Class class$com$sap$ip$mmr$IRepository;

    protected RepositoryServer() {
    }

    public static Category getCategory() {
        return category;
    }

    public void addLog(Log log) {
        if (log != null) {
            PersistenceComponent pc;
            this.removeLog(log);
            RepositoryServer.getCategory().addLog(log);
            RepositoryServer.getCategory().setEffectiveSeverity(log.getEffectiveSeverity());
            Iterator iter = this.pcsM2.iterator();
            while (iter.hasNext()) {
                pc = (PersistenceComponent)iter.next();
                pc.getComponent().addLog(log);
            }
            iter = this.pcsM1.iterator();
            while (iter.hasNext()) {
                pc = (PersistenceComponent)iter.next();
                pc.getComponent().addLog(log);
            }
        }
    }

    public void removeLog(Log log) {
        String method = "removeLog(Log log)";
        if (log != null) {
            PersistenceComponent pc;
            try {
                RepositoryServer.getCategory().removeLog(log);
            }
            catch (Exception e) {
                if (e instanceof BaseException) {
                    ((BaseException)((Object)e)).log();
                }
                category.error(location, "removeLog(Log log)", (Object)MMRResourceAccessor.getInstance().getMessageText("0003"), new Object[]{e.toString()});
            }
            Iterator iter = this.pcsM2.iterator();
            while (iter.hasNext()) {
                pc = (PersistenceComponent)iter.next();
                pc.getComponent().removeLog(log);
            }
            iter = this.pcsM1.iterator();
            while (iter.hasNext()) {
                pc = (PersistenceComponent)iter.next();
                pc.getComponent().removeLog(log);
            }
        }
    }

    private static void writeExceptionToCategory(String method, Exception e) {
        category.errorT(location, method, e.toString());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        e.printStackTrace(ps);
        category.errorT(location, method, baos.toString());
    }

    private static void writeErrorToCategory(String method, Error e) {
        category.errorT(location, method, e.toString());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        e.printStackTrace(ps);
        category.errorT(location, method, baos.toString());
    }

    private static String getMethodNamePc(PersistenceComponent pc, String method) {
        return pc.getComponent().getClass().getName() + "::" + method;
    }

    protected TransactionController getTransactionController(IConnection con) {
        if (con == null) {
            return null;
        }
        TransactionController tc = (TransactionController)this.transactionControllers.get(con.getConnectionId());
        if (tc == null) {
            tc = new TransactionController(con);
            this.transactionControllers.put(con.getConnectionId(), tc);
        }
        return tc;
    }

    protected synchronized Cache getCacheM2(String workspace) {
        Cache cache = (Cache)this.cacheM2.get(workspace);
        if (cache == null) {
            cache = new Cache(65536, this.timeToLive);
            this.cacheM2.put(workspace, cache);
        }
        return cache;
    }

    protected synchronized Cache getCacheM2Assoc(String workspace) {
        Cache cache = (Cache)this.cacheM2Assoc.get(workspace);
        if (cache == null) {
            cache = new Cache(65536);
            this.cacheM2Assoc.put(workspace, cache);
        }
        return cache;
    }

    protected synchronized Cache getCacheM1(String workspace) {
        Cache cache = (Cache)this.cacheM1.get(workspace);
        if (cache == null) {
            cache = new Cache(65536, this.timeToLive);
            this.cacheM1.put(workspace, cache);
        }
        return cache;
    }

    protected synchronized Cache getCacheM1Assoc(String workspace) {
        Cache cache = (Cache)this.cacheM1Assoc.get(workspace);
        if (cache == null) {
            cache = new Cache(65536);
            this.cacheM1Assoc.put(workspace, cache);
        }
        return cache;
    }

    public static IRepositoryServer getRepositoryServer() {
        String method = "getRepositoryServer()";
        location.entering("getRepositoryServer()");
        if (repositoryServer != null && repositoryServer.isFinalized()) {
            repositoryServer = null;
        }
        if (repositoryServer == null) {
            repositoryServer = new RepositoryServer();
            try {
                repositoryServer.initialize();
            }
            catch (BaseRuntimeException e) {
                e.log();
                repositoryServer = null;
            }
            catch (BaseException e) {
                e.log();
                repositoryServer = null;
            }
        }
        location.exiting("getRepositoryServer()");
        return repositoryServer;
    }

    public static Configuration getConfiguration() {
        if (configuration == null) {
            configuration = new Configuration();
        }
        return configuration;
    }

    public static IRepositoryFS getRepositoryFS() {
        if (repositoryFS == null) {
            repositoryFS = new RepositoryFS(RepositoryServer.getRepositoryServer(), RepositoryServer.getConfiguration());
        }
        return repositoryFS;
    }

    public synchronized void finalizer() {
        String method = "finalizer";
        location.entering(method);
        HashSet pcs = new HashSet();
        pcs.addAll(this.pcsM1);
        pcs.addAll(this.pcsM2);
        Iterator iter = pcs.iterator();
        while (iter.hasNext()) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            try {
                pc.getComponent().finalizer();
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
        }
        repositoryServer.setFinalized(true);
        this.cacheM2.clear();
        this.cacheM2Assoc.clear();
        this.cacheM1.clear();
        this.cacheM1Assoc.clear();
        this.qualifiedNamesMap.clear();
        this.commitedModelElements.clear();
        this.commitedObjects.clear();
        this.deletedModelElements.clear();
        this.deletedObjects.clear();
        this.topLevelMofPackageM2 = null;
        if (this.threadGC != null) {
            this.threadGC.setRepositoryServer(null);
            this.threadGC = null;
        }
        location.exiting();
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public void setFinalized(boolean newValue) {
        this.finalized = newValue;
    }

    public void connectionClosed(IConnection connection) {
        PersistenceComponent pc;
        if (connection == null) {
            return;
        }
        List l = this.getPCsOfConnection(2, true, connection);
        if (l == null) {
            return;
        }
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            pc = (PersistenceComponent)iter.next();
            try {
                pc.getComponent().connectionClosed(connection);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
        }
        iter = this.getPCsOfConnection(1, true, connection).iterator();
        while (iter.hasNext()) {
            pc = (PersistenceComponent)iter.next();
            try {
                pc.getComponent().connectionClosed(connection);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
        }
        ClassLoaderFactory.getClassLoaderFactory().removeClassLoader(connection);
        this.transactionControllers.remove(connection.getConnectionId());
        this.garbageCollector();
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    protected synchronized void garbageCollector() {
        Cache ca;
        Collection col;
        Cache c;
        String workspace;
        Iterator iter = this.cacheM2.keySet().iterator();
        while (iter.hasNext()) {
            workspace = (String)iter.next();
            c = this.getCacheM2(workspace);
            col = c.garbageCollector();
            if (col.size() <= 0) continue;
            ca = this.getCacheM2Assoc(workspace);
            ca.remove(col);
        }
        iter = this.cacheM1.keySet().iterator();
        while (iter.hasNext()) {
            workspace = (String)iter.next();
            c = this.getCacheM1(workspace);
            col = c.garbageCollector();
            if (col.size() <= 0) continue;
            ca = this.getCacheM1Assoc(workspace);
            ca.remove(col);
        }
    }

    public synchronized void clearCaches() {
        Cache c;
        Iterator iter = this.cacheM2.values().iterator();
        while (iter.hasNext()) {
            c = (Cache)iter.next();
            c.clear();
        }
        iter = this.cacheM2Assoc.values().iterator();
        while (iter.hasNext()) {
            c = (Cache)iter.next();
            c.clear();
        }
        iter = this.cacheM1.values().iterator();
        while (iter.hasNext()) {
            c = (Cache)iter.next();
            c.clear();
        }
        iter = this.cacheM1Assoc.values().iterator();
        while (iter.hasNext()) {
            c = (Cache)iter.next();
            c.clear();
        }
    }

    public boolean transactionBegin(IConnection connection) {
        if (connection != null) {
            this.getTransactionController(connection).transactionBegin(1);
            this.getTransactionController(connection).transactionBegin(2);
        }
        return true;
    }

    public boolean transactionBeforeCommit(IConnection connection, Collection modelElementsInsert, Map modelElementsAssocInsert, Collection modelElementsDelete, Collection objectInsert, Map objectAssocInsert, Collection objectsDelete) throws BaseException, BaseRuntimeException {
        boolean res = true;
        if (connection != null) {
            res = this.getTransactionController(connection).transactionBeforeCommit(1, modelElementsInsert, modelElementsAssocInsert, modelElementsDelete, objectInsert, objectAssocInsert, objectsDelete);
        }
        return res;
    }

    public boolean transactionCommit(IConnection connection) {
        if (connection != null) {
            this.getTransactionController(connection).transactionCommit(1);
            this.getTransactionController(connection).transactionCommit(2);
        }
        this.commitedModelElements.clear();
        this.commitedObjects.clear();
        this.deletedModelElements.clear();
        this.deletedObjects.clear();
        return true;
    }

    public boolean transactionRollback(IConnection connection) {
        if (connection != null) {
            this.getTransactionController(connection).transactionRollback(1);
            this.getTransactionController(connection).transactionRollback(2);
        }
        return true;
    }

    public RefObject selectM3(IConnection connection, String mofId) {
        return null;
    }

    public AssociationsOfObject selectM3Assoc(IConnection connection, String associationId, String mofId) {
        return null;
    }

    public RefObject selectM3ByName(IConnection connection, String qualifiedName) {
        return null;
    }

    public Collection deleteM2(IConnection connection, Collection modelElements) {
        LinkedList colFailed = null;
        if (modelElements == null || modelElements.size() <= 0) {
            return colFailed;
        }
        String method = "deleteM2";
        location.entering(method);
        Iterator iWs = connection.getConnectionSpec().getWorkspacesM2().iterator();
        while (iWs.hasNext()) {
            Workspace w = (Workspace)iWs.next();
            if (w.isReadOnly()) continue;
            Cache cache = this.getCacheM2(w.getName());
            Iterator iter = modelElements.iterator();
            while (iter.hasNext()) {
                ModelElement me = (ModelElement)iter.next();
                cache.remove(me.refMofId());
            }
        }
        Iterator iter = this.getPCsOfConnection(2, true, connection).iterator();
        while (iter.hasNext()) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            Collection c = null;
            try {
                c = pc.getComponent().deleteM2(connection, modelElements);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
            if (c == null) continue;
            if (colFailed == null) {
                colFailed = new LinkedList();
            }
            colFailed.addAll(c);
        }
        if (modelElements != null) {
            this.deletedModelElements.addAll(modelElements);
        }
        location.exiting();
        return colFailed;
    }

    public boolean deleteM2Assoc(IConnection connection, Collection mofIds) {
        if (mofIds == null || mofIds.size() <= 0) {
            return true;
        }
        String method = "deleteM2Assoc";
        location.entering(method);
        Iterator iWs = connection.getConnectionSpec().getWorkspacesM2().iterator();
        while (iWs.hasNext()) {
            Workspace w = (Workspace)iWs.next();
            if (w.isReadOnly()) continue;
            Cache cache = this.getCacheM2Assoc(w.getName());
            Iterator iter = mofIds.iterator();
            while (iter.hasNext()) {
                String mofId = (String)iter.next();
                cache.remove(mofId);
            }
        }
        boolean flag = true;
        Iterator iter = this.getPCsOfConnection(2, true, connection).iterator();
        while (iter.hasNext() && flag) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            try {
                flag = pc.getComponent().deleteM2Assoc(connection, mofIds);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
            if (flag) continue;
            category.errorT(location, method, MMRResourceAccessor.getInstance().getMessageText(connection, "1013"), new Object[]{pc.getComponent()});
        }
        location.exiting();
        return flag;
    }

    public void deleteM2All(IConnection connection) {
        if (connection != null) {
            Iterator iWs = connection.getConnectionSpec().getWorkspacesM2().iterator();
            while (iWs.hasNext()) {
                Workspace w = (Workspace)iWs.next();
                if (w.isReadOnly()) continue;
                this.getCacheM2(w.getName()).clear();
                this.getCacheM2Assoc(w.getName()).clear();
            }
        }
        this.topLevelMofPackageM2 = null;
        this.commitedModelElements.clear();
        this.deletedModelElements.clear();
        Iterator iter = this.getPCsOfConnection(2, true, connection).iterator();
        while (iter.hasNext()) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            try {
                pc.getComponent().deleteM2All(connection);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
        }
    }

    public void deleteM1All(IConnection connection) {
        if (connection != null) {
            Iterator iWs = connection.getConnectionSpec().getWorkspacesM1().iterator();
            while (iWs.hasNext()) {
                Workspace w = (Workspace)iWs.next();
                if (w.isReadOnly()) continue;
                this.getCacheM1(w.getName()).clear();
                this.getCacheM1Assoc(w.getName()).clear();
            }
        }
        this.commitedObjects.clear();
        this.deletedObjects.clear();
        Iterator iter = this.getPCsOfConnection(1, true, connection).iterator();
        while (iter.hasNext()) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            try {
                pc.getComponent().deleteM1All(connection);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
        }
    }

    public Collection insertM2(IConnection connection, Collection modelElements) {
        if (modelElements == null || modelElements.size() <= 0) {
            return null;
        }
        String method = "insertM2(IConnection connection, Collection modelElements)";
        location.entering(method);
        Iterator iWs = connection.getConnectionSpec().getWorkspacesM2().iterator();
        while (iWs.hasNext()) {
            Workspace w = (Workspace)iWs.next();
            if (w.isReadOnly()) continue;
            this.getCacheM2(w.getName()).putAll(modelElements);
        }
        LinkedList<IModelElement> mes = new LinkedList<IModelElement>();
        Iterator iter = modelElements.iterator();
        while (iter.hasNext()) {
            IModelElement me = (IModelElement)iter.next();
            if (me.getState() == StateEnum.STATE_UNCHANGED) continue;
            me.setLastChangedAt(Utilities.getUtilities().getTimeSAPInternalFormat());
            me.setLastChangedBy(connection.getConnectionSpec().getUserName());
            if (me.getCreatedAt() == null) {
                me.setCreatedAt(Utilities.getUtilities().getTimeSAPInternalFormat());
                me.setCreatedBy(connection.getConnectionSpec().getUserName());
            }
            mes.add(me);
        }
        this.commitedModelElements.addAll(mes);
        if (connection.getConnectionSpec().isReadOnly()) {
            location.exiting();
            return null;
        }
        Collection col = this.insertM2PersistenceOnly(connection, mes);
        location.exiting();
        return col;
    }

    private Collection insertM2PersistenceOnly(IConnection connection, Collection modelElements) {
        String method = "insertM2PersistenceOnly(IConnection connection, Collection modelElements)";
        if (connection.getConnectionSpec().isReadOnly() || modelElements == null || modelElements.size() <= 0) {
            return null;
        }
        LinkedList colFailed = null;
        Iterator iter1 = this.getPCsOfConnection(2, true, connection).iterator();
        while (iter1.hasNext()) {
            PersistenceComponent pc = (PersistenceComponent)iter1.next();
            Collection c = null;
            try {
                c = pc.getComponent().insertM2(connection, modelElements);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
            if (c == null) continue;
            if (colFailed == null) {
                colFailed = new LinkedList();
            }
            colFailed.addAll(c);
            category.errorT(location, "insertM2PersistenceOnly(IConnection connection, Collection modelElements)", MMRResourceAccessor.getInstance().getMessageText(connection, "1013"), new Object[]{pc.getComponent()});
        }
        return colFailed;
    }

    public boolean insertM2Assoc(IConnection connection, Map aoos) {
        boolean flag = true;
        if (aoos == null || aoos.size() <= 0) {
            return true;
        }
        String method = "insertM2Assoc";
        location.entering(method);
        Iterator i = aoos.values().iterator();
        while (i.hasNext()) {
            AssociationsOfObject aoo = (AssociationsOfObject)i.next();
            aoo.setLastChangedAt(Utilities.getUtilities().getTimeSAPInternalFormat());
            aoo.setLastChangedBy(connection.getConnectionSpec().getUserName());
        }
        HashMap<String, AssociationsOfObject> aoosV = new HashMap<String, AssociationsOfObject>(aoos.size());
        Iterator<Object> iter = aoos.values().iterator();
        while (iter.hasNext()) {
            AssociationsOfObject aoo = (AssociationsOfObject)iter.next();
            aoosV.put(aoo.getMofId(), aoo);
        }
        Iterator iWs = connection.getConnectionSpec().getWorkspacesM2().iterator();
        while (iWs.hasNext()) {
            Workspace w = (Workspace)iWs.next();
            if (w.isReadOnly()) continue;
            this.getCacheM2Assoc(w.getName()).putAll(aoosV);
        }
        if (connection.getConnectionSpec().isReadOnly()) {
            location.exiting();
            return true;
        }
        iter = this.getPCsOfConnection(2, true, connection).iterator();
        while (iter.hasNext() && flag) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            try {
                flag = pc.getComponent().insertM2Assoc(connection, aoos);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
            if (flag) continue;
            category.errorT(location, method, MMRResourceAccessor.getInstance().getMessageText(connection, "1013"), new Object[]{pc.getComponent()});
        }
        location.exiting();
        return flag;
    }

    public Collection selectM2(IConnection connection, Collection mofIdsOrModelElements, boolean forUpdate) {
        return this.selectM2(connection, mofIdsOrModelElements, forUpdate, null);
    }

    public Collection selectM2(IConnection connection, Collection mofIdsOrModelElements, boolean forUpdate, PersistenceComponent pC) {
        if (mofIdsOrModelElements == null || mofIdsOrModelElements.size() <= 0) {
            return new LinkedList();
        }
        String method = "selectM2";
        location.entering(method);
        LinkedList<IModelElement> colSelected = new LinkedList<IModelElement>();
        HashSet mofIds = new HashSet(mofIdsOrModelElements.size());
        Iterator iter = mofIdsOrModelElements.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof String) {
                mofIds.add(o);
                continue;
            }
            if (!(o instanceof IModelElement)) continue;
            mofIds.add(((IModelElement)o).refMofId());
        }
        Iterator iWs = connection.getConnectionSpec().getWorkspacesM2().iterator();
        while (iWs.hasNext()) {
            Workspace w = (Workspace)iWs.next();
            Cache cache = this.getCacheM2(w.getName());
            iter = mofIds.iterator();
            while (iter.hasNext()) {
                String mofId = (String)iter.next();
                if (mofId.equals("MOF_PACKAGE_M2_ROOT")) {
                    colSelected.add(this.selectMofPackageRootM2(connection));
                    iter.remove();
                    continue;
                }
                IModelElement me = (IModelElement)cache.get(mofId);
                if (me == null) continue;
                colSelected.add(me);
                iter.remove();
            }
        }
        if (mofIds.size() > 0) {
            iter = this.getPCsOfConnection(2, false, connection).iterator();
            while (iter.hasNext()) {
                PersistenceComponent pc = (PersistenceComponent)iter.next();
                if (pC != null && !pC.equals(pc)) continue;
                Collection col = null;
                try {
                    col = pc.getComponent().selectM2(connection, mofIds, forUpdate);
                }
                catch (BaseRuntimeException e) {
                    e.log();
                }
                catch (BaseException e) {
                    e.log();
                }
                if (col == null) continue;
                colSelected.addAll(col);
                iWs = connection.getConnectionSpec().getWorkspacesM2().iterator();
                while (iWs.hasNext()) {
                    Workspace w = (Workspace)iWs.next();
                    Cache cache = this.getCacheM2(w.getName());
                    cache.putAll(col);
                }
                Iterator iterF = col.iterator();
                while (iterF.hasNext()) {
                    IModelElement meF = (IModelElement)iterF.next();
                    mofIds.remove(meF.refMofId());
                }
            }
        }
        LinkedList<ModelElementImpl> colSelectedClone = new LinkedList<ModelElementImpl>();
        iter = colSelected.iterator();
        while (iter.hasNext()) {
            ModelElementImpl me = (ModelElementImpl)iter.next();
            me.setRepository(connection.getRepository());
            me.setState(StateEnum.STATE_UNCHANGED);
            ModelElementImpl clone = this.createCloneM2(Repository.getInstance(connection), me);
            clone.setState(StateEnum.STATE_UNCHANGED);
            colSelectedClone.add(clone);
        }
        if (connection.getConnectionSpec().getConnectionsRequired() != null && mofIds.size() > 0) {
            iter = connection.getConnectionSpec().getConnectionsRequired().iterator();
            while (iter.hasNext()) {
                IConnection cRequ = (IConnection)iter.next();
                Collection col = this.selectM2(cRequ, mofIds, forUpdate);
                if (col == null) continue;
                colSelectedClone.addAll(col);
            }
        }
        location.exiting();
        return colSelectedClone;
    }

    public ModelElement resolveQualifiedNameM2(IConnection connection, List qualifiedName) {
        String method = "resolveQualifiedNameM2";
        location.entering(method);
        String qn = Utilities.getUtilities().encodeQualifiedName(qualifiedName);
        ModelElement me = (ModelElement)this.qualifiedNamesMap.get(qn);
        if (me == null) {
            Iterator iter = this.getPCsOfConnection(2, false, connection).iterator();
            while (iter.hasNext() && me == null) {
                PersistenceComponent pc = (PersistenceComponent)iter.next();
                try {
                    me = pc.getComponent().resolveQualifiedNameM2(connection, qualifiedName);
                }
                catch (BaseException e1) {
                    e1.log();
                }
                catch (BaseRuntimeException e1) {
                    e1.log();
                }
            }
            if (me == null && connection.getConnectionSpec().getConnectionsRequired() != null) {
                iter = connection.getConnectionSpec().getConnectionsRequired().iterator();
                while (iter.hasNext()) {
                    IConnection cRequ = (IConnection)iter.next();
                    me = cRequ.resolveQualifiedNameM2(qualifiedName);
                }
            }
            if (me != null) {
                this.qualifiedNamesMap.put(qn, me);
            }
        }
        ModelElementImpl clone = null;
        if (me != null && me instanceof ModelElementImpl) {
            clone = this.createCloneM2(Repository.getInstance(connection), (ModelElementImpl)me);
            clone.setState(StateEnum.STATE_UNCHANGED);
            clone.setRepository(connection.getRepository());
            me = clone;
        }
        location.exiting();
        return clone;
    }

    public Collection selectM2AllOfClass(IConnection connection, List qualifiedName) {
        String method = "selectM2AllOfClass";
        location.entering(method);
        LinkedList colSelected = new LinkedList();
        Iterator iter = this.getPCsOfConnection(2, false, connection).iterator();
        while (iter.hasNext()) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            Collection col = null;
            try {
                col = pc.getComponent().selectM2AllOfClass(connection, qualifiedName);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
            if (col == null) continue;
            colSelected.addAll(col);
        }
        Iterator iWs = connection.getConnectionSpec().getWorkspacesM2().iterator();
        while (iWs.hasNext()) {
            Workspace w = (Workspace)iWs.next();
            this.getCacheM2(w.getName()).putAll(colSelected);
        }
        LinkedList<ModelElementImpl> colFoundClone = new LinkedList<ModelElementImpl>();
        iter = colSelected.iterator();
        while (iter.hasNext()) {
            ModelElementImpl me = (ModelElementImpl)iter.next();
            me.setRepository(connection.getRepository());
            me.setState(StateEnum.STATE_UNCHANGED);
            ModelElementImpl clone = this.createCloneM2(Repository.getInstance(connection), me);
            clone.setState(StateEnum.STATE_UNCHANGED);
            colFoundClone.add(clone);
        }
        location.exiting();
        return colFoundClone;
    }

    public Collection selectM1AllClasses(IConnection connection) throws BaseException, BaseRuntimeException {
        String method = "selectM1AllClasses";
        location.entering(method);
        LinkedList types = new LinkedList();
        Iterator iter = this.getPCsOfConnection(1, false, connection).iterator();
        while (iter.hasNext()) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            try {
                Collection col = pc.getComponent().selectM1AllClasses(connection);
                if (col == null || col.size() <= 0) continue;
                types.addAll(col);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
        }
        iter = types.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o == null) {
                iter.next();
                continue;
            }
            if (!(o instanceof IMMRObject)) continue;
            ((IMMRObject)o).set___Repository(connection.getRepository());
        }
        location.exiting();
        return types;
    }

    public MofPackageImpl selectMofPackageRootM2(IConnection connection) {
        if (this.topLevelMofPackageM2 == null) {
            this.topLevelMofPackageM2 = new MofPackageImpl(null, "MOF_PACKAGE_M2_ROOT", "Default MOF Package M2-layer", true, false, false, (VisibilityKind)VisibilityKindEnum.PUBLIC_VIS);
            this.topLevelMofPackageM2.setMofId("MOF_PACKAGE_M2_ROOT");
            this.topLevelMofPackageM2.setMofLayer(2);
            this.topLevelMofPackageM2.setRepository(Repository.getInstance(connection));
            this.topLevelMofPackageM2.setState(StateEnum.STATE_UNCHANGED);
            Iterator iWs = connection.getConnectionSpec().getWorkspacesM2().iterator();
            while (iWs.hasNext()) {
                Workspace w = (Workspace)iWs.next();
                this.getCacheM2(w.getName()).put(this.topLevelMofPackageM2);
            }
        }
        MofPackageImpl clone = null;
        if (connection != null) {
            clone = (MofPackageImpl)this.createCloneM2(connection.getRepository(), this.topLevelMofPackageM2);
            clone.setMofId("MOF_PACKAGE_M2_ROOT");
            clone.setMofLayer(2);
            clone.setRepository(Repository.getInstance(connection));
            clone.setState(StateEnum.STATE_UNCHANGED);
        }
        return clone;
    }

    public Collection selectM2TopLevelPackages(IConnection connection) {
        String method = "selectM2TopLevelPackages";
        location.entering(method);
        TreeSet set = new TreeSet();
        Iterator iter = this.getPCsOfConnection(2, false, connection).iterator();
        while (iter.hasNext()) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            Collection c = null;
            try {
                c = pc.getComponent().selectM2TopLevelPackages(connection);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
            if (c == null) continue;
            set.addAll(c);
        }
        LinkedList<ModelElementImpl> colSelectedClone = new LinkedList<ModelElementImpl>();
        iter = set.iterator();
        while (iter.hasNext()) {
            ModelElementImpl me = (ModelElementImpl)iter.next();
            me.setRepository(connection.getRepository());
            me.setState(StateEnum.STATE_UNCHANGED);
            ModelElementImpl clone = this.createCloneM2(Repository.getInstance(connection), me);
            clone.setState(StateEnum.STATE_UNCHANGED);
            colSelectedClone.add(clone);
        }
        location.exiting();
        return colSelectedClone;
    }

    public AssociationsOfObject selectM2Assoc(IConnection connection, String associationId, String mofId) {
        AssociationsOfObject aoo_;
        Iterator iter;
        Cache cache;
        Workspace w;
        if (mofId == null) {
            return null;
        }
        String method = "selectM2Assoc";
        location.entering(method);
        AssociationsOfObject aoo = null;
        AssociationsOfObject aooCache = null;
        Iterator iWs = connection.getConnectionSpec().getWorkspacesM2().iterator();
        while (iWs.hasNext()) {
            w = (Workspace)iWs.next();
            cache = this.getCacheM2Assoc(w.getName());
            aooCache = (AssociationsOfObject)cache.get(mofId);
            if (associationId == null || aooCache == null || !this.containsAssociationId(aooCache, associationId)) continue;
            location.exiting();
            return aooCache;
        }
        if (mofId != null && mofId.compareTo("MOF_PACKAGE_M2_ROOT") == 0 && associationId.compareTo("Contains") == 0) {
            aoo = new AssociationsOfObject(mofId);
            Collection col = this.selectM2TopLevelPackages(connection);
            if (col != null && col.size() > 0) {
                Iterator iter2 = col.iterator();
                while (iter2.hasNext()) {
                    ModelElement me = (ModelElement)iter2.next();
                    Association a = new Association(mofId, me.refMofId(), associationId);
                    aoo.getMofIdsForward().add(a);
                }
            }
        } else {
            iter = this.getPCsOfConnection(2, false, connection).iterator();
            while (iter.hasNext() && aoo == null) {
                PersistenceComponent pc = (PersistenceComponent)iter.next();
                aoo_ = null;
                try {
                    aoo_ = pc.getComponent().selectM2Assoc(connection, associationId, mofId);
                }
                catch (BaseRuntimeException e) {
                    e.log();
                }
                catch (BaseException e) {
                    e.log();
                }
                if (aoo_ == null) continue;
                if (aoo == null) {
                    aoo = aoo_;
                    continue;
                }
                aoo.merge(aoo_);
            }
        }
        if (aoo == null && connection.getConnectionSpec().getConnectionsRequired() != null) {
            iter = connection.getConnectionSpec().getConnectionsRequired().iterator();
            while (iter.hasNext() && aoo == null) {
                IConnection cRequ = (IConnection)iter.next();
                aoo_ = this.selectM2Assoc(cRequ, associationId, mofId);
                if (aoo_ == null) continue;
                if (aoo == null) {
                    aoo = aoo_;
                    continue;
                }
                aoo.merge(aoo_);
            }
        }
        if (aoo != null) {
            if (aooCache == null) {
                iWs = connection.getConnectionSpec().getWorkspacesM2().iterator();
                while (iWs.hasNext()) {
                    w = (Workspace)iWs.next();
                    cache = this.getCacheM2Assoc(w.getName());
                    cache.put(aoo.getMofId(), aoo);
                }
            } else {
                aooCache.merge(aoo);
            }
        }
        location.exiting();
        return aoo;
    }

    public Collection deleteM1(IConnection connection, Collection objects) {
        LinkedList colFailed = null;
        if (objects == null || objects.size() <= 0) {
            return colFailed;
        }
        String method = "deleteM1";
        location.entering(method);
        Iterator iWs = connection.getConnectionSpec().getWorkspacesM1().iterator();
        while (iWs.hasNext()) {
            Workspace w = (Workspace)iWs.next();
            if (w.isReadOnly()) continue;
            Cache cache = this.getCacheM1(w.getName());
            Iterator iter = objects.iterator();
            while (iter.hasNext()) {
                RefObject ro = (RefObject)iter.next();
                cache.remove(ro.refMofId());
            }
        }
        Iterator iter = this.getPCsOfConnection(1, true, connection).iterator();
        while (iter.hasNext()) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            Collection c = null;
            try {
                c = pc.getComponent().deleteM1(connection, objects);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
            if (c == null) continue;
            if (colFailed == null) {
                colFailed = new LinkedList();
            }
            colFailed.addAll(c);
        }
        if (objects != null) {
            this.deletedObjects.addAll(objects);
        }
        location.exiting();
        return colFailed;
    }

    public boolean deleteM1Assoc(IConnection connection, Collection mofIds) {
        boolean flag = true;
        if (mofIds == null || mofIds.size() <= 0) {
            return flag;
        }
        String method = "deleteM1Assoc";
        location.entering(method);
        Iterator iWs = connection.getConnectionSpec().getWorkspacesM1().iterator();
        while (iWs.hasNext()) {
            Workspace w = (Workspace)iWs.next();
            if (w.isReadOnly()) continue;
            Cache cache = this.getCacheM1Assoc(w.getName());
            Iterator iter = mofIds.iterator();
            while (iter.hasNext()) {
                String mofId = (String)iter.next();
                cache.remove(mofId);
            }
        }
        Iterator iter = this.getPCsOfConnection(1, true, connection).iterator();
        while (iter.hasNext() && flag) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            try {
                flag = pc.getComponent().deleteM1Assoc(connection, mofIds);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
            if (flag) continue;
            category.errorT(location, method, MMRResourceAccessor.getInstance().getMessageText(connection, "1013"), new Object[]{pc.getComponent()});
        }
        location.exiting();
        return flag;
    }

    public Collection insertM1(IConnection connection, Collection objects) {
        Object o;
        if (objects == null || objects.size() <= 0) {
            return null;
        }
        String method = "insertM1";
        location.entering(method);
        LinkedList refObjects = new LinkedList();
        Iterator iter = objects.iterator();
        while (iter.hasNext()) {
            o = iter.next();
            if (!(o instanceof RefObject)) continue;
            refObjects.add(o);
        }
        iter = refObjects.iterator();
        while (iter.hasNext()) {
            o = iter.next();
            if (!(o instanceof IMMRObject)) continue;
            IMMRObject mmro = (IMMRObject)o;
            mmro.set___State(StateEnum.STATE_UNCHANGED);
            mmro.set___LastChangedAt(Utilities.getUtilities().getTimeSAPInternalFormat());
            mmro.set___LastChangedBy(connection.getConnectionSpec().getUserName());
            if (mmro.get___CreatedAt() != null) continue;
            mmro.set___CreatedAt(Utilities.getUtilities().getTimeSAPInternalFormat());
            mmro.set___CreatedBy(connection.getConnectionSpec().getUserName());
        }
        Iterator iWs = connection.getConnectionSpec().getWorkspacesM1().iterator();
        while (iWs.hasNext()) {
            Workspace w = (Workspace)iWs.next();
            if (w.isReadOnly()) continue;
            this.getCacheM1(w.getName()).putAll(refObjects);
        }
        this.commitedObjects.addAll(refObjects);
        if (connection.getConnectionSpec().isReadOnly()) {
            location.exiting();
            return null;
        }
        LinkedList colFailed = null;
        Iterator iter1 = this.getPCsOfConnection(1, true, connection).iterator();
        while (iter1.hasNext()) {
            PersistenceComponent pc = (PersistenceComponent)iter1.next();
            Collection c = null;
            try {
                c = pc.getComponent().insertM1(connection, refObjects);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
            if (c == null) continue;
            if (colFailed == null) {
                colFailed = new LinkedList();
            }
            colFailed.addAll(c);
            category.errorT(location, method, MMRResourceAccessor.getInstance().getMessageText(connection, "1013"), new Object[]{pc.getComponent()});
        }
        location.exiting();
        return colFailed;
    }

    public boolean insertM1Assoc(IConnection connection, Map aoos) {
        boolean flag = true;
        if (aoos == null || aoos.size() <= 0) {
            return flag;
        }
        String method = "insertM1Assoc";
        location.entering(method);
        Iterator i = aoos.values().iterator();
        while (i.hasNext()) {
            AssociationsOfObject aoo = (AssociationsOfObject)i.next();
            aoo.setLastChangedAt(Utilities.getUtilities().getTimeSAPInternalFormat());
            aoo.setLastChangedBy(connection.getConnectionSpec().getUserName());
        }
        Iterator iWs = connection.getConnectionSpec().getWorkspacesM1().iterator();
        while (iWs.hasNext()) {
            Workspace w = (Workspace)iWs.next();
            if (w.isReadOnly()) continue;
            this.getCacheM1Assoc(w.getName()).putAll(aoos);
        }
        if (connection.getConnectionSpec().isReadOnly()) {
            location.exiting();
            return true;
        }
        Iterator iter = this.getPCsOfConnection(1, true, connection).iterator();
        while (iter.hasNext() && flag) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            try {
                flag = pc.getComponent().insertM1Assoc(connection, aoos);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
            if (flag) continue;
            category.errorT(location, method, MMRResourceAccessor.getInstance().getMessageText(connection, "1013"), new Object[]{pc.getComponent()});
        }
        location.exiting();
        return flag;
    }

    public Collection selectM1(IConnection connection, Collection mofIdsOrObjects, boolean forUpdate) {
        return this.selectM1(connection, mofIdsOrObjects, forUpdate, null);
    }

    protected Collection selectM1(IConnection connection, Collection mofIdsOrObjects, boolean forUpdate, PersistenceComponent pC) {
        if (mofIdsOrObjects == null || mofIdsOrObjects.size() <= 0) {
            return new LinkedList();
        }
        String method = "selectM1";
        location.entering(method);
        LinkedList colSelect = new LinkedList(mofIdsOrObjects);
        LinkedList<IMMRObject> colSelected = new LinkedList<IMMRObject>();
        Iterator iWs = connection.getConnectionSpec().getWorkspacesM1().iterator();
        while (iWs.hasNext()) {
            Workspace w = (Workspace)iWs.next();
            Cache cache = this.getCacheM1(w.getName());
            Iterator iter = colSelect.iterator();
            while (iter.hasNext()) {
                IMMRObject of;
                Object o = iter.next();
                if (o instanceof String) {
                    of = (IMMRObject)cache.get((String)o);
                    if (of == null) continue;
                    colSelected.add(of);
                    iter.remove();
                    continue;
                }
                if (!(o instanceof IMMRObject) || (of = (IMMRObject)cache.get(((IMMRObject)o).get___MofId())) == null) continue;
                colSelected.add(of);
                iter.remove();
            }
        }
        Iterator iter = this.getPCsOfConnection(1, false, connection).iterator();
        while (iter.hasNext()) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            if (pC != null && !pC.equals(pc)) continue;
            Collection col = null;
            try {
                col = pc.getComponent().selectM1(connection, colSelect, forUpdate);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
            if (col == null) continue;
            Iterator iterV = col.iterator();
            while (iterV.hasNext()) {
                IMMRObject mmro = (IMMRObject)iterV.next();
                if (mmro.get___GeneratorVersion().compareTo("1.1.1") >= 0) continue;
                category.errorT(location, method, MMRResourceAccessor.getInstance().getMessageText(connection, "1015"), new Object[]{mmro.get___GeneratorVersion(), "1.1.1", mmro, pc.component});
                iter.remove();
            }
            colSelected.addAll(col);
            Iterator iterF = col.iterator();
            while (iterF.hasNext()) {
                IMMRObject mmro = (IMMRObject)iterF.next();
                colSelect.remove(mmro);
                colSelect.remove(mmro.get___MofId());
            }
        }
        iWs = connection.getConnectionSpec().getWorkspacesM1().iterator();
        while (iWs.hasNext()) {
            Workspace w = (Workspace)iWs.next();
            Cache cache = this.getCacheM1(w.getName());
            cache.putAll(colSelected);
        }
        LinkedList<IMMRObject> colSelectedClone = new LinkedList<IMMRObject>();
        iter = colSelected.iterator();
        while (iter.hasNext()) {
            IMMRObject o = (IMMRObject)iter.next();
            o.set___State(StateEnum.STATE_UNCHANGED);
            o.set___Repository(connection.getRepository());
            IMMRObject clone = this.createCloneM1(Repository.getInstance(connection), o);
            if (clone == null) {
                category.errorT(location, method, MMRResourceAccessor.getInstance().getMessageText(connection, "1014"), new Object[]{o});
                continue;
            }
            clone.set___State(StateEnum.STATE_UNCHANGED);
            colSelectedClone.add(clone);
        }
        if (connection.getConnectionSpec().getConnectionsRequired() != null && colSelectedClone.size() > 0) {
            iter = connection.getConnectionSpec().getConnectionsRequired().iterator();
            while (iter.hasNext()) {
                IConnection cRequ = (IConnection)iter.next();
                Collection col = this.selectM1(cRequ, colSelectedClone, forUpdate);
                if (col == null) continue;
                colSelectedClone.addAll(col);
            }
        }
        location.exiting();
        return colSelectedClone;
    }

    public IMMRObject selectM1ByName(IConnection connection, String type, List args, List instantiators, boolean forUpdate) {
        String method = "selectM1ByName";
        location.entering(method);
        IMMRObject oFound = null;
        Iterator iter = this.getPCsOfConnection(1, false, connection).iterator();
        while (iter.hasNext() && oFound == null) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            try {
                oFound = pc.getComponent().selectM1ByName(connection, type, args, instantiators, forUpdate);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
            if (oFound == null || oFound.get___GeneratorVersion().compareTo("1.1.1") >= 0) continue;
            category.errorT(location, method, MMRResourceAccessor.getInstance().getMessageText(connection, "1015"), new Object[]{oFound.get___GeneratorVersion(), "1.1.1", oFound, pc.component});
            return null;
        }
        if (oFound != null) {
            oFound.set___Repository(connection.getRepository());
            oFound.set___State(StateEnum.STATE_UNCHANGED);
            Iterator iWs = connection.getConnectionSpec().getWorkspacesM1().iterator();
            while (iWs.hasNext()) {
                Workspace w = (Workspace)iWs.next();
                this.getCacheM1(w.getName()).put(oFound);
            }
        }
        IMMRObject clone = this.createCloneM1(Repository.getInstance(connection), oFound);
        clone.set___State(StateEnum.STATE_UNCHANGED);
        location.exiting();
        return clone;
    }

    public Collection selectM1AllOfClass(IConnection connection, List qualifiedName) {
        String method = "selectM1AllOfClass";
        location.entering(method);
        LinkedList colSelected = new LinkedList();
        Iterator iter = this.getPCsOfConnection(1, false, connection).iterator();
        while (iter.hasNext()) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            Collection col = null;
            try {
                col = pc.getComponent().selectM1AllOfClass(connection, qualifiedName);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
            if (col == null) continue;
            Iterator iterV = col.iterator();
            while (iterV.hasNext()) {
                IMMRObject mmro = (IMMRObject)iterV.next();
                if (mmro.get___GeneratorVersion().compareTo("1.1.1") >= 0) continue;
                category.errorT(location, method, MMRResourceAccessor.getInstance().getMessageText(connection, "1015"), new Object[]{mmro.get___GeneratorVersion(), "1.1.1", mmro, pc.component});
                iter.remove();
            }
            colSelected.addAll(col);
        }
        Iterator iWs = connection.getConnectionSpec().getWorkspacesM1().iterator();
        while (iWs.hasNext()) {
            Workspace w = (Workspace)iWs.next();
            this.getCacheM1(w.getName()).putAll(colSelected);
        }
        LinkedList<IMMRObject> colFoundClone = new LinkedList<IMMRObject>();
        iter = colSelected.iterator();
        while (iter.hasNext()) {
            IMMRObject o = (IMMRObject)iter.next();
            o.set___Repository(connection.getRepository());
            o.set___State(StateEnum.STATE_UNCHANGED);
            IMMRObject clone = this.createCloneM1(Repository.getInstance(connection), o);
            if (clone == null) {
                category.errorT(location, method, MMRResourceAccessor.getInstance().getMessageText(connection, "1014"), new Object[]{o});
                continue;
            }
            clone.set___State(StateEnum.STATE_UNCHANGED);
            colFoundClone.add(clone);
        }
        location.exiting();
        return colFoundClone;
    }

    public ListInstanceInfo selectM1InstanceInfos(IConnection connection, List qualifiedName, String pattern) {
        String method = "selectM1InstanceInfos";
        location.entering(method);
        ListInstanceInfo lii = new ListInstanceInfo();
        Iterator iter = this.getPCsOfConnection(1, false, connection).iterator();
        while (iter.hasNext()) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            ListInstanceInfo col = null;
            try {
                col = pc.getComponent().selectM1InstanceInfos(connection, qualifiedName, pattern);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
            if (col == null) continue;
            lii.addAll(col);
        }
        location.exiting();
        return lii;
    }

    public String getQualifiedNameM1(IConnection connection, RefBaseObject rbo) throws BaseException, BaseRuntimeException {
        String qn = null;
        Iterator iter = this.getPCsOfConnection(1, false, connection).iterator();
        while (iter.hasNext() && qn == null) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            String s = null;
            try {
                s = pc.getComponent().getQualifiedNameM1(connection, rbo);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
            if (s == null) continue;
            qn = s;
        }
        return qn;
    }

    private boolean containsAssociationId(AssociationsOfObject aoo, String associationId) {
        Association a;
        boolean res = false;
        if (associationId == null) {
            return res;
        }
        Iterator iter = aoo.getMofIdsForward().iterator();
        while (iter.hasNext() && !res) {
            a = (Association)iter.next();
            if (!associationId.equals(a.getAssociationId())) continue;
            res = true;
        }
        iter = aoo.getMofIdsBackward().iterator();
        while (iter.hasNext() && !res) {
            a = (Association)iter.next();
            if (a.getAssociationId().compareTo(associationId) != 0) continue;
            res = true;
        }
        return res;
    }

    public AssociationsOfObject selectM1Assoc(IConnection connection, String associationId, String mofId) {
        AssociationsOfObject aoo_;
        if (mofId == null) {
            return null;
        }
        String method = "selectM1Assoc";
        location.entering(method);
        AssociationsOfObject aoo = null;
        Iterator iWs = connection.getConnectionSpec().getWorkspacesM1().iterator();
        while (iWs.hasNext()) {
            Workspace w = (Workspace)iWs.next();
            Cache cache = this.getCacheM1Assoc(w.getName());
            AssociationsOfObject aooCache = (AssociationsOfObject)cache.get(mofId);
            if (aooCache == null || !this.containsAssociationId(aooCache, associationId)) continue;
            location.exiting();
            return aooCache;
        }
        Iterator iter = this.getPCsOfConnection(1, false, connection).iterator();
        while (iter.hasNext() && aoo == null) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            aoo_ = null;
            try {
                aoo_ = pc.getComponent().selectM1Assoc(connection, associationId, mofId);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
            if (aoo_ == null) continue;
            if (aoo == null) {
                aoo = aoo_;
                continue;
            }
            aoo.merge(aoo_);
        }
        if (aoo == null && connection.getConnectionSpec().getConnectionsRequired() != null) {
            iter = connection.getConnectionSpec().getConnectionsRequired().iterator();
            while (iter.hasNext() && aoo == null) {
                IConnection cRequ = (IConnection)iter.next();
                aoo_ = this.selectM1Assoc(cRequ, associationId, mofId);
                if (aoo_ == null) continue;
                if (aoo == null) {
                    aoo = aoo_;
                    continue;
                }
                aoo.merge(aoo_);
            }
        }
        if (aoo != null) {
            iWs = connection.getConnectionSpec().getWorkspacesM1().iterator();
            while (iWs.hasNext()) {
                Workspace w = (Workspace)iWs.next();
                Cache cache = this.getCacheM1Assoc(w.getName());
                AssociationsOfObject aooCache = (AssociationsOfObject)cache.get(mofId);
                if (aooCache == null) {
                    cache.put(aoo.getMofId(), aoo);
                    continue;
                }
                aooCache.merge(aoo);
            }
        }
        location.exiting();
        return aoo;
    }

    private List getPCsOfConnection(int mofLayer, boolean forWrite, IConnection connection) {
        LinkedList<PersistenceComponent> list = null;
        switch (mofLayer) {
            case 2: {
                list = this.pcsM2;
                break;
            }
            case 1: {
                list = new LinkedList<PersistenceComponent>();
                Iterator iter = this.pcsM1.iterator();
                while (iter.hasNext()) {
                    PersistenceComponent pc = (PersistenceComponent)iter.next();
                    boolean flag = false;
                    List lw = pc.getWorkspacesAvailableM1();
                    if (lw == null) {
                        list.add(pc);
                        continue;
                    }
                    Iterator iter1 = lw.iterator();
                    while (iter1.hasNext() && !flag) {
                        Workspace w = (Workspace)iter1.next();
                        if (forWrite) {
                            if (connection.getConnectionSpec().getWorkspacesM1() == null) continue;
                            Iterator iter2 = connection.getConnectionSpec().getWorkspacesM1().iterator();
                            while (iter2.hasNext() && !flag) {
                                Workspace w_ = (Workspace)iter2.next();
                                if (w_.isReadOnly() || !w_.equals(w)) continue;
                                flag = true;
                            }
                            continue;
                        }
                        if (connection.getConnectionSpec().getWorkspacesM1() == null || !connection.getConnectionSpec().getWorkspacesM1().contains(w)) continue;
                        flag = true;
                    }
                    if (!flag) continue;
                    list.add(pc);
                }
                break;
            }
            default: {
                list = null;
            }
        }
        return list;
    }

    protected IPersistence getPCDynamic(PersistenceDescription desc) {
        IPersistence p = null;
        Class<?> cl = null;
        try {
            cl = this.getClass().getClassLoader().loadClass(desc.getClassName());
            if (cl != null) {
                Class[] parameterTypes = new Class[]{class$com$sap$ip$mmr$IRepositoryServer == null ? (class$com$sap$ip$mmr$IRepositoryServer = RepositoryServer.class$("com.sap.ip.mmr.IRepositoryServer")) : class$com$sap$ip$mmr$IRepositoryServer};
                Constructor<?> con = null;
                try {
                    Object o;
                    con = cl.getConstructor(parameterTypes);
                    int n = 1;
                    if (desc.getInitArgs() != null) {
                        n += desc.getInitArgs().length;
                    }
                    Object[] initargs = new Object[n];
                    initargs[0] = this;
                    if (desc.getInitArgs() != null) {
                        o = desc.getInitArgs();
                        for (int i = 0; i < ((Object[])o).length; ++i) {
                            initargs[i + 1] = o[i];
                        }
                    }
                    o = con.newInstance(initargs);
                    p = (IPersistence)o;
                }
                catch (NoClassDefFoundError e1) {
                    p = null;
                }
                catch (IllegalAccessException e2) {
                    p = null;
                }
                catch (InstantiationException e3) {
                    p = null;
                }
                catch (InvocationTargetException e4) {
                    e4.printStackTrace(System.err);
                    p = null;
                }
            }
        }
        catch (NoSuchMethodException e) {
            p = null;
        }
        catch (ClassNotFoundException e) {
            p = null;
        }
        return p;
    }

    public boolean initialize() {
        String method = "initialize()";
        location.entering("initialize()");
        boolean res = true;
        if (!this.initialized) {
            PersistenceDescription pd;
            IPersistence p;
            category.logT(300, location, "initialize()", "Initializing ...");
            this.initialized = true;
            if (RepositoryServer.getConfiguration().getDatabaseType() != 0) {
                this.timeToLive = 300L;
            }
            this.instantiatorM1 = Instantiator.getInstantiator(this);
            this.getJndiInitialContext();
            category.logT(300, location, "initialize()", "JNDI context: " + this.jndiInitialContext);
            this.repositoryDB = this.getRepositoryDB();
            category.logT(300, location, "initialize()", "repositoryDB: " + this.repositoryDB.toString());
            if (this.repositoryDB == null || this.repositoryDB instanceof PersistenceFSMultiWS) {
                PersistenceJarMulti pcj = new PersistenceJarMulti(this);
                this.registerPersistenceComponent(pcj);
                category.logT(300, location, "initialize()", "Jar based persistence: " + pcj.toString());
            }
            if (this.repositoryDB != null && this.repositoryDB.getClass().getName().compareTo("com.sap.ip.mmr.db.RepositoryDB") == 0) {
                this.threadGC = new ThreadGC(this);
                this.threadGC.setPriority(1);
                this.threadGC.start();
            }
            if ((p = this.getPCDynamic(pd = new PersistenceDescription("com.sap.ip.mmr.persistence.PersistenceJCOMultiWS", null))) != null) {
                this.registerPersistenceComponent(p);
                category.logT(300, location, "initialize()", "other persistence: " + p.toString());
            }
            this.timeLastDeployment = Utilities.getUtilities().getTime();
        }
        location.exiting("initialize()");
        return res;
    }

    public boolean deregisterPersistenceComponent(IPersistence persistenceComponent) {
        String method = "deregisterPersistenceComponent(IPersistence persistenceComponent)";
        boolean flag = false;
        Iterator iter = this.pcsM1.iterator();
        while (iter.hasNext() && !flag) {
            PersistenceComponent component = (PersistenceComponent)iter.next();
            if (!component.getComponent().equals(persistenceComponent)) continue;
            iter.remove();
            flag = true;
        }
        location.infoT(category, "deregisterPersistenceComponent(IPersistence persistenceComponent)", "Deregistered persistence component '{0}'", new Object[]{persistenceComponent.getClass().getName()});
        return flag;
    }

    public Collection registerPersistenceComponent(IPersistence persistenceComponent) {
        String method = "registerPersistenceComponent(IPersistence persistenceComponent)";
        location.entering("registerPersistenceComponent(IPersistence persistenceComponent)");
        Collection mpFailed = null;
        boolean flag = false;
        Iterator iter = this.pcsM1.iterator();
        while (iter.hasNext() && !flag) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            if (!pc.getComponent().equals(persistenceComponent)) continue;
            flag = true;
        }
        if (flag) {
            return mpFailed;
        }
        List list = persistenceComponent.getMofPackageNamesResponsible();
        LinkedList<String> ownedMofPackages = null;
        if (list != null) {
            ownedMofPackages = new LinkedList<String>();
            iter = list.iterator();
            while (iter.hasNext()) {
                String path = (String)iter.next();
                path = path.replace('/', '.');
                path = path.replace('\\', '.');
                ownedMofPackages.add(path);
            }
        }
        location.infoT(category, "registerPersistenceComponent(IPersistence persistenceComponent)", MMRResourceAccessor.getInstance().getMessageText("1006"), new Object[]{persistenceComponent.getClass().getName()});
        PersistenceComponent pc = new PersistenceComponent(persistenceComponent, ownedMofPackages);
        this.pcsM1.add(pc);
        if (persistenceComponent instanceof PersistenceFSMultiWS || persistenceComponent instanceof PersistenceJarMulti || persistenceComponent == this.getRepositoryDB()) {
            this.pcsM2.add(pc);
        }
        persistenceComponent.setRepositoryServer(this);
        try {
            persistenceComponent.initialize();
        }
        catch (BaseRuntimeException e) {
            e.log();
        }
        catch (BaseException e) {
            e.log();
        }
        location.exiting("registerPersistenceComponent(IPersistence persistenceComponent)");
        return mpFailed;
    }

    public InputStream getResourceByName(String path) {
        return RepositoryServer.getRepositoryFS().getResourceAsStream(path, false);
    }

    public List getMofPackageNamesResponsible() {
        return null;
    }

    public void setRepositoryServer(IRepositoryServer repositoryServer) {
    }

    public IPersistence getRepositoryDB() {
        String method = "getRepositoryDB()";
        location.entering("getRepositoryDB()");
        int newDbType = RepositoryServer.getConfiguration().getDatabaseType();
        if (newDbType != this.dbType) {
            this.repositoryDB = null;
        }
        if (this.repositoryDB != null) {
            return this.repositoryDB;
        }
        switch (newDbType) {
            case 0: {
                category.logT(300, location, "getRepositoryDB()", "no database persistence will be used");
                break;
            }
            default: {
                Class<?> cl;
                try {
                    cl = this.getClass().getClassLoader().loadClass("com.sap.ip.mmr.db.RepositoryDB");
                }
                catch (ClassNotFoundException e) {
                    cl = null;
                }
                if (cl != null) {
                    try {
                        this.repositoryDB = (IRepositoryDB)cl.newInstance();
                    }
                    catch (InstantiationException e) {
                        this.repositoryDB = null;
                    }
                    catch (IllegalAccessException e) {
                        this.repositoryDB = null;
                    }
                    if (this.repositoryDB != null) {
                        this.repositoryDB.setRepositoryServer(this);
                    }
                }
                if (this.repositoryDB != null && ((IRepositoryDB)this.repositoryDB).getDataSource() != null) break;
                this.repositoryDB = new PersistenceFSMultiWS(this);
            }
        }
        if (this.repositoryDB != null) {
            try {
                if (!this.repositoryDB.initialize()) {
                    this.repositoryDB = null;
                }
            }
            catch (BaseRuntimeException e1) {
                e1.log();
            }
            catch (BaseException e1) {
                e1.log();
            }
        }
        if (this.repositoryDB != null) {
            this.registerPersistenceComponent(this.repositoryDB);
        }
        this.dbType = newDbType;
        location.exiting("getRepositoryDB()");
        return this.repositoryDB;
    }

    public List getWorkspacesAvailableM1(IConnection connection) {
        String method = "getWorkspacesAvailableM1(IConnection connection)";
        location.entering("getWorkspacesAvailableM1(IConnection connection)");
        LinkedList<Workspace> workspaces = new LinkedList<Workspace>();
        HashSet set = new HashSet();
        set.addAll(this.pcsM1);
        set.addAll(this.pcsM2);
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            List c = pc.getComponent().getWorkspacesAvailableM1(connection);
            if (c == null || c.size() <= 0) continue;
            workspaces.addAll(c);
        }
        if (workspaces.size() <= 0) {
            Workspace w = new Workspace("[default]");
            workspaces.add(w);
        }
        location.exiting("getWorkspacesAvailableM1(IConnection connection)");
        return workspaces;
    }

    public List getWorkspacesAvailableM2(IConnection connection) {
        String method = "getWorkspacesAvailableM2(IConnection connection)";
        location.entering("getWorkspacesAvailableM2(IConnection connection)");
        LinkedList<Workspace> workspaces = new LinkedList<Workspace>();
        HashSet set = new HashSet();
        set.addAll(this.pcsM1);
        set.addAll(this.pcsM2);
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            List c = pc.getComponent().getWorkspacesAvailableM2(connection);
            if (c == null || c.size() <= 0) continue;
            workspaces.addAll(c);
        }
        if (workspaces.size() <= 0) {
            Workspace w = new Workspace("[default]");
            workspaces.add(w);
        }
        location.exiting("getWorkspacesAvailableM2(IConnection connection)");
        return workspaces;
    }

    public boolean writeJava(IConnection connection, String directory, IJavaElement javaElement) {
        boolean flag = false;
        if (javaElement != null && javaElement.getQualifiedName() != null) {
            JavaSource js = new JavaSource(javaElement.getQualifiedName());
            js.setLayerMof(0);
            js.setSourceCode(((Object)javaElement).toString());
            flag = RepositoryServer.getRepositoryFS().writeJavaSource(directory, js);
        }
        return flag;
    }

    public boolean writeJDO(IConnection connection, String directory, JDODescriptor jdoDescriptor) {
        FileContent fc = jdoDescriptor.getFileContentJDODescriptor(directory);
        fc.setMofLayer(0);
        RepositoryServer.getRepositoryFS().writeFileContent(fc, false);
        fc = jdoDescriptor.getFileContentJDOMapper(directory);
        RepositoryServer.getRepositoryFS().writeFileContent(fc, false);
        return true;
    }

    public boolean writeDDIC(IConnection connection, String directory, Table table) {
        String method = "writeDDIC(IConnection connection,String directory,Table table)";
        category.errorT(location, "writeDDIC(IConnection connection,String directory,Table table)", MMRResourceAccessor.getInstance().getMessageText(connection, "0000"));
        return false;
    }

    public List queryM2(IConnection connection, List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes) {
        Collection subt;
        RefObject ro;
        String method = "queryM2";
        location.entering(method);
        LinkedList<List> types = new LinkedList<List>();
        types.add(qualifiedNameOfType);
        if (qualifiedNameOfType != null && includeSubTypes && (ro = connection.getRepository().selectM3ByName((String)qualifiedNameOfType.get(qualifiedNameOfType.size() - 1))) != null && ro instanceof GeneralizableElementImpl && (subt = ((GeneralizableElementImpl)ro).allSubtypes()) != null) {
            Iterator i = subt.iterator();
            while (i.hasNext()) {
                ModelElement mesubt = (ModelElement)i.next();
                types.add(mesubt.getQualifiedName());
            }
        }
        LinkedList found = new LinkedList();
        Iterator iterTypes = types.iterator();
        while (iterTypes.hasNext()) {
            List qnof = (List)iterTypes.next();
            Iterator iter = this.getPCsOfConnection(2, false, connection).iterator();
            while (iter.hasNext()) {
                PersistenceComponent pc = (PersistenceComponent)iter.next();
                List l = null;
                try {
                    l = pc.getComponent().queryM2(connection, qnof, filters, false);
                }
                catch (BaseRuntimeException e) {
                    e.log();
                }
                catch (BaseException e) {
                    e.log();
                }
                if (l == null) continue;
                found.addAll(l);
            }
        }
        location.exiting();
        return found;
    }

    public List queryM1(IConnection connection, List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes) {
        MofClassImpl mc;
        Collection subt;
        ModelElement me;
        String method = "queryM1";
        location.entering(method);
        LinkedList<List> types = new LinkedList<List>();
        types.add(qualifiedNameOfType);
        if (qualifiedNameOfType != null && includeSubTypes && (me = this.resolveQualifiedNameM2(connection, qualifiedNameOfType)) instanceof MofClassImpl && (subt = (mc = (MofClassImpl)me).allSubtypes()) != null) {
            Iterator i = subt.iterator();
            while (i.hasNext()) {
                ModelElement mesubt = (ModelElement)i.next();
                types.add(mesubt.getQualifiedName());
            }
        }
        List pcs = this.getPCsOfConnection(1, false, connection);
        LinkedList found = new LinkedList();
        Iterator iterTypes = types.iterator();
        while (iterTypes.hasNext()) {
            List qnof = (List)iterTypes.next();
            Iterator iter = pcs.iterator();
            while (iter.hasNext()) {
                PersistenceComponent pc = (PersistenceComponent)iter.next();
                List l = null;
                try {
                    l = pc.getComponent().queryM1(connection, qnof, filters, false);
                }
                catch (BaseRuntimeException e) {
                    e.log();
                }
                catch (BaseException e) {
                    e.log();
                }
                if (l == null) continue;
                found.addAll(l);
            }
        }
        location.exiting();
        return found;
    }

    public Hierarchy getHierarchyM1(IConnection connection, String mofId) {
        Hierarchy h = null;
        Iterator iter = this.getPCsOfConnection(1, false, connection).iterator();
        while (iter.hasNext() && h == null) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            try {
                h = pc.getComponent().getHierarchyM1(connection, mofId);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
        }
        return h;
    }

    public Hierarchy getHierarchyM1ByName(IConnection connection, String name) {
        Hierarchy h = null;
        Iterator iter = this.getPCsOfConnection(1, false, connection).iterator();
        while (iter.hasNext() && h == null) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            try {
                h = pc.getComponent().getHierarchyM1ByName(connection, name);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
        }
        return h;
    }

    public boolean writeHierarchyM1(IConnection connection, Hierarchy hierarchy) {
        boolean res = true;
        hierarchy.setLastChanged(Utilities.getUtilities().getTimeSAPInternalFormat());
        Iterator iter = this.getPCsOfConnection(1, true, connection).iterator();
        while (iter.hasNext() && res) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            try {
                res = pc.getComponent().writeHierarchyM1(connection, hierarchy);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
        }
        return res;
    }

    public Hierarchy getHierarchyM0(IConnection connection, String mofId) {
        Hierarchy h = null;
        Iterator iter = this.getPCsOfConnection(0, false, connection).iterator();
        while (iter.hasNext() && h == null) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            try {
                h = pc.getComponent().getHierarchyM0(connection, mofId);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
        }
        return h;
    }

    public Hierarchy getHierarchyM0ByName(IConnection connection, String name) {
        Hierarchy h = null;
        Iterator iter = this.getPCsOfConnection(0, false, connection).iterator();
        while (iter.hasNext() && h == null) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            try {
                h = pc.getComponent().getHierarchyM0ByName(connection, name);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
        }
        return h;
    }

    public boolean writeHierarchyM0(IConnection connection, Hierarchy hierarchy) {
        boolean res = true;
        hierarchy.setLastChanged(Utilities.getUtilities().getTimeSAPInternalFormat());
        Iterator iter = this.getPCsOfConnection(0, true, connection).iterator();
        while (iter.hasNext() && res) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            try {
                res = pc.getComponent().writeHierarchyM0(connection, hierarchy);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
        }
        return res;
    }

    public ModelElementImpl createCloneM2(IRepository repository, ModelElementImpl me) {
        String method = "createCloneM2(IRepository repository, ModelElementImpl me)";
        ModelElementImpl clone = null;
        try {
            Constructor<?> cn = me.getClass().getConstructor(class$com$sap$ip$mmr$IRepository == null ? (class$com$sap$ip$mmr$IRepository = RepositoryServer.class$("com.sap.ip.mmr.IRepository")) : class$com$sap$ip$mmr$IRepository);
            try {
                Object[] objects = new Object[]{repository};
                clone = (ModelElementImpl)cn.newInstance(objects);
            }
            catch (NoClassDefFoundError e0) {
                RepositoryServer.writeErrorToCategory("createCloneM2(IRepository repository, ModelElementImpl me)", e0);
            }
            catch (InstantiationException e1) {
                RepositoryServer.writeExceptionToCategory("createCloneM2(IRepository repository, ModelElementImpl me)", e1);
            }
            catch (IllegalArgumentException e2) {
                RepositoryServer.writeExceptionToCategory("createCloneM2(IRepository repository, ModelElementImpl me)", e2);
            }
            catch (IllegalAccessException e3) {
                RepositoryServer.writeExceptionToCategory("createCloneM2(IRepository repository, ModelElementImpl me)", e3);
            }
            catch (InvocationTargetException e4) {
                RepositoryServer.writeExceptionToCategory("createCloneM2(IRepository repository, ModelElementImpl me)", e4);
            }
            catch (ExceptionInInitializerError e5) {
                RepositoryServer.writeErrorToCategory("createCloneM2(IRepository repository, ModelElementImpl me)", e5);
            }
            if (clone != null) {
                clone.setRepository(repository);
                clone.copy(me);
                clone.setMofId(me.refMofId());
            }
        }
        catch (Exception e) {
            RepositoryServer.writeExceptionToCategory("createCloneM2(IRepository repository, ModelElementImpl me)", e);
            clone = null;
        }
        return clone;
    }

    public RefBaseObject createInstanceM1(IConnection connection, String nameClass, List args, boolean noMessage) {
        RefBaseObject o = null;
        IRepository repository = Repository.getInstance(connection);
        this.instantiatorM1.setConnection(connection);
        try {
            o = (RefBaseObject)this.instantiatorM1.createInstanceByJavaClassName(repository, nameClass, args, false);
            if (o == null) {
                o = new MMRObject();
            }
        }
        catch (Exception e) {
            o = null;
        }
        return o;
    }

    public IMMRObject createCloneM1(IRepository repository, IMMRObject ro) {
        String method = "createCloneM1(IRepository repository, IMMRObject ro)";
        IMMRObject clone = null;
        if (ro == null) {
            return clone;
        }
        try {
            Constructor<?> cn = ro.getClass().getConstructor(class$com$sap$ip$mmr$IRepository == null ? (class$com$sap$ip$mmr$IRepository = RepositoryServer.class$("com.sap.ip.mmr.IRepository")) : class$com$sap$ip$mmr$IRepository);
            try {
                Object[] objects = new Object[]{repository};
                clone = (IMMRObject)cn.newInstance(objects);
            }
            catch (NoClassDefFoundError e0) {
                RepositoryServer.writeErrorToCategory("createCloneM1(IRepository repository, IMMRObject ro)", e0);
            }
            catch (InstantiationException e1) {
                RepositoryServer.writeExceptionToCategory("createCloneM1(IRepository repository, IMMRObject ro)", e1);
            }
            catch (IllegalArgumentException e2) {
                RepositoryServer.writeExceptionToCategory("createCloneM1(IRepository repository, IMMRObject ro)", e2);
            }
            catch (IllegalAccessException e3) {
                RepositoryServer.writeExceptionToCategory("createCloneM1(IRepository repository, IMMRObject ro)", e3);
            }
            catch (InvocationTargetException e4) {
                RepositoryServer.writeExceptionToCategory("createCloneM1(IRepository repository, IMMRObject ro)", e4);
            }
            catch (ExceptionInInitializerError e5) {
                RepositoryServer.writeErrorToCategory("createCloneM1(IRepository repository, IMMRObject ro)", e5);
            }
            if (clone == null) {
                clone = new MMRObject();
            }
            clone.set___Repository(repository);
            clone.___copy(ro);
            clone.set___MofId(ro.get___MofId());
        }
        catch (Exception e) {
            RepositoryServer.writeExceptionToCategory("createCloneM1(IRepository repository, IMMRObject ro)", e);
            clone = null;
        }
        return clone;
    }

    public Collection resolveFilesM2(IConnection connection, ModelElement modelElement) {
        Collection col = null;
        if (this.getRepositoryDB() != null) {
            try {
                col = this.getRepositoryDB().resolveFilesM2(connection, modelElement);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
        }
        return col;
    }

    public Collection resolveFilesM1(IConnection connection, RefObject ro) {
        Collection col = null;
        if (this.getRepositoryDB() != null) {
            try {
                col = this.getRepositoryDB().resolveFilesM1(connection, ro);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
        }
        return col;
    }

    public Context getJndiInitialContext() {
        String method = "getJndiInitialContext()";
        location.entering("getJndiInitialContext()");
        if (this.jndiInitialContext == null) {
            try {
                this.jndiInitialContext = new InitialContext();
                location.infoT(category, "getJndiInitialContext()", MMRResourceAccessor.getInstance().getMessageText("2021"), new Object[]{this.jndiInitialContext});
            }
            catch (NamingException e) {
                location.infoT(category, "getJndiInitialContext()", MMRResourceAccessor.getInstance().getMessageText("2022"));
                this.jndiInitialContext = null;
            }
        }
        location.exiting("getJndiInitialContext()");
        return this.jndiInitialContext;
    }

    public boolean runTask(IConnection connection, String classNameOfTask, Map properties) {
        String destPath;
        String method = "runTask(IConnection connection,String classNameOfTask,Map properties))";
        ITask task = null;
        try {
            Class<?> cl = Class.forName(classNameOfTask);
            try {
                Object o = cl.newInstance();
                if (!(o instanceof ITask)) {
                    category.errorT(location, "runTask(IConnection connection,String classNameOfTask,Map properties))", MMRResourceAccessor.getInstance().getMessageText(connection, "1000"), new Object[]{classNameOfTask});
                    return false;
                }
                task = (ITask)o;
            }
            catch (InstantiationException e1) {
                category.errorT(location, "runTask(IConnection connection,String classNameOfTask,Map properties))", MMRResourceAccessor.getInstance().getMessageText(connection, "1001"), new Object[]{classNameOfTask, e1});
                return false;
            }
            catch (IllegalAccessException e1) {
                category.errorT(location, "runTask(IConnection connection,String classNameOfTask,Map properties))", MMRResourceAccessor.getInstance().getMessageText(connection, "1001"), new Object[]{classNameOfTask, e1});
                return false;
            }
        }
        catch (ClassNotFoundException e) {
            category.errorT(location, "runTask(IConnection connection,String classNameOfTask,Map properties))", MMRResourceAccessor.getInstance().getMessageText(connection, "1002"), new Object[]{classNameOfTask, e});
            return false;
        }
        if (task == null) {
            category.errorT(location, "runTask(IConnection connection,String classNameOfTask,Map properties))", MMRResourceAccessor.getInstance().getMessageText(connection, "1003"), new Object[]{classNameOfTask});
            return false;
        }
        category.infoT(location, "runTask(IConnection connection,String classNameOfTask,Map properties))", MMRResourceAccessor.getInstance().getMessageText(connection, "1007"), new Object[]{classNameOfTask});
        HashSet wsBackupM1 = null;
        HashSet wsBackupM2 = null;
        if (task.getClass().getName().compareTo("com.sap.ip.mmr.db.tasks.TaskDeployToDB") != 0) {
            Workspace w;
            wsBackupM1 = new HashSet();
            wsBackupM1.addAll(connection.getConnectionSpec().getWorkspacesM1());
            connection.getConnectionSpec().getWorkspacesM1().clear();
            Iterator i = wsBackupM1.iterator();
            while (i.hasNext()) {
                w = (Workspace)i.next();
                try {
                    connection.getConnectionSpec().getWorkspacesM1().add(w.clone());
                }
                catch (CloneNotSupportedException e) {
                    Repository.category.errorT(location, e.toString());
                }
            }
            wsBackupM2 = new HashSet();
            wsBackupM2.addAll(connection.getConnectionSpec().getWorkspacesM2());
            connection.getConnectionSpec().getWorkspacesM2().clear();
            i = wsBackupM2.iterator();
            while (i.hasNext()) {
                w = (Workspace)i.next();
                try {
                    connection.getConnectionSpec().getWorkspacesM2().add(w.clone());
                }
                catch (CloneNotSupportedException e) {
                    Repository.category.errorT(location, e.toString());
                }
            }
        }
        ArrayList modelElements = null;
        ArrayList objects = null;
        if (task.getClass().getName().compareTo("com.sap.ip.mmr.db.tasks.TaskDeployToDB") != 0) {
            String sourcePath = (String)properties.get("srcpath");
            category.infoT(location, "runTask(IConnection connection,String classNameOfTask,Map properties))", MMRResourceAccessor.getInstance().getMessageText(connection, "1008"), new Object[]{classNameOfTask, sourcePath});
            if (sourcePath == null) {
                modelElements = (ArrayList)properties.get("collectionM2");
                objects = (ArrayList)properties.get("collectionM1");
            } else {
                String path;
                Iterator iter;
                String paths = (String)properties.get("classpath");
                if (paths != null) {
                    List list = Utilities.getUtilities().splitClassPath(paths);
                    iter = list.iterator();
                    while (iter.hasNext()) {
                        path = (String)iter.next();
                        ClassLoaderFactory.getClassLoaderFactory().getClassLoader(this, connection).addClassPath(path);
                        if (path.indexOf(".jar") >= 0) continue;
                        iter.remove();
                    }
                    PersistenceJarMulti pJar = this.getPersistenceJarMulti();
                    if (pJar != null) {
                        pJar.addClassPaths(connection, list);
                    }
                }
                List l = Utilities.getUtilities().splitClassPath(sourcePath);
                iter = l.iterator();
                while (iter.hasNext()) {
                    path = (String)iter.next();
                    File file = new File(path);
                    if (!file.exists()) {
                        category.errorT(location, "runTask(IConnection connection,String classNameOfTask,Map properties))", MMRResourceAccessor.getInstance().getMessageText(connection, "1004"), new Object[]{path, classNameOfTask});
                        continue;
                    }
                    if (file.isDirectory()) {
                        Workspace w;
                        Iterator iterW;
                        Collection c;
                        if (!(this.getRepositoryDB() instanceof PersistenceFSMultiWS)) continue;
                        PersistenceFSMultiWS p = (PersistenceFSMultiWS)this.getRepositoryDB();
                        try {
                            c = p.selectM2All(connection);
                            if (c != null && c.size() > 0) {
                                if (modelElements == null) {
                                    modelElements = new ArrayList();
                                }
                                modelElements.addAll(c);
                                iterW = connection.getConnectionSpec().getWorkspacesM2().iterator();
                                while (iterW.hasNext()) {
                                    w = (Workspace)iterW.next();
                                    this.getCacheM2(w.getName()).putAll(modelElements);
                                }
                            }
                        }
                        catch (BaseRuntimeException e) {
                            e.log();
                        }
                        catch (BaseException e) {
                            e.log();
                        }
                        try {
                            c = p.selectM1All(connection);
                            if (c == null || c.size() <= 0) continue;
                            if (objects == null) {
                                objects = new ArrayList();
                            }
                            objects.addAll(c);
                            iterW = connection.getConnectionSpec().getWorkspacesM1().iterator();
                            while (iterW.hasNext()) {
                                w = (Workspace)iterW.next();
                                this.getCacheM1(w.getName()).putAll(objects);
                            }
                            continue;
                        }
                        catch (BaseRuntimeException e) {
                            e.log();
                            continue;
                        }
                        catch (BaseException e) {
                            e.log();
                            continue;
                        }
                    }
                    ClassLoaderFactory.getClassLoaderFactory().getClassLoader(this, connection).addClassPath(sourcePath);
                    int idx = sourcePath.lastIndexOf(46);
                    if (idx < 0) {
                        category.errorT(location, "runTask(IConnection connection,String classNameOfTask,Map properties))", MMRResourceAccessor.getInstance().getMessageText(connection, "1005"), new Object[]{sourcePath, classNameOfTask});
                        return false;
                    }
                    if (sourcePath.substring(idx).compareTo(".jar") == 0) {
                        Collection c;
                        PersistenceJarMulti pJar = this.getPersistenceJarMulti();
                        pJar.addClassPath(connection, sourcePath);
                        if (pJar == null) continue;
                        try {
                            c = pJar.selectM2All(connection);
                            if (c != null && c.size() > 0) {
                                if (modelElements == null) {
                                    modelElements = new ArrayList();
                                }
                                modelElements.addAll(c);
                            }
                        }
                        catch (BaseRuntimeException e) {
                            e.log();
                        }
                        catch (BaseException e) {
                            e.log();
                        }
                        try {
                            c = pJar.selectM1All(connection);
                            if (c == null || c.size() <= 0) continue;
                            if (objects == null) {
                                objects = new ArrayList();
                            }
                            objects.addAll(c);
                        }
                        catch (BaseRuntimeException e) {
                            e.log();
                        }
                        catch (BaseException e) {
                            e.log();
                        }
                        continue;
                    }
                    modelElements = (Collection)properties.get("collectionM2");
                    objects = (Collection)properties.get("collectionM1");
                }
            }
        }
        if ((destPath = (String)properties.get("dstpath")) == null) {
            destPath = RepositoryServer.getRepositoryFS().getDirTempFiles();
            properties.put("dstpath", destPath);
        }
        Collection modelElementsDeleted = (Collection)properties.get("collectionM2Deleted");
        Collection objectsDeleted = (Collection)properties.get("collectionM1Deleted");
        boolean res = false;
        try {
            res = task.runTask(this, connection, modelElements, objects, modelElementsDeleted, objectsDeleted, properties);
        }
        catch (StackOverflowError e) {
            e.printStackTrace(System.err);
        }
        if (wsBackupM1 != null) {
            connection.getConnectionSpec().getWorkspacesM1().clear();
            connection.getConnectionSpec().getWorkspacesM1().addAll(wsBackupM1);
        }
        if (wsBackupM2 != null) {
            connection.getConnectionSpec().getWorkspacesM2().clear();
            connection.getConnectionSpec().getWorkspacesM2().addAll(wsBackupM2);
        }
        if (classNameOfTask.compareTo("com.sap.ip.mmr.db.tasks.TaskDeployToDB") == 0) {
            this.timeLastDeployment = Utilities.getUtilities().getTime();
            this.clearCaches();
        }
        return res;
    }

    protected PersistenceJarMulti getPersistenceJarMulti() {
        PersistenceJarMulti pJar = null;
        Iterator iter = this.pcsM2.iterator();
        while (iter.hasNext() && pJar == null) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            if (!(pc.getComponent() instanceof PersistenceJarMulti)) continue;
            pJar = (PersistenceJarMulti)pc.getComponent();
        }
        return pJar;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public Set getPersistenceComponent(String className) {
        PersistenceComponent pc;
        HashSet<IPersistence> s = new HashSet<IPersistence>();
        Iterator iter = this.pcsM1.iterator();
        while (iter.hasNext()) {
            pc = (PersistenceComponent)iter.next();
            if (pc.getComponent().getClass().getName().compareTo(className) != 0) continue;
            s.add(pc.getComponent());
        }
        iter = this.pcsM2.iterator();
        while (iter.hasNext()) {
            pc = (PersistenceComponent)iter.next();
            if (pc.getComponent().getClass().getName().compareTo(className) != 0) continue;
            s.add(pc.getComponent());
        }
        return s;
    }

    public HashMapBidirectional createHashMapBidirectional() {
        return new HashMapBidirectional();
    }

    public String createMofId() {
        return Repository.createMofId();
    }

    public byte[] loadJavaClass(String className) {
        byte[] data = null;
        IPersistence rdb = this.getRepositoryDB();
        if (rdb != null) {
            data = rdb.loadJavaClass(className);
        }
        return data;
    }

    public byte[] loadJavaClass(String className, Set workspaces) {
        byte[] data = null;
        IPersistence rdb = this.getRepositoryDB();
        if (rdb != null) {
            data = rdb.loadJavaClass(className, workspaces);
        }
        return data;
    }

    public Set getWorkspaces() {
        return null;
    }

    public String getMMRDBInformation(IConnection connection) {
        IPersistence rdb = this.getRepositoryDB();
        if (rdb != null && rdb instanceof IRepositoryDB) {
            return ((IRepositoryDB)rdb).getMMRDBInformation(connection);
        }
        return "No relational database available.";
    }

    public String getState() {
        PersistenceComponent pc;
        StringBuffer state = new StringBuffer();
        state.append("<p class=\"p.subhead-two\">");
        state.append("RepositoryServer instance: " + this.toString());
        state.append("</p>");
        state.append("<p>Instances was created at: ");
        state.append(Utilities.getUtilities().getTimeFormated(this.timeOfCreation));
        state.append("</p>");
        state.append("<p class=\"p.subhead-two\">Persistence Components Registered for Metadata (M1 layer)</p>");
        state.append("<table cellspacing=\"0\" cellpadding=\"5\" width=\"100%\">");
        Iterator<Object> iter = this.pcsM1.iterator();
        while (iter.hasNext()) {
            pc = (PersistenceComponent)iter.next();
            state.append("<tr>");
            state.append("<td>");
            state.append(pc.getComponent().toString());
            state.append("</td>");
            state.append("<td>");
            state.append(pc.getGuid());
            state.append("</td>");
            state.append("<td>");
            state.append(pc.getFilters());
            state.append("</td>");
            state.append("</tr>");
        }
        state.append("</table>");
        state.append("<p class=\"p.subhead-two\">Persistence Components registered for Metamodels (M2 layer)</p>");
        state.append("<table cellspacing=\"0\" cellpadding=\"5\" width=\"100%\">");
        iter = this.pcsM2.iterator();
        while (iter.hasNext()) {
            pc = (PersistenceComponent)iter.next();
            state.append("<tr>");
            state.append("<td>");
            state.append(pc.getComponent().toString());
            state.append("</td>");
            state.append("<td>");
            state.append(pc.getGuid());
            state.append("</td>");
            state.append("<td>");
            state.append(pc.getFilters());
            state.append("</td>");
            state.append("</tr>");
        }
        state.append("</table>");
        state.append("<p class=\"p.subhead-two\">Caches</p>");
        state.append("<p>Cached instances lifetime: " + Utilities.getUtilities().getTimeFormated(this.timeToLive) + "</p>");
        HashSet s = new HashSet();
        s.addAll(this.cacheM2.keySet());
        s.addAll(this.cacheM2Assoc.keySet());
        s.addAll(this.cacheM1.keySet());
        s.addAll(this.cacheM1Assoc.keySet());
        if (s.size() == 0) {
            state.append("<p>Caches are still empty.</p>");
        } else {
            state.append("<table cellspacing=\"0\" cellpadding=\"5\" width=\"100%\">");
            iter = s.iterator();
            while (iter.hasNext()) {
                String wsName = (String)iter.next();
                int size = 0;
                state.append("<tr>");
                state.append("<td>" + wsName + "</td>");
                state.append("<td>M2-layer instances:</td>");
                size = this.getCacheM2(wsName) != null ? this.getCacheM2(wsName).size() : 0;
                state.append("<td>" + size + "</td>");
                state.append("</tr>");
                state.append("<tr>");
                state.append("<td>" + wsName + "</td>");
                state.append("<td>M2-layer associations of instances:</td>");
                size = this.getCacheM2Assoc(wsName) != null ? this.getCacheM2Assoc(wsName).size() : 0;
                state.append("<td>" + size + "</td>");
                state.append("</tr>");
                state.append("<tr>");
                state.append("<td>" + wsName + "</td>");
                state.append("<td>M1-layer instances:</td>");
                size = this.getCacheM1(wsName) != null ? this.getCacheM1(wsName).size() : 0;
                state.append("<td>" + size + "</td>");
                state.append("</tr>");
                state.append("<tr>");
                state.append("<td>" + wsName + "</td>");
                state.append("<td>M1-layer associations of instances:</td>");
                size = this.getCacheM1Assoc(wsName) != null ? this.getCacheM1Assoc(wsName).size() : 0;
                state.append("<td>" + size + "</td>");
                state.append("</tr>");
            }
            state.append("</table>");
        }
        state.append("<p class=\"p.subhead-two\">Active connections to RepositoryServer</p>");
        state.append(ConnectionFactory.getConnectionsDescription());
        state.append("<p class=\"p.subhead-two\">Threads</p>");
        state.append("<table cellspacing=\"0\" cellpadding=\"5\" width=\"100%\">");
        state.append("\t<tr align=\"left\">");
        state.append("\t\t<th>");
        state.append("\t\t\tStatus");
        state.append("\t\t</th>");
        state.append("\t\t<th>");
        state.append("\t\t\tID");
        state.append("\t\t</th>");
        state.append("\t\t<th>");
        state.append("\t\t\tDescription");
        state.append("\t\t</th>");
        state.append("\t</tr>");
        iter = threads.values().iterator();
        while (iter.hasNext()) {
            ThreadInformation ti = (ThreadInformation)iter.next();
            state.append("\t<tr>");
            state.append("\t\t<td>");
            state.append("\t\t    " + ti.getStatus());
            state.append("\t\t</td>");
            state.append("\t\t<td>");
            state.append("\t\t   " + ti.getTuid());
            state.append("\t\t</td>");
            state.append("\t\t<td>");
            state.append("\t\t   " + ti.getDescription());
            state.append("\t\t</td>");
            state.append("\t</tr>");
        }
        state.append("</table>");
        return state.toString();
    }

    public boolean deregisterWorkspace(Workspace workspace, int mofLayer) {
        boolean done = false;
        switch (mofLayer) {
            case 1: {
                Iterator iter = this.pcsM1.iterator();
                while (iter.hasNext() && !done) {
                    PersistenceComponent pc = (PersistenceComponent)iter.next();
                    if (!pc.getComponent().deregisterWorkspace(workspace, mofLayer)) continue;
                    done = true;
                }
                break;
            }
            case 2: {
                Iterator iter = this.pcsM2.iterator();
                while (iter.hasNext() && !done) {
                    PersistenceComponent pc = (PersistenceComponent)iter.next();
                    if (pc.getComponent() != this.getRepositoryDB() || !pc.getComponent().deregisterWorkspace(workspace, mofLayer)) continue;
                    done = true;
                }
                break;
            }
        }
        return done;
    }

    public boolean registerWorkspace(Workspace workspace, int mofLayer) {
        String method = "registerWorkspace(Workspace workspace, int mofLayer)";
        location.entering("registerWorkspace(Workspace workspace, int mofLayer)");
        boolean done = false;
        switch (mofLayer) {
            case 1: {
                Iterator iter = this.pcsM1.iterator();
                while (iter.hasNext() && !done) {
                    PersistenceComponent pc = (PersistenceComponent)iter.next();
                    if (pc.getComponent() == this.getRepositoryDB() && pc.getComponent() instanceof PersistenceFSMultiWS && (workspace.getPath() == null || workspace.getPath().length() < 1) || !pc.getComponent().registerWorkspace(workspace, mofLayer)) continue;
                    pc.getWorkspacesAvailableM1().add(workspace);
                    done = true;
                }
                break;
            }
            case 2: {
                Iterator iter = this.pcsM2.iterator();
                while (iter.hasNext() && !done) {
                    PersistenceComponent pc = (PersistenceComponent)iter.next();
                    if (pc.getComponent() == this.getRepositoryDB() && pc.getComponent() instanceof PersistenceFSMultiWS && (workspace.getPath() == null || workspace.getPath().length() < 1) || !pc.getComponent().registerWorkspace(workspace, mofLayer)) continue;
                    pc.getWorkspacesAvailableM2().add(workspace);
                    done = true;
                }
                break;
            }
        }
        location.exiting("registerWorkspace(Workspace workspace, int mofLayer)");
        return done;
    }

    public Collection getWorkspaceAttributeDescriptions() {
        Collection c;
        PersistenceComponent pc;
        LinkedList col = new LinkedList();
        Iterator i = this.pcsM1.iterator();
        while (i.hasNext()) {
            pc = (PersistenceComponent)i.next();
            c = pc.getComponent().getWorkspaceAttributeDescriptions();
            if (c == null || c.size() <= 0) continue;
            col.addAll(c);
        }
        i = this.pcsM2.iterator();
        while (i.hasNext()) {
            pc = (PersistenceComponent)i.next();
            c = pc.getComponent().getWorkspaceAttributeDescriptions();
            if (c == null || c.size() <= 0) continue;
            col.addAll(c);
        }
        return col;
    }

    public void addThreadInformation(ThreadInformation threadInformation) {
        threads.put(threadInformation.getTuid(), threadInformation);
    }

    public ThreadInformation getThreadInformation(String tuid) {
        return (ThreadInformation)threads.get(tuid);
    }

    public ThreadInformation removeThreadInformation(String tuid) {
        return (ThreadInformation)threads.remove(tuid);
    }

    public Collection getThreadInformations() {
        LinkedList l = new LinkedList();
        l.addAll(threads.values());
        return l;
    }

    public boolean checkPersistence(IConnection connection) {
        PersistenceComponent pc;
        boolean flag = true;
        Iterator iter = this.pcsM2.iterator();
        while (iter.hasNext() && flag) {
            pc = (PersistenceComponent)iter.next();
            flag = pc.getComponent().checkPersistence(connection);
        }
        iter = this.pcsM1.iterator();
        while (iter.hasNext()) {
            pc = (PersistenceComponent)iter.next();
            flag = pc.getComponent().checkPersistence(connection);
        }
        return flag;
    }

    public boolean repairPersistence(IConnection connection) {
        PersistenceComponent pc;
        boolean flag = true;
        Iterator iter = this.pcsM2.iterator();
        while (iter.hasNext() && flag) {
            pc = (PersistenceComponent)iter.next();
            flag = pc.getComponent().repairPersistence(connection);
        }
        iter = this.pcsM1.iterator();
        while (iter.hasNext()) {
            pc = (PersistenceComponent)iter.next();
            flag = pc.getComponent().repairPersistence(connection);
        }
        return flag;
    }

    public long getTimeLastDeployment() {
        return this.timeLastDeployment;
    }

    public void workspaceContentHasChanged(IConnection connection, Workspace workspace) {
        this.clearAssociationCache(connection);
        HashSet set = new HashSet();
        set.addAll(this.pcsM1);
        set.addAll(this.pcsM2);
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            PersistenceComponent pc = (PersistenceComponent)iter.next();
            pc.getComponent().workspaceContentHasChanged(connection, workspace);
        }
    }

    private void clearAssociationCache(IConnection connection) {
        Cache cache;
        Workspace ws;
        List col = connection.getWorkspacesAvailableM1();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            ws = (Workspace)it.next();
            cache = this.getCacheM1Assoc(ws.getName());
            cache.clear();
        }
        col = connection.getWorkspacesAvailableM2();
        it = col.iterator();
        while (it.hasNext()) {
            ws = (Workspace)it.next();
            cache = this.getCacheM2Assoc(ws.getName());
            cache.clear();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        threads = new HashMap();
    }

    protected class PersistenceComponent {
        IPersistence component;
        List filters;
        List ownedMofPackages;
        List workspacesAvailableM1;
        List workspacesAvailableM2;
        String guid;

        public PersistenceComponent(IPersistence component, Collection filters) {
            this.component = component;
            this.filters = filters != null ? new LinkedList(filters) : new LinkedList();
            this.ownedMofPackages = new LinkedList();
            this.guid = Utilities.getUtilities().getGUID();
            this.workspacesAvailableM1 = component.getWorkspacesAvailableM1(null);
            this.workspacesAvailableM2 = component.getWorkspacesAvailableM2(null);
        }

        public IPersistence getComponent() {
            return this.component;
        }

        public List getOwnedMofPackages() {
            return this.ownedMofPackages;
        }

        public List getFilters() {
            return this.filters;
        }

        public String getGuid() {
            return this.guid;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(1024);
            sb.append("Persistence Component: " + this.component.getClass().getName());
            sb.append(Utilities.SystemLineSeparator);
            return sb.toString();
        }

        public List getWorkspacesAvailableM1() {
            return this.workspacesAvailableM1;
        }

        public List getWorkspacesAvailableM2() {
            return this.workspacesAvailableM2;
        }

        public boolean equals(Object arg0) {
            boolean flag = false;
            if (arg0 instanceof PersistenceComponent) {
                if (((PersistenceComponent)arg0).getGuid().compareTo(this.getGuid()) == 0) {
                    flag = true;
                }
            } else if (arg0 instanceof String && this.component.getClass().getName().compareTo((String)arg0) == 0) {
                flag = true;
            }
            return flag;
        }

        public int hashCode() {
            return this.getGuid().hashCode();
        }
    }

    protected class ThreadGC
    extends Thread {
        private RepositoryServer repositoryServer;

        public ThreadGC(RepositoryServer rs) {
            this.repositoryServer = rs;
        }

        public void run() {
            while (this.repositoryServer != null) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (this.isInterrupted()) break;
                if (this.repositoryServer == null) continue;
                this.repositoryServer.garbageCollector();
            }
        }

        public void destroy() {
            this.repositoryServer = null;
        }

        public void interrupt() {
            this.repositoryServer = null;
            super.interrupt();
        }

        public boolean isInterrupted() {
            this.repositoryServer = null;
            return super.isInterrupted();
        }

        public RepositoryServer getRepositoryServer() {
            return this.repositoryServer;
        }

        public void setRepositoryServer(RepositoryServer server) {
            this.repositoryServer = server;
        }
    }

    protected class TransactionController {
        private IConnection connection = null;

        public TransactionController(IConnection con) {
            this.connection = con;
        }

        public void transactionBegin(int mofLayer) {
            String method = "transactionBegin()";
            location.entering("transactionBegin()");
            location.logT(100, "transactionBegin()", MMRResourceAccessor.getInstance().getMessageText(this.connection, "1050"), new Object[]{this.connection, new Integer(0)});
            Iterator iter = RepositoryServer.this.getPCsOfConnection(mofLayer, true, this.connection).iterator();
            while (iter.hasNext()) {
                PersistenceComponent pc = (PersistenceComponent)iter.next();
                try {
                    pc.getComponent().transactionBegin(this.connection);
                }
                catch (BaseRuntimeException e) {
                    e.log();
                }
                catch (BaseException e) {
                    e.log();
                }
            }
            location.exiting();
        }

        public boolean transactionBeforeCommit(int mofLayer, Collection modelElementsInsert, Map modelElementsAssocInsert, Collection modelElementsDelete, Collection objectInsert, Map objectAssocInsert, Collection objectsDelete) {
            String method = "transactionCommit()";
            location.entering("transactionCommit()");
            boolean res = true;
            Iterator iter = RepositoryServer.this.getPCsOfConnection(mofLayer, true, this.connection).iterator();
            while (iter.hasNext() && res) {
                PersistenceComponent pc = (PersistenceComponent)iter.next();
                try {
                    res = pc.getComponent().transactionBeforeCommit(this.connection, modelElementsInsert, modelElementsAssocInsert, modelElementsDelete, objectInsert, objectAssocInsert, objectsDelete);
                }
                catch (Exception e) {
                    RepositoryServer.writeExceptionToCategory(RepositoryServer.getMethodNamePc(pc, "transactionCommit()"), e);
                }
            }
            location.exiting();
            return res;
        }

        public void transactionCommit(int mofLayer) {
            String method = "transactionCommit()";
            location.entering("transactionCommit()");
            location.logT(100, "transactionCommit()", MMRResourceAccessor.getInstance().getMessageText(this.connection, "1053"), new Object[]{this.connection, new Integer(0)});
            Iterator iter = RepositoryServer.this.getPCsOfConnection(mofLayer, true, this.connection).iterator();
            while (iter.hasNext()) {
                PersistenceComponent pc = (PersistenceComponent)iter.next();
                try {
                    pc.getComponent().transactionCommit(this.connection);
                }
                catch (BaseRuntimeException e) {
                    e.log();
                }
                catch (BaseException e) {
                    e.log();
                }
            }
            location.exiting();
        }

        public void transactionRollback(int mofLayer) {
            String method = "transactionRollback()";
            location.entering("transactionRollback()");
            location.logT(100, "transactionRollback()", MMRResourceAccessor.getInstance().getMessageText(this.connection, "1053"), new Object[]{this.connection, new Integer(0)});
            Iterator iter = RepositoryServer.this.getPCsOfConnection(mofLayer, true, this.connection).iterator();
            while (iter.hasNext()) {
                PersistenceComponent pc = (PersistenceComponent)iter.next();
                try {
                    pc.getComponent().transactionRollback(this.connection);
                }
                catch (BaseRuntimeException e) {
                    e.log();
                }
                catch (BaseException e) {
                    e.log();
                }
            }
            location.exiting();
        }
    }
}

