/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.generation.console;

import com.sap.ide.generationfwk.naming.NamingGenerationUnitFile;
import com.sap.ide.generationfwk.naming.NamingServiceBase;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.general.exception.ValidationException;
import com.sap.ide.metamodel.general.i18n.I18NService;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.project.ProjectProperties;
import com.sap.ide.webdynpro.checklayer.CheckResult;
import com.sap.ide.webdynpro.checklayer.out.ConsoleManager;
import com.sap.ide.webdynpro.generation.Generation;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class GenerationConsole
extends Generation {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$ide$webdynpro$generation$console$GenerationConsole == null ? (class$com$sap$ide$webdynpro$generation$console$GenerationConsole = GenerationConsole.class$("com.sap.ide.webdynpro.generation.console.GenerationConsole")) : class$com$sap$ide$webdynpro$generation$console$GenerationConsole).getName());
    public static final String COMMAND_PARAMETER_CFG_FILE = "-cfgfile";
    public static final String COMMAND_PARAMETER_HELP = "-help";
    public static final String COMMAND_PARAMETER_TEST = "-test";
    public static final String COMMAND_PARAMETER_SOURCEPATH = "-sourcepath";
    public static final String COMMAND_PARAMETER_TARGETPATH = "-d";
    public static final String COMMAND_PARAMETER_PACKAGE = "-package";
    public static final String COMMAND_PARAMETER_ARCHIVE_NAME = "-archivename";
    public static final String COMMAND_PARAMETER_COMPONENT = "-component";
    public static final String COMMAND_PARAMETER_COMPONENT_INTERFACE_DEFINITION = "-componentifdefinition";
    public static final String COMMAND_PARAMETER_DEPLOYMENT = "-deployment";
    public static final String COMMAND_PARAMETER_DC_NAME = "-dcname";
    public static final String COMMAND_PARAMETER_MODEL = "-model";
    public static final String COMMAND_PARAMETER_NO_CHECK = "-nocheck";
    public static final String COMMAND_PARAMETER_NO_FOLDER_STRUCTURE = "-nofolderstructure";
    public static final String COMMAND_PARAMETER_ADDPATHS = "-addpaths";
    public static final String COMMAND_PARAMETER_LANGUAGE = "-language";
    public static final String COMMAND_PARAMETER_VENDOR = "-vendor";
    public static final String COMMAND_PARAMETER_JARM_LEVEL = "-jarm";
    public static final String PARAMETER_VALUE_ALL = "+";
    private String mCfgFile = "WebDynproGenerationConfiguration.xml";
    private String mSourcePath = "";
    private String mPackage = "";
    private String mArchiveName = "";
    private String mComponent = "";
    private String mComponentInterfaceDefinition = "";
    private String mModel = "";
    private boolean mNoCheck = false;
    private boolean mNoFolderStructure = false;
    private boolean mDeployment = false;
    private String mDcName = "";
    private String mAddPaths = "";
    private String mLanguage = "";
    private String mVendor = "";
    private boolean mHelp = false;
    private WebDynproRoot mWebDynproRoot = null;
    private DtDictionaryRoot mDictionaryRoot = null;
    static /* synthetic */ Class class$com$sap$ide$webdynpro$generation$console$GenerationConsole;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$WebDynproRoot;
    static /* synthetic */ Class class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot;

    private GenerationConsole() {
        this(1);
    }

    protected GenerationConsole(int environment) {
        this(environment, "WebDynproGenerationConfiguration.xml");
    }

    protected GenerationConsole(int environment, String templateConfigurationFile) {
        super(environment, templateConfigurationFile);
    }

    public static void main(String[] args) {
        long lStaringTime = System.currentTimeMillis();
        GenerationConsole lGenerator = new GenerationConsole();
        lGenerator.generate(args);
        long lEndingTime = System.currentTimeMillis();
        if (Generation.isErrorIndicator()) {
            lGenerator.printMessage(2, "Generation failed due to errors (" + (lEndingTime - lStaringTime) / 1000L + " seconds)");
        } else {
            lGenerator.printMessage(1, "Generation finished (" + (lEndingTime - lStaringTime) / 1000L + " seconds)");
        }
        lGenerator.cleanup();
    }

    protected final void generate(String[] args) {
        this.setIncremental(false);
        this.setErrorIndicator(false);
        this.scanCommandLine(args);
        if (this.isHelp()) {
            this.printHelp();
            return;
        }
        this.getNamingService().isFolderStructure(!this.isNoFolderStructure());
        try {
            block15: {
                try {
                    int i;
                    this.refreshConfiguration();
                    if (this.getComponent() != null && this.getComponent().length() > 0) {
                        this.createWebDynproRoot(this.getSourcePath(), this.getAddPaths());
                        Component[] lComponents = this.instantiateComponents();
                        if (lComponents != null && lComponents.length > 0) {
                            i = 0;
                            while (i < lComponents.length) {
                                this.generatePersistentComponent(lComponents[i], !this.isNoCheck());
                                ++i;
                            }
                        }
                    }
                    if (this.getComponentInterfaceDefinition() != null && this.getComponentInterfaceDefinition().length() > 0) {
                        this.createWebDynproRoot(this.getSourcePath(), this.getAddPaths());
                        ComponentInterfaceDefinition[] lComponentInterfaceDefinitions = this.instantiateComponentInterfaceDefinitions();
                        if (lComponentInterfaceDefinitions != null && lComponentInterfaceDefinitions.length > 0) {
                            i = 0;
                            while (i < lComponentInterfaceDefinitions.length) {
                                this.generatePersistentComponentInterfaceDefinition(lComponentInterfaceDefinitions[i], !this.isNoCheck());
                                ++i;
                            }
                        }
                    }
                    if (this.getModel() != null && this.getModel().length() > 0) {
                        this.createWebDynproRoot(this.getSourcePath(), this.getAddPaths());
                        Model[] lModels = this.instantiateModels();
                        if (lModels != null && lModels.length > 0) {
                            i = 0;
                            while (i < lModels.length) {
                                this.generatePersistentModel(lModels[i], !this.isNoCheck());
                                ++i;
                            }
                        }
                    }
                    if (!this.isDeployment()) break block15;
                    this.createWebDynproRoot(this.getSourcePath(), this.getAddPaths());
                    ProjectProperties lProjectProperties = null;
                    if (this.getWebDynproRoot().getAllProjectProperties().length > 0) {
                        lProjectProperties = this.getWebDynproRoot().getAllProjectProperties()[0];
                    }
                    this.generatePersistentArchive(this.getArchiveName(), this.getVendor(), this.getDcName(), lProjectProperties, this.getWebDynproRoot().getApplications(), this.getWebDynproRoot().getModels(), this.getWebDynproRoot().getComponents(), this.getWebDynproRoot().getComponentInterfaceDefinitions(), this.getDictionaryRoot().getSimpleTypes(), this.getDictionaryRoot().getStructures(), this.getLanguages(this.getLanguage()), !this.isNoCheck());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    TRACE_LOCATION.catching((Throwable)ex);
                    this.printMessage(2, "Unknown exception during generation " + ex.getMessage() + " (" + ex.toString() + ")");
                    Object var5_6 = null;
                    this.shutDownMetamodel();
                }
            }
            Object var5_5 = null;
            this.shutDownMetamodel();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.shutDownMetamodel();
            throw throwable;
        }
    }

    private void shutDownMetamodel() {
        if (this.getWebDynproRoot() != null) {
            try {
                this.getWebDynproRoot().getMetamodel().shutDown();
            }
            catch (Exception e) {
                TRACE_LOCATION.catching((Throwable)e);
                e.printStackTrace();
            }
            this.setWebDynproRoot(null);
        }
        if (!I18NService.getInstance().isCodepageValidationEnabled()) {
            I18NService.getInstance().enableCodepageValidation();
        }
    }

    private Component[] instantiateComponents() {
        if (this.getWebDynproRoot() == null) {
            return new Component[0];
        }
        Component[] lComponents = new Component[]{};
        try {
            if (this.getPackage().trim().equals(PARAMETER_VALUE_ALL) && this.getComponent().trim().equals(PARAMETER_VALUE_ALL)) {
                Component[] lAllComponents = this.getWebDynproRoot().getComponents();
                ArrayList<Component> lSourceObjectList = new ArrayList<Component>();
                int i = 0;
                while (i < lAllComponents.length) {
                    if (!lAllComponents[i].originatesInArchive()) {
                        lSourceObjectList.add(lAllComponents[i]);
                    }
                    ++i;
                }
                lComponents = new Component[lSourceObjectList.size()];
                lComponents = lSourceObjectList.toArray(lComponents);
            } else {
                lComponents = this.getComponent().trim().equals(PARAMETER_VALUE_ALL) ? this.getWebDynproRoot().getComponents(this.getPackage()) : new Component[]{this.getWebDynproRoot().getComponent(this.getPackage(), this.getComponent())};
            }
        }
        catch (LoadException ex) {
            this.printMessage(2, "Component " + this.getComponent() + " could not be instantiated by the MetadataAPI, " + ex.getMessage() + "\n    sourcepath: " + this.getSourcePath() + "\n    package:    " + this.getPackage() + "\n    cause:      " + ex.getCause());
            return null;
        }
        int i = 0;
        while (i < lComponents.length) {
            if (lComponents[i] == null) {
                this.printMessage(2, "Component " + this.getComponent() + " could not be instantiated by the MetadataAPI");
                return null;
            }
            try {
                lComponents[i].validate();
            }
            catch (ValidationException e) {
                this.printMessage(3, "Metadata of component " + lComponents[i].getName() + " is not valid! " + e.getMessage());
            }
            ++i;
        }
        return lComponents;
    }

    private Model[] instantiateModels() {
        if (this.getWebDynproRoot() == null) {
            return new Model[0];
        }
        Model[] lModels = new Model[]{};
        try {
            if (this.getPackage().trim().equals(PARAMETER_VALUE_ALL) && this.getModel().trim().equals(PARAMETER_VALUE_ALL)) {
                Model[] lAllModels = this.getWebDynproRoot().getModels();
                ArrayList<Model> lSourceObjectList = new ArrayList<Model>();
                int i = 0;
                while (i < lAllModels.length) {
                    if (!lAllModels[i].originatesInArchive()) {
                        lSourceObjectList.add(lAllModels[i]);
                    }
                    ++i;
                }
                lModels = new Model[lSourceObjectList.size()];
                lModels = lSourceObjectList.toArray(lModels);
            } else {
                lModels = this.getModel().trim().equals(PARAMETER_VALUE_ALL) ? this.getWebDynproRoot().getModels(this.getPackage()) : new Model[]{this.getWebDynproRoot().getModel(this.getPackage(), this.getModel())};
            }
        }
        catch (LoadException ex) {
            this.printMessage(2, "Model " + this.getModel() + " could not be instantiated by the MetadataAPI, " + ex.getMessage() + "\n    sourcepath: " + this.getSourcePath() + "\n    package:    " + this.getPackage() + "\n    cause:      " + ex.getCause());
            return null;
        }
        int i = 0;
        while (i < lModels.length) {
            if (lModels[i] == null) {
                this.printMessage(2, "Model " + this.getModel() + " could not be instantiated by the MetadataAPI");
            } else {
                try {
                    lModels[i].validate();
                }
                catch (ValidationException e) {
                    this.printMessage(3, "Metadata of model " + lModels[i].getName() + " is not valid! " + e.getMessage());
                }
            }
            ++i;
        }
        return lModels;
    }

    private ComponentInterfaceDefinition[] instantiateComponentInterfaceDefinitions() {
        if (this.getWebDynproRoot() == null) {
            return new ComponentInterfaceDefinition[0];
        }
        ComponentInterfaceDefinition[] lComponentInterfaceDefinitions = new ComponentInterfaceDefinition[]{};
        try {
            if (this.getPackage().trim().equals(PARAMETER_VALUE_ALL) && this.getComponentInterfaceDefinition().trim().equals(PARAMETER_VALUE_ALL)) {
                ComponentInterfaceDefinition[] lAllComponentInterfaceDefinitions = this.getWebDynproRoot().getComponentInterfaceDefinitions();
                ArrayList<ComponentInterfaceDefinition> lSourceObjectList = new ArrayList<ComponentInterfaceDefinition>();
                int i = 0;
                while (i < lAllComponentInterfaceDefinitions.length) {
                    if (!lAllComponentInterfaceDefinitions[i].originatesInArchive()) {
                        lSourceObjectList.add(lAllComponentInterfaceDefinitions[i]);
                    }
                    ++i;
                }
                lComponentInterfaceDefinitions = new ComponentInterfaceDefinition[lSourceObjectList.size()];
                lComponentInterfaceDefinitions = lSourceObjectList.toArray(lComponentInterfaceDefinitions);
            } else {
                lComponentInterfaceDefinitions = this.getComponentInterfaceDefinition().trim().equals(PARAMETER_VALUE_ALL) ? this.getWebDynproRoot().getComponentInterfaceDefinitions(this.getPackage()) : new ComponentInterfaceDefinition[]{this.getWebDynproRoot().getComponentInterfaceDefinition(this.getPackage(), this.getComponentInterfaceDefinition())};
            }
        }
        catch (LoadException ex) {
            this.printMessage(2, "ComponentInterfaceDefinition " + this.getComponentInterfaceDefinition() + " could not be instantiated by the MetadataAPI, " + ex.getMessage() + "\n    sourcepath: " + this.getSourcePath() + "\n    package:    " + this.getPackage() + "\n    cause:      " + ex.getCause());
            return null;
        }
        int i = 0;
        while (i < lComponentInterfaceDefinitions.length) {
            if (lComponentInterfaceDefinitions[i] == null) {
                this.printMessage(2, "ComponentInterfaceDefinition " + this.getComponentInterfaceDefinition() + " could not be instantiated by the MetadataAPI");
                return null;
            }
            try {
                lComponentInterfaceDefinitions[i].validate();
            }
            catch (ValidationException e) {
                this.printMessage(3, "Metadata of component " + lComponentInterfaceDefinitions[i].getName() + " is not valid! " + e.getMessage());
            }
            ++i;
        }
        return lComponentInterfaceDefinitions;
    }

    private void scanCommandLine(String[] args) {
        if (args == null || args.length == 0) {
            this.setHelp(true);
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_HELP)) {
                this.setHelp(true);
                return;
            }
            if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_CFG_FILE)) {
                this.setCfgFile(args[++i]);
                this.getGenerationConfiguration().setConfigurationFile(this.getCfgFile());
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_TEST)) {
                this.setTestMode(true);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_SOURCEPATH)) {
                File lSourceDirectory;
                if (!(lSourceDirectory = new File(args[++i])).exists() || !lSourceDirectory.isDirectory()) {
                    this.printMessage(2, "Source directory " + lSourceDirectory.toString() + " does not exist");
                } else {
                    this.setSourcePath(lSourceDirectory.toString());
                }
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_TARGETPATH)) {
                File lTargetDirectory;
                if (!(lTargetDirectory = new File(args[++i])).exists()) {
                    this.printMessage(1, "Destination directory " + lTargetDirectory.toString() + " does not exist");
                    if (lTargetDirectory.mkdirs()) {
                        this.setTargetPath(lTargetDirectory.toString());
                        this.printMessage(1, "Destination directory " + lTargetDirectory.toString() + " is created");
                    } else {
                        this.setTargetPath(new File(".").toString());
                        this.printMessage(1, "Set local destination directory " + lTargetDirectory.toString());
                    }
                } else if (!lTargetDirectory.isDirectory()) {
                    this.printMessage(1, "Destination directory " + lTargetDirectory.toString() + " is not a directory");
                    this.setTargetPath(new File(".").toString());
                    this.printMessage(1, "Set local destination directory " + lTargetDirectory.toString());
                } else {
                    this.setTargetPath(lTargetDirectory.toString());
                }
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_PACKAGE)) {
                this.setPackage(args[++i]);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_ARCHIVE_NAME)) {
                this.setArchiveName(args[++i]);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_COMPONENT)) {
                this.setComponent(args[++i]);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_MODEL)) {
                this.setModel(args[++i]);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_NO_CHECK)) {
                this.setNoCheck(true);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_NO_FOLDER_STRUCTURE)) {
                this.setNoFolderStructure(true);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_COMPONENT_INTERFACE_DEFINITION)) {
                this.setComponentInterfaceDefinition(args[++i]);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_DEPLOYMENT)) {
                this.setDeployment(true);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_VENDOR)) {
                this.setVendor(args[++i]);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_DC_NAME)) {
                this.setDcName(args[++i]);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_ADDPATHS)) {
                this.setAddPaths(args[++i]);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_LANGUAGE)) {
                this.setLanguage(args[++i]);
            } else if (args[i].equalsIgnoreCase(COMMAND_PARAMETER_JARM_LEVEL)) {
                this.setJarmLevel(Integer.parseInt(args[++i]));
            } else if (args[i].startsWith("-")) {
                this.printMessage(2, "Illegal option " + args[i]);
            }
            ++i;
        }
        if (this.getSourcePath() == null || this.getSourcePath().length() == 0) {
            this.printMessage(1, "Set destination directory " + this.getTargetPath() + " as source directory");
            this.setSourcePath(this.getTargetPath());
        }
        if (!(this.getPackage() != null && this.getPackage().length() != 0 || this.getComponent() != null && this.getComponent().length() != 0 || this.getComponentInterfaceDefinition() != null && this.getComponentInterfaceDefinition().length() != 0 || this.getModel() != null && this.getModel().length() != 0)) {
            this.setPackage(PARAMETER_VALUE_ALL);
            this.setComponent(PARAMETER_VALUE_ALL);
            this.setComponentInterfaceDefinition(PARAMETER_VALUE_ALL);
            this.setModel(PARAMETER_VALUE_ALL);
        }
        if (this.isTestMode()) {
            this.printCommandParameters();
        }
    }

    public final void printCommandParameters() {
        this.printMessage(1, "");
        this.printMessage(1, "test ouput: command parameters");
        this.printMessage(1, "  -cfgfile               : " + this.getCfgFile());
        this.printMessage(1, "  -sourcepath            : " + this.getSourcePath());
        this.printMessage(1, "  -d                     : " + this.getTargetPath());
        this.printMessage(1, "  -package               : " + this.getPackage());
        this.printMessage(1, "  -component             : " + this.getComponent());
        this.printMessage(1, "  -componentifdefinition : " + this.getComponentInterfaceDefinition());
        this.printMessage(1, "  -model                 : " + this.getModel());
        this.printMessage(1, "  -deployment            : " + this.isDeployment());
        this.printMessage(1, "  -archivename           : " + this.getArchiveName());
        this.printMessage(1, "  -vendor                : " + this.getVendor());
        this.printMessage(1, "  -dcname                : " + this.getDcName());
        this.printMessage(1, "  -addpaths              : " + this.getAddPaths());
        this.printMessage(1, "  -language              : " + this.getLanguage());
        this.printMessage(1, "  -jarm                  : " + this.getJarmLevel());
        this.printMessage(1, "");
    }

    public final void printHelp() {
        this.printMessage(1, "");
        this.printMessage(1, "usage: java com.sap.ide.webdynpro.generation.GenerationConsole [-cfgfile <file>] [-help] [-test] -sourcepath <dir> -d <dir> [-package <java package>] [-component <componentName>] [-componentifdefinition <componentIfDefinitionName>] [-deployment] [-archivename <archiveName>] [-vendor <vendor>] [-dcname <dcName>] [-model <modelName>] [-addpaths <dir1>;<dir2>] [-language <language1;<language2>]");
        this.printMessage(1, "");
        this.printMessage(1, "  -help                      display this message");
        this.printMessage(1, "  -test                      test mode");
        this.printMessage(1, "  -jarm       <level>        jarm instrumentation level (0,1, ... 10)");
        this.printMessage(1, "");
        this.printMessage(1, "  -cfgfile    <file>         generation configuration file");
        this.printMessage(1, "  -sourcepath <dir>          directory where design time repository files can be found");
        this.printMessage(1, "  -d          <dir>          directory where java files will be generated");
        this.printMessage(1, "  -package    <pkg>          root package");
        this.printMessage(1, "  -addpaths   <dir1>;<dir2>  list of directories or archive paths where metamodel content is located (separated by semikolon)");
        this.printMessage(1, "  -language   <language>     language of texts");
        this.printMessage(1, "");
        this.printMessage(1, "  -component              <componentName>              Web Dynpro component name");
        this.printMessage(1, "  -componentifdefinition  <componentIfDefinitionName>  Web Dynpro component interface definition name");
        this.printMessage(1, "  -model                  <modelName>                  Web Dynpro model name");
        this.printMessage(1, "");
        this.printMessage(1, "  -deployment                 requests generation of deployment information");
        this.printMessage(1, "  -vendor      <vendor>       vendor name");
        this.printMessage(1, "  -archivename <archiveName>  name of deployable archive");
        this.printMessage(1, "  -dcname      <dcName>       name of development component");
        this.printMessage(1, "");
        this.printMessage(1, "Example: java GenerationConsole -sourcepath c:/myApplProject/src  -d c:/myAppl   -package com.sap.test.app   -application myAppl");
        this.printMessage(1, "Example: java GenerationConsole -sourcepath c:/myCompProject/src  -d c:/myComp   -package com.sap.test.app   -component   myComponent -language en;fr");
        this.printMessage(1, "Example: java GenerationConsole -sourcepath c:/myModelProject/src -d c:/myModel  -package com.sap.test.model -model       myModel     -language de");
        this.printMessage(1, "Example: java GenerationConsole -sourcepath c:/myModelProject/src -d c:/myDeploy -deployment -vendor sap.com -archivename sap.com~bwsp~mywd -language de;fr");
        this.printMessage(1, "");
    }

    private void setCfgFile(String cfgFile) {
        this.mCfgFile = cfgFile == null || cfgFile.length() == 0 ? "WebDynproGenerationConfiguration.xml" : cfgFile;
    }

    public final String getCfgFile() {
        return this.mCfgFile;
    }

    private void setSourcePath(String sourcePath) {
        this.mSourcePath = sourcePath == null ? "" : NamingServiceBase.getNormalizedFileName((String)sourcePath);
    }

    public final String getSourcePath() {
        return this.mSourcePath;
    }

    private void setPackage(String packageName) {
        this.mPackage = packageName == null ? "" : packageName;
    }

    public final String getPackage() {
        return this.mPackage;
    }

    private void setArchiveName(String archiveName) {
        this.mArchiveName = archiveName == null ? "" : archiveName;
    }

    public final String getArchiveName() {
        return this.mArchiveName;
    }

    private void setVendor(String vendor) {
        this.mVendor = vendor == null ? "" : vendor;
    }

    public final String getVendor() {
        return this.mVendor;
    }

    private void setDcName(String dcName) {
        this.mDcName = dcName == null ? "" : dcName;
    }

    public final String getDcName() {
        return this.mDcName;
    }

    private void setLanguage(String language) {
        this.mLanguage = language == null ? "" : language;
    }

    public final String getLanguage() {
        return this.mLanguage;
    }

    private void setAddPaths(String addPaths) {
        this.mAddPaths = addPaths == null ? "" : addPaths;
    }

    public final String getAddPaths() {
        return this.mAddPaths;
    }

    private void setComponent(String componentName) {
        this.mComponent = componentName == null ? "" : componentName;
    }

    public final String getComponent() {
        return this.mComponent;
    }

    private void setModel(String modelName) {
        this.mModel = modelName == null ? "" : modelName;
    }

    public final String getModel() {
        return this.mModel;
    }

    private void setComponentInterfaceDefinition(String componentInterfaceDefinition) {
        this.mComponentInterfaceDefinition = componentInterfaceDefinition == null ? "" : componentInterfaceDefinition;
    }

    public final String getComponentInterfaceDefinition() {
        return this.mComponentInterfaceDefinition;
    }

    public final boolean isDeployment() {
        return this.mDeployment;
    }

    private void setDeployment(boolean deployment) {
        this.mDeployment = deployment;
    }

    public final boolean isHelp() {
        return this.mHelp;
    }

    private void setHelp(boolean help) {
        this.mHelp = help;
    }

    public final boolean isNoCheck() {
        return this.mNoCheck;
    }

    private void setNoCheck(boolean noCheck) {
        this.mNoCheck = noCheck;
    }

    public final boolean isNoFolderStructure() {
        return this.mNoFolderStructure;
    }

    private void setNoFolderStructure(boolean noFolderStructure) {
        this.mNoFolderStructure = noFolderStructure;
    }

    private WebDynproRoot createWebDynproRoot(String rootPath, String addPaths) {
        if (this.getWebDynproRoot() == null) {
            try {
                I18NService.getInstance().disableCodepageValidation();
                Metamodel lMetamodel = new Metamodel("WebDynpro", rootPath, GenerationConsole.getAdditionalPaths(addPaths));
                String[] lAddArchives = GenerationConsole.getAdditionalArchivePaths(addPaths);
                int i = 0;
                while (i < lAddArchives.length) {
                    lMetamodel.addArchive(lAddArchives[i]);
                    ++i;
                }
                this.setWebDynproRoot((WebDynproRoot)lMetamodel.createRoot(class$com$sap$ide$metamodel$webdynpro$WebDynproRoot == null ? (class$com$sap$ide$metamodel$webdynpro$WebDynproRoot = GenerationConsole.class$("com.sap.ide.metamodel.webdynpro.WebDynproRoot")) : class$com$sap$ide$metamodel$webdynpro$WebDynproRoot));
                this.setDictionaryRoot((DtDictionaryRoot)lMetamodel.createRoot(class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot == null ? (class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot = GenerationConsole.class$("com.sap.ide.metamodel.dictionary.DtDictionaryRoot")) : class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot));
            }
            catch (MetamodelException e) {
                this.printMessage(2, "Could not initialize WebDynpro root, " + e.getMessage() + "\n    rootpath: " + this.getSourcePath());
            }
        }
        return this.getWebDynproRoot();
    }

    private static String[] splitParameterListString(String parameterList) {
        StringTokenizer lTokenizer = new StringTokenizer(parameterList, "\"';,", false);
        ArrayList<String> lParameterArrayList = new ArrayList<String>();
        while (lTokenizer.hasMoreTokens()) {
            lParameterArrayList.add(lTokenizer.nextToken().trim());
        }
        String[] lParameterList = new String[]{};
        return lParameterArrayList.toArray(lParameterList);
    }

    private static String[] getAdditionalPaths(String addPaths) {
        String[] lAddPaths = GenerationConsole.splitParameterListString(addPaths);
        ArrayList<String> lPathsArrayList = new ArrayList<String>();
        int i = 0;
        while (i < lAddPaths.length) {
            if (!lAddPaths[i].toLowerCase().endsWith(".jar") && !lAddPaths[i].toLowerCase().endsWith(".zip")) {
                lPathsArrayList.add(lAddPaths[i]);
            }
            ++i;
        }
        lAddPaths = new String[lPathsArrayList.size()];
        return lPathsArrayList.toArray(lAddPaths);
    }

    private static String[] getAdditionalArchivePaths(String addPaths) {
        String[] lAddArchives = GenerationConsole.splitParameterListString(addPaths);
        ArrayList<String> lArchivesArrayList = new ArrayList<String>();
        int i = 0;
        while (i < lAddArchives.length) {
            if (lAddArchives[i].toLowerCase().endsWith(".jar") || lAddArchives[i].toLowerCase().endsWith(".zip")) {
                lArchivesArrayList.add(lAddArchives[i]);
            }
            ++i;
        }
        lAddArchives = new String[lArchivesArrayList.size()];
        return lArchivesArrayList.toArray(lAddArchives);
    }

    private String[] getLanguages(String languages) {
        String[] lLanguagesList = GenerationConsole.splitParameterListString(languages);
        if (lLanguagesList == null) {
            lLanguagesList = new String[]{};
        }
        return lLanguagesList;
    }

    private WebDynproRoot getWebDynproRoot() {
        return this.mWebDynproRoot;
    }

    private void setWebDynproRoot(WebDynproRoot webDynproRoot) {
        this.mWebDynproRoot = webDynproRoot;
    }

    private DtDictionaryRoot getDictionaryRoot() {
        return this.mDictionaryRoot;
    }

    private void setDictionaryRoot(DtDictionaryRoot dictionaryRoot) {
        this.mDictionaryRoot = dictionaryRoot;
    }

    protected final boolean isGeneration(DevelopmentObject devObject) {
        return !devObject.getMDO().originatesInArchive();
    }

    protected void showCheckResult(CheckResult checkResult) {
        super.showCheckResult(checkResult);
        ConsoleManager.showCheckResults((CheckResult)checkResult);
    }

    protected final String getGenerationUnitDisplayName(NamingGenerationUnitFile naming) {
        String lTargetPath = NamingServiceBase.getNormalizedFileName((String)this.getTargetPath());
        String lFilePath = NamingServiceBase.getNormalizedFileName((String)naming.getAbsoluteFilePath());
        if (lTargetPath == null || lTargetPath.length() == 0) {
            return lFilePath;
        }
        if (lFilePath.startsWith(lTargetPath)) {
            return lFilePath.substring(lTargetPath.length() + 1);
        }
        return lFilePath;
    }

    protected void cleanup() {
        super.cleanup();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

