/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.webdynpro.basesrvc.util;

import com.sap.exception.BaseRuntimeException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;
import java.util.Stack;

public abstract class StringUtil {
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public static final String concat(String[] strings, String separator) {
        if (strings == null) {
            return null;
        }
        return StringUtil.concat(strings, separator, strings.length);
    }

    public static final String concat(Object[] objects, String separator, int length) {
        if (objects == null) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        if (objects.length < length) {
            throw new IllegalArgumentException("Length " + length + " is larger than array size " + objects.length);
        }
        StringBuffer buffer = new StringBuffer(256);
        int i = 0;
        while (i < length) {
            if (i > 0) {
                buffer.append(separator);
            }
            buffer.append(StringUtil.toString(objects[i]));
            ++i;
        }
        return buffer.toString();
    }

    public static final boolean equalsIgnoreLeadingZeroes(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null ^ s2 == null) {
            return false;
        }
        return StringUtil.trimLeadingZeroes(s1, 0).equals(StringUtil.trimLeadingZeroes(s2, 0));
    }

    public static final String escapeJavaIdentifier(String text) {
        StringBuffer buffer = new StringBuffer("ID_");
        int length = text.length();
        int i = 0;
        while (i < length) {
            char character = text.charAt(i);
            if (StringUtil.needsJavaIdEscaping(character)) {
                buffer.append('_');
                buffer.append(Integer.toHexString(character));
                buffer.append('_');
            } else {
                buffer.append(character);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static final String escapeString(String text) {
        if (StringUtil.isEmpty(text)) {
            return "";
        }
        StringBuffer buffer = null;
        int i = 0;
        while (i < text.length()) {
            char character = text.charAt(i);
            String escapedCharacter = StringUtil.escapeChar(character);
            if (escapedCharacter != null) {
                if (buffer == null) {
                    buffer = new StringBuffer(2 * text.length());
                    int j = 0;
                    while (j < i) {
                        buffer.append(text.charAt(j));
                        ++j;
                    }
                }
                buffer.append(escapedCharacter);
            } else if (buffer != null) {
                buffer.append(character);
            }
            ++i;
        }
        return buffer == null ? text : buffer.toString();
    }

    public static final String format(Object value, Format format) {
        if (value == null) {
            return "";
        }
        if (format != null) {
            return format.format(value);
        }
        return value.toString();
    }

    public static final Format getFormatFor(Class type, Locale locale) {
        if (!StringUtil.isEditableType(type) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = StringUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean) == type || Boolean.TYPE == type || (class$java$lang$Character == null ? (class$java$lang$Character = StringUtil.class$("java.lang.Character")) : class$java$lang$Character) == type || Character.TYPE == type || (class$java$lang$String == null ? (class$java$lang$String = StringUtil.class$("java.lang.String")) : class$java$lang$String) == type) {
            return null;
        }
        if ((class$java$util$Date == null ? (class$java$util$Date = StringUtil.class$("java.util.Date")) : class$java$util$Date) == type) {
            DateFormat format = DateFormat.getDateTimeInstance(2, 3, locale);
            format.setLenient(false);
            return format;
        }
        return NumberFormat.getNumberInstance(locale);
    }

    public static final boolean isEditableType(Class type) {
        if (type == null) {
            return false;
        }
        return type.isPrimitive() && type != Void.TYPE || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = StringUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean) == type || (class$java$lang$Character == null ? (class$java$lang$Character = StringUtil.class$("java.lang.Character")) : class$java$lang$Character) == type || (class$java$util$Date == null ? (class$java$util$Date = StringUtil.class$("java.util.Date")) : class$java$util$Date) == type || (class$java$lang$String == null ? (class$java$lang$String = StringUtil.class$("java.lang.String")) : class$java$lang$String) == type || (class$java$lang$Number == null ? (class$java$lang$Number = StringUtil.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(type);
    }

    public static final boolean isDigital(String text) {
        if (StringUtil.isEmpty(text)) {
            return true;
        }
        int i = 0;
        while (i < text.length()) {
            if (!Character.isDigit(text.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final void checkDyckWord(String text, String opening, String closing, String separators) throws ParseException {
        if (StringUtil.isEmpty(text)) {
            return;
        }
        Stack<Integer> pendingBrackets = new Stack<Integer>();
        char lastNonWhite = ' ';
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (!Character.isWhitespace(c)) {
                if (opening.indexOf(c) >= 0) {
                    pendingBrackets.push(new Integer(opening.indexOf(c)));
                } else if (closing.indexOf(c) >= 0) {
                    if (pendingBrackets.empty()) {
                        throw new ParseException("Unmatched closing bracket " + c + " @" + i, i);
                    }
                    int expectedIndex = (Integer)pendingBrackets.pop();
                    if (closing.indexOf(c) != expectedIndex) {
                        throw new ParseException("Mismatched closing bracket " + c + " @" + i + ", expected " + opening.charAt(expectedIndex), i);
                    }
                    if (separators.indexOf(lastNonWhite) >= 0) {
                        throw new ParseException("Separator " + lastNonWhite + " before closing bracket " + c + " @" + i, i);
                    }
                } else if (separators.indexOf(c) >= 0) {
                    if (c == lastNonWhite) {
                        throw new ParseException("Duplicate separator " + c + " @" + i, i);
                    }
                    if (separators.indexOf(lastNonWhite) >= 0) {
                        throw new ParseException("Repeated separator " + c + " after separator " + lastNonWhite + " @" + i, i);
                    }
                    if (opening.indexOf(lastNonWhite) >= 0) {
                        throw new ParseException("Separator " + c + " after opening bracket " + lastNonWhite + " @" + i, i);
                    }
                }
                lastNonWhite = c;
            }
            ++i;
        }
    }

    public static final boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Object parse(String text, Class type, Format format) throws ParseException, ClassCastException {
        if (!StringUtil.isEditableType(type)) {
            throw new IllegalArgumentException(type + " is not an editable type");
        }
        if (text != null) {
            text = text.trim();
        }
        if (StringUtil.isEmpty(text)) {
            if (type.isPrimitive()) {
                throw new ParseException(text, 0);
            }
            if (type != (class$java$lang$String == null ? (class$java$lang$String = StringUtil.class$("java.lang.String")) : class$java$lang$String)) return null;
            return "";
        }
        Object value = null;
        ParsePosition parsePosition = new ParsePosition(0);
        if (format == null) {
            if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = StringUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean) == type || Boolean.TYPE == type) {
                value = Boolean.valueOf(text);
                parsePosition.setIndex(text.length());
            } else if ((class$java$lang$Character == null ? (class$java$lang$Character = StringUtil.class$("java.lang.Character")) : class$java$lang$Character) == type || Character.TYPE == type) {
                value = new Character(text.charAt(0));
                parsePosition.setIndex(1);
            } else if ((class$java$lang$Byte == null ? (class$java$lang$Byte = StringUtil.class$("java.lang.Byte")) : class$java$lang$Byte) == type || Byte.TYPE == type) {
                value = Byte.valueOf(text);
                parsePosition.setIndex(text.length());
            } else if ((class$java$lang$Double == null ? (class$java$lang$Double = StringUtil.class$("java.lang.Double")) : class$java$lang$Double) == type || Double.TYPE == type) {
                value = Double.valueOf(text);
                parsePosition.setIndex(text.length());
            } else if ((class$java$lang$Float == null ? (class$java$lang$Float = StringUtil.class$("java.lang.Float")) : class$java$lang$Float) == type || Float.TYPE == type) {
                value = Float.valueOf(text);
                parsePosition.setIndex(text.length());
            } else if ((class$java$lang$Integer == null ? (class$java$lang$Integer = StringUtil.class$("java.lang.Integer")) : class$java$lang$Integer) == type || Integer.TYPE == type) {
                value = Integer.valueOf(text);
                parsePosition.setIndex(text.length());
            } else if ((class$java$lang$Long == null ? (class$java$lang$Long = StringUtil.class$("java.lang.Long")) : class$java$lang$Long) == type || Long.TYPE == type) {
                value = Long.valueOf(text);
                parsePosition.setIndex(text.length());
            } else if ((class$java$lang$Short == null ? (class$java$lang$Short = StringUtil.class$("java.lang.Short")) : class$java$lang$Short) == type || Short.TYPE == type) {
                value = Short.valueOf(text);
                parsePosition.setIndex(text.length());
            } else {
                if ((class$java$lang$String == null ? (class$java$lang$String = StringUtil.class$("java.lang.String")) : class$java$lang$String) != type) throw new ParseException(text, 0);
                value = text;
                parsePosition.setIndex(text.length());
            }
        } else if (format instanceof DateFormat) {
            if (type != (class$java$util$Date == null ? (class$java$util$Date = StringUtil.class$("java.util.Date")) : class$java$util$Date)) {
                throw new ClassCastException(type.getName());
            }
            value = (Date)format.parseObject(text, parsePosition);
        } else if (format instanceof NumberFormat) {
            Number parsedValue = (Number)format.parseObject(text, parsePosition);
            if (parsedValue == null) {
                value = null;
            } else if ((class$java$lang$Float == null ? (class$java$lang$Float = StringUtil.class$("java.lang.Float")) : class$java$lang$Float) == type || Float.TYPE == type) {
                value = new Float(parsedValue.floatValue());
            } else if ((class$java$lang$Double == null ? (class$java$lang$Double = StringUtil.class$("java.lang.Double")) : class$java$lang$Double) == type || Double.TYPE == type) {
                value = new Double(parsedValue.doubleValue());
            } else if ((class$java$lang$Byte == null ? (class$java$lang$Byte = StringUtil.class$("java.lang.Byte")) : class$java$lang$Byte) == type || Byte.TYPE == type) {
                value = new Byte(parsedValue.byteValue());
            } else if ((class$java$lang$Short == null ? (class$java$lang$Short = StringUtil.class$("java.lang.Short")) : class$java$lang$Short) == type || Short.TYPE == type) {
                value = new Short(parsedValue.shortValue());
            } else if ((class$java$lang$Integer == null ? (class$java$lang$Integer = StringUtil.class$("java.lang.Integer")) : class$java$lang$Integer) == type || Integer.TYPE == type) {
                value = new Integer(parsedValue.intValue());
            } else {
                if ((class$java$lang$Long == null ? (class$java$lang$Long = StringUtil.class$("java.lang.Long")) : class$java$lang$Long) != type) {
                    if (Long.TYPE != type) throw new ClassCastException(type.getName());
                }
                value = new Long(parsedValue.longValue());
            }
        }
        if (parsePosition.getIndex() == text.length()) return value;
        throw new ParseException("Trailing garbage in text '" + text + "' starting at position " + parsePosition.getIndex(), parsePosition.getIndex());
    }

    public static final void printJsEscaped(PrintWriter w, String text) {
        w.print('\"');
        if (!StringUtil.isEmpty(text)) {
            int i = 0;
            while (i < text.length()) {
                char character = text.charAt(i);
                if ('<' == character) {
                    if (text.length() > i + 7 && "</script".equals(text.substring(i, i + 8).toLowerCase())) {
                        w.print("</\"+\"");
                        w.print(text.substring(i + 2, i + 8));
                        i += 7;
                    } else if (text.length() > i + 3 && "<!--".equals(text.substring(i, i + 4))) {
                        w.print("<!\"+\"--");
                        i += 3;
                    } else {
                        w.write(character);
                    }
                } else {
                    try {
                        StringUtil.printEscapedChar(w, character);
                    }
                    catch (IOException ex) {
                        throw new BaseRuntimeException((Throwable)ex);
                    }
                }
                ++i;
            }
        }
        w.print('\"');
    }

    public static final void printXmlEscaped(PrintWriter w, String value) {
        if (StringUtil.isEmpty(value)) {
            return;
        }
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c < ' ') {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        w.print(c);
                        break;
                    }
                }
            } else {
                switch (c) {
                    case '&': {
                        w.print("&amp;");
                        break;
                    }
                    case '<': {
                        w.print("&lt;");
                        break;
                    }
                    case '\"': {
                        w.print("&quot;");
                        break;
                    }
                    default: {
                        w.print(c);
                    }
                }
            }
            ++i;
        }
    }

    public static final void printXmlEscapedForRendering(PrintWriter w, String value) {
        if (StringUtil.isEmpty(value)) {
            return;
        }
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c < ' ') {
                switch (c) {
                    case '\t': {
                        w.print(c);
                    }
                    case '\n': {
                        w.print("&#xA;");
                        break;
                    }
                    case '\r': {
                        w.print("&#xD;");
                        break;
                    }
                }
            } else {
                switch (c) {
                    case '&': {
                        w.print("&amp;");
                        break;
                    }
                    case '<': {
                        w.print("&lt;");
                        break;
                    }
                    case '\"': {
                        w.print("&quot;");
                        break;
                    }
                    default: {
                        w.print(c);
                    }
                }
            }
            ++i;
        }
    }

    public static final String[] divide(String text, char separator) {
        return StringUtil.divide(text, separator, true);
    }

    public static final String[] divide(String text, char separator, boolean trim) {
        if (StringUtil.isEmpty(text)) {
            return new String[0];
        }
        int separators = 0;
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == separator) {
                ++separators;
            }
            ++i;
        }
        String[] array = new String[separators + 1];
        int offset = 0;
        int i2 = 0;
        while (i2 < separators) {
            int index = text.indexOf(separator, offset);
            array[i2] = trim ? text.substring(offset, index).trim() : text.substring(offset, index);
            offset = index + 1;
            ++i2;
        }
        array[separators] = trim ? text.substring(offset).trim() : text.substring(offset);
        return array;
    }

    public static final String searchAndReplace(String text, String pattern, String substitute) {
        int i;
        int offset = 0;
        int index = text.indexOf(pattern, offset);
        if (index < 0 || pattern.equals(substitute)) {
            return text;
        }
        StringBuffer result = new StringBuffer(text.length() + text.length() / pattern.length() * substitute.length());
        while (index >= 0) {
            i = offset;
            while (i < index) {
                result.append(text.charAt(i));
                ++i;
            }
            result.append(substitute);
            offset = index + pattern.length();
            index = text.indexOf(pattern, offset);
        }
        i = offset;
        while (i < text.length()) {
            result.append(text.charAt(i));
            ++i;
        }
        return result.toString();
    }

    public static final String toString(Object object) {
        return object != null ? object.toString() : "";
    }

    public static final String toString(int[] path) {
        if (path == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer("{");
        int i = 0;
        while (i < path.length) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(path[i]);
            ++i;
        }
        buffer.append("}");
        return buffer.toString();
    }

    public static final String trimLeadingZeroes(String no, int length) {
        if (length < 0 || StringUtil.isEmpty(no)) {
            return no;
        }
        int noLength = no.length();
        int firstNonZeroPosition = 0;
        while (firstNonZeroPosition < noLength - 1 && no.charAt(firstNonZeroPosition) == '0') {
            ++firstNonZeroPosition;
        }
        int i = firstNonZeroPosition;
        while (i < noLength) {
            if (!Character.isDigit(no.charAt(i))) {
                return no;
            }
            ++i;
        }
        if (noLength >= length) {
            int index = Math.min(noLength - length, firstNonZeroPosition);
            return no.substring(index);
        }
        StringBuffer buffer = new StringBuffer(length);
        int i2 = noLength;
        while (i2 < length) {
            buffer.append('0');
            ++i2;
        }
        buffer.append(no);
        return buffer.toString();
    }

    public static final String getQualifiedClassName(String packageName, String unqualifiedClassName) {
        if (packageName == null || "".equals(packageName)) {
            return unqualifiedClassName;
        }
        return packageName + "." + unqualifiedClassName;
    }

    public static final String getUnqualifiedClassName(Class clazz) {
        return StringUtil.getUnqualifiedClassName(clazz.getName());
    }

    public static final String getUnqualifiedClassName(String fullClassName) {
        int index = fullClassName.lastIndexOf(46);
        return index < 0 ? fullClassName : fullClassName.substring(index + 1);
    }

    public static final String getPackageName(Class clazz) {
        return StringUtil.getPackageName(clazz.getName());
    }

    public static final String getPackageName(String fullClassName) {
        int index = fullClassName.lastIndexOf(46);
        return index < 0 ? "" : fullClassName.substring(0, index);
    }

    public static final String escapeChar(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '\'': {
                return "\\'";
            }
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return null;
    }

    private static final boolean needsJavaIdEscaping(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return false;
            }
        }
        return true;
    }

    public static final void printEscapedChar(Writer w, char c) throws IOException {
        switch (c) {
            case '\b': {
                w.write(92);
                w.write(98);
                break;
            }
            case '\f': {
                w.write(92);
                w.write(102);
                break;
            }
            case '\n': {
                w.write(92);
                w.write(110);
                break;
            }
            case '\r': {
                w.write(92);
                w.write(114);
                break;
            }
            case '\t': {
                w.write(92);
                w.write(116);
                break;
            }
            case '\'': {
                w.write(92);
                w.write(39);
                break;
            }
            case '\"': {
                w.write(92);
                w.write(34);
                break;
            }
            case '\\': {
                w.write(92);
                w.write(92);
                break;
            }
            default: {
                w.write(c);
            }
        }
    }

    public static final String capitalize(String str) {
        if (StringUtil.isEmpty(str) || Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static final String decapitalize(String str) {
        if (StringUtil.isEmpty(str) || Character.isLowerCase(str.charAt(0))) {
            return str;
        }
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

