/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.webdynpro.basesrvc.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ReferenceCounter {
    private final Map references = new HashMap();

    public void clear() {
        this.references.clear();
    }

    public int decreaseCount(Object key, boolean removeEntryWhenZero) {
        return this.decreaseCount(key, 1, removeEntryWhenZero);
    }

    public int decreaseCount(Object key, int count, boolean removeEntryWhenZero) {
        MutableInteger counter = (MutableInteger)this.references.get(key);
        if (counter == null) {
            return Integer.MIN_VALUE;
        }
        int value = counter.changeValue(-count);
        if (value < 0) {
            throw new IllegalStateException("Reference count has become negative for key " + key);
        }
        if (value == 0 && removeEntryWhenZero) {
            this.references.remove(key);
        }
        return value;
    }

    public int getCount(Object key) {
        MutableInteger counter = (MutableInteger)this.references.get(key);
        return counter != null ? counter.getValue() : 0;
    }

    public int increaseCount(Object key) {
        return this.increaseCount(key, 1);
    }

    public int increaseCount(Object key, int count) {
        MutableInteger counter = (MutableInteger)this.references.get(key);
        if (counter == null) {
            counter = new MutableInteger();
            this.references.put(key, counter);
        }
        return counter.changeValue(count);
    }

    public boolean isNewCount(Object key) {
        MutableInteger counter = (MutableInteger)this.references.get(key);
        return counter != null ? counter.isNew() : false;
    }

    public Iterator iterator() {
        return this.references.keySet().iterator();
    }

    public void resetNewCounts() {
        Iterator it = this.references.values().iterator();
        while (it.hasNext()) {
            MutableInteger counter = (MutableInteger)it.next();
            counter.resetNew();
        }
    }

    protected static final class MutableInteger {
        private static final int LOWEST_BIT = 1;
        private static final int ALL_BUT_LOWEST_BIT = -2;
        private int value = 1;

        protected MutableInteger() {
        }

        public int changeValue(int difference) {
            this.value += difference << 1;
            return this.getValue();
        }

        public int getValue() {
            return this.value >> 1;
        }

        public boolean isNew() {
            return (this.value & 1) != 0;
        }

        public void resetNew() {
            this.value &= 0xFFFFFFFE;
        }
    }
}

