/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.concurrent;

import com.sap.engine.lib.util.concurrent.ReadWriteLock;
import com.sap.engine.lib.util.concurrent.Sync;

public class WriterPreferenceReadWriteLock
implements ReadWriteLock {
    protected long activeReadersCount = 0L;
    protected Thread activeWriterThread = null;
    protected long waitingReadersCount = 0L;
    protected long waitingWritersCount = 0L;
    protected final ReaderLock readerLock = new ReaderLock();
    protected final WriterLock writerLock = new WriterLock();

    public Sync writeLock() {
        return this.writerLock;
    }

    public Sync readLock() {
        return this.readerLock;
    }

    protected synchronized void cancelledWaitingReader() {
        --this.waitingReadersCount;
    }

    protected synchronized void cancelledWaitingWriter() {
        --this.waitingWritersCount;
    }

    protected boolean allowReader() {
        return this.activeWriterThread == null && this.waitingWritersCount == 0L;
    }

    protected synchronized boolean startRead() {
        boolean allowRead = this.allowReader();
        if (allowRead) {
            ++this.activeReadersCount;
        }
        return allowRead;
    }

    protected synchronized boolean startWrite() {
        boolean allowWrite;
        boolean bl = allowWrite = this.activeWriterThread == null && this.activeReadersCount == 0L;
        if (allowWrite) {
            this.activeWriterThread = Thread.currentThread();
        }
        return allowWrite;
    }

    protected synchronized boolean startReadFromNewReader() {
        boolean pass = this.startRead();
        if (!pass) {
            ++this.waitingReadersCount;
        }
        return pass;
    }

    protected synchronized boolean startWriteFromNewWriter() {
        boolean pass = this.startWrite();
        if (!pass) {
            ++this.waitingWritersCount;
        }
        return pass;
    }

    protected synchronized boolean startReadFromWaitingReader() {
        boolean pass = this.startRead();
        if (pass) {
            --this.waitingReadersCount;
        }
        return pass;
    }

    protected synchronized boolean startWriteFromWaitingWriter() {
        boolean pass = this.startWrite();
        if (pass) {
            --this.waitingWritersCount;
        }
        return pass;
    }

    protected synchronized Signaller endRead() {
        if (--this.activeReadersCount == 0L && this.waitingWritersCount > 0L) {
            return this.writerLock;
        }
        return null;
    }

    protected synchronized Signaller endWrite() {
        this.activeWriterThread = null;
        if (this.waitingReadersCount > 0L && this.allowReader()) {
            return this.readerLock;
        }
        if (this.waitingWritersCount > 0L) {
            return this.writerLock;
        }
        return null;
    }

    protected class WriterLock
    extends Signaller
    implements Sync {
        protected WriterLock() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void acquire() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            WriterLock writerLock = this;
            // MONITORENTER : writerLock
            if (!WriterPreferenceReadWriteLock.this.startWriteFromNewWriter()) {
                try {
                    do {
                        this.wait();
                    } while (!WriterPreferenceReadWriteLock.this.startWriteFromWaitingWriter());
                    // MONITOREXIT : writerLock
                    return;
                }
                catch (InterruptedException ex) {
                    WriterPreferenceReadWriteLock.this.cancelledWaitingWriter();
                    this.notify();
                    ie = ex;
                }
            }
            // MONITOREXIT : writerLock
            if (ie == null) return;
            WriterPreferenceReadWriteLock.this.readerLock.signalWaiters();
            throw ie;
        }

        public void release() {
            Signaller s = WriterPreferenceReadWriteLock.this.endWrite();
            if (s != null) {
                s.signalWaiters();
            }
        }

        synchronized void signalWaiters() {
            this.notify();
        }

        public boolean attempt(long msecs) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            WriterLock writerLock = this;
            synchronized (writerLock) {
                block10: {
                    if (msecs <= 0L) {
                        boolean bl = WriterPreferenceReadWriteLock.this.startWrite();
                        return bl;
                    }
                    if (WriterPreferenceReadWriteLock.this.startWriteFromNewWriter()) {
                        boolean bl = true;
                        return bl;
                    }
                    long waitTime = msecs;
                    long start = System.currentTimeMillis();
                    do {
                        try {
                            this.wait(waitTime);
                        }
                        catch (InterruptedException ex) {
                            WriterPreferenceReadWriteLock.this.cancelledWaitingWriter();
                            this.notify();
                            ie = ex;
                            break block10;
                        }
                        if (!WriterPreferenceReadWriteLock.this.startWriteFromWaitingWriter()) continue;
                        boolean bl = true;
                        return bl;
                    } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                    WriterPreferenceReadWriteLock.this.cancelledWaitingWriter();
                    this.notify();
                }
            }
            WriterPreferenceReadWriteLock.this.readerLock.signalWaiters();
            if (ie != null) {
                throw ie;
            }
            return false;
        }
    }

    protected class ReaderLock
    extends Signaller
    implements Sync {
        protected ReaderLock() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void acquire() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            ReaderLock readerLock = this;
            // MONITORENTER : readerLock
            if (!WriterPreferenceReadWriteLock.this.startReadFromNewReader()) {
                try {
                    do {
                        this.wait();
                    } while (!WriterPreferenceReadWriteLock.this.startReadFromWaitingReader());
                    // MONITOREXIT : readerLock
                    return;
                }
                catch (InterruptedException ex) {
                    WriterPreferenceReadWriteLock.this.cancelledWaitingReader();
                    ie = ex;
                }
            }
            // MONITOREXIT : readerLock
            if (ie == null) return;
            WriterPreferenceReadWriteLock.this.writerLock.signalWaiters();
            throw ie;
        }

        public void release() {
            Signaller s = WriterPreferenceReadWriteLock.this.endRead();
            if (s != null) {
                s.signalWaiters();
            }
        }

        synchronized void signalWaiters() {
            this.notifyAll();
        }

        public boolean attempt(long msecs) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            ReaderLock readerLock = this;
            synchronized (readerLock) {
                block10: {
                    if (msecs <= 0L) {
                        boolean bl = WriterPreferenceReadWriteLock.this.startRead();
                        return bl;
                    }
                    if (WriterPreferenceReadWriteLock.this.startReadFromNewReader()) {
                        boolean bl = true;
                        return bl;
                    }
                    long waitTime = msecs;
                    long start = System.currentTimeMillis();
                    do {
                        try {
                            this.wait(waitTime);
                        }
                        catch (InterruptedException ex) {
                            WriterPreferenceReadWriteLock.this.cancelledWaitingReader();
                            ie = ex;
                            break block10;
                        }
                        if (!WriterPreferenceReadWriteLock.this.startReadFromWaitingReader()) continue;
                        boolean bl = true;
                        return bl;
                    } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                    WriterPreferenceReadWriteLock.this.cancelledWaitingReader();
                }
            }
            WriterPreferenceReadWriteLock.this.writerLock.signalWaiters();
            if (ie != null) {
                throw ie;
            }
            return false;
        }
    }

    protected abstract class Signaller {
        protected Signaller() {
        }

        abstract void signalWaiters();
    }
}

