/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.concurrent;

import com.sap.engine.lib.util.concurrent.Barrier;
import com.sap.engine.lib.util.concurrent.BrokenBarrierException;
import com.sap.engine.lib.util.concurrent.Semaphore;
import com.sap.engine.lib.util.concurrent.TimeoutException;
import com.sap.engine.lib.util.concurrent.WaiterPreferenceSemaphore;

public class Rendezvous
implements Barrier {
    protected final int partiesCount;
    protected boolean isBroken = false;
    protected int entriesCount = 0;
    protected long departuresCount = 0L;
    protected final Semaphore entryGateSync;
    protected final Object[] slotsArray;
    protected RendezvousFunction rendezvousFunction;

    public Rendezvous(int parties) {
        this(parties, new Rotator());
    }

    public Rendezvous(int parties, RendezvousFunction function) {
        if (parties <= 0) {
            throw new IllegalArgumentException();
        }
        this.partiesCount = parties;
        this.rendezvousFunction = function;
        this.entryGateSync = new WaiterPreferenceSemaphore(parties);
        this.slotsArray = new Object[parties];
    }

    public synchronized RendezvousFunction setRendezvousFunction(RendezvousFunction function) {
        RendezvousFunction old = this.rendezvousFunction;
        this.rendezvousFunction = function;
        return old;
    }

    public int parties() {
        return this.partiesCount;
    }

    public synchronized boolean broken() {
        return this.isBroken;
    }

    public void restart() {
        while (true) {
            Rendezvous rendezvous = this;
            synchronized (rendezvous) {
                if (this.entriesCount == 0) {
                    this.isBroken = false;
                    return;
                }
                this.notifyAll();
            }
            Thread.yield();
        }
    }

    public Object rendezvous(Object x) throws InterruptedException, BrokenBarrierException {
        return this.doRendezvous(x, false, 0L);
    }

    public Object attemptRendezvous(Object x, long msecs) throws InterruptedException, TimeoutException, BrokenBarrierException {
        return this.doRendezvous(x, true, msecs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object doRendezvous(Object x, boolean timed, long msecs) throws InterruptedException, TimeoutException, BrokenBarrierException {
        long startTime;
        if (timed) {
            startTime = System.currentTimeMillis();
            if (!this.entryGateSync.attempt(msecs)) {
                throw new TimeoutException(msecs);
            }
        } else {
            startTime = 0L;
            this.entryGateSync.acquire();
        }
        Rendezvous rendezvous = this;
        synchronized (rendezvous) {
            int index;
            Object y;
            block24: {
                int i2;
                Throwable throwable2;
                block23: {
                    y = null;
                    index = this.entriesCount++;
                    this.slotsArray[index] = x;
                    try {
                        if (this.entriesCount == this.partiesCount) {
                            this.departuresCount = this.entriesCount;
                            this.notifyAll();
                            try {
                                if (!this.isBroken && this.rendezvousFunction != null) {
                                    this.rendezvousFunction.rendezvousFunction(this.slotsArray);
                                }
                            }
                            catch (RuntimeException ex) {
                                this.isBroken = true;
                            }
                        } else {
                            while (!this.isBroken) {
                                if (this.departuresCount >= 1L) {
                                    break;
                                }
                                long timeLeft = 0L;
                                if (timed && (timeLeft = msecs - (System.currentTimeMillis() - startTime)) <= 0L) {
                                    this.isBroken = true;
                                    this.departuresCount = this.entriesCount;
                                    this.notifyAll();
                                    throw new TimeoutException(msecs);
                                }
                                try {
                                    this.wait(timeLeft);
                                }
                                catch (InterruptedException ex) {
                                    if (!this.isBroken && this.departuresCount <= 0L) {
                                        this.isBroken = true;
                                        this.departuresCount = this.entriesCount;
                                        this.notifyAll();
                                        throw ex;
                                    }
                                    Thread.currentThread().interrupt();
                                    break;
                                }
                            }
                        }
                        Object var14_12 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var14_13 = null;
                        y = this.slotsArray[index];
                        if (--this.departuresCount > 0L) throw throwable2;
                        i2 = 0;
                        break block23;
                    }
                    y = this.slotsArray[index];
                    if (--this.departuresCount <= 0L) {
                        int i2 = 0;
                        while (true) {
                            if (i2 >= this.slotsArray.length) {
                                this.entryGateSync.release(this.entriesCount);
                                this.entriesCount = 0;
                                break block24;
                            }
                            this.slotsArray[i2] = null;
                            ++i2;
                        }
                    }
                    break block24;
                }
                while (true) {
                    if (i2 >= this.slotsArray.length) break;
                    this.slotsArray[i2] = null;
                    ++i2;
                }
                this.entryGateSync.release(this.entriesCount);
                this.entriesCount = 0;
                throw throwable2;
            }
            if (!this.isBroken) return y;
            throw new BrokenBarrierException(index);
        }
    }

    public static class Rotator
    implements RendezvousFunction {
        public void rendezvousFunction(Object[] objects) {
            int lastIdx = objects.length - 1;
            Object first = objects[0];
            int i = 0;
            while (i < lastIdx) {
                objects[i] = objects[i + 1];
                ++i;
            }
            objects[lastIdx] = first;
        }
    }

    public static interface RendezvousFunction {
        public void rendezvousFunction(Object[] var1);
    }
}

