/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.concurrent;

import com.sap.engine.lib.util.HashMapObjectIntPositive;
import com.sap.engine.lib.util.concurrent.WriterPreferenceReadWriteLock;

public class ReentrantWriterPreferenceReadWriteLock
extends WriterPreferenceReadWriteLock {
    protected long writeHoldsCount = 0L;
    protected HashMapObjectIntPositive readersHash = new HashMapObjectIntPositive();

    protected boolean allowReader() {
        return this.activeWriterThread == null && this.waitingWritersCount == 0L || this.activeWriterThread == Thread.currentThread();
    }

    protected synchronized boolean startRead() {
        Thread t = Thread.currentThread();
        int c = this.readersHash.get(t);
        if (c != -1) {
            this.readersHash.put(t, c + 1);
            ++this.activeReadersCount;
            return true;
        }
        if (this.allowReader()) {
            this.readersHash.put(t, 1);
            ++this.activeReadersCount;
            return true;
        }
        return false;
    }

    protected synchronized boolean startWrite() {
        if (this.activeWriterThread == Thread.currentThread()) {
            ++this.writeHoldsCount;
            return true;
        }
        if (this.writeHoldsCount == 0L) {
            if (this.activeReadersCount == 0L || this.readersHash.size() == 1 && this.readersHash.get(Thread.currentThread()) != -1) {
                this.activeWriterThread = Thread.currentThread();
                this.writeHoldsCount = 1L;
                return true;
            }
            return false;
        }
        return false;
    }

    protected synchronized WriterPreferenceReadWriteLock.Signaller endRead() {
        --this.activeReadersCount;
        Thread t = Thread.currentThread();
        int c = this.readersHash.get(t);
        if (c != 1) {
            this.readersHash.put(t, c - 1);
            return null;
        }
        this.readersHash.remove(t);
        if (this.writeHoldsCount > 0L) {
            return null;
        }
        if (this.activeReadersCount == 0L && this.waitingWritersCount > 0L) {
            return this.writerLock;
        }
        return null;
    }

    protected synchronized WriterPreferenceReadWriteLock.Signaller endWrite() {
        --this.writeHoldsCount;
        if (this.writeHoldsCount > 0L) {
            return null;
        }
        this.activeWriterThread = null;
        if (this.waitingReadersCount > 0L && this.allowReader()) {
            return this.readerLock;
        }
        if (this.waitingWritersCount > 0L) {
            return this.writerLock;
        }
        return null;
    }
}

