/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.algorithms;

import com.sap.engine.lib.util.algorithms.BinaryIntFunction;
import com.sap.engine.lib.util.algorithms.MutableAlgorithm;
import com.sap.engine.lib.util.iterators.ChangeableIterator;
import com.sap.engine.lib.util.iterators.ForwardIterator;
import com.sap.engine.lib.util.iterators.RandomAccessIterator;

public class SortAlgorithms
extends MutableAlgorithm {
    BinaryIntFunction intFunction;
    boolean flag;

    public void setCompareFunction(BinaryIntFunction _intFunction) {
        this.intFunction = _intFunction;
    }

    public void setAscending(boolean _flag) {
        this.flag = _flag;
    }

    public void qsort(ChangeableIterator iterator) {
    }

    public void qsort(ForwardIterator iterator) {
    }

    public void qsort(RandomAccessIterator iterator) {
        int size = iterator.size();
        int start = iterator.currentPosition();
        int end = size;
        if (this.flag) {
            this.internalQsortAsc(iterator, start, end);
        } else {
            this.internalQsortDesc(iterator, start, end);
        }
    }

    private void internalQsortAsc(RandomAccessIterator iterator, int start, int size) {
        int c;
        int a;
        if (size < 7) {
            int i = start;
            while (i < size + start) {
                int j = i;
                while (j > start && this.intFunction.intFunction(iterator.jumpTo(j - 1), iterator.jumpTo(j)) > 0) {
                    this.swap(iterator, j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = start + size / 2;
        if (size > 7) {
            int l = start;
            int n = start + size - 1;
            if (size > 40) {
                int s = size / 8;
                l = this.median(iterator, l, l + s, l + 2 * s);
                m = this.median(iterator, m - s, m, m + s);
                n = this.median(iterator, n - 2 * s, n - s, n);
            }
            m = this.median(iterator, l, m, n);
        }
        Object medium = iterator.jumpTo(m);
        int b = a = start;
        int d = c = start + size - 1;
        while (true) {
            if (b <= c && this.intFunction.intFunction(iterator.jumpTo(b), medium) <= 0) {
                if (this.intFunction.intFunction(iterator.jumpTo(b), medium) == 0) {
                    this.swap(iterator, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.intFunction.intFunction(iterator.jumpTo(c), medium) >= 0) {
                if (this.intFunction.intFunction(iterator.jumpTo(b), medium) == 0) {
                    this.swap(iterator, c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(iterator, b++, c--);
        }
        int n = start + size;
        int s = Math.min(a - start, b - a);
        this.vecswap(iterator, start, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(iterator, b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.internalQsortAsc(iterator, start, s);
        }
        if ((s = d - c) > 1) {
            this.internalQsortAsc(iterator, n - s, s);
        }
    }

    private void internalQsortDesc(RandomAccessIterator iterator, int start, int size) {
        int c;
        int a;
        if (size < 7) {
            int i = start;
            while (i < size + start) {
                int j = i;
                while (j > start && this.intFunction.intFunction(iterator.jumpTo(j - 1), iterator.jumpTo(j)) < 0) {
                    this.swap(iterator, j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = start + size / 2;
        if (size > 7) {
            int l = start;
            int n = start + size - 1;
            if (size > 40) {
                int s = size / 8;
                l = this.median(iterator, l, l + s, l + 2 * s);
                m = this.median(iterator, m - s, m, m + s);
                n = this.median(iterator, n - 2 * s, n - s, n);
            }
            m = this.median(iterator, l, m, n);
        }
        Object medium = iterator.jumpTo(m);
        int b = a = start;
        int d = c = start + size - 1;
        while (true) {
            if (b <= c && this.intFunction.intFunction(iterator.jumpTo(b), medium) >= 0) {
                if (this.intFunction.intFunction(iterator.jumpTo(b), medium) == 0) {
                    this.swap(iterator, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.intFunction.intFunction(iterator.jumpTo(c), medium) <= 0) {
                if (this.intFunction.intFunction(iterator.jumpTo(b), medium) == 0) {
                    this.swap(iterator, c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(iterator, b++, c--);
        }
        int n = start + size;
        int s = Math.min(a - start, b - a);
        this.vecswap(iterator, start, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(iterator, b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.internalQsortDesc(iterator, start, s);
        }
        if ((s = d - c) > 1) {
            this.internalQsortDesc(iterator, n - s, s);
        }
    }

    private void swap(RandomAccessIterator iterator, int a, int b) {
        Object work = iterator.jumpTo(a);
        Object work1 = iterator.jumpTo(b);
        iterator.jumpTo(b);
        iterator.change(work);
        iterator.jumpTo(a);
        iterator.change(work1);
    }

    private void vecswap(RandomAccessIterator iterator, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(iterator, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private int median(RandomAccessIterator iterator, int a, int b, int c) {
        return this.intFunction.intFunction(iterator.jumpTo(a), iterator.jumpTo(b)) < 0 ? (this.intFunction.intFunction(iterator.jumpTo(b), iterator.jumpTo(c)) < 0 ? b : (this.intFunction.intFunction(iterator.jumpTo(a), iterator.jumpTo(c)) < 0 ? c : a)) : (this.intFunction.intFunction(iterator.jumpTo(b), iterator.jumpTo(c)) > 0 ? b : (this.intFunction.intFunction(iterator.jumpTo(a), iterator.jumpTo(c)) > 0 ? c : a));
    }
}

