/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.AbstractDataStructure;
import com.sap.engine.lib.util.DeepCloneable;
import com.sap.engine.lib.util.IntHashHolder;
import com.sap.engine.lib.util.IntHashHolderImpl;
import com.sap.engine.lib.util.NotSupportedException;
import com.sap.engine.lib.util.PrimeGenerator;
import com.sap.engine.lib.util.RootDataStructure;
import com.sap.engine.lib.util.base.Pointer;
import com.sap.engine.lib.util.iterators.ArrayEnumeration;
import com.sap.engine.lib.util.iterators.ForwardIterator;
import com.sap.engine.lib.util.iterators.IteratorException;
import com.sap.engine.lib.util.iterators.RootIterator;
import com.sap.engine.lib.util.iterators.SnapShotEnumeration;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Set
extends AbstractDataStructure {
    public static final float LOAD_FACTOR = 0.75f;
    public static final int INITIAL_CAPACITY = 13;
    public static final int GROW_STEP = 2;
    protected static final int LAST = -1;
    protected int growStep;
    protected int growSimpl;
    protected float loadFactor;
    protected IntHashHolder hasher;
    protected int simplIndex;
    protected int limit;
    protected int capacity;
    protected transient int nextFree;
    protected transient Object[] keys;
    protected transient int[] nextPtr;

    public Set() {
        this(13, 2, 0.75f, new IntHashHolderImpl());
    }

    public Set(int initialCapacity) {
        this(initialCapacity, 2, 0.75f, new IntHashHolderImpl());
    }

    public Set(int initialCapacity, int growStep, float loadFactor, IntHashHolder hasher) {
        if ((double)loadFactor > 1.0 || loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Load Factor = " + loadFactor);
        }
        if (growStep <= 1) {
            throw new IllegalArgumentException("Grow step = " + growStep);
        }
        this.growStep = growStep;
        this.growSimpl = growStep == 2 ? 4 : (growStep < 10 ? growStep + 4 : 13);
        this.loadFactor = loadFactor;
        this.hasher = hasher;
        this.simplIndex = 0;
        this.init(initialCapacity);
    }

    public Enumeration elements() {
        return new Enumeration(){
            private int i;
            private int counter;
            {
                this.i = Set.this.keys.length;
                this.counter = 0;
            }

            public boolean hasMoreElements() {
                return this.counter < Set.this.count;
            }

            public Object nextElement() {
                while (--this.i >= 0) {
                    if (Set.this.keys[this.i] == null) continue;
                    ++this.counter;
                    return Set.this.keys[this.i];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public SnapShotEnumeration elementsEnumeration() {
        return new ArrayEnumeration(this.toArray());
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.count]);
    }

    public Object[] toArray(Object[] result) {
        int index = 0;
        if (result.length < this.count) {
            result = (Object[])Array.newInstance(result.getClass().getComponentType(), this.count);
        }
        int i = this.keys.length;
        while (--i >= 0) {
            if (this.keys[i] == null) continue;
            result[index++] = this.keys[i];
        }
        return result;
    }

    public boolean contains(Object key) {
        int pos = this.nextPtr[this.hasher.hash(key.hashCode()) % this.capacity];
        while (pos != -1) {
            if (this.keys[pos - this.capacity].equals(key)) {
                return true;
            }
            pos = this.nextPtr[pos];
        }
        return false;
    }

    public void clear() {
        int i = this.keys.length;
        while (--i >= 0) {
            this.nextPtr[i] = -1;
            this.keys[i] = null;
        }
        int i2 = this.keys.length;
        while (i2 < this.capacity) {
            this.nextPtr[i2] = -1;
            ++i2;
        }
        int i3 = this.capacity;
        while (i3 < this.nextPtr.length) {
            this.nextPtr[i3++] = i3;
        }
        this.nextFree = this.capacity;
        this.count = 0;
    }

    public Object clone() {
        Set result = (Set)super.clone();
        result.keys = new Object[this.keys.length];
        result.nextPtr = new int[this.nextPtr.length];
        System.arraycopy(this.nextPtr, 0, result.nextPtr, 0, this.nextPtr.length);
        System.arraycopy(this.keys, 0, result.keys, 0, this.keys.length);
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set t = (Set)object;
        if (t.count != this.count) {
            return false;
        }
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                if (!t.contains(this.keys[pos - this.capacity])) {
                    return false;
                }
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        return true;
    }

    public void shrink() {
        this.shrink(0.75f);
    }

    public void shrink(float shrinkFactor) {
        if (shrinkFactor <= 0.0f || (double)shrinkFactor > 1.0) {
            throw new IllegalArgumentException("Shrink Factor = " + shrinkFactor);
        }
        int newCapacity = (int)((float)this.count / (this.loadFactor * shrinkFactor));
        long l = PrimeGenerator.getClosestPrime(newCapacity);
        this.simplIndex = (int)(l >> 32);
        newCapacity = (int)l;
        if (newCapacity < this.capacity) {
            Object[] oldKeys = this.keys;
            this.init(newCapacity);
            int i = oldKeys.length;
            while (--i >= 0) {
                if (oldKeys[i] == null) continue;
                this.putQuick(oldKeys[i]);
            }
        }
    }

    public boolean add(Object key) {
        if (this.count == this.limit) {
            this.rehash();
        }
        int pos = this.hasher.hash(key.hashCode()) % this.capacity;
        while (this.nextPtr[pos] != -1) {
            if (!this.keys[(pos = this.nextPtr[pos]) - this.capacity].equals(key)) continue;
            return false;
        }
        this.nextPtr[pos] = this.nextFree;
        this.keys[this.nextFree - this.capacity] = key;
        this.nextFree = this.nextPtr[this.nextFree];
        this.nextPtr[this.nextPtr[pos]] = -1;
        ++this.count;
        return true;
    }

    public boolean addAll(Object[] elements) {
        int oldCount = this.count;
        int i = elements.length;
        block0: while (--i >= 0) {
            if (this.count == this.limit) {
                this.rehash();
            }
            int pos = this.hasher.hash(elements[i].hashCode()) % this.capacity;
            while (this.nextPtr[pos] != -1) {
                if (this.keys[(pos = this.nextPtr[pos]) - this.capacity].equals(elements[i])) continue block0;
            }
            this.nextPtr[pos] = this.nextFree;
            this.keys[this.nextFree - this.capacity] = elements[i];
            this.nextFree = this.nextPtr[this.nextFree];
            this.nextPtr[this.nextPtr[pos]] = -1;
            ++this.count;
        }
        return oldCount != this.count;
    }

    protected void putQuick(Object key) {
        int pos = this.hasher.hash(key.hashCode()) % this.capacity;
        while (this.nextPtr[pos] != -1) {
            pos = this.nextPtr[pos];
        }
        this.nextPtr[pos] = this.nextFree;
        this.keys[this.nextFree - this.capacity] = key;
        this.nextFree = this.nextPtr[this.nextFree];
        this.nextPtr[this.nextPtr[pos]] = -1;
        ++this.count;
    }

    public boolean remove(Object key) {
        int prevPos = this.hasher.hash(key.hashCode()) % this.capacity;
        int pos = this.nextPtr[prevPos];
        while (pos != -1) {
            if (this.keys[pos - this.capacity].equals(key)) {
                this.keys[pos - this.capacity] = null;
                this.nextPtr[prevPos] = this.nextPtr[pos];
                this.nextPtr[pos] = this.nextFree;
                this.nextFree = pos;
                --this.count;
                return true;
            }
            prevPos = pos;
            pos = this.nextPtr[pos];
        }
        return false;
    }

    protected void init(int initialCapacity) {
        if (this.growStep > 17) {
            this.capacity = (int)PrimeGenerator.getClosestPrime(initialCapacity);
        } else {
            long l = PrimeGenerator.getClosestPrime(initialCapacity, this.simplIndex);
            this.simplIndex = (int)(l >> 32) + this.growSimpl;
            this.capacity = (int)l;
        }
        this.limit = (int)((float)this.capacity * this.loadFactor);
        this.nextPtr = new int[this.capacity + this.limit];
        int i = this.capacity;
        while (--i >= 0) {
            this.nextPtr[i] = -1;
        }
        int i2 = this.capacity;
        while (i2 < this.nextPtr.length) {
            this.nextPtr[i2++] = i2;
        }
        this.keys = new Object[this.limit];
        this.nextFree = this.capacity;
        this.count = 0;
    }

    protected void rehash() {
        Object[] oldKeys = this.keys;
        this.init(this.capacity * this.growStep);
        int i = oldKeys.length;
        while (--i >= 0) {
            this.putQuick(oldKeys[i]);
        }
    }

    public String toString() {
        int c = 0;
        StringBuffer buf = new StringBuffer(2 * this.count + 1);
        buf.append("{");
        int i = 0;
        while (i < this.capacity) {
            int pos = this.nextPtr[i];
            while (pos != -1) {
                buf.append(this.keys[pos - this.capacity]);
                if (++c < this.count) {
                    buf.append(", ");
                }
                pos = this.nextPtr[pos];
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public void setHasher(IntHashHolder hasher) {
        this.hasher = hasher;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        int i = this.keys.length;
        while (--i >= 0) {
            if (this.keys[i] == null) continue;
            stream.writeObject(this.keys[i]);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.nextPtr = new int[this.capacity + this.limit];
        int i = this.capacity;
        while (--i >= 0) {
            this.nextPtr[i] = -1;
        }
        int i2 = this.capacity;
        while (i2 < this.nextPtr.length) {
            this.nextPtr[i2++] = i2;
        }
        this.keys = new Object[this.limit];
        this.nextFree = this.capacity;
        int size = this.count;
        this.count = 0;
        int i3 = size;
        while (--i3 >= 0) {
            this.putQuick(stream.readObject());
        }
    }

    public Pointer[] toPointerArray() {
        throw new NotSupportedException("Use toArray() method instead!");
    }

    public Object deepClone() {
        Set result = (Set)super.clone();
        result.keys = new Object[this.keys.length];
        result.nextPtr = new int[this.nextPtr.length];
        int i = 0;
        while (i < this.keys.length) {
            result.keys[i] = ((DeepCloneable)this.keys[i]).deepClone();
            ++i;
        }
        System.arraycopy(this.nextPtr, 0, result.nextPtr, 0, this.nextPtr.length);
        return result;
    }

    public RootIterator elementsIterator() {
        return new SetIterator();
    }

    protected Object iterGet(RootIterator rootIter) {
        SetIterator iter = (SetIterator)rootIter;
        if (iter.counter >= iter.end) {
            throw new IteratorException("End of Iterator reached!");
        }
        int tmpI = iter.i;
        int tmpPos = iter.pos;
        while (tmpI < this.capacity) {
            if (tmpPos != -1) {
                return this.keys[tmpPos - this.capacity];
            }
            tmpPos = this.nextPtr[++tmpI];
        }
        throw new IteratorException("End of Iterator reached!");
    }

    /*
     * Unable to fully structure code
     */
    protected Object iterNext(RootIterator rootIter, int offset) {
        iter = (SetIterator)rootIter;
        if (offset < 0) {
            throw new IteratorException("Invalid argument: " + offset + " < 0");
        }
        newCounter = SetIterator.access$000(iter) + offset;
        if (newCounter < SetIterator.access$100(iter)) ** GOTO lbl22
        throw new IteratorException("End of Iterator reached!");
        {
            result = this.keys[SetIterator.access$300(iter) - this.capacity];
            SetIterator.access$402(iter, SetIterator.access$300(iter));
            SetIterator.access$302(iter, this.nextPtr[SetIterator.access$300(iter)]);
            if (SetIterator.access$008(iter) == newCounter) {
                return result;
            }
            do {
                if (SetIterator.access$300(iter) != -1) continue block0;
                SetIterator.access$208(iter);
                SetIterator.access$402(iter, SetIterator.access$200(iter));
                SetIterator.access$302(iter, this.nextPtr[SetIterator.access$200(iter)]);
lbl22:
                // 2 sources

            } while (SetIterator.access$200(iter) < this.capacity);
        }
        throw new IteratorException("End of Iterator reached!");
    }

    /*
     * Unable to fully structure code
     */
    protected Object iterRemove(RootIterator rootIter) {
        iter = (SetIterator)rootIter;
        if (this.count == 0) {
            throw new IteratorException("Iterator is empty!");
        }
        if (SetIterator.access$000(iter) < SetIterator.access$100(iter)) ** GOTO lbl25
        throw new IteratorException("End of Iterator reached!");
lbl-1000:
        // 1 sources

        {
            if (SetIterator.access$300(iter) != -1) {
                index = SetIterator.access$300(iter) - this.capacity;
                result = this.keys[index];
                this.keys[index] = null;
                this.nextPtr[SetIterator.access$400((SetIterator)iter)] = this.nextPtr[SetIterator.access$300(iter)];
                this.nextPtr[SetIterator.access$300((SetIterator)iter)] = this.nextFree;
                this.nextFree = SetIterator.access$300(iter);
                SetIterator.access$302(iter, this.nextPtr[SetIterator.access$400(iter)]);
                --this.count;
                SetIterator.access$008(iter);
                return result;
            }
            SetIterator.access$208(iter);
            SetIterator.access$402(iter, SetIterator.access$200(iter));
            SetIterator.access$302(iter, this.nextPtr[SetIterator.access$200(iter)]);
lbl25:
            // 2 sources

            ** while (SetIterator.access$200((SetIterator)iter) < this.capacity)
        }
lbl26:
        // 1 sources

        throw new IteratorException("End of Iterator reached!");
    }

    protected class SetIterator
    implements ForwardIterator {
        private int i;
        private int prevPos;
        private int pos;
        private int start;
        private int end;
        private int counter;

        protected SetIterator() {
            this.prevPos = this.i = 0;
            this.pos = Set.this.nextPtr[this.i];
            this.start = 0;
            this.end = Set.this.count;
            this.counter = this.start;
        }

        public Object get() {
            return Set.this.iterGet(this);
        }

        public boolean isAtBegin() {
            return this.counter == this.start;
        }

        public boolean isAtEnd() {
            return this.counter == this.end;
        }

        public RootDataStructure getDataStructure() {
            return Set.this;
        }

        public Object next() {
            return Set.this.iterNext(this, 0);
        }

        public Object next(int n) {
            return Set.this.iterNext(this, n);
        }

        public void setStartFromIterator(RootIterator iterator) {
            SetIterator si = (SetIterator)iterator;
            if (Set.this != si.getDataStructure()) {
                throw new IteratorException("An attempt to set start from an Iterator over a different Set instance!");
            }
            int newCounter = si.counter;
            int newPos = si.pos;
            int newPrevPos = si.prevPos;
            int newI = si.i;
            if (newCounter >= this.end) {
                throw new IteratorException("An attempt to set the start behind the end of the Iterator: " + newCounter + " >= " + this.end);
            }
            this.counter = this.start = newCounter;
            this.prevPos = newPrevPos;
            this.pos = newPos;
            this.i = newI;
        }

        public void setEndFromIterator(RootIterator iterator) {
            SetIterator si = (SetIterator)iterator;
            if (Set.this != si.getDataStructure()) {
                throw new IteratorException("An attempt to set end from an Iterator over a different Set instance!");
            }
            int newCounter = si.counter;
            if (newCounter < this.counter) {
                throw new IteratorException(" end ahead of the current position of the Iterator: " + newCounter + " < " + this.counter);
            }
            this.end = newCounter;
        }

        public Object add(Object obj) {
            throw new IteratorException("Operation is not supported!");
        }

        public Object change(Object obj) {
            throw new IteratorException("Operation is not supported!");
        }

        public Object remove() {
            return Set.this.iterRemove(this);
        }

        public Object insert(Object obj) {
            throw new IteratorException("Operation is not supported!");
        }

        public int size() {
            return this.end - this.start;
        }

        public boolean isInsertable() {
            return false;
        }

        public boolean isRemoveable() {
            return true;
        }

        public boolean isChangeable() {
            return false;
        }

        public boolean isAddable() {
            return false;
        }

        static /* synthetic */ int access$402(SetIterator x0, int x1) {
            x0.prevPos = x1;
            return x0.prevPos;
        }

        static /* synthetic */ int access$302(SetIterator x0, int x1) {
            x0.pos = x1;
            return x0.pos;
        }

        static /* synthetic */ int access$008(SetIterator x0) {
            return x0.counter++;
        }

        static /* synthetic */ int access$208(SetIterator x0) {
            return x0.i++;
        }

        static /* synthetic */ int access$400(SetIterator x0) {
            return x0.prevPos;
        }
    }
}

