/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.PoolInstanceCreator;
import com.sap.engine.lib.util.PoolObject;

public class PoolObjectWithCreator
extends PoolObject {
    protected PoolInstanceCreator creator;

    public PoolObjectWithCreator(PoolInstanceCreator creator) {
        this.creator = creator;
    }

    public PoolObjectWithCreator(PoolInstanceCreator creator, int initialSize) {
        this(creator, initialSize, 0, 0);
    }

    public PoolObjectWithCreator(PoolInstanceCreator creator, int initialSize, int capacityIncrement) {
        this(creator, initialSize, capacityIncrement, 0);
    }

    public PoolObjectWithCreator(PoolInstanceCreator creator, int initialSize, int capacityIncrement, int limit) {
        if (initialSize <= 0) {
            throw new IllegalArgumentException("Initial size must be positive!");
        }
        this.creator = creator;
        this.capacityIncrement = capacityIncrement;
        this.pool = new Object[initialSize];
        int i = 0;
        while (i < initialSize) {
            this.pool[i] = this.newInstance();
            ++i;
        }
        this.elementCount = initialSize;
        this.setLimit(limit);
    }

    public Object newInstance() {
        return this.creator.newInstance();
    }
}

